/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fits;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.fits.FitsDataSource;
import org.das2.util.monitor.ProgressMonitor;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;

public class FitsDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new FitsDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws FitsException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            try {
                String surl = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                Set<String> plottable = FitsDataSourceFactory.getPlottable(DataSetURI.toUri((String)surl), mon).keySet();
                for (String s : plottable) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s, (DataSourceFactory)this, "arg_0", null, null, true));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    protected static Map<String, Integer> getPlottable(URI uri, ProgressMonitor mon) throws IOException, FitsException {
        File f = DataSetURI.getFile((URI)uri, (ProgressMonitor)mon);
        FitsFile file = new FitsFile(f);
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        int nhdu = file.getNoHDUnits();
        for (int i = 0; i < nhdu; ++i) {
            FitsHDUnit hdu = file.getHDUnit(i);
            result.put(hdu.getHeader().getName(), i);
        }
        return result;
    }

    public String getDescription() {
        return "NASA Fits files";
    }
}

