/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.DArrayDimension;
import dods.dap.DODSException;
import dods.dap.NoSuchFunctionException;
import dods.dap.NoSuchVariableException;
import dods.dap.Server.Clause;
import dods.dap.Server.ClauseFactory;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.InvalidParameterException;
import dods.dap.Server.SBHException;
import dods.dap.Server.SDArray;
import dods.dap.Server.SDGrid;
import dods.dap.Server.SDODSException;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.dap.Server.TopLevelClause;
import dods.dap.Server.WrongTypeException;
import dods.dap.parser.ExprParser;
import dods.dap.parser.ParseException;
import dods.dap.parser.TokenMgrError;
import dods.util.Debug;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

public class CEEvaluator {
    private static boolean _Debug = false;
    private ServerDDS _dds;
    private Vector _cv;
    private ClauseFactory clauseFactory;

    public CEEvaluator(ServerDDS dds) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet("CE");
    }

    public CEEvaluator(ServerDDS dds, ClauseFactory clauseFactory) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet("CE");
        this.clauseFactory = clauseFactory;
    }

    public ServerDDS getDDS() {
        return this._dds;
    }

    public void parseConstraint(String expression) throws ParseException, DODSException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, InvalidParameterException, SBHException, WrongTypeException {
        StringReader sExpr = new StringReader(expression);
        ExprParser exp = new ExprParser(sExpr);
        if (this.clauseFactory == null) {
            this.clauseFactory = new ClauseFactory();
        }
        try {
            exp.constraint_expression(this, this._dds.getFactory(), this.clauseFactory);
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme.getMessage());
        }
        if (_Debug) {
            int it = 0;
            Enumeration ec = this.getClauses();
            System.out.println("Results of clause parsing:");
            if (!ec.hasMoreElements()) {
                System.out.println("    No Clauses Found.");
            }
            while (ec.hasMoreElements()) {
                System.out.println("    Clause " + ++it + ": " + ec.nextElement());
            }
        }
    }

    public void appendClause(Clause c) {
        if (c != null) {
            this._cv.add(c);
        }
    }

    public boolean removeClause(Clause c) {
        if (c != null) {
            return this._cv.remove(c);
        }
        return false;
    }

    public final Enumeration getClauses() {
        return this._cv.elements();
    }

    public void send(String dataset, OutputStream sink, Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            ServerMethods s = (ServerMethods)e.nextElement();
            if (_Debug) {
                System.out.println("Sending variable: " + ((BaseType)((Object)s)).getName());
            }
            if (!s.isProject()) continue;
            if (_Debug) {
                System.out.println("Calling " + ((BaseType)((Object)s)).getTypeName() + ".serialize() (Name: " + ((BaseType)((Object)s)).getName() + ")");
            }
            s.serialize(dataset, (DataOutputStream)sink, this, specialO);
        }
    }

    public boolean evalClauses(Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        boolean result = true;
        Enumeration ec = this.getClauses();
        while (ec.hasMoreElements() && result) {
            Object o = ec.nextElement();
            if (_Debug) {
                System.out.println("Evaluating clause: " + ec.nextElement());
            }
            result = ((TopLevelClause)o).evaluate();
        }
        return result;
    }

    public void markAll(boolean state) throws InvalidParameterException, NoSuchVariableException, SBHException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (state) {
                if (o instanceof SDArray) {
                    SDArray SDA = (SDArray)o;
                    Enumeration eSDA = SDA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                } else if (o instanceof SDGrid) {
                    SDGrid SDG = (SDGrid)o;
                    SDArray sdgA = (SDArray)SDG.getVar(0);
                    Enumeration eSDA = sdgA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                }
            }
            ServerMethods s = (ServerMethods)o;
            s.setProject(state);
        }
    }
}

