/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.BaseType;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.RelOpClause;
import dods.dap.Server.SDODSException;
import dods.dap.Server.SDString;
import dods.dap.Server.SDURL;
import dods.dap.Server.ServerMethods;
import dods.dap.Server.SubClause;
import dods.dap.Server.TopLevelClause;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class SqlRelOpClause
extends RelOpClause
implements TopLevelClause {
    private static final boolean _Debug = false;
    private String regexpError1 = "\n\n    The SQL Server only supports part\n    of the regular expression syntax.\n";
    private String regexpError2 = "    The supported special characters are\n    '.' and '.*'. The set notation '[...]'\n    is also supported, but not in conjunction\n    with the '*' character.\n";

    protected SqlRelOpClause(int op, SubClause lhs, List rhs) throws SDODSException {
        super(op, lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    public String getSqlRepresentation(boolean useDatasetName, sqlDDS dds) throws InvalidOperatorException {
        void var4_9;
        List ropLst;
        String lop;
        String s = "";
        boolean isRegExp = false;
        List lhsChildren = this.lhs.getChildren();
        if (!lhsChildren.isEmpty()) {
            throw new InvalidOperatorException("Nested expressions are not supported! (LHS of RelOpCluase has children!)");
        }
        BaseType lhsVal = this.lhs.getValue();
        if (this.lhs.isConstant()) {
            StringWriter val = new StringWriter();
            lhsVal.printVal(new PrintWriter(val), "", false);
            lop = val.toString();
        } else {
            lop = lhsVal.getLongName();
            if (useDatasetName) {
                lop = dds.getName() + "." + lop;
            }
        }
        switch (this.getOperator()) {
            case 5: {
                String op = "=";
                break;
            }
            case 6: {
                String op = "<>";
                break;
            }
            case 7: {
                String op = ">";
                break;
            }
            case 8: {
                String op = ">=";
                break;
            }
            case 9: {
                String op = "<";
                break;
            }
            case 10: {
                String op = "<=";
                break;
            }
            case 11: {
                String op = " LIKE ";
                isRegExp = true;
                break;
            }
            default: {
                throw new InvalidOperatorException("Only Simple Comparison Operators Are Support in SQL servers.");
            }
        }
        if (isRegExp) {
            ropLst = this.getRHS();
            for (int i = 0; i < ropLst.size(); ++i) {
                SubClause rhs_i = (SubClause)ropLst.get(i);
                List rhs_i_Children = rhs_i.getChildren();
                if (!rhs_i_Children.isEmpty()) {
                    throw new InvalidOperatorException("Nested expressions are not supported! (RHS[" + i + "] of RelOpClause has children!)");
                }
                BaseType rhsVal = rhs_i.getValue();
                if (!(rhsVal instanceof sqlString)) {
                    throw new InvalidOperatorException("Regular Expressions MUST Be Strings!");
                }
                String regexp = ((sqlString)rhsVal).getValue();
                String rop = this.regexp2SQL(regexp);
                if (i > 0) {
                    s = s + " OR ";
                }
                s = s + lop + (String)var4_9 + rop;
            }
            System.out.print("\n\n");
        } else {
            ropLst = this.getRHS();
            for (int i = 0; i < ropLst.size(); ++i) {
                String rop;
                SubClause rhs_i = (SubClause)ropLst.get(i);
                List rhs_i_Children = rhs_i.getChildren();
                if (!rhs_i_Children.isEmpty()) {
                    throw new InvalidOperatorException("Nested expressions are not supported! (RHS[" + i + "] of RelOpClause has children!)");
                }
                BaseType rhsVal = rhs_i.getValue();
                if (rhs_i.isConstant()) {
                    if (rhsVal instanceof SDString) {
                        rop = "'" + ((SDString)rhsVal).getValue() + "'";
                    } else if (rhsVal instanceof SDURL) {
                        rop = "'" + ((SDURL)rhsVal).getValue() + "'";
                    } else {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ServerMethods sm = (ServerMethods)((Object)rhsVal);
                        boolean proj = sm.isProject();
                        sm.setProject(true);
                        rhsVal.printVal(pw, "", false);
                        sm.setProject(proj);
                        rop = sw.toString();
                    }
                } else {
                    rop = rhsVal.getLongName();
                    rop = dds.getName() + "." + rop;
                }
                if (i > 0) {
                    s = s + " OR ";
                }
                s = s + lop + (String)var4_9 + rop;
            }
        }
        return s;
    }

    private String regexp2SQL(String regexp) throws InvalidOperatorException {
        int i;
        String[] unsupportedChars = new String[]{"\\|", "\\(", "\\)", "$", "+", "?"};
        for (int i2 = 0; i2 < unsupportedChars.length; ++i2) {
            if (regexp.indexOf(unsupportedChars[i2]) < 0) continue;
            String emsg = this.regexpError1 + "\n    The '" + unsupportedChars[i2] + "' special character is not supported.\n\n" + this.regexpError2;
            throw new InvalidOperatorException(emsg);
        }
        StringBuffer resb = new StringBuffer(regexp);
        for (int i3 = 0; i3 < resb.length(); ++i3) {
            if (resb.charAt(i3) == '%') {
                if (i3 > 0) {
                    if (resb.charAt(i3 - 1) != '\\') {
                        resb.insert(i3, '\\');
                    }
                } else {
                    resb.insert(i3, '\\');
                }
            }
            if (resb.charAt(i3) != '_') continue;
            if (i3 > 0) {
                if (resb.charAt(i3 - 1) == '\\') continue;
                resb.insert(i3, '\\');
                continue;
            }
            resb.insert(i3, '\\');
        }
        boolean badFormat = false;
        for (i = 0; i < resb.length(); ++i) {
            if (resb.charAt(i) != '*') continue;
            if (i > 0) {
                if (resb.charAt(i - 1) == '.') continue;
                badFormat = true;
                continue;
            }
            badFormat = true;
        }
        if (badFormat) {
            String emsg = this.regexpError1 + "\n    The '*'" + " must be used in conjunction with '.'\n" + "    As in '.*' only!\n\n" + this.regexpError2;
            throw new InvalidOperatorException(emsg);
        }
        for (i = 0; i < resb.length(); ++i) {
            if (resb.charAt(i) != '.') continue;
            if (i < resb.length() - 1) {
                if (resb.charAt(i + 1) == '*') {
                    resb.replace(i, i + 2, "%");
                    continue;
                }
                resb.replace(i, i + 1, "_");
                continue;
            }
            resb.replace(i, i + 1, "_");
        }
        String result = "'" + resb.toString() + "'";
        return result;
    }
}

