/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.NoSuchVariableException;
import dods.dap.Server.BTFunctionClause;
import dods.dap.Server.BoolFunction;
import dods.dap.Server.BoolFunctionClause;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.Clause;
import dods.dap.Server.ClauseFactory;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.SDODSException;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.dap.parser.ExprParserConstants;
import dods.servers.sql.SqlBTFunction;
import dods.servers.sql.SqlBoolFunction;
import dods.servers.sql.SqlRelOpClause;
import dods.servers.sql.sqlDDS;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class sqlCEEval
extends CEEvaluator
implements ExprParserConstants {
    private static final boolean _Debug = true;

    public sqlCEEval(ServerDDS dds) {
        super(dds);
    }

    public sqlCEEval(ServerDDS dds, ClauseFactory clauseFactory) {
        super(dds, clauseFactory);
    }

    public void send(String dataset, OutputStream sink, Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        Enumeration e = this.getDDS().getVariables();
        while (e.hasMoreElements()) {
            ServerMethods s = (ServerMethods)e.nextElement();
            System.out.println("CEE --- Sending variable: " + ((BaseType)((Object)s)).getName());
            if (!s.isProject()) continue;
            s.serialize(dataset, (DataOutputStream)sink, this, specialO);
        }
    }

    public String getSQLQuery(DAS das, boolean useDatasetName) throws InvalidOperatorException {
        sqlDDS dds = (sqlDDS)this.getDDS();
        String projectedVariables = "";
        String projectedTables = "";
        Vector projV = dds.getRequestedVars();
        Vector projT = dds.getRequestedTables();
        String prefix = "";
        if (useDatasetName) {
            prefix = dds.getName() + ".";
        }
        Enumeration e = projV.elements();
        while (e.hasMoreElements()) {
            projectedVariables = projectedVariables + prefix + ((BaseType)e.nextElement()).getLongName();
            if (!e.hasMoreElements()) continue;
            projectedVariables = projectedVariables + ", ";
        }
        e = projT.elements();
        while (e.hasMoreElements()) {
            projectedTables = projectedTables + prefix + ((BaseType)e.nextElement()).getLongName();
            if (!e.hasMoreElements()) continue;
            projectedTables = projectedTables + ", ";
        }
        System.out.println("projectedVariables: '" + projectedVariables + "'");
        System.out.println("projectedTables:    '" + projectedTables + "'");
        String query = "SELECT " + this.distinct() + projectedVariables + " FROM " + projectedTables;
        String constraint = this.convertClausesToSQL(useDatasetName);
        if (constraint != null) {
            query = query + " WHERE " + constraint;
        }
        return query;
    }

    private String distinct() {
        String distinct = "";
        LinkedList<Clause> uClauses = new LinkedList<Clause>();
        Enumeration enumeration = this.getClauses();
        while (enumeration.hasMoreElements()) {
            Clause c = (Clause)enumeration.nextElement();
            if (!(c instanceof BoolFunctionClause)) continue;
            BoolFunctionClause bfc = (BoolFunctionClause)c;
            BoolFunction func = bfc.getFunction();
            List args = bfc.getChildren();
            if (!func.getName().equals("unique") || !(func instanceof SqlBoolFunction)) continue;
            distinct = ((SqlBoolFunction)func).getSQLCommand(args);
            uClauses.add(c);
            System.out.println("THEY CALLED THE unique() FUNCTION!");
        }
        if (!uClauses.isEmpty()) {
            for (int i = 0; i < uClauses.size(); ++i) {
                this.removeClause((Clause)uClauses.get(i));
            }
        }
        return distinct;
    }

    protected String convertClausesToSQL(boolean useDatasetName) throws InvalidOperatorException {
        System.out.println("Converting Clauses to SQL constraints...");
        String constraint = null;
        Enumeration enumeration = this.getClauses();
        LinkedList<Clause> toBePurged = new LinkedList<Clause>();
        while (enumeration.hasMoreElements()) {
            Clause c = (Clause)enumeration.nextElement();
            String s = this.convertClauseToSQL(c, useDatasetName);
            System.out.println("SQL: " + s);
            if (s == null) continue;
            constraint = constraint != null ? constraint + " AND ( " + s + " )" : "(" + s + ")";
            toBePurged.add(c);
        }
        for (int i = 0; i < toBePurged.size(); ++i) {
            Clause c = (Clause)toBePurged.get(i);
            this.removeClause(c);
        }
        return constraint;
    }

    protected String convertClauseToSQL(Clause c, boolean useDatasetName) throws InvalidOperatorException {
        sqlDDS dds = (sqlDDS)this.getDDS();
        String s = "";
        if (c instanceof SqlRelOpClause) {
            SqlRelOpClause relop = (SqlRelOpClause)c;
            s = relop.getSqlRepresentation(useDatasetName, dds);
        } else if (c instanceof BTFunctionClause) {
            BTFunctionClause btfc = (BTFunctionClause)c;
            if (btfc.getFunction() instanceof SqlBTFunction) {
                List args = btfc.getChildren();
                s = ((SqlBTFunction)((Object)btfc)).getSQLCommand(args);
            } else {
                s = null;
            }
        } else if (c instanceof BoolFunctionClause) {
            BoolFunctionClause bfc = (BoolFunctionClause)c;
            BoolFunction func = bfc.getFunction();
            if (func instanceof SqlBoolFunction) {
                List args = bfc.getChildren();
                s = ((SqlBoolFunction)func).getSQLCommand(args);
            } else {
                s = null;
            }
        } else {
            s = null;
        }
        return s;
    }

    protected String getSQLVariables() {
        String s = null;
        return s;
    }

    protected String getSQLFromClause() {
        String s = null;
        return s;
    }

    protected String getSQLWhereClause() {
        String s = null;
        return s;
    }
}

