/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.EnumerationUnits;
import org.das2.qstream.SerializeDelegate;

public class EnumerationUnitsSerializeDelegate
implements SerializeDelegate {
    protected static final Logger logger = Logger.getLogger("qstream");
    private final Map<String, EnumerationUnits> contextEnumerationUnits = new HashMap<String, EnumerationUnits>();

    public EnumerationUnitsSerializeDelegate() {
        logger.log(Level.FINE, "create EUSD {0}", this.hashCode());
    }

    @Override
    public String format(Object o) {
        EnumerationUnits eu = (EnumerationUnits)o;
        StringBuilder buf = new StringBuilder();
        buf.append("").append(eu.getId()).append("[");
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object parse(String typeId, String s) {
        Pattern p = Pattern.compile("(.+?)(\\[(.*)\\])?");
        Matcher m = p.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad format!");
        }
        String id = m.group(1);
        EnumerationUnits u = this.contextEnumerationUnits.get(s);
        if (u == null) {
            u = new EnumerationUnits(id);
            this.contextEnumerationUnits.put(s, u);
        }
        logger.log(Level.FINER, "creating nominal datum {0} {1}", new Object[]{u, u.hashCode()});
        String values = m.group(3);
        String[] ss = values == null ? new String[]{} : values.split("::", -2);
        if (ss.length == 1) {
            assert (values != null);
            ss = values.split("; ", -2);
        }
        for (String nv : ss) {
            if (nv.trim().length() <= 0) continue;
            int idx = nv.indexOf(":");
            if (idx > -1) {
                try {
                    int ival = Integer.parseInt(nv.substring(0, idx));
                    String sval = nv.substring(idx + 1);
                    u.createDatum(ival, (Object)sval);
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.WARNING, "NumberFormatException caught: {0}", nv);
                }
                continue;
            }
            logger.log(Level.WARNING, "Bad index caught: {0}", nv);
        }
        return u;
    }

    @Override
    public String typeId(Class clas) {
        return "enumerationUnit";
    }
}

