/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qstream.QdsToD2sStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QdsToDas22
extends QdsToD2sStream {
    private static final Logger log = LoggerManager.getLogger((String)"qstream");
    static final int MAX_HDRS = 100;
    List<String> lHdrsSent = new ArrayList<String>();
    static final String[] aStdPlaneProps = new String[]{"BIN_MIN", "BIN_MAX", "BIN_MINUS", "BIN_PLUS"};

    public QdsToDas22() {
    }

    public QdsToDas22(int genSigDigits, int fracSecDigits) {
        super(genSigDigits, fracSecDigits);
    }

    @Override
    public boolean canWrite(QDataSet qds) {
        int nTypes = 0;
        if (SemanticOps.isJoin((QDataSet)qds)) {
            for (int i = 0; i < qds.length(); ++i) {
                if (!this._canWriteNonJoin((QDataSet)DataSetOps.slice0((QDataSet)qds, (int)i))) {
                    return false;
                }
                if (nTypes++ <= 99) continue;
                return false;
            }
            return true;
        }
        return this._canWriteNonJoin(qds);
    }

    @Override
    public boolean write(QDataSet qds, OutputStream os) throws IOException {
        String sPktHdr;
        QdsToD2sStream.PacketXferInfo pxi;
        int i;
        if (!this.canWrite(qds)) {
            return false;
        }
        ArrayList<String> lHdrsToSend = new ArrayList<String>();
        if (this.lHdrsSent.isEmpty()) {
            Document doc = this._makeStreamHdr(qds);
            if (doc == null) {
                return false;
            }
            lHdrsToSend.add(QdsToDas22.xmlDocToStr(doc));
        }
        ArrayList<QdsToD2sStream.PacketXferInfo> lPi = new ArrayList<QdsToD2sStream.PacketXferInfo>();
        if (SemanticOps.isJoin((QDataSet)qds)) {
            for (i = 0; i < qds.length(); ++i) {
                MutablePropertyDataSet ds = DataSetOps.slice0((QDataSet)qds, (int)i);
                pxi = this._makePktXferInfo((QDataSet)ds);
                if (pxi == null) {
                    return false;
                }
                lPi.add(pxi);
                sPktHdr = QdsToDas22.xmlDocToStr(pxi.doc);
                if (this.lHdrsSent.contains(sPktHdr)) continue;
                lHdrsToSend.add(sPktHdr);
            }
        } else {
            pxi = this._makePktXferInfo(qds);
            if (pxi == null) {
                return false;
            }
            lPi.add(pxi);
            sPktHdr = QdsToDas22.xmlDocToStr(pxi.doc);
            if (!this.lHdrsSent.contains(sPktHdr)) {
                lHdrsToSend.add(sPktHdr);
            }
        }
        for (i = 0; i < lHdrsToSend.size(); ++i) {
            int iPktId = this.lHdrsSent.size();
            if (iPktId >= 100) {
                return false;
            }
            QdsToDas22.writeHeader(os, 0, iPktId, (String)lHdrsToSend.get(i));
            this.lHdrsSent.add((String)lHdrsToSend.get(i));
        }
        for (QdsToD2sStream.PacketXferInfo pktinfo : lPi) {
            sPktHdr = QdsToDas22.xmlDocToStr(pktinfo.doc);
            int iPktId = this.lHdrsSent.indexOf(sPktHdr);
            this.writeData(os, 0, iPktId, pktinfo);
        }
        return true;
    }

    boolean _canWriteNonJoin(QDataSet qds) {
        String[] lTmp;
        QDataSet dsDep0 = null;
        QDataSet dsDep1 = null;
        if (qds instanceof BundleDataSet) {
            for (int i = 0; i < qds.length(0); ++i) {
                QDataSet dsDep;
                QDataSet ds = ((BundleDataSet)qds).unbundle(i);
                if (ds instanceof BundleDataSet) {
                    return false;
                }
                if (ds.rank() > 2) {
                    return false;
                }
                if (ds.rank() > 1) {
                    dsDep = (QDataSet)ds.property("DEPEND_1");
                    if (dsDep != null) {
                        if (dsDep1 == null) {
                            dsDep1 = dsDep;
                            log.log(Level.FINE, "dsDep1: {0}", dsDep1);
                        } else if (dsDep != dsDep1) {
                            return false;
                        }
                    }
                    if (dsDep != null && dsDep.rank() > 1) {
                        return false;
                    }
                }
                if ((dsDep = (QDataSet)ds.property("DEPEND_0")) == null) continue;
                if (dsDep0 == null) {
                    dsDep0 = dsDep;
                    log.log(Level.FINE, "dsDep0: {0}", dsDep0);
                    continue;
                }
                if (dsDep == dsDep0) continue;
                return false;
            }
            return true;
        }
        if (qds.rank() > 2) {
            return false;
        }
        QDataSet dsDep = (QDataSet)qds.property("DEPEND_1");
        if (dsDep != null && dsDep.rank() > 1) {
            return false;
        }
        for (String s : lTmp = new String[]{"BUNDLE_0", "BUNDLE_2", "BUNDLE_3"}) {
            if (qds.property(s) == null) continue;
            return false;
        }
        return true;
    }

    Document _makeStreamHdr(QDataSet qds) {
        Document doc = this.newXmlDoc();
        Element stream = doc.createElement("stream");
        stream.setAttribute("version", "2.2");
        Element props = doc.createElement("properties");
        int nProps = 0;
        nProps += this.addStrProp(props, qds, "TITLE", "title");
        nProps += this.addStrProp(props, qds, "DESCRIPTION", "summary");
        nProps += this.addStrProp(props, qds, "RENDER_TYPE", "renderer");
        String sAxis = QdsToDas22.getQdsAxis(qds);
        if (sAxis == null) {
            return null;
        }
        nProps += this._addSimpleProps(props, qds, sAxis);
        Map dUser = (Map)qds.property("USER_PROPERTIES");
        boolean bStripDot = this._stripDotProps(qds);
        if (dUser != null) {
            nProps += this.addPropsFromMap(props, dUser, bStripDot);
        }
        if (nProps > 0) {
            stream.appendChild(props);
        }
        doc.appendChild(stream);
        return doc;
    }

    QdsToD2sStream.PacketXferInfo _makePktXferInfo(QDataSet qds) throws IOException {
        QDataSet dep0;
        ArrayList<QdsToD2sStream.QdsXferInfo> lDsXfer = new ArrayList<QdsToD2sStream.QdsXferInfo>();
        Document doc = this.newXmlDoc();
        Element elPkt = doc.createElement("packet");
        doc.appendChild(elPkt);
        assert (!SemanticOps.isJoin((QDataSet)qds));
        ArrayList<QDataSet> lDsToRead = new ArrayList<QDataSet>();
        ArrayList<QDataSet> lDsRemain = new ArrayList<QDataSet>();
        if (qds instanceof BundleDataSet) {
            dep0 = (QDataSet)qds.property("DEPEND_0");
            if (dep0 != null) {
                this._addPhysicalDimension(elPkt, lDsXfer, "x", dep0);
            }
            for (int i = 0; i < qds.length(0); ++i) {
                lDsToRead.add(((BundleDataSet)qds).unbundle(i));
            }
        } else {
            lDsToRead.add(qds);
        }
        for (QDataSet ds : lDsToRead) {
            dep0 = (QDataSet)ds.property("DEPEND_0");
            if (dep0 != null) {
                if (lDsXfer.isEmpty()) {
                    this._addPhysicalDimension(elPkt, lDsXfer, "x", dep0);
                } else if (dep0 != ((QdsToD2sStream.QdsXferInfo)lDsXfer.get((int)0)).qds) {
                    log.warning("Multiple independent depend_0 datasets in bundle");
                    return null;
                }
                lDsRemain.add(ds);
                continue;
            }
            if (!lDsXfer.isEmpty() || ds.rank() != 1) continue;
            this._addPhysicalDimension(elPkt, lDsXfer, "x", ds);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        QDataSet dsZ = null;
        for (QDataSet ds : lDsToRead) {
            if (ds.rank() > 1) {
                lDsRemain.add(ds);
                continue;
            }
            assert (ds.property("DEPEND_0") != null);
            if (dsZ != null) {
                log.warning("Multiple Y planes encountered in X,Y,Z dataset");
                return null;
            }
            int nNewArrays = this._addPhysicalDimension(elPkt, lDsXfer, "y", ds);
            if (nNewArrays == 0) {
                return null;
            }
            dsZ = (QDataSet)ds.property("PLANE_0");
            if (dsZ == null) continue;
            if (SemanticOps.isBundle((QDataSet)dsZ)) {
                for (int i = 0; i < dsZ.length(); ++i) {
                    MutablePropertyDataSet dsSubZ = DataSetOps.slice0((QDataSet)dsZ, (int)i);
                    nNewArrays = this._addPhysicalDimension(elPkt, lDsXfer, "z", (QDataSet)dsSubZ);
                    if (nNewArrays != 0) continue;
                    return null;
                }
                continue;
            }
            nNewArrays = this._addPhysicalDimension(elPkt, lDsXfer, "z", dsZ);
            if (nNewArrays != 0) continue;
            return null;
        }
        lDsToRead = lDsRemain;
        QDataSet dsYTags = null;
        for (QDataSet ds : lDsToRead) {
            int nNewArrays;
            if (ds.rank() > 2) {
                assert (false);
                return null;
            }
            if (dsZ != null) {
                log.warning("YScan planes not allowed in the same packets as Z planes");
                return null;
            }
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null) {
                if (dsYTags == null) {
                    dsYTags = dep1;
                } else if (dsYTags != dep1) {
                    log.warning("Independent Y values for different rank-2  datasets in the same bundle");
                    return null;
                }
            }
            if ((nNewArrays = this._addPhysicalDimension(elPkt, lDsXfer, "yscan", ds)) >= 1) continue;
            return null;
        }
        return new QdsToD2sStream.PacketXferInfo(doc, lDsXfer);
    }

    int _addPhysicalDimension(Element elPkt, List<QdsToD2sStream.QdsXferInfo> lXfer, String sAxis, QDataSet ds) throws IOException {
        int nArrays = 0;
        Document doc = elPkt.getOwnerDocument();
        Element el = doc.createElement(sAxis);
        elPkt.appendChild(el);
        ++nArrays;
        QdsToD2sStream.QdsXferInfo xfer = new QdsToD2sStream.QdsXferInfo(ds, this.bBinary, this.nSigDigit, this.nSecDigit);
        lXfer.add(xfer);
        String sName = this._getName(elPkt, ds, sAxis);
        el.setAttribute("name", sName);
        el.setAttribute("type", this._makeTypeFromXfer(xfer));
        Units units = (Units)ds.property("UNITS");
        String sTag = sAxis.equals("yscan") ? "zUnits" : "units";
        el.setAttribute(sTag, units != null ? units.toString() : "");
        Element elProps = doc.createElement("properties");
        int nProps = 0;
        if (sAxis.equals("yscan")) {
            nProps += this._addSimpleProps(elProps, ds, "z");
            nProps += this._yTagsNProps(ds, el, elProps);
        } else {
            nProps += this._addSimpleProps(elProps, ds, sAxis);
        }
        if (nProps > 0) {
            el.appendChild(elProps);
        }
        String sErr = "Statistics dataset is a different rank than the average dataset";
        for (String sProp : aStdPlaneProps) {
            QDataSet dsStats = (QDataSet)ds.property(sProp);
            if (dsStats == null) continue;
            if (dsStats.rank() != ds.rank()) {
                log.warning(sErr);
                continue;
            }
            QdsToD2sStream.QdsXferInfo xferStats = new QdsToD2sStream.QdsXferInfo(dsStats, this.bBinary, this.nSigDigit, this.nSecDigit);
            Element elStats = doc.createElement(sAxis);
            elPkt.appendChild(elStats);
            lXfer.add(xferStats);
            ++nArrays;
            Units unitsStats = (Units)ds.property("UNITS");
            elStats.setAttribute("name", sName + "." + QdsToDas22._statsName(sProp));
            sTag = sAxis.equals("yscan") ? "zUnits" : "units";
            elStats.setAttribute(sTag, unitsStats != null ? unitsStats.toString() : "");
            elStats.setAttribute("type", this._makeTypeFromXfer(xferStats));
            Element elStatsProps = doc.createElement("properties");
            elStatsProps.setAttribute("source", sName);
            elStatsProps.setAttribute("operation", sProp);
            if (sAxis.equals("yscan")) {
                this._addSimpleProps(elStatsProps, dsStats, "z");
                this._yTagsNProps(dsStats, elStats, elStatsProps);
            } else {
                this._addSimpleProps(elStatsProps, dsStats, sAxis);
            }
            elStats.appendChild(elStatsProps);
        }
        return nArrays;
    }

    String _getName(Element elPkt, QDataSet ds, String sPlane) {
        String sName = (String)ds.property("NAME");
        if (sName != null) {
            return sName;
        }
        Units units = (Units)ds.property("UNITS");
        sName = this.makeNameFromUnits(units);
        if (sName.length() >= 0) {
            return sName;
        }
        int n = elPkt.getElementsByTagName(sPlane).getLength();
        return String.format("%s_%d", sPlane.toUpperCase(), n);
    }

    String _makeTypeFromXfer(QdsToD2sStream.QdsXferInfo xfer) throws IOException {
        String sName = xfer.name();
        int nSz = xfer.size();
        String sReal = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little_endian_real" : "sun_real";
        switch (sName) {
            case "double": {
                return String.format("%s8", sReal);
            }
            case "float": {
                return String.format("%s4", sReal);
            }
            case "ascii": {
                return String.format("ascii%d", nSz);
            }
            case "time": {
                return String.format("time%d", nSz);
            }
        }
        throw new IOException(String.format("das2.2 streams cannot transmit data values of type %s%d", sName, nSz));
    }

    static String _statsName(String sProp) {
        switch (sProp) {
            case "BIN_MIN": {
                return "min";
            }
            case "BIN_MAX": {
                return "max";
            }
            case "BIN_MINUS": {
                return "min";
            }
            case "BIN_PLUS": {
                return "max";
            }
        }
        return "unknown";
    }

    int _yTagsNProps(QDataSet ds, Element el, Element elProps) throws IOException {
        int nItems = ds.length(0);
        el.setAttribute("nitems", String.format("%d", nItems));
        QDataSet dsYTags = (QDataSet)ds.property("DEPEND_1");
        if (dsYTags == null) {
            el.setAttribute("yTagMin", "0.0");
            el.setAttribute("yTagInterval", "1.0");
            return 0;
        }
        if (dsYTags.rank() != 1) {
            throw new IOException("das2.2 YTags must be rank 1.  (Hint: Dataset may be exportable using das2.3/basic)");
        }
        QdsToD2sStream.Sequence1D seq = this.getSequenceRank1(dsYTags, 1.0E-4);
        if (seq != null) {
            el.setAttribute("yTagMin", seq.sMinval);
            el.setAttribute("yTagInterval", seq.sInterval);
        } else {
            String sFmt = String.format("%%.%de", this.nSigDigit);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(sFmt, dsYTags.value(0)));
            for (int i = 1; i < dsYTags.length(); ++i) {
                sb.append(",").append(String.format(sFmt, dsYTags.value(i)));
            }
            el.setAttribute("yTags", sb.toString());
        }
        Units yunits = (Units)dsYTags.property("UNITS");
        if (yunits != null) {
            el.setAttribute("yUnits", yunits.toString());
        } else {
            el.setAttribute("yUnits", "");
        }
        return this._addSimpleProps(elProps, dsYTags, "y");
    }

    int addBoolProp(Element props, String sName, Object oValue) {
        String sValue = (Boolean)oValue != false ? "true" : "false";
        props.setAttribute(sName, sValue);
        return 1;
    }

    int addStrProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addStrProp(props, d2key, oProp);
        }
        return 0;
    }

    int addStrProp(Element props, String sName, Object oValue) {
        String sInput = (String)oValue;
        Pattern p = Pattern.compile("%\\{ *USER_PROPERTIES\\.");
        Matcher m = p.matcher(sInput);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "%{");
        }
        m.appendTail(sb);
        String sOutput = sb.toString();
        props.setAttribute(sName, sOutput);
        return 1;
    }

    int addRealProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addRealProp(props, d2key, oProp);
        }
        return 0;
    }

    int addRealProp(Element props, String sName, Object oValue) {
        Number num = (Number)oValue;
        String sVal = String.format("%.6e", num.doubleValue());
        props.setAttribute("double:" + sName, sVal);
        return 1;
    }

    int addDatumProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addDatumProp(props, d2key, oProp);
        }
        return 0;
    }

    int addDatumProp(Element props, String sName, Object oValue) {
        Datum datum = (Datum)oValue;
        props.setAttribute("Datum:" + sName, datum.toString());
        return 1;
    }

    int addRngProp(Element props, QDataSet qds, String sMinKey, String sMaxKey, String sUnitsKey, String d2key) {
        String sValue;
        Object oMin = qds.property(sMinKey);
        Object oMax = qds.property(sMaxKey);
        Object oUnits = qds.property(sUnitsKey);
        if (oMin == null || oMax == null) {
            return 0;
        }
        Number rMin = (Number)oMin;
        Number rMax = (Number)oMax;
        if (oUnits != null) {
            String sUnits = ((Units)oUnits).toString();
            sValue = String.format("%.6e to %.6e %s", rMin.doubleValue(), rMax.doubleValue(), sUnits);
        } else {
            sValue = String.format("%.6e to %.6e", rMin.doubleValue(), rMax.doubleValue());
        }
        props.setAttribute("DatumRange:" + d2key, sValue);
        return 1;
    }

    int addRngProp(Element props, String sName, Object oValue) {
        String sOutput;
        DatumRange rng = (DatumRange)oValue;
        Units units = rng.getUnits();
        if (units instanceof TimeLocationUnits) {
            Datum dmMin = rng.min();
            Datum dmMax = rng.max();
            sOutput = String.format("%s to %s UTC", dmMin.toString().replaceAll("Z", ""), dmMax.toString().replaceAll("Z", ""));
        } else {
            sOutput = rng.toString();
        }
        props.setAttribute("DatumRange:" + sName, sOutput);
        return 1;
    }

    int _addSimpleProps(Element props, QDataSet qds, String sAxis) {
        int nProps = 0;
        nProps += this.addStrProp(props, qds, "FORMAT", sAxis + "Format");
        nProps += this.addStrProp(props, qds, "SCALE_TYPE", sAxis + "ScaleType");
        nProps += this.addStrProp(props, qds, "LABEL", sAxis + "Label");
        nProps += this.addStrProp(props, qds, "DESCRIPTION", sAxis + "Summary");
        nProps += this.addRealProp(props, qds, "FILL_VALUE", sAxis + "Fill");
        nProps += this.addRealProp(props, qds, "VALID_MIN", sAxis + "ValidMin");
        nProps += this.addRealProp(props, qds, "VALID_MAX", sAxis + "ValidMax");
        nProps += this.addRngProp(props, qds, "TYPICAL_MIN", "TYPICAL_MAX", "UNITS", sAxis + "Range");
        Object obj = qds.property("CADENCE");
        if (obj != null) {
            QDataSet dsTmp = (QDataSet)obj;
            Units units = (Units)dsTmp.property("UNITS");
            if (units == null) {
                units = Units.dimensionless;
            }
            Datum dtm = Datum.create((double)dsTmp.value(), (Units)units);
            props.setAttribute("Datum:" + sAxis + "TagWidth", dtm.toString());
            ++nProps;
        }
        return nProps;
    }

    int addPropsFromMap(Element props, Map<String, Object> dMap, boolean bStripDot) {
        if (dMap == null) {
            return 0;
        }
        int nAdded = 0;
        for (Map.Entry<String, Object> ent : dMap.entrySet()) {
            String sKey = ent.getKey();
            if (bStripDot && sKey.contains(".") || props.hasAttribute(sKey)) continue;
            Object oVal = ent.getValue();
            if (oVal instanceof Boolean) {
                nAdded += this.addBoolProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof String) {
                nAdded += this.addStrProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Number) {
                nAdded += this.addRealProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Datum) {
                nAdded += this.addDatumProp(props, sKey, oVal);
                continue;
            }
            if (!(oVal instanceof DatumRange)) continue;
            nAdded += this.addRngProp(props, sKey, oVal);
        }
        return nAdded;
    }
}

