/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.AsciiTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.FormatStreamHandler;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.TransferType;
import org.das2.qstream.Util;
import org.das2.qstream.XMLSerializeDelegate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SerialStreamFormatter {
    public static final int DEFAULT_TIME_DIGITS = 27;
    public static final String INOUTFORM_INLINE = "inline";
    public static final String INOUTFORM_ONE_RECORD = "oneRecord";
    public static final String INOUTFORM_STREAMING = "streaming";
    StreamDescriptor sd;
    StreamHandler sh;
    Map<String, PacketDescriptor> pds;
    Map<String, TransferType> transferTypes;
    Map<Units, TransferType> unitsTransferTypes;
    Map<QDataSet, String> names = new LinkedHashMap<QDataSet, String>();
    Map<String, String> namesRev = new LinkedHashMap<String, String>();
    private static final char CHAR_NEWLINE = '\n';
    private static final Logger logger = Logger.getLogger("qstream");
    protected boolean asciiTypes = true;
    protected boolean bigEndian = false;

    public boolean isAsciiTypes() {
        return this.asciiTypes;
    }

    public void setAsciiTypes(boolean asciiTypes) {
        this.asciiTypes = asciiTypes;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public SerialStreamFormatter() {
        this.transferTypes = new LinkedHashMap<String, TransferType>();
        this.unitsTransferTypes = new LinkedHashMap<Units, TransferType>();
    }

    protected StreamDescriptor doStreamDescriptor(String name) {
        try {
            StreamDescriptor sd = new StreamDescriptor(DocumentBuilderFactory.newInstance());
            Document document = sd.newDocument(sd);
            Element streamElement = document.createElement("stream");
            streamElement.setAttribute("dataset_id", name);
            if (!this.asciiTypes) {
                streamElement.setAttribute("byte_order", this.isBigEndian() ? "big_endian" : "little_endian");
            }
            sd.setDomElement(streamElement);
            sd.addDescriptor(sd);
            return sd;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(String name, WritableByteChannel out) throws IOException, StreamException {
        FormatStreamHandler sh = new FormatStreamHandler();
        sh.setWritableByteChannel(out);
        this.init(name, sh);
    }

    public void init(String name, StreamHandler sh) throws IOException, StreamException {
        this.pds = new HashMap<String, PacketDescriptor>();
        this.sd = this.doStreamDescriptor(name);
        this.sh = sh;
        sh.streamDescriptor(this.sd);
    }

    private synchronized String newNameFor(QDataSet ds1) {
        String name = this.names.get(ds1);
        if (name == null) {
            name = (String)ds1.property("NAME");
        }
        if (name == null) {
            name = "ds_" + this.names.size();
        }
        if (this.namesRev.containsKey(name)) {
            String name0 = name;
            int i = 1;
            name = name0 + String.valueOf(i);
            while (this.namesRev.containsKey(name)) {
                name = name0 + String.valueOf(++i);
            }
        }
        this.names.put(ds1, name);
        this.namesRev.put(name, ds1.toString());
        return name;
    }

    private synchronized String nameFor(QDataSet ds1) {
        boolean assignName;
        System.err.println("" + ds1 + " " + ds1.hashCode());
        String name = this.names.get(ds1);
        boolean bl = assignName = name == null;
        if (name == null) {
            name = (String)ds1.property("NAME");
        }
        if (name == null) {
            name = "ds_" + this.names.size();
        }
        if (assignName) {
            this.names.put(ds1, name);
            this.namesRev.put(name, ds1.toString());
        }
        return name;
    }

    private TransferType getUnitTransferType(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        return this.unitsTransferTypes.get(u);
    }

    private TransferType getTransferType(String name, QDataSet ds1) {
        TransferType tt = this.transferTypes.get(name);
        if (tt == null) {
            tt = this.getUnitTransferType(ds1);
            if (tt != null) {
                return tt;
            }
            if (this.asciiTypes) {
                Units u = SemanticOps.getUnits((QDataSet)ds1);
                tt = UnitsUtil.isTimeLocation((Units)u) ? new AsciiTimeTransferType(27, u) : new AsciiTransferType(10, true);
            } else if (ds1.length() > 125000) {
                logger.fine("using floats because we'll certainly run out of room otherwise");
                tt = new FloatTransferType();
            } else {
                tt = new DoubleTransferType();
            }
        }
        return tt;
    }

    public void setUnitTransferType(Units u, TransferType tt) {
        if (this.asciiTypes && !tt.isAscii()) {
            throw new IllegalArgumentException("stream is declared as ascii stream, but non-ascii transfer type specified for times: " + tt);
        }
        this.unitsTransferTypes.put(u, tt);
    }

    public void setTransferType(String name, TransferType tt) {
        if (this.asciiTypes && !tt.isAscii()) {
            throw new IllegalArgumentException("stream is declared as ascii stream, but non-ascii transfer type specified for " + name + ": " + tt);
        }
        this.transferTypes.put(name, tt);
    }

    private Element doProperties(Document document, Map<String, Object> props, boolean slice) {
        Element properties = document.createElement("properties");
        for (Map.Entry<String, Object> e : props.entrySet()) {
            String name = e.getKey();
            Element prop = null;
            Object value = e.getValue();
            String name1 = name;
            boolean allowRank0 = true;
            if (slice) {
                if (name.startsWith("DEPEND_")) {
                    name1 = "DEPEND_" + (1 + Integer.parseInt(name.substring(7)));
                } else if (name.equals("CONTEXT_0")) {
                    name1 = "DEPEND_0";
                    allowRank0 = false;
                } else if (name.startsWith("BINS_")) {
                    name1 = "BINS_" + (1 + Integer.parseInt(name.substring(5)));
                } else if (name.startsWith("BUNDLE_")) {
                    name1 = "BUNDLE_" + (1 + Integer.parseInt(name.substring(7)));
                }
            }
            if (value == null) continue;
            if (value instanceof QDataSet) {
                QDataSet qds = (QDataSet)value;
                prop = document.createElement("property");
                prop.setAttribute("name", name1);
                if (qds.rank() == 0 && allowRank0) {
                    SerializeDelegate r0d = SerializeRegistry.getByName("rank0dataset");
                    prop.setAttribute("type", "rank0dataset");
                    Units u = (Units)qds.property("UNITS");
                    if (u != null && u instanceof EnumerationUnits) continue;
                    prop.setAttribute("value", r0d.format(value));
                } else {
                    if (!this.names.containsKey((QDataSet)value)) {
                        System.err.println("Unidentified " + name1 + "!!");
                    }
                    prop.setAttribute("type", "qdataset");
                    prop.setAttribute("value", this.nameFor((QDataSet)value));
                }
            } else {
                SerializeDelegate sd = SerializeRegistry.getDelegate(value.getClass());
                if (sd == null) {
                    System.err.println("dropping " + name1 + " because unsupported type: " + value.getClass());
                } else {
                    prop = document.createElement("property");
                    prop.setAttribute("name", name1);
                    if (sd instanceof XMLSerializeDelegate) {
                        prop.appendChild(((XMLSerializeDelegate)((Object)sd)).xmlFormat(document, value));
                    } else {
                        prop.setAttribute("type", sd.typeId(value.getClass()));
                        prop.setAttribute("value", sd.format(value));
                    }
                }
            }
            if (prop == null) continue;
            properties.appendChild(prop);
        }
        return properties;
    }

    private Element doValues(Document document, PacketDescriptor packetDescriptor, PlaneDescriptor planeDescriptor, QDataSet ds1) {
        Element values = document.createElement("values");
        int[] qubeDims = null;
        if (!packetDescriptor.isValuesInDescriptor()) {
            values.setAttribute("encoding", planeDescriptor.getType().name());
            qubeDims = DataSetUtil.qubeDims((QDataSet)ds1);
        }
        if (packetDescriptor.isStream()) {
            if (ds1.rank() > 0) {
                values.setAttribute("length", Util.encodeArray(qubeDims, 0, qubeDims.length));
            } else {
                values.setAttribute("length", "");
            }
        } else {
            if (qubeDims != null) {
                values.setAttribute("length", Util.encodeArray(qubeDims, 0, qubeDims.length));
            }
            if (packetDescriptor.isValuesInDescriptor()) {
                StringBuilder s = new StringBuilder("");
                for (int i = 0; i < ds1.length(); ++i) {
                    s.append(",").append(ds1.value(i));
                }
                values.setAttribute("values", ds1.length() == 0 ? "" : s.substring(1));
                if (ds1.length() == 0) {
                    values.setAttribute("length", "0");
                }
            }
        }
        return values;
    }

    private void doValuesElement(QDataSet ds, PacketDescriptor pd, PlaneDescriptor planeDescriptor, Document document, Element qdatasetElement) throws DOMException {
        QDataSet bundleDescriptor;
        Object sunits = ds.property("UNITS");
        if (sunits != null && !(sunits instanceof Units)) {
            throw new IllegalArgumentException("UNITS property doesn't contain type units, it's type " + sunits.getClass() + ": " + sunits);
        }
        Units u = (Units)sunits;
        if (u == null && SemanticOps.isRank1Bundle((QDataSet)ds) && ds.rank() == 1 && (bundleDescriptor = (QDataSet)ds.property("BUNDLE_0")) != null) {
            for (int i = 0; i < bundleDescriptor.length(); ++i) {
                Units u1 = (Units)bundleDescriptor.property("UNITS", i);
                if (u1 == null || !UnitsUtil.isTimeLocation((Units)u1)) continue;
                System.err.println("using high res kludge to format bundle dataset that contains " + u1);
            }
        }
        String name = this.nameFor(ds);
        TransferType tt = this.getTransferType(name, ds);
        if (!pd.isValuesInDescriptor()) {
            planeDescriptor.setType(tt);
        }
        if (pd.isValuesInDescriptor() && ds.rank() == 2) {
            for (int i = 0; i < ds.length(); ++i) {
                Element values = this.doValues(document, pd, planeDescriptor, ds.slice(i));
                values.setAttribute("index", String.valueOf(i));
                qdatasetElement.appendChild(values);
            }
        } else {
            Element values = this.doValues(document, pd, planeDescriptor, ds);
            qdatasetElement.appendChild(values);
        }
    }

    private PlaneDescriptor doPlaneDescriptor(Document document, PacketDescriptor pd, QDataSet ds, boolean slice) {
        QDataSet bds;
        Element qdatasetElement = document.createElement("qdataset");
        qdatasetElement.setAttribute("id", this.newNameFor(ds));
        logger.log(Level.FINE, "writing qdataset {0}", this.nameFor(ds));
        qdatasetElement.setAttribute("rank", String.valueOf(ds.rank() + (slice ? 1 : 0)));
        if (SemanticOps.isRank1Bundle((QDataSet)ds) && (bds = (QDataSet)ds.property("BUNDLE_0")) == null) {
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                Element props = this.doProperties(document, DataSetUtil.getProperties((QDataSet)ds1), slice);
                props.setAttribute("index", String.valueOf(i));
                qdatasetElement.appendChild(props);
            }
        }
        Element props = this.doProperties(document, DataSetUtil.getProperties((QDataSet)ds), slice);
        qdatasetElement.appendChild(props);
        PlaneDescriptor planeDescriptor = new PlaneDescriptor();
        planeDescriptor.setRank(ds.rank());
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        if (!pd.valuesInDescriptor) {
            if (pd.isStream()) {
                planeDescriptor.setQube(qube);
            } else {
                planeDescriptor.setQube(qube);
            }
        } else if (ds.length() == 0) {
            logger.severe("here ds.length()==0");
        }
        planeDescriptor.setDs(ds);
        planeDescriptor.setName(this.nameFor(ds));
        this.doValuesElement(ds, pd, planeDescriptor, document, qdatasetElement);
        planeDescriptor.setDomElement(qdatasetElement);
        return planeDescriptor;
    }

    private PacketDescriptor doPacketDescriptor(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank, String joinId) {
        try {
            PlaneDescriptor planeDescriptor;
            QDataSet plane0;
            int i;
            QDataSet dep0;
            if (!valuesInDescriptor && !DataSetUtil.isQube((QDataSet)ds)) {
                throw new IllegalArgumentException("must be qube!");
            }
            PacketDescriptor packetDescriptor = new PacketDescriptor();
            packetDescriptor.setStream(stream);
            packetDescriptor.setStreamRank(streamRank);
            if (valuesInDescriptor) {
                packetDescriptor.setValuesInDescriptor(true);
            }
            Document document = sd.newDocument(packetDescriptor);
            Element packetElement = document.createElement("packet");
            if (stream && (dep0 = (QDataSet)ds.property("CONTEXT_0")) != null) {
                PlaneDescriptor planeDescriptor2 = this.doPlaneDescriptor(document, packetDescriptor, dep0, stream);
                packetDescriptor.addPlane(planeDescriptor2);
                packetElement.appendChild(planeDescriptor2.getDomElement());
            }
            for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
                planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, plane0, stream);
                packetDescriptor.addPlane(planeDescriptor);
                packetElement.appendChild(planeDescriptor.getDomElement());
            }
            if (SemanticOps.isBundle((QDataSet)ds)) {
                for (i = 0; i < ds.length(0); ++i) {
                    QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                    planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds1, stream);
                    packetDescriptor.addPlane(planeDescriptor);
                    Element dselement = planeDescriptor.getDomElement();
                    if (joinId != null) {
                        dselement.setAttribute("joinId", joinId);
                    }
                    packetElement.appendChild(dselement);
                }
            } else {
                PlaneDescriptor planeDescriptor3 = this.doPlaneDescriptor(document, packetDescriptor, ds, stream);
                packetDescriptor.addPlane(planeDescriptor3);
                Element dselement = planeDescriptor3.getDomElement();
                if (joinId != null) {
                    dselement.setAttribute("joinId", joinId);
                }
                packetElement.appendChild(dselement);
            }
            packetDescriptor.setDomElement(packetElement);
            return packetDescriptor;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void maybeFormat(String name, QDataSet ds1, String inoutForm) throws IOException, StreamException {
        if (ds1 != null) {
            this.format(name, ds1, inoutForm);
        }
    }

    public void format(String joinName, String name, QDataSet ds1, String inoutForm) throws IOException, StreamException {
        int planeCount;
        PacketDescriptor pd;
        if (name == null || name.trim().length() == 0) {
            if (inoutForm.equals(INOUTFORM_INLINE)) {
                name = this.nameFor(ds1);
            } else {
                throw new IllegalArgumentException("anonymous dataset must be inline");
            }
        }
        if ((pd = this.pds.get(name)) == null || inoutForm.equals(INOUTFORM_INLINE)) {
            pd = inoutForm.equals(INOUTFORM_INLINE) ? this.doPacketDescriptor(this.sd, ds1, false, true, ds1.rank(), joinName) : (inoutForm.equals(INOUTFORM_ONE_RECORD) ? this.doPacketDescriptor(this.sd, ds1, false, false, ds1.rank(), joinName) : this.doPacketDescriptor(this.sd, ds1, true, false, ds1.rank() + 1, joinName));
            this.pds.put(name, pd);
            this.sh.packetDescriptor(pd);
            if (inoutForm.equals(INOUTFORM_INLINE)) {
                return;
            }
        }
        int bufferSize = 4 + pd.sizeBytes();
        byte[] bbuf = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(bbuf);
        if (this.isBigEndian()) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        String packetTag = String.format(":%02d:", this.sd.descriptorId(pd));
        buffer.put(packetTag.getBytes());
        if (pd.isStream()) {
            planeCount = pd.planes.size();
            if (planeCount > 2) {
                throw new IllegalArgumentException("more than two planes found!");
            }
            for (int iplane = 0; iplane < planeCount; ++iplane) {
                boolean lastPlane;
                PlaneDescriptor plane = pd.planes.get(iplane);
                TransferType tt = plane.getType();
                QDataSet planeds = iplane == planeCount - 1 ? ds1 : (QDataSet)ds1.property("CONTEXT_0");
                boolean bl = lastPlane = iplane == planeCount - 1;
                if (planeds.rank() == 0) {
                    tt.write(planeds.value(), buffer);
                } else if (planeds.rank() == 1) {
                    for (int j = 0; j < planeds.length(); ++j) {
                        tt.write(planeds.value(j), buffer);
                    }
                } else {
                    QDataSet slice = planeds;
                    QubeDataSetIterator it = new QubeDataSetIterator(slice);
                    while (it.hasNext()) {
                        it.next();
                        tt.write(it.getValue(slice), buffer);
                    }
                }
                if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                buffer.put(bufferSize - 1, (byte)10);
            }
            buffer.flip();
            buffer.position(4);
            this.sh.packet(pd, buffer.slice());
            buffer.flip();
        } else {
            planeCount = pd.planes.size();
            for (int iplane = 0; iplane < planeCount; ++iplane) {
                boolean lastPlane;
                PlaneDescriptor plane = pd.planes.get(iplane);
                TransferType tt = plane.getType();
                QDataSet planeds = plane.getDs();
                QubeDataSetIterator it = new QubeDataSetIterator(planeds);
                while (it.hasNext()) {
                    it.next();
                    tt.write(it.getValue(planeds), buffer);
                }
                boolean bl = lastPlane = iplane == planeCount - 1;
                if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                buffer.put(bufferSize - 1, (byte)10);
            }
            buffer.flip();
            buffer.position(4);
            this.sh.packet(pd, buffer.slice());
            buffer.flip();
        }
        ArrayList probs = new ArrayList();
        if (!DataSetUtil.validate((QDataSet)ds1, probs)) {
            throw new IllegalArgumentException("DataSet is not valid: " + (String)probs.get(0));
        }
    }

    public void format(String name, QDataSet ds1, String inoutForm) throws IOException, StreamException {
        this.format(null, name, ds1, inoutForm);
    }

    public void join(String name, int rank, Map<String, Object> props) throws StreamException, IOException {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(true);
        packetDescriptor.setStreamRank(rank);
        try {
            Document document = this.sd.newDocument(packetDescriptor);
            Element packetElement = document.createElement("packet");
            Element qdataset = document.createElement("qdataset");
            packetElement.appendChild(qdataset);
            qdataset.setAttribute("id", name);
            qdataset.setAttribute("rank", String.valueOf(rank));
            Element propsElement = this.doProperties(document, props, false);
            qdataset.appendChild(propsElement);
            Element valuesElement = document.createElement("values");
            valuesElement.setAttribute("join", "ignore");
            qdataset.appendChild(valuesElement);
            packetDescriptor.setDomElement(packetElement);
            this.sh.packetDescriptor(packetDescriptor);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void retire(String name) {
        PacketDescriptor pd = this.pds.get(name);
        this.sd.retireDescriptor(pd);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamException {
        QDataSet ds = Ops.ripplesJoinSpectrogramTimeSeries((int)24);
        boolean join = SemanticOps.isJoin((QDataSet)ds);
        SerialStreamFormatter form = new SerialStreamFormatter();
        String name = "Flux";
        form.setAsciiTypes(true);
        form.setTransferType(name, new AsciiTransferType(10, false));
        form.setUnitTransferType((Units)Units.us2000, new AsciiTimeTransferType(17, (Units)Units.us2000));
        form.init(name, Channels.newChannel(new FileOutputStream("/tmp/foo.serialStreamFormatter.toStream.qds")));
        if (join) {
            form.join(name, 3, new HashMap<String, Object>());
            for (int j = 0; j < ds.length(); ++j) {
                QDataSet jds1 = ds.slice(j);
                form.maybeFormat(null, (QDataSet)jds1.property("DEPEND_1"), INOUTFORM_INLINE);
                String channelName = name + String.valueOf(j);
                for (int i = 0; i < jds1.length(); ++i) {
                    form.format(name, channelName, jds1.slice(i), INOUTFORM_STREAMING);
                }
            }
        } else {
            form.maybeFormat(null, (QDataSet)ds.property("DEPEND_1"), INOUTFORM_INLINE);
            for (int i = 0; i < ds.length(); ++i) {
                form.format(name, ds.slice(i), INOUTFORM_STREAMING);
            }
        }
    }
}

