/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Random;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.FDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import test.BundleBinsDemo;

public class SimpleStreamFormatterTest {
    public static void main(String[] args) throws ParseException, StreamException, FileNotFoundException, IOException {
        SimpleStreamFormatterTest.testBundle();
    }

    private static QDataSet test1() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)11);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format(ds, new FileOutputStream("test1.qds"), true);
        return ds;
    }

    private static QDataSet test1_5() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.labelsDataset((String[])new String[]{"B-GSM,X", "B-GSM,Y", "B-GSM,Z"});
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format(ds, new FileOutputStream("test1_5.qds"), true);
        return ds;
    }

    private static QDataSet test2() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)11);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.findgen((int)11, (int)3);
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labelsDataset((String[])new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)ds, new FileOutputStream("test2.qds"), true);
        return ds;
    }

    private static QDataSet test3() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("13.86 " + Units.seconds), (int)11);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.multiply((QDataSet)Ops.pow((QDataSet)Ops.replicate((double)100000.0, (int)11, (int)3), (QDataSet)Ops.randu((int)11, (int)3)), (QDataSet)Ops.randu((int)11, (int)3));
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet mode = (MutablePropertyDataSet)Ops.floor((QDataSet)Ops.multiply((QDataSet)Ops.randu((int)11), (QDataSet)Ops.replicate((int)4, (int)11)));
        EnumerationUnits u = new EnumerationUnits("quality");
        u.createDatum(0, (Object)"Good");
        u.createDatum(1, (Object)"Better");
        u.createDatum(2, (Object)"Best");
        u.createDatum(3, (Object)"Perfect");
        mode.putProperty("UNITS", (Object)u);
        mode.putProperty("DEPEND_0", (Object)tags);
        mode.putProperty("NAME", (Object)"quality");
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labelsDataset((String[])new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        ds.putProperty("PLANE_0", (Object)mode);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)ds, new FileOutputStream("test3.qds"), true);
        return ds;
    }

    private static QDataSet test4_rank3() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)3, (int)4, (int)5);
        ds.putValue(1, 2, 3, 0.05);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)ds, new FileOutputStream("test4_rank3.qds"), true);
        return ds;
    }

    private static QDataSet test0_rank2() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)3, (int)4);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)ds, new FileOutputStream("test0_rank2.qds"), true);
        return ds;
    }

    private static QDataSet test5() throws StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)5);
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)ds, new FileOutputStream("test5.qds"), true);
        return ds;
    }

    private static QDataSet test6() throws StreamException, IOException {
        QDataSet result = null;
        result = Ops.join(result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format(result, new FileOutputStream("test6.qds"), true);
        return result;
    }

    private static QDataSet test7() throws StreamException, IOException {
        int nrec = 190000;
        long t0 = System.currentTimeMillis();
        FDataSet result = FDataSet.createRank1((int)nrec);
        SimpleStreamFormatterTest.funData((WritableDataSet)result, 9.2, 0.01, 0, false);
        DDataSet dep0 = DDataSet.createRank1((int)nrec);
        SimpleStreamFormatterTest.funData((WritableDataSet)dep0, 10000.0, 0.01, 0, true);
        result.putProperty("DEPEND_0", (Object)dep0);
        for (int i = 0; i < 13; ++i) {
            FDataSet planeds = FDataSet.createRank1((int)nrec);
            SimpleStreamFormatterTest.funData((WritableDataSet)planeds, Math.random() * 100.0, Math.random() * 10.0, 0, false);
            planeds.putProperty("NAME", (Object)("myplane_" + i));
            result.putProperty("PLANE_" + i, (Object)planeds);
        }
        System.err.println("generated data in  " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
        System.err.println("formatting... ");
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format((QDataSet)result, new FileOutputStream("test7.qds"), false);
        System.err.println("time: " + (System.currentTimeMillis() - t0));
        return result;
    }

    private static void testBundle() throws StreamException, FileNotFoundException, IOException {
        QDataSet ds = BundleBinsDemo.demo1();
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        format.format(ds, new FileOutputStream("testBundle.qds"), true);
    }

    private static void funData(WritableDataSet ds, double start, double res, int seed, boolean mono) {
        Random rand = new Random(seed);
        if (!mono) {
            QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res * (rand.nextDouble() - 0.5);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res;
            }
        }
    }
}

