/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom2d.Triangle;
import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.PointWeighted;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.volumes.Volume;
import ProGAL.math.Constants;
import java.util.Collection;
import java.util.List;

public class Sphere
implements Volume {
    protected Point center;
    protected double radius;

    public Sphere(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Sphere(double x, double y, double z, double radius) {
        this.center = new Point(x, y, z);
        this.radius = radius;
    }

    public Sphere(Point[] ps) {
        this(0.0, 0.0, 0.0, 0.0);
        this.radius = Sphere.computeSphere_fast(ps[0], ps[1], ps[2], ps[3], this.center);
    }

    public Sphere(Point p0, Point p1, Point p2, Point p3) {
        this(0.0, 0.0, 0.0, 0.0);
        this.radius = Sphere.computeSphere_fast(p0, p1, p2, p3, this.center);
    }

    public Sphere(CTetrahedron tetr) {
        this(0.0, 0.0, 0.0, 0.0);
        Point[] ps = tetr.getCorners();
        this.radius = Sphere.computeSphere_fast(ps[0], ps[1], ps[2], ps[3], this.center);
    }

    public Sphere(PointWeighted p) {
        this.center = p;
        this.radius = Math.sqrt(p.getWeight());
    }

    public Sphere(Circle c) {
        this.center = c.getCenter();
        this.radius = c.getRadius();
    }

    public static double computeSphere_fast(Point p0, Point p1, Point p2, Point p3, Point center) {
        double x1 = p1.x() - p0.x();
        double y1 = p1.y() - p0.y();
        double z1 = p1.z() - p0.z();
        double x2 = p2.x() - p0.x();
        double y2 = p2.y() - p0.y();
        double z2 = p2.z() - p0.z();
        double x3 = p3.x() - p0.x();
        double y3 = p3.y() - p0.y();
        double z3 = p3.z() - p0.z();
        double xx1 = x1 * x1 + y1 * y1 + z1 * z1;
        double xx2 = x2 * x2 + y2 * y2 + z2 * z2;
        double xx3 = x3 * x3 + y3 * y3 + z3 * z3;
        double x1y2 = x1 * y2;
        double x1y3 = x1 * y3;
        double x1z2 = x1 * z2;
        double x1z3 = x1 * z3;
        double x2y1 = x2 * y1;
        double x2y3 = x2 * y3;
        double x2z1 = x2 * z1;
        double x2z3 = x2 * z3;
        double x3y2 = x3 * y2;
        double x3y1 = x3 * y1;
        double x3z2 = x3 * z2;
        double x3z1 = x3 * z1;
        double y1z2 = y1 * z2;
        double y1z3 = y1 * z3;
        double y2z1 = y2 * z1;
        double y2z3 = y2 * z3;
        double y3z1 = y3 * z1;
        double y3z2 = y3 * z2;
        double m11 = -((x1y2 - x2y1) * z3 + (x3y1 - x1y3) * z2 + (x2y3 - x3y2) * z1);
        if (m11 != 0.0) {
            double m12 = -(xx1 * (y2z3 - y3z2) + xx3 * (y1z2 - y2z1) + xx2 * (y3z1 - y1z3));
            double m13 = -(xx1 * (x2z3 - x3z2) + xx3 * (x1z2 - x2z1) + xx2 * (x3z1 - x1z3));
            double m14 = -(xx1 * (x2y3 - x3y2) + xx3 * (x1y2 - x2y1) + xx2 * (x3y1 - x1y3));
            double m11x2 = 0.5 / m11;
            double x = m12 * m11x2;
            double y = -m13 * m11x2;
            double z = m14 * m11x2;
            if (center != null) {
                center.setX(x + p0.x());
                center.setY(y + p0.y());
                center.setZ(z + p0.z());
            }
            return Math.sqrt(x * x + y * y + z * z);
        }
        throw new RuntimeException("Points are coplanar");
    }

    private void computeSphere(Point p0, Point p1, Point p2, Point p3) {
        double x0 = p0.x();
        double y0 = p0.y();
        double z0 = p0.z();
        double x1 = p1.x();
        double y1 = p1.y();
        double z1 = p1.z();
        double x2 = p2.x();
        double y2 = p2.y();
        double z2 = p2.z();
        double x3 = p3.x();
        double y3 = p3.y();
        double z3 = p3.z();
        double xx0 = x0 * x0 + y0 * y0 + z0 * z0;
        double xx1 = x1 * x1 + y1 * y1 + z1 * z1;
        double xx2 = x2 * x2 + y2 * y2 + z2 * z2;
        double xx3 = x3 * x3 + y3 * y3 + z3 * z3;
        double y1z2 = y1 * z2;
        double y3z1 = y3 * z1;
        double y2z3 = y2 * z3;
        double y1z3 = y1 * z3;
        double y2z1 = y2 * z1;
        double y3z2 = y3 * z2;
        double x1z2 = x1 * z2;
        double x3z1 = x3 * z1;
        double x2z3 = x2 * z3;
        double x1z3 = x1 * z3;
        double x2z1 = x2 * z1;
        double x3z2 = x3 * z2;
        double x1y2 = x1 * y2;
        double x3y1 = x3 * y1;
        double x2y3 = x2 * y3;
        double x1y3 = x1 * y3;
        double x2y1 = x2 * y1;
        double x3y2 = x3 * y2;
        double m11 = x0 * (y1z2 + y3z1 + y2z3 - y1z3 - y2z1 - y3z2) - y0 * (x1z2 + x3z1 + x2z3 - x1z3 - x2z1 - x3z2) + z0 * (x1y2 + x3y1 + x2y3 - x1y3 - x2y1 - x3y2) - ((x1y2 - x2y1) * z3 + (x3y1 - x1y3) * z2 + (x2y3 - x3y2) * z1);
        if (m11 != 0.0) {
            double m12 = xx0 * (y1z2 + y3z1 + y2z3 - y1z3 - y2z1 - y3z2) - y0 * (xx1 * (z2 - z3) + xx3 * (z1 - z2) + xx2 * (z3 - z1)) + z0 * (xx1 * (y2 - y3) + xx3 * (y1 - y2) + xx2 * (y3 - y1)) - (xx1 * (y2z3 - y3z2) + xx3 * (y1z2 - y2z1) + xx2 * (y3z1 - y1z3));
            double m13 = xx0 * (x1z2 + x3z1 + x2z3 - x1z3 - x2z1 - x3z2) - x0 * (xx1 * (z2 - z3) + xx3 * (z1 - z2) + xx2 * (z3 - z1)) + z0 * (xx1 * (x2 - x3) + xx3 * (x1 - x2) + xx2 * (x3 - x1)) - (xx1 * (x2z3 - x3z2) + xx3 * (x1z2 - x2z1) + xx2 * (x3z1 - x1z3));
            double m14 = xx0 * (x1y2 + x3y1 + x2y3 - x1y3 - x2y1 - x3y2) - x0 * (xx1 * (y2 - y3) + xx3 * (y1 - y2) + xx2 * (y3 - y1)) + y0 * (xx1 * (x2 - x3) + xx3 * (x1 - x2) + xx2 * (x3 - x1)) - (xx1 * (x2y3 - x3y2) + xx3 * (x1y2 - x2y1) + xx2 * (x3y1 - x1y3));
            double m15 = xx0 * (z3 * (x1y2 - x2y1) + z2 * (x3y1 - x1y3) + z1 * (x2y3 - x3y2)) - x0 * (xx1 * (y2z3 - y3z2) + xx3 * (y1z2 - y2z1) + xx2 * (y3z1 - y1z3)) + y0 * (xx1 * (x2z3 - x3z2) + xx3 * (x1z2 - x2z1) + xx2 * (x3z1 - x1z3)) - z0 * (xx1 * (x2y3 - x3y2) + xx3 * (x1y2 - x2y1) + xx2 * (x3y1 - x1y3));
            double m11x2 = 0.5 / m11;
            double x = m12 * m11x2;
            double y = -m13 * m11x2;
            double z = m14 * m11x2;
            this.center = new Point(x, y, z);
            this.radius = Math.sqrt(x * x + y * y + z * z - m15 / m11);
        } else {
            System.out.println("Points are coplanar");
        }
    }

    @Override
    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getRadiusSquared() {
        return this.radius * this.radius;
    }

    public double getSurfaceArea() {
        return Math.PI * 4 * this.radius * this.radius;
    }

    @Override
    public double getVolume() {
        return this.getSurfaceArea() * this.radius / 3.0;
    }

    public boolean isInside(Point p) {
        return this.center.distanceSquared(p) < this.getRadiusSquared();
    }

    public boolean isInside(Point p, double eps) {
        return this.center.distanceSquared(p) < this.radius * this.radius - eps;
    }

    public boolean isEmpty(Point[] points, double eps) {
        for (int i = 0; i < points.length; ++i) {
            if (!this.isInside(points[i], eps)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(List<Vertex> points, double eps) {
        for (Point point : points) {
            if (!this.isInside(point, eps)) continue;
            return false;
        }
        return true;
    }

    public void contains(List<Vertex> points, double eps) {
        for (Vertex p : points) {
            if (!this.isInside(p, eps)) continue;
            System.out.print(p.getId() + " " + this.radius * this.radius + " " + this.center.distanceSquared(p) + ", ");
        }
        System.out.println();
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public void setCenter(Point p0, Point p1, Point p2, Point p3) {
        this.computeSphere(p0, p1, p2, p3);
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean isIntersected(Sphere sphere) {
        return this.overlaps(sphere);
    }

    public LineSegment getIntersection(Line line) {
        double u1;
        double u2;
        double c;
        double a;
        double ez;
        double ey;
        Point p1 = line.getP();
        Point p2 = line.getPoint(1.0);
        double dx = p2.x() - p1.x();
        double dy = p2.y() - p1.y();
        double dz = p2.z() - p1.z();
        double ex = p1.x() - this.center.x();
        double b = 2.0 * (dx * ex + dy * (ey = p1.y() - this.center.y()) + dz * (ez = p1.z() - this.center.z()));
        double delta = b * b - 4.0 * (a = dx * dx + dy * dy + dz * dz) * (c = this.center.x() * this.center.x() + this.center.y() * this.center.y() + this.center.z() * this.center.z() + p1.x() * p1.x() + p1.y() * p1.y() + p1.z() * p1.z() - 2.0 * (this.center.x() * p1.x() + this.center.y() * p1.y() + this.center.z() * p1.z()) - this.radius * this.radius);
        if (delta < 0.0) {
            return null;
        }
        if (delta == 0.0) {
            u1 = u2 = -b / (2.0 * a);
        } else {
            double sqr = Math.sqrt(delta);
            u1 = (-b + sqr) / (2.0 * a);
            u2 = (-b - sqr) / (2.0 * a);
        }
        return new LineSegment(new Point(p1.x() + u1 * dx, p1.y() + u1 * dy, p1.z() + u1 * dz), new Point(p1.x() + u2 * dx, p1.y() + u2 * dy, p1.z() + u2 * dz));
    }

    public double[] intersectionParameters(Line line) {
        double rr;
        double cc;
        Vector c;
        Vector l = line.getDir();
        double lc = l.dot(c = line.getP().vectorTo(this.center));
        double tmp = lc * lc - (cc = c.dot(c)) + (rr = this.radius * this.radius);
        if (tmp < 0.0) {
            return new double[0];
        }
        if (tmp == 0.0) {
            return new double[]{lc};
        }
        double d1 = lc - Math.sqrt(tmp);
        double d2 = lc + Math.sqrt(tmp);
        return new double[]{d1, d2};
    }

    public Point[] getIntersections(Circle c) {
        Plane plane = new Plane(c.getCenter(), c.getNormalVector());
        Circle c2 = plane.getIntersection(this);
        if (c2 != null) {
            return c.getIntersection(c2);
        }
        return null;
    }

    public Double getIntersectionAngle(Circle c, Point p, Vector dir) {
        Plane plane = new Plane(c.getCenter(), c.getNormalVector());
        Circle c2 = plane.getIntersection(this);
        if (c2 != null) {
            return c.getFirstIntersection(c2, p, dir);
        }
        return null;
    }

    public boolean containsNone(List<Point> points) {
        double rr = this.radius * this.radius - 1.0E-9;
        for (Point p : points) {
            if (!(p.distanceSquared(this.center) < rr)) continue;
            return false;
        }
        return true;
    }

    public int containsNumber(List<Vertex> points) {
        int count = 0;
        double rr = this.radius * this.radius - 1.0E-9;
        for (Point point : points) {
            if (!(point.distanceSquared(this.center) < rr)) continue;
            ++count;
        }
        return count;
    }

    public boolean containsNoneButAtMostOne(Vertex v, List<Vertex> points) {
        double rr = this.radius * this.radius - 1.0E-9;
        for (Vertex p : points) {
            if (!(p.distanceSquared(this.center) < rr) || p == v) continue;
            System.out.println("Contains vertex " + p.getId());
            return false;
        }
        return true;
    }

    public boolean contains(Point p) {
        double rr = this.radius * this.radius - 1.0E-9;
        return p.distanceSquared(this.center) < rr;
    }

    public double powerDistance(Point p) {
        return this.center.distanceSquared(p) - this.radius * this.radius;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Sphere3d[%s,%" + dec + "f]", this.center.toString(dec), this.radius);
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    @Override
    public boolean overlaps(Volume vol) {
        if (vol instanceof Sphere) {
            return ((Sphere)vol).center.distance(this.center) <= ((Sphere)vol).radius + this.radius;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Sphere clone() {
        return new Sphere(this.center.clone(), this.radius);
    }

    public static Sphere getMinSphere(Circle c) {
        return new Sphere(c.getCenter(), c.getRadius());
    }

    public static Sphere getMinSphere(Point p1, Point p2) {
        return new Sphere(Point.getMidpoint(p1, p2), p1.distance(p2) / 2.0);
    }

    public static Sphere getMinSphere(Point p0, Point p1, Point p2) {
        Point center = new Point((p0.x() + p1.x() + p2.x()) / 3.0, (p0.y() + p1.y() + p2.y()) / 3.0, (p0.z() + p1.z() + p2.z()) / 3.0);
        double radius = p0.distance(center);
        return new Sphere(center, radius);
    }

    public static Sphere getMinSphere(Point p0, Point p1, Point p2, Point p3) {
        Sphere ret = new Sphere(0.0, 0.0, 0.0, 0.0);
        ret.radius = Sphere.computeSphere_fast(p0, p1, p2, p3, ret.center);
        return ret;
    }

    public static Sphere getMinSphere(PointList points) {
        return Sphere.getMinSphere(points.getRandomPermutation(), points.size(), new PointList());
    }

    private static Sphere getMinSphere(PointList points, int n, PointList boundaryPoints) {
        Sphere sphere = null;
        int k = 0;
        switch (boundaryPoints.size()) {
            case 0: {
                sphere = Sphere.getMinSphere((Point)points.get(0), (Point)points.get(1));
                k = 2;
                break;
            }
            case 1: {
                sphere = Sphere.getMinSphere((Point)points.get(0), (Point)boundaryPoints.get(0));
                k = 1;
                break;
            }
            case 2: {
                sphere = Sphere.getMinSphere((Point)boundaryPoints.get(0), (Point)boundaryPoints.get(1));
                break;
            }
            case 3: {
                sphere = Sphere.getMinSphere((Point)boundaryPoints.get(0), (Point)boundaryPoints.get(1), (Point)boundaryPoints.get(2));
            }
        }
        for (int i = k; i < n + boundaryPoints.size(); ++i) {
            Point p = (Point)points.get(i);
            if (boundaryPoints.contains(p) || sphere.isInside(p)) continue;
            if (boundaryPoints.size() < 3) {
                boundaryPoints.add(p);
                sphere = Sphere.getMinSphere(points, i - 1, boundaryPoints);
                boundaryPoints.remove(p);
                continue;
            }
            sphere = Sphere.getMinSphere((Point)boundaryPoints.get(0), (Point)boundaryPoints.get(1), (Point)boundaryPoints.get(2), p);
        }
        return sphere;
    }

    public static Circle getIntersection(Sphere s1, Sphere s2) {
        double r1 = s1.radius;
        double r2 = s2.radius;
        double d = s1.center.distance(s2.center);
        if (d > r1 + r2) {
            return null;
        }
        double h = Triangle.calculateHeight(r1, r2, d);
        double d1 = Math.sqrt(r1 * r1 - h * h);
        double d2 = Math.sqrt(r2 * r2 - h * h);
        if (d2 > d) {
            d1 *= -1.0;
        }
        Vector normal = s1.center.vectorTo(s2.center).normalizeThis();
        Point center = s1.center.add(normal.multiply(d1));
        return new Circle(center, h, normal);
    }

    public static Point[] getIntersections(Sphere s1, Sphere s2, Sphere s3) {
        Circle i12 = Sphere.getIntersection(s1, s2);
        if (i12 == null) {
            return new Point[0];
        }
        return s3.getIntersections(i12);
    }

    private double angle(Vector v1, Vector v2) {
        double ret = Math.atan2(v1.y(), v1.x()) - Math.atan2(v2.y(), v2.x());
        if (ret < 0.0) {
            ret = Constants.TAU + ret;
        }
        return ret;
    }

    private Double findAngle(int start, int end, Vertex A, Vertex B, Vertex C, Vertex D, int dir, double alphaVal) {
        Point Cnew = C.clone();
        Point Dnew = D.clone();
        if (dir == 0) {
            Cnew.rotationCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(start));
            Dnew.rotationCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(start));
        } else {
            Cnew.rotationCCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(start));
            Dnew.rotationCCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(start));
        }
        double radius = new Sphere(A, B, Cnew, Dnew).getRadius();
        if (Math.abs(radius - alphaVal) < Math.pow(10.0, -9.0)) {
            return (double)start * 1.0;
        }
        System.out.println("Radius-alphaVal = " + (radius - alphaVal));
        double sign = Math.signum(radius - alphaVal);
        double newStart = start;
        double newEnd = end;
        for (int i = 0; i < 99; ++i) {
            double angle = (newEnd + newStart) / 2.0;
            System.out.println("Angle = " + angle);
            Cnew = C.clone();
            Dnew = D.clone();
            if (dir == 0) {
                Cnew.rotationCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(angle));
                Dnew.rotationCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(angle));
            } else {
                Cnew.rotationCCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(angle));
                Dnew.rotationCCW(new Vector(0.0, 0.0, 1.0), Math.toRadians(angle));
            }
            radius = new Sphere(A, B, Cnew, Dnew).getRadius();
            System.out.println("Radius-alphaVal = " + (radius - alphaVal));
            if (Math.abs(radius - alphaVal) < Math.pow(10.0, -9.0)) {
                return angle;
            }
            double newSign = Math.signum(radius - alphaVal);
            if (newSign != sign) {
                newEnd = angle;
                continue;
            }
            newStart = angle;
        }
        return null;
    }

    public static double unionVolume_Grid(Collection<Sphere> spheres) {
        Point[] centers = new Point[spheres.size()];
        double[] radSqs = new double[spheres.size()];
        double[] rads = new double[spheres.size()];
        Point minPoint = new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point maxPoint = new Point(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int c = 0;
        for (Sphere s : spheres) {
            centers[c] = s.center;
            radSqs[c] = s.getRadiusSquared();
            rads[c] = s.radius;
            ++c;
            for (int i = 0; i < 3; ++i) {
                if (s.center.get(i) - s.radius < minPoint.get(i)) {
                    minPoint.set(i, s.center.get(i) - s.radius);
                }
                if (!(s.center.get(i) + s.radius > maxPoint.get(i))) continue;
                maxPoint.set(i, s.center.get(i) + s.radius);
            }
        }
        int cells = 80;
        double[] delta = new double[]{(maxPoint.x() - minPoint.x()) / (double)cells, (maxPoint.y() - minPoint.y()) / (double)cells, (maxPoint.z() - minPoint.z()) / (double)cells};
        boolean[][][] bits = new boolean[cells + 1][cells + 1][cells + 1];
        int xC = 0;
        int yC = 0;
        int zC = 0;
        for (double x = minPoint.x(); x <= maxPoint.x(); x += delta[0]) {
            yC = 0;
            for (double y = minPoint.y(); y <= maxPoint.y(); y += delta[1]) {
                zC = 0;
                for (double z = minPoint.z(); z <= maxPoint.z(); z += delta[2]) {
                    for (int i = 0; i < centers.length; ++i) {
                        double dX = Math.abs(x - centers[i].x());
                        double dY = Math.abs(y - centers[i].y());
                        double dZ = Math.abs(z - centers[i].z());
                        if (dX > rads[i] || dY > rads[i] || dZ > rads[i] || !(dX * dX + dY * dY + dZ * dZ < radSqs[i])) continue;
                        bits[xC][yC][zC] = true;
                        break;
                    }
                    ++zC;
                }
                ++yC;
            }
            ++xC;
        }
        int borderCells = 0;
        int insideCells = 0;
        for (int x = 0; x < cells; ++x) {
            for (int y = 0; y < cells; ++y) {
                for (int z = 0; z < cells; ++z) {
                    if (!bits[x][y][z] && !bits[x][y][z + 1] && !bits[x][y + 1][z] && !bits[x][y + 1][z + 1] && !bits[x + 1][y][z] && !bits[x + 1][y][z + 1] && !bits[x + 1][y + 1][z] && !bits[x + 1][y + 1][z + 1]) continue;
                    if (bits[x][y][z] && bits[x][y][z + 1] && bits[x][y + 1][z] && bits[x][y + 1][z + 1] && bits[x + 1][y][z] && bits[x + 1][y][z + 1] && bits[x + 1][y + 1][z] && bits[x + 1][y + 1][z + 1]) {
                        ++insideCells;
                        continue;
                    }
                    ++borderCells;
                }
            }
        }
        double cellVol = delta[0] * delta[1] * delta[2];
        double insideVol = cellVol * (double)insideCells;
        double borderVol = cellVol * (double)borderCells;
        return insideVol + borderVol / 2.0;
    }

    public PointList generateRandomPointsOnSphere(int n) {
        PointList ret = PointList.generateRandomPointsOnSphere(n);
        for (Point p : ret) {
            p.scaleThis(this.radius);
            p.addThis(this.center.toVector());
        }
        return ret;
    }

    public PointList generatePointsOnSphere(int n) {
        PointList ret = PointList.generatePointsOnSphere(n);
        for (Point p : ret) {
            p.scaleThis(this.radius);
            p.addThis(this.center.toVector());
        }
        return ret;
    }
}

