/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.QDataSet;

public final class GridDataSet
extends AbstractDataSet {
    TreeMap<Integer, Double> xtags;
    TreeMap<Integer, Double> ytags;
    Map<Double, Integer> rxtags;
    Map<Double, Integer> rytags;
    Map<Integer, Double> values;
    int ix = 0;
    int iy = 0;
    private static final double FILL = -1.0E31;
    private AbstractDataSet x = new AbstractDataSet(){

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return GridDataSet.this.xtags.get(i);
        }

        @Override
        public int length() {
            return GridDataSet.this.xtags.size();
        }
    };
    private AbstractDataSet y = new AbstractDataSet(){

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return GridDataSet.this.ytags.get(i);
        }

        @Override
        public int length() {
            return GridDataSet.this.ytags.size();
        }
    };

    public GridDataSet() {
        this.xtags = new TreeMap();
        this.rxtags = new HashMap<Double, Integer>();
        this.ytags = new TreeMap();
        this.rytags = new HashMap<Double, Integer>();
        this.values = new HashMap<Integer, Double>();
        this.properties.put("FILL_VALUE", -1.0E31);
    }

    public void add(QDataSet slice) {
        QDataSet bds = null;
        if (slice.rank() == 1) {
            double xx = slice.value(0);
            double yy = slice.value(1);
            double zz = slice.value(2);
            this.add(xx, yy, zz);
            bds = (QDataSet)slice.property("BUNDLE_0");
        } else if (slice.rank() == 2) {
            for (int i = 0; i < slice.length(); ++i) {
                double xx = slice.value(i, 0);
                double yy = slice.value(i, 1);
                double zz = slice.value(i, 2);
                this.add(xx, yy, zz);
            }
            bds = (QDataSet)slice.property("BUNDLE_1");
        }
        if (bds != null) {
            for (int i = 0; i < 3; ++i) {
                String s;
                AbstractDataSet mds;
                switch (i) {
                    case 0: {
                        mds = this.x;
                        break;
                    }
                    case 1: {
                        mds = this.y;
                        break;
                    }
                    default: {
                        mds = this;
                    }
                }
                Units u = (Units)bds.property("UNITS", i);
                if (u != null) {
                    mds.putProperty("UNITS", u);
                }
                if ((s = (String)bds.property("LABEL", i)) != null) {
                    mds.putProperty("LABEL", s);
                }
                if ((s = (String)bds.property("TITLE", i)) == null) continue;
                mds.putProperty("TITLE", s);
            }
        }
    }

    public void add(double x, double y, double z) {
        int iiy;
        int iix;
        if (!this.rxtags.containsKey(x)) {
            this.xtags.put(this.ix, x);
            this.rxtags.put(x, this.ix);
            iix = this.ix++;
        } else {
            iix = this.rxtags.get(x);
        }
        if (!this.rytags.containsKey(y)) {
            this.ytags.put(this.iy, y);
            this.rytags.put(y, this.iy);
            iiy = this.iy++;
        } else {
            iiy = this.rytags.get(y);
        }
        this.values.put(iiy * 10000 + iix, z);
    }

    @Override
    public int rank() {
        return 2;
    }

    @Override
    public int length() {
        return this.xtags.size();
    }

    @Override
    public int length(int i) {
        return this.ytags.size();
    }

    @Override
    public Object property(String name) {
        switch (name) {
            case "DEPEND_0": {
                return this.x;
            }
            case "DEPEND_1": {
                return this.y;
            }
        }
        return super.property(name);
    }

    @Override
    public double value(int i0, int i1) {
        Double v = this.values.get(i1 * 10000 + i0);
        if (v == null) {
            return -1.0E31;
        }
        return v;
    }
}

