/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class SubsetDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset");
    QDataSet source;
    QDataSet[] sorts;
    int[] lens;
    boolean nonQube = false;

    private static List<Integer> indgen(int start, int stop, int stride) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = start; i < stop; i += stride) {
            result.add(i);
        }
        return result;
    }

    public static int[] parseIndices(String spec, int dimlen) throws ParseException {
        int[] iresult;
        boolean invert;
        Pattern p1 = Pattern.compile("(\\-?\\d+)\\-(\\-?\\d+)");
        Pattern p2 = Pattern.compile("(\\-?\\d+)?\\:(\\-?\\d+)?(\\:(\\-?\\d+)?)?");
        boolean bl = invert = spec.length() > 1 && spec.charAt(0) == '~';
        if (invert) {
            spec = spec.substring(1);
        }
        String[] ss = spec.split(",");
        ArrayList<Integer> result = new ArrayList<Integer>();
        int charPos = 0;
        for (String s : ss) {
            int stop;
            int start;
            Matcher m = p2.matcher(s);
            if (m.matches()) {
                int n = start = m.group(1) == null ? 0 : Integer.parseInt(m.group(1));
                if (start < 0) {
                    start += dimlen;
                }
                int n2 = stop = m.group(2) == null ? dimlen : Integer.parseInt(m.group(2));
                if (stop < 0) {
                    stop += dimlen;
                }
                int stride = m.group(4) == null ? 1 : Integer.parseInt(m.group(4));
                List<Integer> ii = SubsetDataSet.indgen(start, stop, stride);
                result.addAll(ii);
            } else {
                m = p1.matcher(s);
                if (m.matches()) {
                    int n = start = m.group(1) == null ? 0 : Integer.parseInt(m.group(1));
                    if (start < 0) {
                        start += dimlen;
                    }
                    int n3 = stop = m.group(2) == null ? dimlen : Integer.parseInt(m.group(2));
                    if (stop < 0) {
                        stop += dimlen;
                    }
                    List<Integer> ii = start > stop ? SubsetDataSet.indgen(stop, start + 1, 1) : SubsetDataSet.indgen(start, stop + 1, 1);
                    result.addAll(ii);
                } else {
                    try {
                        int ii = Integer.parseInt(s);
                        if (ii < 0) {
                            ii += dimlen;
                        }
                        result.add(ii);
                    }
                    catch (NumberFormatException ex) {
                        throw new ParseException("unable to parse: " + s, charPos);
                    }
                }
            }
            charPos += 1 + s.length();
        }
        if (invert) {
            iresult = new int[dimlen - result.size()];
            Collections.sort(result);
            int resultIndex = 0;
            int outputIndex = 0;
            int ii = (Integer)result.get(resultIndex);
            for (int i = 0; i < dimlen; ++i) {
                if (i == ii) {
                    if (++resultIndex == result.size()) {
                        ii = Integer.MAX_VALUE;
                        continue;
                    }
                    ii = (Integer)result.get(resultIndex);
                    continue;
                }
                iresult[outputIndex] = i;
                ++outputIndex;
            }
        } else {
            iresult = new int[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                iresult[i] = (Integer)result.get(i);
            }
        }
        return iresult;
    }

    public SubsetDataSet(QDataSet source) {
        this.source = source;
        this.sorts = new QDataSet[source.rank()];
        this.lens = new int[source.rank()];
        if (!DataSetUtil.isQube(source)) {
            this.nonQube = true;
        } else {
            QDataSet dep1 = (QDataSet)source.slice(0).property("DEPEND_0");
            this.putProperty("DEPEND_1", dep1);
        }
        int[] lenss = DataSetUtil.qubeDims(source);
        if (this.nonQube) {
            this.lens[0] = source.length();
            this.sorts[0] = new IndexGenDataSet(this.lens[0]);
            for (int i = 1; i < source.rank(); ++i) {
                this.lens[i] = Integer.MAX_VALUE;
                this.sorts[i] = new IndexGenDataSet(this.lens[i]);
            }
        } else {
            for (int i = 0; i < lenss.length; ++i) {
                this.lens[i] = lenss[i];
                this.sorts[i] = new IndexGenDataSet(lenss[i]);
            }
        }
    }

    public void applyIndex(int idim, QDataSet idx) {
        String[] ss;
        QDataSet bundle;
        int i;
        QDataSet max;
        if (this.nonQube && idim > 0) {
            throw new IllegalArgumentException("unable to applyIndex on non-qube source dataset");
        }
        if (idx.rank() == 1 && (max = Ops.reduceMax(idx, 0)).value() >= (double)this.lens[idim]) {
            logger.log(Level.WARNING, "idx dataset contains maximum that is out-of-bounds: {0}", max);
        }
        this.sorts[idim] = idx;
        this.lens[idim] = idx.length();
        if (idx.rank() > 1) {
            throw new IllegalArgumentException("indexes must be rank 1");
        }
        QDataSet dep = (QDataSet)this.property("DEPEND_" + idim);
        if (dep == null) {
            dep = (QDataSet)this.source.property("DEPEND_" + idim);
        }
        if (dep != null) {
            SubsetDataSet dim = new SubsetDataSet(dep);
            switch (dep.rank()) {
                case 1: {
                    dim.applyIndex(0, idx);
                    break;
                }
                case 2: {
                    if (dep.property("BINS_1") != null) {
                        dim.applyIndex(0, idx);
                        break;
                    }
                    if (dep.property("BUNDLE_1") != null) {
                        dim.applyIndex(0, idx);
                        break;
                    }
                    dim.applyIndex(1, idx);
                    break;
                }
                case 3: {
                    dim.applyIndex(2, idx);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DEPEND_" + idim + " must be rank 1 or rank 2");
                }
            }
            this.putProperty("DEPEND_" + idim, dim);
        }
        for (i = idim + 1; i < this.source.rank(); ++i) {
            dep = (QDataSet)this.property("DEPEND_" + i);
            if (dep == null || dep.rank() < 2) continue;
            SubsetDataSet dim = new SubsetDataSet(dep);
            dim.applyIndex(idim, idx);
            this.putProperty("DEPEND_" + i, dim);
        }
        if (idim == 0) {
            for (i = 1; i < 4; ++i) {
                QDataSet depi = (QDataSet)this.source.property("DEPEND_" + i);
                if (depi == null || depi.rank() <= 1) continue;
                SubsetDataSet dim = new SubsetDataSet(depi);
                dim.applyIndex(0, idx);
                this.putProperty("DEPEND_" + i, dim);
            }
        }
        if ((bundle = (QDataSet)this.property("BUNDLE_" + idim)) == null) {
            bundle = (QDataSet)this.source.property("BUNDLE" + idim);
        }
        if (bundle != null) {
            SubsetDataSet b = new SubsetDataSet(bundle);
            b.applyIndex(0, idx);
            this.putProperty("BUNDLE_" + idim, b);
        }
        block11: for (String s : ss = new String[]{"DELTA_PLUS", "DELTA_MINUS", "BIN_PLUS", "BIN_MINUS"}) {
            QDataSet d = (QDataSet)this.property(s);
            if (d == null) continue;
            switch (d.rank()) {
                case 3: {
                    SubsetDataSet b = new SubsetDataSet(d);
                    b.applyIndex(idim, idx);
                    this.putProperty(s, b);
                    continue block11;
                }
                case 2: {
                    SubsetDataSet b = new SubsetDataSet(d);
                    b.applyIndex(idim == 0 ? 0 : 1, idx);
                    this.putProperty(s, b);
                    continue block11;
                }
                default: {
                    if (idim != 0) continue block11;
                    SubsetDataSet b = new SubsetDataSet(d);
                    b.applyIndex(0, idx);
                    this.putProperty(s, b);
                }
            }
        }
    }

    @Override
    public int rank() {
        return this.source.rank();
    }

    @Override
    public int length() {
        return this.lens[0];
    }

    @Override
    public int length(int i) {
        return this.nonQube ? this.source.length(i) : this.lens[1];
    }

    @Override
    public int length(int i, int j) {
        return this.nonQube ? this.source.length(i, j) : this.lens[2];
    }

    @Override
    public int length(int i, int j, int k) {
        return this.nonQube ? this.source.length(i, j, k) : this.lens[3];
    }

    @Override
    public double value() {
        return this.source.value();
    }

    @Override
    public double value(int i) {
        return this.source.value((int)this.sorts[0].value(i));
    }

    @Override
    public double value(int i0, int i1) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2), (int)this.sorts[3].value(i3));
    }

    @Override
    public Object property(String name, int i) {
        Object v = this.properties.get(name);
        return v != null ? v : this.source.property(name, (int)this.sorts[0].value(i));
    }

    @Override
    public Object property(String name) {
        Object v = this.properties.get(name);
        Object result = v != null ? v : this.source.property(name);
        return result;
    }
}

