/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.datum.Datum;
import org.das2.qds.QDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.ops.Ops;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class ExpandToFillGapsFilterEditorPanel
extends AbstractFilterEditorPanel {
    public static final String PROP_REGEX = "\\|expandToFillGaps\\((.*)\\)";
    private QDataSet ds;
    private JLabel aboutDataLabel;
    private JRadioButton autoButton;
    private JPanel autoPanel;
    private ButtonGroup buttonGroup1;
    private JTextField expandRatioTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JRadioButton manualButton;
    private JPanel manualPanel;
    private JTextField minimumCadenceTF;
    private JFormattedTextField multiplierTF;
    private BindingGroup bindingGroup;

    public ExpandToFillGapsFilterEditorPanel() {
        this.initComponents();
        this.bindingGroup = new BindingGroup();
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autoPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.autoButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.manualButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.updateAutoMessage();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.autoButton = new JRadioButton();
        this.manualButton = new JRadioButton();
        this.autoPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.expandRatioTextField = new JTextField();
        this.aboutDataLabel = new JLabel();
        this.manualPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.minimumCadenceTF = new JTextField();
        this.jLabel4 = new JLabel();
        this.multiplierTF = new JFormattedTextField();
        this.jLabel1.setText("Expand To Fill Gaps");
        this.buttonGroup1.add(this.autoButton);
        this.autoButton.setSelected(true);
        this.autoButton.setText("Auto-Detect");
        this.buttonGroup1.add(this.manualButton);
        this.manualButton.setText("Manual");
        this.manualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpandToFillGapsFilterEditorPanel.this.manualButtonActionPerformed(evt);
            }
        });
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autoButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.autoPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel2.setText("Expand Ratio (1.0 is entire gap):");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autoPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.expandRatioTextField.setText("1.0");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autoPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.expandRatioTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.expandRatioTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExpandToFillGapsFilterEditorPanel.this.expandRatioTextFieldFocusLost(evt);
            }
        });
        this.expandRatioTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpandToFillGapsFilterEditorPanel.this.expandRatioTextFieldActionPerformed(evt);
            }
        });
        this.aboutDataLabel.setFont(this.aboutDataLabel.getFont().deriveFont(this.aboutDataLabel.getFont().getStyle() | 2, this.aboutDataLabel.getFont().getSize() - 1));
        this.aboutDataLabel.setText("jLabel3");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autoPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.aboutDataLabel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout autoPanelLayout = new GroupLayout(this.autoPanel);
        this.autoPanel.setLayout(autoPanelLayout);
        autoPanelLayout.setHorizontalGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addContainerGap().addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aboutDataLabel, -1, -1, Short.MAX_VALUE).addGroup(autoPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expandRatioTextField, -2, 88, -2).addGap(0, 60, Short.MAX_VALUE))).addContainerGap()));
        autoPanelLayout.setVerticalGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.expandRatioTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.aboutDataLabel)));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.manualPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel3.setText("Minimum Cadence:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.jLabel3, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.minimumCadenceTF.setText("1s");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.minimumCadenceTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel4.setText("Expansion Multiplier:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.jLabel4, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.multiplierTF.setText("1.0");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.manualPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.multiplierTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout manualPanelLayout = new GroupLayout(this.manualPanel);
        this.manualPanel.setLayout(manualPanelLayout);
        manualPanelLayout.setHorizontalGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualPanelLayout.createSequentialGroup().addContainerGap().addGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(manualPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minimumCadenceTF)).addGroup(manualPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multiplierTF, -2, 85, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        manualPanelLayout.setVerticalGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualPanelLayout.createSequentialGroup().addContainerGap().addGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.minimumCadenceTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.multiplierTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.autoButton).addGap(18, 18, 18).addComponent(this.manualButton))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.autoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.manualPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoButton).addComponent(this.manualButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void manualButtonActionPerformed(ActionEvent evt) {
    }

    private void expandRatioTextFieldActionPerformed(ActionEvent evt) {
        this.updateAutoMessage();
    }

    private void expandRatioTextFieldFocusLost(FocusEvent evt) {
        this.updateAutoMessage();
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String arg = m.group(1);
            String[] ss = arg.split(",");
            if (ss.length == 1) {
                this.expandRatioTextField.setText(ss[0]);
                this.autoButton.setSelected(true);
            } else {
                this.minimumCadenceTF.setText(ss[0]);
                this.multiplierTF.setText(ss[1]);
                this.manualButton.setSelected(true);
            }
        } else {
            this.expandRatioTextField.setText("0.8");
            this.autoButton.setSelected(true);
        }
    }

    @Override
    public String getFilter() {
        if (this.autoButton.isSelected()) {
            return "|expandToFillGaps(" + this.expandRatioTextField.getText() + ")";
        }
        return "|expandToFillGaps(" + this.minimumCadenceTF.getText() + "," + this.multiplierTF.getText() + ")";
    }

    private void updateAutoMessage() {
        if (this.ds != null) {
            Datum cadenceMin;
            Datum twiceCadenceMin;
            QDataSet ttags = (QDataSet)this.ds.property("DEPEND_0");
            if (ttags == null) {
                this.aboutDataLabel.setText("dataset didn't have timetags.");
                return;
            }
            QDataSet dts = Ops.abs(Ops.diff(ttags));
            QDataSet r = Ops.where(Ops.gt((Object)dts, twiceCadenceMin = (cadenceMin = Ops.datum(Ops.reduceMin(dts, 0))).multiply(2.0)));
            if (r.length() < 1) {
                this.aboutDataLabel.setText("no gaps found.");
            } else {
                double factor;
                int[] startIndexes = new int[r.length() + 1];
                startIndexes[0] = 0;
                Datum cadenceMax = null;
                int count = 0;
                for (int i = 0; i < r.length(); ++i) {
                    startIndexes[i + 1] = (int)r.value(i);
                    Datum cadence = Ops.datum(Ops.subtract(ttags.slice(startIndexes[i + 1] + 1), ttags.slice(startIndexes[i])));
                    if (cadenceMax != null && (!(cadence.value() > 0.0) || !cadence.lt(cadenceMax))) continue;
                    cadenceMax = cadence;
                    count = startIndexes[i + 1] + 1 - startIndexes[i];
                }
                assert (cadenceMax != null);
                double stepFactor = cadenceMax.divide(cadenceMin).divide((double)count).value();
                try {
                    factor = Double.parseDouble(this.expandRatioTextField.getText());
                }
                catch (NumberFormatException ex) {
                    factor = 0.8;
                }
                double expansionMultiplier = stepFactor * factor;
                this.aboutDataLabel.setText("fine cadence is " + cadenceMin + " and expand to fill gaps of " + cadenceMax + " using an expansion multiplier of " + String.format("%.2f", expansionMultiplier));
                logger.log(Level.FINE, "expandToFillGaps: cadenceMin={0} cadenceMax={1}", new Object[]{cadenceMin, cadenceMax});
            }
        } else {
            this.aboutDataLabel.setText("no dataset available for context.");
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        this.ds = ds;
        if (Schemes.isRank2Waveform(ds)) {
            this.aboutDataLabel.setText("data is rank 2 waveform.");
        } else if (ds.rank() == 2) {
            this.updateAutoMessage();
        }
    }
}

