/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class UnbundleFilterEditorPanel
extends AbstractFilterEditorPanel {
    public static final String PROP_REGEX = "\\|unbundle\\((.+)\\)";
    public JComboBox jComboBox1;
    public JLabel jLabel1;

    public UnbundleFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel1.setText("Component to unbundle :");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(2, 2, 2).add((Component)this.jComboBox1, 0, 150, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBox1, -2, -1, -2)));
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.firePropertyChange("filter", null, this.getFilter());
    }

    @Override
    public void setInput(QDataSet ds) {
        if (ds.rank() > 1) {
            try {
                String name = (String)this.jComboBox1.getSelectedItem();
                String[] names = DataSetOps.bundleNames(ds);
                this.jComboBox1.setModel(new DefaultComboBoxModel<String>(names));
                this.jComboBox1.setSelectedItem(name);
            }
            catch (IllegalArgumentException ex) {
                this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"ch0", "ch1", "ch2"}));
            }
        }
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String s = m.group(1);
            if (s.startsWith("'") && s.endsWith("'")) {
                s = s.substring(1, s.length() - 1);
            }
            this.jComboBox1.setSelectedItem(s);
        } else {
            this.jComboBox1.setSelectedItem("'Bx'");
        }
    }

    @Override
    public String getFilter() {
        String s = this.jComboBox1.getSelectedItem().toString().trim();
        if (s.length() > 0 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        if (s.length() > 0 && (s.charAt(0) >= '0' && s.charAt(0) <= '9' || s.charAt(0) == '-')) {
            return "|unbundle(" + s + ")";
        }
        return "|unbundle('" + s + "')";
    }

    public String getComponent() {
        return this.jComboBox1.getSelectedItem().toString();
    }
}

