/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Misc;

@Immutable
public class CoordinateEns
implements Coordinate {
    private final List<EnsCoordValue> ensSorted;
    private final int code;
    private String name = "ens";

    public CoordinateEns(int code, List<EnsCoordValue> ensSorted) {
        this.ensSorted = Collections.unmodifiableList(ensSorted);
        this.code = code;
    }

    public List<EnsCoordValue> getEnsSorted() {
        return this.ensSorted;
    }

    @Override
    public List<?> getValues() {
        return this.ensSorted;
    }

    @Override
    public int getIndex(Object val) {
        return this.ensSorted.indexOf(val);
    }

    @Override
    public Object getValue(int idx) {
        return this.ensSorted.get(idx);
    }

    public int getIndexByMember(double need) {
        for (int i = 0; i < this.ensSorted.size(); ++i) {
            EnsCoordValue coord = this.ensSorted.get(i);
            if (!Misc.nearlyEquals(need, (double)coord.getEnsMember())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this.ensSorted.size();
    }

    @Override
    public int getNCoords() {
        return this.getSize();
    }

    @Override
    public int estMemorySize() {
        return 160 + this.getSize() * 12;
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.ens;
    }

    @Override
    public String getUnit() {
        return "";
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals("ens")) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name;
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s: ", new Object[]{indent, this.getType()});
        for (EnsCoordValue level : this.ensSorted) {
            info.format(" %s", level);
        }
        info.format(" (%d)%n", this.ensSorted.size());
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Ensemble coords: (%s)%n", this.getUnit());
        for (EnsCoordValue level : this.ensSorted) {
            info.format("   %s%n", level);
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        for (int i = 0; i < this.ensSorted.size() - 1; ++i) {
            int diff = this.ensSorted.get(i + 1).getEnsMember() - this.ensSorted.get(i).getEnsMember();
            counters.count("resol", Integer.valueOf(diff));
        }
        return counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateEns that = (CoordinateEns)o;
        if (this.code != that.code) {
            return false;
        }
        return this.ensSorted.equals(that.ensSorted);
    }

    public int hashCode() {
        int result = this.ensSorted.hashCode();
        result = 31 * result + this.code;
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        int code;
        Grib1Customizer cust;

        public Builder1(Grib1Customizer cust, int code) {
            this.cust = cust;
            this.code = code;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            return new EnsCoordValue(pds.getPerturbationType(), pds.getPerturbationNumber());
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            List<EnsCoordValue> levelSorted = values.stream().map(val -> (EnsCoordValue)val).sorted().collect(Collectors.toList());
            return new CoordinateEns(this.code, levelSorted);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        int code;

        public Builder2(int code) {
            this.code = code;
        }

        @Override
        public Object extract(Grib2Record gr) {
            Grib2Pds pds = gr.getPDS();
            Grib2Pds.PdsEnsemble pdse = (Grib2Pds.PdsEnsemble)((Object)pds);
            return new EnsCoordValue(pdse.getPerturbationType(), pdse.getPerturbationNumber());
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<EnsCoordValue> levelSorted = new ArrayList<EnsCoordValue>(values.size());
            for (Object val : values) {
                levelSorted.add((EnsCoordValue)val);
            }
            Collections.sort(levelSorted);
            return new CoordinateEns(this.code, levelSorted);
        }
    }
}

