/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.LocationUnits;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatterFactory;
import org.das2.datum.format.ExponentDatumFormatter;
import org.das2.datum.format.ExponentialDatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;

public final class DatumUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.datum");
    private static final String ZEROS100 = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    private DatumUtil() {
    }

    private static double max(double[] A) {
        double max = A[0];
        for (int i = 0; i < A.length; ++i) {
            max = max > A[i] ? max : A[i];
        }
        return max;
    }

    private static double gcd(double a, double d, double error) {
        if (a < 0.0) {
            a = -1.0 * a;
        }
        if (d < 0.0) {
            d = -1.0 * d;
        }
        if (error > 0.0) {
            a = Math.round(a / error);
            d = Math.round(d / error);
        }
        if (a < d) {
            double t = a;
            a = d;
            d = t;
        }
        if (d == 0.0) {
            if (error > 0.0) {
                return a * error;
            }
            return a;
        }
        double r = a % d;
        for (int iterations = 0; r > 0.0 && iterations < 15; ++iterations) {
            d = r;
            r = a % d;
        }
        if (error > 0.0) {
            return d * error;
        }
        return d;
    }

    private static double gcd(double[] A, double error) {
        double guess = A[0];
        if (guess < 0.0) {
            guess = -1.0 * guess;
        }
        double result = guess;
        for (int i = 1; i < A.length; ++i) {
            result = DatumUtil.gcd(result, A[i], error);
        }
        return result;
    }

    public static DatumFormatter bestFormatter(DatumVector datums) {
        return DatumUtil.bestFormatter(datums, null);
    }

    public static DatumFormatter bestFormatter(DatumVector datums, DatumRange context) {
        Units units;
        Units origUnits;
        double[] array;
        if (datums.getLength() == 0) {
            return DefaultDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (datums.getUnits() instanceof EnumerationUnits) {
            return EnumerationDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (datums.getUnits() instanceof TimeLocationUnits) {
            if (context != null) {
                return TimeDatumFormatter.guessFormatter(datums, context);
            }
            if (datums.getLength() > 1) {
                Datum t1 = datums.get(0);
                int nticks = datums.getLength();
                Datum t2 = datums.get(nticks - 1);
                return DatumUtil.bestTimeFormatter(t1, t2, nticks - 1);
            }
            return TimeDatumFormatter.guessFormatter(datums, context);
        }
        if (datums.getUnits() instanceof LocationUnits) {
            array = new double[datums.getLength()];
            Datum offs = datums.get(0);
            origUnits = offs.getUnits();
            units = ((LocationUnits)offs.getUnits()).getOffsetUnits();
            array[0] = 0.0;
            for (int i = 1; i < datums.getLength(); ++i) {
                array[i] = datums.get(i).subtract(offs).doubleValue(units);
            }
        } else {
            origUnits = units = datums.getUnits();
            array = datums.toDoubleArray(units);
        }
        double[] logArray = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            logArray[j] = Math.log10(Math.abs(array[j]));
        }
        double limit = Math.pow(10.0, (int)Math.log10(DatumUtil.max(array)) - 7);
        double gcd = DatumUtil.gcd(array, limit);
        double gcdlog = DatumUtil.gcd(logArray, 1.0E-4);
        int smallestExp = 9999;
        int biggestExp = -9999;
        int ismallestExp = -1;
        double largest = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < array.length; ++j) {
            double d = array[j];
            if (!(Math.abs(d) > gcd * 0.1)) continue;
            int ee = (int)Math.floor(0.05 + Math.abs(logArray[j]));
            if (ee < smallestExp) {
                smallestExp = ee;
                ismallestExp = j;
            }
            if (ee > biggestExp) {
                biggestExp = ee;
            }
            if (!(d > largest)) continue;
            largest = d;
        }
        if (ismallestExp == -1) {
            return DefaultDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (gcdlog == (double)((int)gcdlog) && biggestExp > 3) {
            return new ExponentDatumFormatter("%d");
        }
        Datum resolution = units.createDatum(gcd);
        Datum base = datums.get(ismallestExp);
        if (base.lt(origUnits.createDatum(0.0))) {
            base = base.multiply(-1.0);
        }
        return DatumUtil.bestFormatter(base, base.add(resolution), 1);
    }

    public static int fractionalDigits(Datum resolution) {
        int nzero;
        int DOUBLE_DIGITS = 10;
        double d = Math.abs(resolution.doubleValue());
        int e = (int)Math.floor(Math.log10(d) + 1.0E-4);
        long i = (long)(d / Math.pow(10.0, e - (DOUBLE_DIGITS - 1)) + 0.5);
        for (nzero = 1; nzero < 16 && (double)i % Math.pow(10.0, nzero) == 0.0; ++nzero) {
        }
        return DOUBLE_DIGITS - 1 - --nzero - e;
    }

    public static DatumFormatter limitLogResolutionFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        double logmin = Math.log10(minimum.doubleValue(units));
        double logmax = Math.log10(maximum.doubleValue(units));
        double percent = (Math.pow(10.0, (logmax - logmin) / (double)nsteps) - 1.0) * 100.0;
        int nFraction = 2 - (int)Math.floor(0.05 + Math.log10(percent));
        nFraction = nFraction < 0 ? 0 : nFraction;
        String formatString = DatumUtil.exp(nFraction);
        DatumFormatterFactory factory = units.getDatumFormatterFactory();
        try {
            return factory.newFormatter(formatString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatumFormatter limitResolutionFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        Datum resolution = maximum.subtract(minimum).divide(nsteps);
        double discernable = resolution.doubleValue(units);
        int nFraction = -1 * (int)Math.floor(0.05 + Math.log10(discernable));
        nFraction = nFraction < 0 ? 0 : nFraction;
        String formatString = DatumUtil.zeros(nFraction);
        DatumFormatterFactory factory = units.getDatumFormatterFactory();
        try {
            return factory.newFormatter(formatString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatumFormatter bestFormatter(Datum minimum, Datum maximum, int nsteps) {
        Units units = minimum.getUnits();
        if (maximum.lt(minimum)) {
            Datum tmp = maximum;
            maximum = minimum;
            minimum = tmp;
        }
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(minimum, maximum, nsteps);
        }
        DatumFormatterFactory factory = minimum.getUnits().getDatumFormatterFactory();
        try {
            if (!(factory instanceof DefaultDatumFormatterFactory)) {
                return factory.defaultFormatter();
            }
            int fracDigits = DatumUtil.fractionalDigits(maximum.subtract(minimum).divide(nsteps));
            int smallestExp = 99;
            double discernable = Math.pow(10.0, -1 * fracDigits);
            Datum step = maximum.subtract(minimum).divide(nsteps);
            for (int j = 0; j < nsteps; ++j) {
                int ee;
                double d = minimum.add(step.multiply(j)).doubleValue(units);
                if (!(Math.abs(d) > discernable * 0.1) || (ee = (int)Math.floor(0.05 + Math.log10(Math.abs(d)))) >= smallestExp) continue;
                smallestExp = ee;
            }
            if (smallestExp < -60 || smallestExp > 60) {
                return DefaultDatumFormatterFactory.getInstance().defaultFormatter();
            }
            if (smallestExp < -3 || smallestExp > 3) {
                return new ExponentialDatumFormatter(smallestExp - -1 * fracDigits + 1, smallestExp);
            }
            int nFraction = -1 * (int)Math.floor(0.05 + Math.log10(discernable));
            nFraction = nFraction < 0 ? 0 : nFraction;
            String formatString = DatumUtil.zeros(nFraction);
            return factory.newFormatter(formatString);
        }
        catch (ParseException pe) {
            RuntimeException re = new RuntimeException(pe);
            logger.log(Level.SEVERE, pe.getMessage(), re);
            throw re;
        }
    }

    private static String exp(int power) {
        StringBuilder buffer = new StringBuilder(power + 4);
        for (int i = 0; i < power - 1; ++i) {
            buffer.append('#');
        }
        buffer.append("0.#E0");
        return buffer.toString();
    }

    public static String zeros(int count) {
        if (count < 1) {
            return "0";
        }
        if (count <= 100) {
            return ZEROS100.substring(0, count + 2);
        }
        StringBuffer buff = new StringBuffer(count + 2).append("0.");
        for (int index = 0; index < count; ++index) {
            buff.append('0');
        }
        return buff.toString();
    }

    public static DatumFormatter bestTimeFormatter(Datum minimum, Datum maximum, int nsteps) {
        double secondsPerStep = maximum.subtract(minimum).doubleValue(Units.seconds) / (double)nsteps;
        if (secondsPerStep < 1.0E-6) {
            return TimeDatumFormatter.NANOSECONDS;
        }
        if (secondsPerStep < 0.001) {
            return TimeDatumFormatter.MICROSECONDS;
        }
        if (secondsPerStep < 1.0) {
            return TimeDatumFormatter.MILLISECONDS;
        }
        if (secondsPerStep < 60.0) {
            return TimeDatumFormatter.SECONDS;
        }
        if (secondsPerStep < 3600.0) {
            return TimeDatumFormatter.MINUTES;
        }
        if (secondsPerStep < 86400.0) {
            return TimeDatumFormatter.HOURS;
        }
        if (secondsPerStep < 2678400.0) {
            return TimeDatumFormatter.DAYS;
        }
        if (secondsPerStep < 3.15576E7) {
            return TimeDatumFormatter.MONTHS;
        }
        return TimeDatumFormatter.YEARS;
    }

    public static String[] splitDatumString(String s) {
        s = s.trim();
        Pattern p = Pattern.compile("([-+]?[0-9]*(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(.*)");
        String[] ss = new String[2];
        Matcher m = p.matcher(s);
        if (m.find()) {
            ss[0] = m.group(1);
            ss[1] = m.group(4).trim();
        }
        return ss;
    }

    public static Datum parse(String s) throws ParseException {
        Units units;
        if (TimeParser.isIso8601String(s = s.trim())) {
            TimeLocationUnits units2 = Units.us2000;
            return ((Units)units2).parse(s);
        }
        String[] ss = DatumUtil.splitDatumString(s);
        if (ss.length == 1) {
            units = Units.dimensionless;
        } else {
            try {
                units = Units.getByName(ss[1]);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        return Datum.create(Double.parseDouble(ss[0]), units);
    }

    public static Datum parseValid(String s) {
        try {
            return DatumUtil.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] datumStringSplit(String s) {
        s = s.trim();
        String[] result = new String[2];
        int state = 112;
        String floatChars = "0123456789eE+-.";
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (state) {
                case 112: {
                    if (c == '$') {
                        result[1] = s.substring(0, i + 1);
                        result[0] = s.substring(i + 1).trim();
                        return result;
                    }
                    state = 109;
                    continue block4;
                }
                case 109: {
                    if (floatChars.contains(s.substring(i, i + 1))) continue block4;
                    result[0] = s.substring(0, i);
                    result[1] = s.substring(i);
                    state = 117;
                    continue block4;
                }
            }
        }
        if (result[1] == null) {
            result[0] = s;
            result[1] = result[0].length() == 8 && result[0].charAt(4) == '-' ? "UTC" : "";
        }
        if (result[0] == null) {
            result[1] = s;
            return result;
        }
        if (result[0].endsWith("E") || result[0].endsWith("e")) {
            int n = result[0].length() - 1;
            result[1] = result[0].substring(n) + result[1];
            result[0] = result[0].substring(0, n);
        }
        if (result[1].length() > 0 && (result[1].charAt(0) == ':' || result[1].charAt(0) == '/' || result[1].charAt(0) == 'T')) {
            result[0] = s;
            result[1] = "UTC";
        }
        return result;
    }

    public static Datum lookupDatum(String s) throws ParseException {
        String[] ss = DatumUtil.splitDatumString(s);
        if (ss[1].equals("UTC")) {
            try {
                Datum time = Units.us2000.parse(ss[0]);
                return time;
            }
            catch (ParseException time) {
                // empty catch block
            }
        }
        if (ss[0] == null) {
            throw new ParseException("magnitude not found", 0);
        }
        Units u = Units.lookupUnits(ss[1]);
        return u.parse(ss[0]);
    }

    public static Datum createValid(String s) {
        return Datum.create(Double.parseDouble(s), Units.dimensionless);
    }

    public static double[] doubleValues(Datum[] datums, Units units) {
        double[] result = new double[datums.length];
        for (int j = 0; j < datums.length; ++j) {
            result[j] = datums[j].doubleValue(units);
        }
        return result;
    }

    public static double[] doubleValues(Datum[] datums, Units[] unitsArray) {
        double[] result = new double[datums.length];
        for (int j = 0; j < datums.length; ++j) {
            result[j] = datums[j].doubleValue(unitsArray[j]);
        }
        return result;
    }

    public static Datum asOrderOneUnits(Datum d) {
        Units dunits = d.getUnits();
        if (dunits == Units.dimensionless) {
            return d;
        }
        if (dunits == Units.dB) {
            return d;
        }
        if (dunits instanceof LocationUnits) {
            return d;
        }
        if (dunits instanceof EnumerationUnits) {
            return d;
        }
        Units[] conversions = dunits.getConvertibleUnits();
        double bestScore = 0.0;
        Datum bestDatum = d;
        for (Units conversion : conversions) {
            Datum dd = d.convertTo(conversion);
            Number n = dd.getValue();
            if (n.equals(d.getValue()) && conversion != dunits) continue;
            double nn = Math.abs(n.doubleValue());
            double score = nn > 100.0 ? 100.0 / nn : nn;
            if (score > bestScore) {
                bestScore = score;
                bestDatum = dd;
                continue;
            }
            if (score != bestScore || conversion != Units.getCanonicalUnit(conversion)) continue;
            bestScore = score;
            bestDatum = dd;
        }
        return bestDatum;
    }

    public static Datum numericalResolutionLimit(Datum datum) {
        double d = datum.doubleValue(datum.getUnits());
        double dp = Math.nextUp(d);
        Datum datump = datum.getUnits().createDatum(dp);
        return datump.subtract(datum);
    }

    public static Datum modp(Datum amount, Datum delta) {
        if (UnitsUtil.isIntervalMeasurement(amount.getUnits())) {
            throw new IllegalArgumentException("amount cannot be a location");
        }
        double count = amount.divide(delta).doubleValue(Units.dimensionless);
        count = Math.floor(count);
        return amount.subtract(delta.multiply(count));
    }

    public static Datum divp(Datum amount, Datum delta) {
        double result = Math.floor(amount.divide(delta).doubleValue(Units.dimensionless));
        return Units.dimensionless.createDatum(result);
    }
}

