/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.util.ArrayList;
import java.util.Collection;
import org.das2.datum.Datum;
import org.das2.datum.LocationUnits;
import org.das2.datum.Units;

public final class DatumVector {
    private final Units units;
    private final Object store;
    private final double resolution;
    private final int offset;
    private final int length;

    private DatumVector(double[] array, int offset, int length, Units units) {
        this(array, offset, length, units, 0.0, true);
    }

    private DatumVector(double[] array, int offset, int length, Units units, double resolution, boolean copy) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (units == null) {
            throw new NullPointerException("units is null");
        }
        if (copy) {
            this.store = new double[length];
            for (int i = 0; i < length; ++i) {
                ((double[])this.store)[i] = array[offset + i];
            }
            offset = 0;
        } else {
            this.store = array;
        }
        this.offset = offset;
        this.units = units;
        this.resolution = resolution;
        this.length = length;
    }

    public DatumVector getSubVector(int start, int end) {
        if (start == 0 && end == this.length) {
            return this;
        }
        if (start < 0) {
            throw new IllegalArgumentException("start less than 0");
        }
        if (end > this.length) {
            throw new IllegalArgumentException("end greater than length");
        }
        return new DatumVector((double[])this.store, this.offset + start, end - start, this.units, this.resolution, false);
    }

    public Datum get(int index) {
        return Datum.create(((double[])this.store)[index + this.offset], this.units, this.resolution);
    }

    public Units getUnits() {
        return this.units;
    }

    public double doubleValue(int index, Units toUnits) {
        return this.units.convertDoubleTo(toUnits, ((double[])this.store)[index + this.offset]);
    }

    public double[] toDoubleArray(Units units) {
        return this.toDoubleArray(null, units);
    }

    public double[] toDoubleArray(double[] array, Units units) {
        if (array == null || array.length < this.length) {
            array = new double[this.length];
        }
        if (units == this.units) {
            System.arraycopy(this.store, this.offset, array, 0, this.length);
        } else {
            double[] store = (double[])this.store;
            for (int i = 0; i < this.length; ++i) {
                array[i] = this.units.convertDoubleTo(units, store[i]);
            }
        }
        return array;
    }

    public static DatumVector newDatumVector(Datum[] array, Units units) {
        double[] dArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            dArray[i] = array[i].doubleValue(units);
        }
        return DatumVector.newDatumVector(dArray, units);
    }

    public static DatumVector newDatumVector(double[] array, Units units) {
        return DatumVector.newDatumVector(array, 0, array.length, units);
    }

    public static DatumVector newDatumVector(double[] array, double resolution, Units units) {
        return new DatumVector(array, 0, array.length, units, resolution, true);
    }

    public static DatumVector newDatumVector(double[] array, int offset, int length, Units units) {
        return new DatumVector(array, offset, length, units);
    }

    public int getLength() {
        return this.length;
    }

    public DatumVector add(Datum d) {
        Units newUnits;
        double[] dd = new double[this.getLength()];
        if (d.getUnits() instanceof LocationUnits) {
            newUnits = d.getUnits();
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = d.add(this.get(i)).doubleValue(newUnits);
            }
        } else {
            newUnits = this.units;
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = this.get(i).add(d).doubleValue(newUnits);
            }
        }
        return new DatumVector(dd, 0, dd.length, newUnits);
    }

    public static DatumVector append(DatumVector a, DatumVector b) {
        int i;
        if (a == null) {
            return b;
        }
        Units u = a.getUnits();
        double[] ra = new double[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            ra[i] = a.doubleValue(i, u);
        }
        for (i = 0; i < b.length; ++i) {
            ra[i + a.length] = b.doubleValue(i, u);
        }
        DatumVector result = new DatumVector(ra, 0, ra.length, u);
        return result;
    }

    public DatumVector subtract(Datum d) {
        double[] dd = new double[this.getLength()];
        Units newUnits = this.units instanceof LocationUnits && d.getUnits() instanceof LocationUnits ? this.units.getOffsetUnits() : this.units;
        for (int i = 0; i < dd.length; ++i) {
            Datum diff = this.get(i).subtract(d);
            dd[i] = diff.doubleValue(newUnits);
        }
        return new DatumVector(dd, 0, dd.length, newUnits);
    }

    public DatumVector multiply(double d) {
        double[] dd = new double[this.getLength()];
        if (this.units instanceof LocationUnits) {
            throw new IllegalArgumentException("can't multiply a LocationUnits");
        }
        for (int i = 0; i < dd.length; ++i) {
            dd[i] = this.get(i).multiply(d).doubleValue(this.units);
        }
        return new DatumVector(dd, 0, dd.length, this.units);
    }

    public String toString() {
        Units units = this.getUnits();
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < Math.min(4, this.getLength()); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            Datum d = this.get(i);
            result.append(d.getFormatter().format(d, units));
        }
        if (this.getLength() > 4) {
            result.append(", ... (len=").append(this.getLength()).append(")");
        }
        result.append(" ").append(units.toString()).append(" ]");
        return result.toString();
    }

    public static boolean datumVectorsEqual(DatumVector a, DatumVector b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getLength() == b.getLength()) {
            for (int i = 0; i < a.getLength(); ++i) {
                if (a.get(i).equals(b.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Collection<? extends Datum> asList() {
        ArrayList<Datum> result = new ArrayList<Datum>();
        for (int i = 0; i < this.getLength(); ++i) {
            result.add(this.get(i));
        }
        return result;
    }
}

