/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;

public class LeapSecondsConverter
extends UnitsConverter {
    private static Logger logger = LoggerManager.getLogger("das2.datum.uc");
    public static final int T1972_LEAP = 10;
    private static List<Long> leapSeconds;
    private static List<Double> withoutLeapSeconds;
    private static long lastUpdateMillis;
    private static double us2000_st;
    private static double us2000_en;
    private static int us2000_c;
    private static long tt2000_st;
    private static long tt2000_en;
    private static int tt2000_c;
    boolean us2000ToTT2000;

    private static void updateLeapSeconds() throws IOException, MalformedURLException, NumberFormatException {
        InputStream in;
        URL url = LeapSecondsConverter.class.getResource("/orbits/CDFLeapSeconds.txt");
        logger.log(Level.FINE, "try reading leap seconds from {0}", url);
        try {
            in = url.openStream();
        }
        catch (IOException ex) {
            logger.log(Level.INFO, "unable to read internal leap seconds file: {0}", url);
            LoggerManager.getLogger("das2.url").log(Level.FINE, "openStream {0}", url);
            url = new URL("https://cdf.gsfc.nasa.gov/html/CDFLeapSeconds.txt");
            in = url.openStream();
            logger.log(Level.FINE, "Using remote copy of leap seconds file at {0}", url);
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
            String s = "";
            leapSeconds = new ArrayList<Long>(50);
            withoutLeapSeconds = new ArrayList<Double>(50);
            String lastLine = s;
            boolean firstLine = true;
            while (true) {
                String[] ss;
                s = r.readLine();
                if (firstLine) {
                    if (s == null) {
                        throw new RuntimeException("Leap seconds file is empty: " + url);
                    }
                    if (!s.startsWith(";")) {
                        throw new RuntimeException("Leap seconds file should start with semicolon (;): " + url);
                    }
                    firstLine = false;
                }
                if (s == null) break;
                if (s.startsWith(";") || (ss = s.trim().split("\\s+", -2))[0].compareTo("1972") < 0) continue;
                int iyear = Integer.parseInt(ss[0]);
                int imonth = Integer.parseInt(ss[1]);
                int iday = Integer.parseInt(ss[2]);
                int ileap = (int)Double.parseDouble(ss[3]);
                double us2000 = TimeUtil.createTimeDatum(iyear, imonth, iday, 0, 0, 0, 0).doubleValue(Units.us2000);
                leapSeconds.add((long)us2000 * 1000L - 43200000000000L + (long)(ileap + 32) * 1000000000L);
                withoutLeapSeconds.add(us2000);
            }
            logger.log(Level.FINE, "Last leap second read from {0} {1}", new Object[]{url, lastLine});
            leapSeconds.add(Long.MAX_VALUE);
            withoutLeapSeconds.add((Double)Double.MAX_VALUE);
            lastUpdateMillis = System.currentTimeMillis();
        }
    }

    public LeapSecondsConverter(boolean us2000ToTT2000) {
        this.us2000ToTT2000 = us2000ToTT2000;
        if (us2000ToTT2000) {
            this.inverse = new LeapSecondsConverter(!us2000ToTT2000);
            this.inverse.inverse = this;
        }
    }

    public static synchronized int getLeapSecondCountForUs2000(double us2000) throws IOException {
        if (System.currentTimeMillis() - lastUpdateMillis > 86400000L) {
            LeapSecondsConverter.updateLeapSeconds();
        }
        if (us2000 < withoutLeapSeconds.get(0)) {
            return 0;
        }
        for (int i = 0; i < withoutLeapSeconds.size() - 1; ++i) {
            if (!(withoutLeapSeconds.get(i) <= us2000) || i != withoutLeapSeconds.size() - 1 && !(us2000 < withoutLeapSeconds.get(i + 1))) continue;
            us2000_st = withoutLeapSeconds.get(i);
            us2000_en = withoutLeapSeconds.get(i + 1);
            us2000_c = i + 10;
            return i + 10;
        }
        logger.severe("code shouldn't get to this point: implementation error...");
        throw new RuntimeException("code shouldn't get to this point: implementation error...");
    }

    public static synchronized int getLeapSecondCountForTT2000(long tt2000) throws IOException {
        if (System.currentTimeMillis() - lastUpdateMillis > 86400000L) {
            LeapSecondsConverter.updateLeapSeconds();
        }
        if (tt2000 < leapSeconds.get(0)) {
            return 0;
        }
        int i = 0;
        for (i = 0; i < leapSeconds.size() - 1; ++i) {
            if (leapSeconds.get(i) > tt2000 || i != leapSeconds.size() - 1 && tt2000 >= leapSeconds.get(i + 1)) continue;
            tt2000_st = leapSeconds.get(i);
            tt2000_en = leapSeconds.get(i + 1);
            tt2000_c = i + 10;
            return i + 10;
        }
        return i + 9;
    }

    @Override
    public UnitsConverter getInverse() {
        return this.inverse;
    }

    @Override
    public synchronized double convert(double value) {
        try {
            if (this.us2000ToTT2000) {
                int leapSec = us2000_st <= value && value < us2000_en ? us2000_c : LeapSecondsConverter.getLeapSecondCountForUs2000(value);
                return value * 1000.0 - 4.32E13 + ((double)(leapSec - 32) + 64.184) * 1.0E9;
            }
            int leapSec = (double)tt2000_st <= value && value < (double)tt2000_en ? tt2000_c : LeapSecondsConverter.getLeapSecondCountForTT2000((long)value);
            return (value - ((double)(leapSec - 32) + 64.184) * 1.0E9 + 4.32E13) / 1000.0;
        }
        catch (IOException ex) {
            throw new RuntimeException("LeapSeconds file not available.  This should never happen since there is a leapSeconds file within code.", ex);
        }
    }

    static {
        lastUpdateMillis = 0L;
        us2000_st = -1.0;
        us2000_en = -1.0;
        us2000_c = -1;
        tt2000_st = -1L;
        tt2000_en = -1L;
        tt2000_c = -1;
    }
}

