/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;

public final class UnitsUtil {
    private UnitsUtil() {
    }

    public static boolean isRatiometric(Units unit) {
        return unit != Units.dimensionless && unit.isConvertibleTo(Units.logERatio);
    }

    public static boolean isTimeLocation(Units unit) {
        return unit == Units.us2000 || unit.isConvertibleTo(Units.us2000);
    }

    public static boolean isRatioMeasurement(Units unit) {
        return !(unit instanceof EnumerationUnits) && unit.getOffsetUnits() == unit;
    }

    public static boolean isIntervalMeasurement(Units unit) {
        return !(unit instanceof EnumerationUnits) && unit.getOffsetUnits() != unit;
    }

    public static boolean isIntervalOrRatioMeasurement(Units unit) {
        return !(unit instanceof EnumerationUnits);
    }

    public static boolean isNominalMeasurement(Units unit) {
        return unit instanceof EnumerationUnits;
    }

    public static boolean isOrdinalMeasurement(Units unit) {
        return unit instanceof EnumerationUnits;
    }

    public static Units getInverseUnit(Units unit) {
        if (unit == Units.seconds) {
            return Units.hertz;
        }
        if (unit == Units.hertz) {
            return Units.seconds;
        }
        if (unit == Units.dimensionless) {
            return Units.dimensionless;
        }
        if (unit == Units.milliseconds) {
            return Units.kiloHertz;
        }
        if (unit == Units.microseconds) {
            return Units.megaHertz;
        }
        if (unit == Units.nanoseconds) {
            return Units.gigaHertz;
        }
        if (unit.isConvertibleTo(Units.seconds)) {
            UnitsConverter uc = unit.getConverter(Units.seconds);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.hertz;
            }
            uc = unit.getConverter(Units.milliseconds);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.kiloHertz;
            }
            uc = unit.getConverter(Units.microseconds);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.megaHertz;
            }
            uc = unit.getConverter(Units.nanoseconds);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.gigaHertz;
            }
            throw new IllegalArgumentException("units not supported: " + unit);
        }
        if (unit.isConvertibleTo(Units.hertz)) {
            UnitsConverter uc = unit.getConverter(Units.hertz);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.seconds;
            }
            uc = unit.getConverter(Units.kiloHertz);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.milliseconds;
            }
            uc = unit.getConverter(Units.megaHertz);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.microseconds;
            }
            uc = unit.getConverter(Units.gigaHertz);
            if (uc == UnitsConverter.IDENTITY) {
                return Units.nanoseconds;
            }
            throw new IllegalArgumentException("units not supported: " + unit);
        }
        throw new IllegalArgumentException("units not supported: " + unit);
    }

    public static String divideToString(Datum aDatum, Datum bDatum) {
        try {
            Datum result = UnitsUtil.divide(aDatum, bDatum);
            return String.valueOf(result);
        }
        catch (IllegalArgumentException e) {
            Units aUnits = aDatum.getUnits();
            Units bUnits = bDatum.getUnits();
            double a = aDatum.doubleValue(aUnits);
            double b = bDatum.doubleValue(bUnits);
            DecimalFormat df = new DecimalFormat("0.000E0");
            return "" + df.format(a / b) + " " + aUnits + " / " + bUnits;
        }
    }

    public static Datum divide(Datum aDatum, Datum bDatum) {
        Units bInvUnits;
        Units bUnits = bDatum.getUnits();
        Units aUnits = aDatum.getUnits();
        try {
            bInvUnits = UnitsUtil.getInverseUnit(bUnits);
        }
        catch (IllegalArgumentException e) {
            bInvUnits = null;
        }
        double a = aDatum.doubleValue(aUnits);
        double b = bDatum.doubleValue(bUnits);
        if (bUnits == Units.dimensionless) {
            return aUnits.createDatum(a / b);
        }
        if (aUnits == Units.dimensionless) {
            if (bInvUnits == null) {
                throw new IllegalArgumentException("unable to calculate, b units not convertable to a");
            }
            return bInvUnits.createDatum(a / b);
        }
        if (!bUnits.isConvertibleTo(aUnits)) {
            throw new IllegalArgumentException("unable to calculate, b units not convertable to a");
        }
        UnitsConverter uc = bUnits.getConverter(aUnits);
        return Units.dimensionless.createDatum(a / uc.convert(b));
    }
}

