/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;

public class ExponentDatumFormatter
extends DatumFormatter {
    String mantissaFormat;
    boolean intMantissa;

    public ExponentDatumFormatter(String mantissaFormat) {
        this.mantissaFormat = mantissaFormat;
        this.intMantissa = mantissaFormat.equals("%d");
    }

    @Override
    public String format(Datum datum) {
        int magnitude = (int)Math.floor(Math.log10(datum.value()));
        double mant = datum.value() / Math.pow(10.0, magnitude);
        if (this.intMantissa) {
            return (int)mant + "E" + magnitude;
        }
        return String.format(this.mantissaFormat, mant) + "E";
    }

    @Override
    public String grannyFormat(Datum datum) {
        return this.grannyFormat(datum, datum.getUnits());
    }

    @Override
    public String grannyFormat(Datum datum, Units units) {
        int magnitude = (int)Math.floor(Math.log10(datum.value()));
        double mant = datum.value() / Math.pow(10.0, magnitude);
        if (this.intMantissa) {
            if (mant == 1.0) {
                return "10!A" + magnitude + "!n";
            }
            return mant + "*10!A" + magnitude + "!n";
        }
        return String.format(this.mantissaFormat, mant) + "*10!A" + magnitude + "!n";
    }
}

