/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.jythonsupport.FunctionSupport;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class GetDataSetsCommand
extends PyObject {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.commands.getdataset");
    public static final PyString __doc__ = new PyString("<html><H2>getDataSets(list,timerange,monitor,[named parameters])</H2> load the data specified by URI into Autoplot's internal data model.  This will\n block until the load is complete, and a ProgressMonitor object can be used to\n monitor the load..\n<br><b>optional parameters:</b>\n<table>\n<tr><td>timerange</td><td>String or DatumRange</td></tr>\n<tr><td>monitor</td><td>Progress Monitor</td></tr>\n</table>\n<br><b>named parameters:</b>\n<table>\n<tr><td>trim=True </td><td>trim the data to the requested time range.</td></tr>\n<tr><td>units=None </td><td>convert the data to the given units, or remove the unit if empty string or None\n<tr><td>sortTime=True</td><td>sort the data by its timetags</td></tr>\n</table></html>");

    private List<String> toList(Object arg) {
        return (List)arg;
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        PyObject val;
        String kw;
        int i;
        FunctionSupport fs = new FunctionSupport("getDataSets", new String[]{"uri", "timerange", "monitor", "trim", "units", "sortTime"}, new PyObject[]{Py.None, Py.None, Py.None, Py.None, Py.None});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        List<String> uris = null;
        Units units = null;
        DatumRange trimRange = null;
        ProgressMonitor monitor = null;
        List<QDataSet> result = null;
        for (i = nparm; i < args.length; ++i) {
            Object v;
            kw = keywords[i - nparm];
            val = args[i];
            val.__str__().__tojava__(String.class);
            if (kw.equals("units")) {
                if (val.__tojava__(Units.class) != Py.NoConversion) {
                    units = (Units)val.__tojava__(Units.class);
                    continue;
                }
                String svalue = val.toString();
                units = Units.lookupUnits((String)svalue);
                continue;
            }
            if (kw.equals("monitor")) {
                v = val.__tojava__(ProgressMonitor.class);
                if (v == Py.NoConversion) continue;
                monitor = (ProgressMonitor)v;
                continue;
            }
            if (!kw.equals("timerange") && !kw.equals("trim")) continue;
            v = val.__tojava__(DatumRange.class);
            if (v != Py.NoConversion) {
                trimRange = (DatumRange)v;
                continue;
            }
            v = val.__tojava__(String.class);
            if (v == Py.NoConversion) continue;
            try {
                trimRange = DatumRangeUtil.parseTimeRange((String)((String)v));
                continue;
            }
            catch (ParseException ex) {
                throw Py.JavaError((Throwable)ex);
            }
        }
        switch (nparm) {
            case 0: {
                throw new IllegalArgumentException("dataset needs at least one argument");
            }
            case 1: {
                uris = this.toList(args[0]);
                break;
            }
            case 2: {
                uris = this.toList(args[0]);
                Object arg1 = args[1].__tojava__(ProgressMonitor.class);
                if (arg1 != Py.NoConversion) {
                    monitor = (ProgressMonitor)arg1;
                }
                if ((arg1 = args[1].__tojava__(DatumRange.class)) != Py.NoConversion) {
                    trimRange = (DatumRange)arg1;
                }
                if ((arg1 = args[1].__tojava__(String.class)) == Py.NoConversion) break;
                try {
                    trimRange = DatumRangeUtil.parseTimeRange((String)((String)arg1));
                    break;
                }
                catch (ParseException ex) {
                    throw Py.JavaError((Throwable)ex);
                }
            }
            case 3: {
                uris = this.toList(args[0]);
                Object arg1 = args[1].__tojava__(DatumRange.class);
                if (arg1 != Py.NoConversion) {
                    trimRange = (DatumRange)arg1;
                }
                if ((arg1 = args[1].__tojava__(String.class)) != Py.NoConversion) {
                    try {
                        trimRange = DatumRangeUtil.parseTimeRange((String)((String)arg1));
                        break;
                    }
                    catch (ParseException ex) {
                        throw Py.JavaError((Throwable)ex);
                    }
                }
                Object arg2 = args[2].__tojava__(ProgressMonitor.class);
                if (arg2 == Py.NoConversion) break;
                monitor = (ProgressMonitor)arg2;
                break;
            }
            default: {
                throw new IllegalArgumentException("dataset needs between one and two parameters.");
            }
        }
        try {
            result = Util.getDataSets(uris, trimRange, monitor);
        }
        catch (Exception ex) {
            throw Py.JavaError((Throwable)ex);
        }
        if (result == null) {
            return Py.None;
        }
        block30: for (i = nparm; i < args.length; ++i) {
            kw = keywords[i - nparm];
            val = args[i];
            String sval = (String)val.__str__().__tojava__(String.class);
            switch (kw) {
                case "trim": {
                    if (trimRange == null) {
                        if (val.equals((Object)Py.None)) continue block30;
                        try {
                            trimRange = DatumRangeUtil.parseTimeRange((String)sval);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(GetDataSetsCommand.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    for (int ids = 0; ids < result.size(); ++ids) {
                        result.set(ids, Ops.trim((QDataSet)result.get(ids), (DatumRange)trimRange));
                    }
                    continue block30;
                }
                case "units": {
                    if (val == Py.None) {
                        for (int ids = 0; ids < result.size(); ++ids) {
                            result.set(ids, (QDataSet)Ops.putProperty((QDataSet)result.get(ids), (String)"UNITS", null));
                        }
                        continue block30;
                    }
                    if (val.__tojava__(Units.class) != Py.NoConversion) {
                        Units u = (Units)val.__tojava__(Units.class);
                        for (int ids = 0; ids < result.size(); ++ids) {
                            result.set(ids, (QDataSet)Ops.putProperty((QDataSet)result.get(ids), (String)"UNITS", (Object)u));
                        }
                        continue block30;
                    }
                    for (int ids = 0; ids < result.size(); ++ids) {
                        result.set(ids, (QDataSet)Ops.putProperty((QDataSet)result.get(ids), (String)"UNITS", (Object)sval));
                    }
                    continue block30;
                }
                case "sortTime": {
                    if (val.__nonzero__()) {
                        long t0 = System.currentTimeMillis();
                        QDataSet tt = Ops.xtags((QDataSet)result.get(0));
                        QDataSet s = Ops.sort((QDataSet)tt);
                        if (Boolean.TRUE.equals(s.property("MONOTONIC")) && s.length() == tt.length()) continue block30;
                        long t1 = System.currentTimeMillis();
                        for (int ids = 0; ids < result.size(); ++ids) {
                            result.set(ids, (QDataSet)Ops.applyIndex((QDataSet)result.get(ids), (QDataSet)s));
                        }
                        long t2 = System.currentTimeMillis();
                        logger.log(Level.INFO, "sort in millis: {0}", t1 - t0);
                        logger.log(Level.INFO, "applyIndex in millis: {0}", t2 - t1);
                    }
                }
                case "timerange": 
                case "monitor": {
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("bad keyword");
                }
            }
        }
        PyList result2 = new PyList();
        for (int ids = 0; ids < result.size(); ++ids) {
            result2.append((PyObject)new PyQDataSet(result.get(ids)));
        }
        return result2;
    }
}

