/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyDatum;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.jythoncompletion.JavadocLookup;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.LDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.JsonUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class JythonOps {
    private static final Logger logger = Logger.getLogger("jython");

    public static QDataSet applyLambda(QDataSet ds, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds));
        while (it.hasNext()) {
            it.next();
            double d = it.getValue(ds);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, QDataSet ds3, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            double d3 = it.getValue(ds3);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2), (PyObject)new PyFloat(d3));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet coerceToDs(PyObject arg0) {
        return JythonOps.dataset(arg0);
    }

    public static QDataSet dataset(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            return ((PyQDataSet)arg0).rods;
        }
        if (arg0 instanceof PyDatum) {
            Datum d = ((PyDatum)arg0).datum;
            Units u = d.getUnits();
            if (u == Units.cdfTT2000 && d instanceof Datum.Long) {
                LDataSet result = LDataSet.wrap((long[])new long[]{((Datum.Long)d).longValue(u)}, (int[])new int[0]);
                result.putProperty("UNITS", (Object)u);
                return result;
            }
            return DataSetUtil.asDataSet((Datum)((PyDatum)arg0).datum);
        }
        if (arg0 instanceof PyList) {
            return PyQDataSetAdapter.adaptList((PyList)arg0);
        }
        if (arg0 instanceof PyArray) {
            return PyQDataSetAdapter.adaptArray((PyArray)arg0);
        }
        if (arg0 instanceof PyTuple) {
            return PyQDataSetAdapter.adaptTuple((PyTuple)arg0);
        }
        if (arg0 instanceof PyInteger) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)));
        }
        if (arg0 instanceof PyLong) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)));
        }
        if (arg0 instanceof PyFloat) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(Datum.class) instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)((Datum)((PyJavaInstance)arg0).__tojava__(Datum.class)));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(DatumRange.class) instanceof DatumRange) {
            return DataSetUtil.asDataSet((DatumRange)((DatumRange)((PyJavaInstance)arg0).__tojava__(DatumRange.class)));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(QDataSet.class) instanceof QDataSet) {
            return DataSetUtil.asDataSet((Object)((PyJavaInstance)arg0).__tojava__(QDataSet.class));
        }
        if (arg0 instanceof PyString) {
            try {
                return Ops.dataset((Object)arg0.toString());
            }
            catch (IllegalArgumentException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
        }
        if (arg0 instanceof PyNone) {
            return null;
        }
        String type = arg0 instanceof PyJavaInstance ? ((PyJavaInstance)arg0).__tojava__(Object.class).getClass().getSimpleName() : "\"" + arg0 + "\"";
        throw Py.TypeError((String)("JythonOps is unable to coerce " + type + " to QDataSet"));
    }

    public static QDataSet dataset(PyObject arg0, Units u) {
        if (arg0 instanceof PyQDataSet) {
            QDataSet result = ((PyQDataSet)arg0).rods;
            return Ops.dataset((Object)result, (Units)u);
        }
        if (arg0 instanceof PyList) {
            PyList pl = (PyList)arg0;
            DataSetBuilder builder = new DataSetBuilder(1, pl.__len__());
            for (int i = 0; i < pl.__len__(); ++i) {
                builder.nextRecord(Ops.dataset((Object)pl.get(i), (Units)u));
            }
            return builder.getDataSet();
        }
        if (arg0 instanceof PyArray) {
            return Ops.putProperty((QDataSet)PyQDataSetAdapter.adaptArray((PyArray)arg0), (String)"UNITS", (Object)u);
        }
        if (arg0 instanceof PyTuple) {
            PyTuple pl = (PyTuple)arg0;
            DataSetBuilder builder = new DataSetBuilder(1, pl.__len__());
            for (int i = 0; i < pl.__len__(); ++i) {
                builder.nextRecord(Ops.dataset((Object)pl.get(i), (Units)u));
            }
            return builder.getDataSet();
        }
        if (arg0 instanceof PyInteger) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)), (Units)u);
        }
        if (arg0 instanceof PyLong) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)), (Units)u);
        }
        if (arg0 instanceof PyFloat) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)), (Units)u);
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(Datum.class) instanceof Datum) {
            Datum d = (Datum)((PyJavaInstance)arg0).__tojava__(Datum.class);
            return Ops.dataset((Object)d, (Units)u);
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(DatumRange.class) instanceof DatumRange) {
            DatumRange dr = (DatumRange)((PyJavaInstance)arg0).__tojava__(DatumRange.class);
            return Ops.dataset((Object)dr, (Units)u);
        }
        if (arg0 instanceof PyString) {
            try {
                return DataSetUtil.asDataSet((Datum)u.parse(arg0.toString()));
            }
            catch (IllegalArgumentException | ParseException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
        }
        if (arg0 instanceof PyNone) {
            return null;
        }
        String type = arg0 instanceof PyJavaInstance ? ((PyJavaInstance)arg0).__tojava__(Object.class).getClass().getSimpleName() : "\"" + arg0 + "\"";
        throw Py.TypeError((String)("JythonOps is unable to coerce " + type + " to QDataSet"));
    }

    public static Datum datum(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            QDataSet ds = ((PyQDataSet)arg0).rods;
            if (ds.rank() > 0) {
                throw new IllegalArgumentException("QDataSet is not rank zero and cannot be converted to datum: " + ds);
            }
            return DataSetUtil.asDatum((QDataSet)ds);
        }
        if (arg0 instanceof PyDatum) {
            return ((PyDatum)arg0).datum;
        }
        if (arg0 instanceof PyInteger) {
            return Units.dimensionless.createDatum(((PyInteger)arg0).getValue());
        }
        if (arg0 instanceof PyFloat) {
            return Units.dimensionless.createDatum(((PyFloat)arg0).getValue());
        }
        if (arg0 instanceof PyJavaInstance) {
            return Ops.datum((Object)((PyJavaInstance)arg0).__tojava__(Object.class));
        }
        if (arg0 instanceof PyString) {
            return Ops.datum((Object)arg0.toString());
        }
        throw Py.TypeError((String)("unable to coerce " + arg0 + " to Datum"));
    }

    public static DatumRange datumRange(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            QDataSet ds = ((PyQDataSet)arg0).rods;
            if (ds.rank() > 1) {
                throw new IllegalArgumentException("QDataSet is not rank one and cannot be converted to datumRange: " + ds);
            }
            return DataSetUtil.asDatumRange((QDataSet)ds);
        }
        if (arg0 instanceof PyList) {
            PyObject p1 = ((PyList)arg0).__getitem__(0);
            PyObject p2 = ((PyList)arg0).__getitem__(1);
            return new DatumRange(JythonOps.datum(p1), JythonOps.datum(p2));
        }
        if (arg0 instanceof PyArray) {
            PyObject p1 = ((PyArray)arg0).__getitem__(0);
            PyObject p2 = ((PyArray)arg0).__getitem__(1);
            return new DatumRange(JythonOps.datum(p1), JythonOps.datum(p2));
        }
        if (arg0 instanceof PyJavaInstance) {
            return Ops.datumRange((Object)((PyJavaInstance)arg0).__tojava__(Object.class));
        }
        if (arg0 instanceof PyString) {
            return Ops.datumRange((Object)arg0.toString());
        }
        throw Py.TypeError((String)("unable to coerce " + arg0 + " to DatumRange"));
    }

    public static DatumRange datumRange(PyObject arg0, PyObject arg1) {
        Units u;
        if (arg1 instanceof PyJavaInstance && (u = (Units)((PyJavaInstance)arg1).__tojava__(Units.class)) != null) {
            return JythonOps.datumRange(arg0, u);
        }
        Datum d1 = JythonOps.datum(arg0);
        Datum d2 = JythonOps.datum(arg1);
        return new DatumRange(d1, d2);
    }

    public static DatumRange datumRange(PyObject arg0, Units context) {
        DatumRange newRange = JythonOps.datumRange(arg0);
        if (!context.isConvertibleTo(newRange.getUnits())) {
            if (newRange.min().getUnits() == Units.dimensionless) {
                newRange = DatumRange.newDatumRange((double)newRange.min().value(), (double)newRange.max().value(), (Units)context);
            }
        } else if (context != newRange.getUnits()) {
            newRange = new DatumRange(newRange.min().convertTo(context), newRange.max().convertTo(context));
        }
        return newRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color color(PyObject val) {
        Color c = null;
        if (val == Py.None) {
            return new Color(0, 0, 0, 0);
        }
        if (val.__tojava__(Color.class) != Py.NoConversion) {
            return (Color)val.__tojava__(Color.class);
        }
        if (val instanceof PyFloat) {
            return new Color((int)((PyFloat)val).getValue());
        }
        if (val instanceof PyInteger) {
            return new Color(((PyInteger)val).getValue());
        }
        if (val instanceof PyQDataSet) {
            return new Color((int)((PyQDataSet)val).getQDataSet().value());
        }
        if (val instanceof PyTuple) {
            String sval = val.toString();
            if ((sval = sval.substring(1, sval.length() - 1)) == null) throw new IllegalArgumentException("can't identify color");
            return Ops.colorFromString((String)sval);
        }
        String sval = (String)val.__str__().__tojava__(String.class);
        if (sval == null) throw new IllegalArgumentException("can't identify color");
        return Ops.colorFromString((String)sval);
    }

    public static Object validateParam(String name, Object v, List constraint) {
        if (!constraint.contains(v)) {
            String sconstraint = constraint.toString();
            if (sconstraint.length() < 40) {
                throw new IllegalArgumentException(String.format("value is not one of allowed values for \"%s\" which are %s: %s", name, sconstraint, v));
            }
            throw new IllegalArgumentException(String.format("value is not one of allowed values for \"%s\": %s", name, v));
        }
        return v;
    }

    public static Object validateParam(String name, Object v, Map<String, Object> constraint) {
        if (name == null) {
            name = "";
        }
        if (constraint.containsKey("regex") && !Pattern.matches((String)constraint.get("regex"), v.toString())) {
            throw new IllegalArgumentException(String.format("value does not match regular expression: %s %s", name, v));
        }
        if (name.equals("timerange")) {
            if (constraint.containsKey("min") && Ops.datumRange((Object)v).min().lt(Ops.datumRange((Object)constraint.get("min")).min())) {
                throw new IllegalArgumentException(String.format("value is less than minimum: %s %s", name, v));
            }
            if (constraint.containsKey("max") && Ops.datumRange((Object)v).max().gt(Ops.datumRange((Object)constraint.get("max")).max())) {
                throw new IllegalArgumentException(String.format("value is greater than maximum: %s %s", name, v));
            }
        } else {
            if (constraint.containsKey("min") && Ops.datum((Object)v).lt(Ops.datum((Object)constraint.get("min")))) {
                throw new IllegalArgumentException(String.format("value is less than minimum: %s %s", name, v));
            }
            if (constraint.containsKey("max") && Ops.datum((Object)v).gt(Ops.datum((Object)constraint.get("max")))) {
                throw new IllegalArgumentException(String.format("value is greater than maximum: %s %s", name, v));
            }
        }
        if (constraint.containsKey("format")) {
            String spec = (String)constraint.get("format");
            if (spec.length() == 0) {
                throw new IllegalArgumentException("format cannot be empty string");
            }
            if (spec.charAt(0) == '$') {
                v = TimeParser.create((String)spec).format(Ops.datumRange((Object)v).min());
            } else if (spec.charAt(0) == '%' && v instanceof Double) {
                String s = String.format(spec, v);
                v = Double.parseDouble(s);
            }
        }
        if (constraint.containsKey("values")) {
            JythonOps.validateParam(name, v, (List)constraint.get("values"));
        }
        return v;
    }

    public static Object validateParam(String name, Object v, PyDictionary constraint) {
        return JythonOps.validateParam(name, v, JythonUtil.pyDictionaryToMap(constraint));
    }

    public static String addToSearchPath(PyList syspath, String path, ProgressMonitor mon) throws IOException, URISyntaxException {
        return JythonOps.addToSearchPath(syspath, path, null, mon);
    }

    public static String addToSearchPath(PyList syspath, String path, String docPath, ProgressMonitor mon) throws IOException, URISyntaxException {
        if (System.getProperty("javawebstart.version") != null) {
            logger.warning("Jython addToSearchPath will probably fail because this is not supported with Webstart.");
        }
        if (path.endsWith(".jar")) {
            File jarFile;
            try {
                jarFile = org.autoplot.datasource.FileSystemUtil.doDownload((String)path, (ProgressMonitor)mon);
            }
            catch (IOException e) {
                jarFile = DataSetURI.downloadResourceAsTempFile((URL)DataSetURI.getURL((String)path), (ProgressMonitor)mon);
            }
            File destDir = FileSystem.settings().getLocalCacheDir();
            destDir = new File(destDir, "jar");
            String ss = path.replace("://", "/");
            destDir = new File(destDir, ss);
            FileSystemUtil.unzipFile((File)jarFile, (File)destDir);
            syspath.insert(0, (PyObject)new PyString(destDir.toString()));
            if (docPath != null) {
                List<String> paths = JythonOps.findJavaPathRoots(FileSystem.create((URI)destDir.toURI()));
                paths.forEach(p -> JavadocLookup.getInstance().setLinkForJavaSignature((String)p, docPath));
            }
            return destDir.toString();
        }
        throw new IllegalArgumentException("only jar files can be added.");
    }

    public static String formUri(String vapScheme, String resourceUri, Object args) {
        LinkedHashMap jargs = new LinkedHashMap();
        if (args != null) {
            if (args instanceof PyDictionary) {
                PyDictionary pd = (PyDictionary)args;
                pd.keys().forEach(k -> jargs.put(String.valueOf(k), String.valueOf(pd.get((PyObject)new PyString(String.valueOf(k))))));
            } else if (args instanceof Map) {
                Map m = (Map)args;
                ((Map)args).keySet().forEach(k -> jargs.put(String.valueOf(k), m.get(k)));
            } else {
                throw new IllegalArgumentException("args cannot be converted to Map");
            }
        }
        return URISplit.format((String)vapScheme, (String)resourceUri, jargs);
    }

    public static MutablePropertyDataSet putProperty(QDataSet ds, String name, Object value) {
        String type = DataSetUtil.getPropertyType((String)name);
        if (type != null && type.equals("Map") && !(value instanceof Map)) {
            try {
                String json = value.toString();
                JSONObject obj = new JSONObject(json);
                value = JsonUtil.jsonToMap((JSONObject)obj);
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, "type is not supported for PROPERTY TYPE MAP: " + value, ex);
            }
        }
        return Ops.putProperty((QDataSet)ds, (String)name, (Object)value);
    }

    public static void invokeSometime(PyObject func) {
        Runnable run = () -> func.__call__();
        new Thread(run).start();
    }

    public static void invokeSometime(PyObject func, PyObject arg) {
        Runnable run = () -> func.__call__(arg);
        new Thread(run).start();
    }

    public static String currentLine() {
        StackTraceElement[] sts = new Exception().getStackTrace();
        for (int i = 0; i < sts.length; ++i) {
            if (!sts[i].getClassName().startsWith("org.python.pycode")) continue;
            return sts[i].getFileName() + ":" + sts[i].getLineNumber();
        }
        return "???";
    }

    public static List<String> findJavaPathRoots(FileSystem destDir) {
        return JythonOps.findJavaPathRoots(destDir, "/", new ArrayList<String>());
    }

    private static List<String> findJavaPathRoots(FileSystem destDir, String prefix, List<String> result) {
        try {
            String[] roots;
            for (String r : roots = destDir.listDirectory("/")) {
                if (r.length() == 0 || Character.isUpperCase(r.charAt(0))) {
                    logger.log(Level.FINER, "skipping {0}", r);
                    continue;
                }
                if (!destDir.getFileObject(r).isFolder()) continue;
                try {
                    FileSystem child = destDir.createFileSystem(r);
                    JythonOps.findJavaPathRoots(child, prefix + r, result);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(JythonOps.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (prefix.length() > 1) {
                boolean haveIt = false;
                for (String r : result) {
                    if (!r.startsWith(prefix)) continue;
                    haveIt = true;
                    break;
                }
                if (!haveIt) {
                    result.add(prefix);
                }
            }
            return result;
        }
        catch (IOException ex) {
            Logger.getLogger(JythonOps.class.getName()).log(Level.SEVERE, null, ex);
            return result;
        }
    }
}

