/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.jythoncompletion.JavadocLookup;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.AugAssign;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.BoolOp;
import org.python.parser.ast.Break;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Expr;
import org.python.parser.ast.ExtSlice;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Pass;
import org.python.parser.ast.Print;
import org.python.parser.ast.Raise;
import org.python.parser.ast.Return;
import org.python.parser.ast.Slice;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.While;
import org.python.parser.ast.aliasType;
import org.python.parser.ast.excepthandlerType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;
import org.python.parser.ast.listcompType;
import org.python.parser.ast.sliceType;
import org.python.parser.ast.stmtType;

public class JythonToJavaConverter {
    private static final Logger logger = LoggerManager.getLogger((String)"jython");
    private static Map<String, String> packages = null;
    public static String TYPE_INT = "int";
    public static String TYPE_LONG = "long";
    public static String TYPE_FLOAT = "float";
    public static String TYPE_STRING = "String";
    public static String TYPE_STRING_ARRAY = "String[]";
    public static String TYPE_OBJECT = "Object";
    public static String TYPE_MAP = "Map";

    public static synchronized String guessPackage(String clas) {
        String result;
        if (packages == null) {
            try {
                HashMap<String, String> lpackages = new HashMap<String, String>();
                try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonToJavaConverter.class.getResourceAsStream("/importLookup.jy")));){
                    String l;
                    Pattern p = Pattern.compile("from (.*) import (.*)");
                    while ((l = r.readLine()) != null) {
                        if (l.length() == 0 || l.charAt(0) == '#') continue;
                        Matcher m = p.matcher(l);
                        if (m.matches()) {
                            lpackages.put(m.group(2), m.group(1));
                            continue;
                        }
                        logger.log(Level.INFO, "does not match pattern: {0}", l);
                    }
                }
                packages = lpackages;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        if ((result = packages.get(clas)) == null) {
            List<String> sss = JavadocLookup.getInstance().searchForSignature(clas);
            for (int i = 0; i < sss.size(); ++i) {
                int idx;
                String s = sss.get(i);
                if (!s.substring((idx = s.lastIndexOf(".")) + 1).equals(clas)) continue;
                result = s.substring(0, idx);
            }
        }
        return result;
    }

    public static synchronized List<String> guessCompletions(String clas) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonToJavaConverter.class.getResourceAsStream("/importLookup.jy")));){
            String l;
            Pattern p = Pattern.compile("from (.*) import (.*)");
            while ((l = r.readLine()) != null) {
                if (l.length() == 0 || l.charAt(0) == '#') continue;
                Matcher m = p.matcher(l);
                if (m.matches()) {
                    String tclas = m.group(2);
                    if (!tclas.startsWith(clas)) continue;
                    result.add(tclas);
                    continue;
                }
                logger.log(Level.INFO, "does not match pattern: {0}", l);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        List<String> sss = JavadocLookup.getInstance().searchForSignature(clas);
        for (int i = 0; i < sss.size(); ++i) {
            String s = sss.get(i);
            int idx = s.lastIndexOf(".");
            if (idx <= -1) continue;
            result.add(s.substring(idx + 1));
        }
        return result;
    }

    public static void addImport(Document doc, String pkg, String name) {
        JythonToJavaConverter.addImport(doc, pkg, name, doc.getLength());
    }

    public static void addImport(Document doc, String pkg, String name, int cursorPosition) {
        try {
            String s = doc.getText(0, cursorPosition);
            String[] ss = s.split("\n");
            Pattern p = Pattern.compile("from (.+) import (.*)");
            boolean haveIt = false;
            int addToLine = -1;
            int addAtOffset = -1;
            int offset = 0;
            for (int i = 0; i < ss.length; ++i) {
                String line = ss[i];
                Matcher m = p.matcher(line);
                if (m.matches() && m.group(1).equals(pkg)) {
                    String[] namess;
                    String names = m.group(2);
                    for (String n : namess = names.split(",", -2)) {
                        if (!n.equals(name)) continue;
                        haveIt = true;
                    }
                    if (!haveIt) {
                        addToLine = i;
                        addAtOffset = offset + line.length();
                    }
                }
                offset = offset + line.length() + 1;
            }
            if (!haveIt) {
                if (addToLine > -1) {
                    doc.insertString(addAtOffset, "," + name, null);
                } else {
                    doc.insertString(0, "from " + pkg + " import " + name + "\n", null);
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(JythonToJavaConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String addImport(String src, String pkg, String name) {
        CharSequence[] ss = src.split("\n");
        Pattern p = Pattern.compile("from (.+) import (.*)");
        boolean haveIt = false;
        int addToLine = -1;
        for (int i = 0; i < ss.length; ++i) {
            String[] namess;
            String line = ss[i];
            Matcher m = p.matcher(line);
            if (!m.matches() || !m.group(1).equals(pkg)) continue;
            String names = m.group(2);
            for (String n : namess = names.split(",", -2)) {
                if (!n.equals(name)) continue;
                haveIt = true;
            }
            if (haveIt) continue;
            addToLine = i;
        }
        if (!haveIt) {
            if (addToLine > -1) {
                ss[addToLine] = ss[addToLine] + "," + name;
                return String.join((CharSequence)"\n", ss);
            }
            return "from " + pkg + " import " + name + "\n" + String.join((CharSequence)"\n", ss);
        }
        return src;
    }

    public static boolean hasImport(String src, String pkg, String name) {
        String[] ss = src.split("\n");
        Pattern p = Pattern.compile("from (.+) import (.*)");
        boolean haveIt = false;
        for (int i = 0; i < ss.length; ++i) {
            String[] namess;
            String line = ss[i];
            Matcher m = p.matcher(line);
            if (!m.matches() || !m.group(1).equals(pkg)) continue;
            String names = m.group(2);
            for (String n : namess = names.split(",", -2)) {
                if (!n.equals(name)) continue;
                haveIt = true;
            }
        }
        return haveIt;
    }

    private static int[] count(String line, char[] chrs) {
        int[] result = new int[chrs.length];
        for (int i = 0; i < chrs.length; ++i) {
            result[i] = 0;
        }
        for (char c : line.toCharArray()) {
            for (int i = 0; i < chrs.length; ++i) {
                if (c != chrs[i]) continue;
                int n = i;
                result[n] = result[n] + 1;
            }
        }
        return result;
    }

    public static String convertReverse(String javaCode) {
        String[] ss = javaCode.split("\n");
        StringBuilder b = new StringBuilder();
        Pattern assignPattern = Pattern.compile("([a-zA-Z.]*[A-Z]\\S+)(\\s+)(\\S+)(\\s*=.*)");
        Pattern importPattern1 = Pattern.compile("import ([a-z\\.]*)\\.([A-Za-z\\*]*)");
        Pattern newPattern = Pattern.compile("(.*)([=\\s]*)?new\\s*([a-zA-Z\\.]+)(.*)");
        int indentLevel = 0;
        String indent = "";
        boolean withinComment = false;
        ArrayList<String> importedPaths = new ArrayList<String>();
        char[] chrs = new char[]{'(', ')', '{', '}'};
        int lineNumber = 0;
        for (String s : ss) {
            String clas;
            Matcher m;
            logger.log(Level.FINER, "line {0}: {1}", new Object[]{lineNumber, s});
            ++lineNumber;
            String strim = s.trim();
            int javaIndent = strim.length() > 1 ? s.indexOf(strim.substring(0, 1)) : 0;
            s = strim;
            indentLevel = javaIndent;
            if (indentLevel != indent.length()) {
                indent = "                                                                       ".substring(0, indentLevel);
            }
            if (s.endsWith(";")) {
                s = s.substring(0, s.length() - 1);
            }
            if ((s = s.replaceAll("//", "#")).startsWith("/*")) {
                withinComment = true;
            }
            if ((m = newPattern.matcher(s)).matches()) {
                clas = "import " + m.group(3);
                if (!importedPaths.contains(clas)) {
                    importedPaths.add(clas);
                }
                s = m.group(1) + m.group(2) + m.group(3) + m.group(4);
            }
            if (s.contains("Short.") && !importedPaths.contains(clas = "from java.lang import Short")) {
                importedPaths.add(clas);
            }
            s = s.replaceAll("null", "None");
            s = s.replaceAll(" new ", " ");
            s = s.replaceAll("throw", "raise");
            s = s.replaceAll("false", "False");
            s = s.replaceAll("true", "True");
            s = s.replaceAll("startsWith", "startswith");
            s = s.replaceAll("endsWith", "endswith");
            s = s.replaceAll("else if", "elif");
            s = s.replaceAll("\\|\\|", "or");
            s = s.replaceAll("\\&\\&", "and");
            s = s.replaceAll("String.format\\((.*?),(.*)\\)", "$1 % \\($2\\)");
            s = s.replaceAll("public static final ([a-zA-Z0-9_]+)", "# returns $1\n" + indent + "def");
            s = s.replaceAll("private static final ([a-zA-Z0-9_]+)", "# returns $1\n" + indent + "def");
            s = s.replaceAll("public static ([a-zA-Z0-9_]+)", "# returns $1\n" + indent + "def");
            s = s.replaceAll("private static ([a-zA-Z0-9_]+)", "# returns $1\n" + indent + "def");
            s = s.replaceAll("for\\s+\\(\\s*int\\s+([a-z]+)\\s*=\\s*(\\d+)\\s*\\; \\s*\\1\\s*\\<\\s*(\\d+)\\;\\s*\\1\\+\\+\\s*\\)", "for $1 in xrange($2,$3)");
            s = s.replaceAll("\\.substring\\(([a-z\\+\\-\\.0-9]+\\s*)(,\\s*([a-z\\+\\-\\.0-9]+)\\s*)?\\)", "[$1:$3]");
            s = s.replaceAll("\\.substring\\(([a-z\\+\\-\\.0-9\\(\\)]+\\s*)(,\\s*([a-z\\+\\-\\.0-9]+)\\s*)?\\)", "[$1:$3]");
            s = s.replaceAll(".charAt\\(([a-z\\+\\-\\.0-9\\(\\)]+\\s*)\\)", "[$1]");
            m = assignPattern.matcher(s = s.replaceAll("([a-zA-Z0-9_]+).length\\(\\)", "len($1)"));
            if (m.matches()) {
                s = m.group(3) + m.group(4);
            } else {
                m = importPattern1.matcher(s);
                if (m.matches()) {
                    s = "from " + m.group(1) + " import " + m.group(2);
                }
            }
            if (s.contains("reformatIsoTime")) {
                System.err.println("Stop here jeremy");
            }
            if (s.contains("{")) {
                s = s.replace("{", ":");
            }
            if (s.contains("}")) {
                s = s.replace("}", "");
            }
            s = s.trim();
            b.append(indent);
            if (withinComment) {
                b.append("# ");
                if (s.endsWith("*/")) {
                    withinComment = false;
                }
                if (s.startsWith("/*")) {
                    s = s.substring(2).trim();
                }
                if (s.startsWith("*/")) {
                    s = s.substring(2).trim();
                }
                if (s.startsWith("*")) {
                    s = s.substring(1).trim();
                }
            }
            if (s.startsWith("public static") && s.endsWith("{")) {
                int i = (s = s.substring(13).trim()).indexOf(" ");
                if (i > 0) {
                    s = s.substring(i).trim();
                }
                s = "def " + s;
            }
            b.append(s).append("\n");
            logger.log(Level.FINER, "out  {0}: {1}", new Object[]{lineNumber, s});
        }
        StringBuilder sb = new StringBuilder();
        for (String s : importedPaths) {
            sb.append(s).append("\n");
        }
        if (!importedPaths.isEmpty()) {
            sb.append("\n");
        }
        sb.append((CharSequence)b);
        return sb.toString();
    }

    public static String getJavaListType(org.python.parser.ast.List list) {
        if (list.elts.length == 0) {
            return "new Object[]";
        }
        exprType o = list.elts[0];
        for (int i = 1; i < list.elts.length; ++i) {
            if (list.elts[i].getClass() == o.getClass()) continue;
            return "new Object[]";
        }
        if (o instanceof Num) {
            Num n = (Num)o;
            if (n.n instanceof PyInteger) {
                return "new int[]";
            }
            if (n.n instanceof PyFloat) {
                return "new double[]";
            }
            return "new Number[]";
        }
        if (o instanceof Str) {
            return "new String[]";
        }
        return "new Object[]";
    }

    public static String convert(String script) throws Exception {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        StringBuilder b = new StringBuilder();
        JythonToJavaConverter.convert(b, n);
        return b.toString();
    }

    private static void convert(StringBuilder sb, Module n) throws Exception {
        MyVisitorBase vb = new MyVisitorBase(sb);
        n.traverse(vb);
    }

    public static void main(String[] args) throws Exception {
        System.err.println(JythonToJavaConverter.convert("'XXX'*50"));
        String furi = "/home/jbf/ct/autoplot/u/2024/sadie/20241029/idlsav.py";
        File src = DataSetURI.getFile((String)furi, (ProgressMonitor)new NullProgressMonitor());
        try (FileReader reader = new FileReader(src);){
            String code = JythonUtil.readScript(new BufferedReader(reader));
            System.err.println(JythonToJavaConverter.convert(code));
        }
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        StringBuilder builder;
        int lineNumber = 1;
        boolean includeLineNumbers = false;
        String lastReturnType = "";
        Stack<Context> contexts = new Stack();
        private static final Map<Integer, String> ops = new HashMap<Integer, String>();
        private static final String spaces4 = "    ";

        MyVisitorBase(StringBuilder builder) {
            this.builder = builder;
            this.contexts.push(new Context());
        }

        public Object visitName(Name node) throws Exception {
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            StringBuilder builder = this.builder;
            this.traverse(builder, "", sn, false);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void traverse(StringBuilder builder, String indent, SimpleNode sn, boolean inline) throws Exception {
            if (this.includeLineNumbers && (builder.length() == 0 || builder.charAt(builder.length() - 1) == '\n')) {
                builder.append(String.format("%04d: ", this.lineNumber));
            }
            if (!inline) {
                boolean endsWithIndent;
                boolean bl = endsWithIndent = builder.indexOf(indent, builder.length() - indent.length()) > -1;
                if (!endsWithIndent) {
                    builder.append(indent);
                }
            }
            if (sn instanceof FunctionDef) {
                this.handleFunctionDef(builder, (FunctionDef)sn, indent, inline);
            } else if (sn instanceof ClassDef) {
                this.handleClassDef(builder, (ClassDef)sn, indent, inline);
            } else if (sn instanceof Global) {
                void var6_32;
                Global g = (Global)sn;
                builder.append("// global ");
                boolean bl = false;
                while (var6_32 < g.names.length) {
                    if (var6_32 > 0) {
                        builder.append(",");
                    }
                    builder.append(g.names[var6_32]);
                    ++var6_32;
                }
            } else if (sn instanceof Break) {
                builder.append("break");
            } else if (sn instanceof Expr) {
                Expr ex = (Expr)sn;
                this.traverse(builder, "", (SimpleNode)ex.value, true);
            } else if (sn instanceof Print) {
                this.handlePrint(builder, (Print)sn, indent, inline);
            } else if (sn instanceof Return) {
                Return rt = (Return)sn;
                builder.append("return");
                if (rt.value != null) {
                    builder.append(" ");
                    this.traverse(builder, "", (SimpleNode)rt.value, true);
                    this.lastReturnType = this.guessType(rt.value);
                }
            } else if (sn instanceof ImportFrom) {
                void var6_34;
                ImportFrom ff = (ImportFrom)sn;
                boolean bl = false;
                while (var6_34 < ff.names.length) {
                    builder.append("import ").append(ff.module).append('.').append(ff.names[var6_34].name);
                    if (var6_34 < ff.names.length - 1) {
                        builder.append(";\n");
                    }
                    ++var6_34;
                }
            } else if (sn instanceof Str) {
                Str ss = (Str)sn;
                builder.append("\"");
                String string = ss.s.replaceAll("\n", "\\\\n");
                builder.append(string);
                builder.append("\"");
            } else if (sn instanceof Num) {
                Num ex = (Num)sn;
                builder.append(ex.n);
            } else if (sn instanceof UnaryOp) {
                UnaryOp op = (UnaryOp)sn;
                switch (op.op) {
                    case 3: {
                        builder.append("+");
                        this.traverse(builder, "", (SimpleNode)op.operand, true);
                        break;
                    }
                    case 4: {
                        builder.append("-");
                        this.traverse(builder, "", (SimpleNode)op.operand, true);
                        break;
                    }
                    case 2: {
                        builder.append("!");
                        this.traverse(builder, "", (SimpleNode)op.operand, true);
                        break;
                    }
                    case 1: {
                        builder.append("~");
                        this.traverse(builder, "", (SimpleNode)op.operand, true);
                        break;
                    }
                    default: {
                        builder.append(op.toString());
                        break;
                    }
                }
            } else if (sn instanceof BinOp) {
                BinOp as = (BinOp)sn;
                if (as.left instanceof Str && as.op == 5) {
                    builder.append("String.format(");
                    this.traverse(builder, "", (SimpleNode)as.left, true);
                    builder.append(",");
                    this.traverse(builder, "", (SimpleNode)as.right, true);
                    builder.append(")");
                } else if (as.left instanceof Str && as.op == 3 && as.right instanceof Num) {
                    builder.append("new StringBuilder().repeat(");
                    this.traverse(builder, "", (SimpleNode)as.left, true);
                    builder.append(",");
                    this.traverse(builder, "", (SimpleNode)as.right, true);
                    builder.append(")");
                } else if (as.op == 6) {
                    builder.append("Math.pow(");
                    this.traverse(builder, "", (SimpleNode)as.left, true);
                    builder.append(",");
                    this.traverse(builder, "", (SimpleNode)as.right, true);
                    builder.append(")");
                } else {
                    void var6_38;
                    this.traverse(builder, "", (SimpleNode)as.left, true);
                    String string = ops.get(as.op);
                    if (string == null) {
                        String string2 = " ?? ";
                    }
                    builder.append((String)var6_38);
                    this.traverse(builder, "", (SimpleNode)as.right, true);
                }
            } else if (sn instanceof BoolOp) {
                BoolOp as = (BoolOp)sn;
                if (as.op != 1 && as.op != 2) throw new IllegalArgumentException("not supported BoolOp as.op=" + as.op);
                switch (as.op) {
                    case 1: {
                        String string = " && ";
                        break;
                    }
                    case 2: {
                        String string = " || ";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("operator is not supported: " + as);
                    }
                }
                builder.append("(");
                this.traverse(builder, "", (SimpleNode)as.values[0], true);
                builder.append(")");
                for (exprType o : Arrays.copyOfRange(as.values, 1, as.values.length)) {
                    void var6_41;
                    builder.append((String)var6_41);
                    builder.append("(");
                    this.traverse(builder, "", (SimpleNode)o, true);
                    builder.append(")");
                }
            } else if (sn instanceof Assign) {
                this.handleAssign(builder, (Assign)sn, indent, inline);
            } else if (sn instanceof Assert) {
                Assert a = (Assert)sn;
                if (a.test instanceof Call) {
                    exprType a2;
                    exprType a1;
                    Call call = (Call)a.test;
                    exprType f = call.func;
                    if (f instanceof Name && ((Name)f).id.equals("isinstance") && call.args.length == 2 && (a1 = call.args[0]) instanceof Name && (a2 = call.args[1]) instanceof Name) {
                        String id = ((Name)a1).id;
                        String typs = ((Name)a2).id;
                        if (typs.equals("str")) {
                            this.assertType(id, "String");
                            return;
                        } else if (typs.equals("file")) {
                            this.assertType(id, "FileChannel");
                            return;
                        } else {
                            this.assertType(id, typs);
                        }
                        return;
                    }
                }
            } else if (sn instanceof Name) {
                this.handleName(builder, (Name)sn, indent, inline);
            } else if (sn instanceof Call) {
                this.handleCall(builder, (Call)sn, indent, inline);
            } else if (sn instanceof Index) {
                Index id = (Index)sn;
                this.traverse(builder, "", (SimpleNode)id.value, true);
            } else if (sn instanceof For) {
                this.handleFor(builder, (For)sn, indent, inline);
            } else if (sn instanceof While) {
                this.handleWhile(builder, (While)sn, indent, inline);
            } else if (sn instanceof If) {
                this.handleIf(builder, (If)sn, indent, inline);
            } else if (sn instanceof Compare) {
                Compare cp = (Compare)sn;
                if (cp.ops.length == 1 && cp.ops[0] == 9 && cp.comparators.length == 1) {
                    String string = this.guessType(cp.left);
                    String t2 = this.guessType(cp.comparators[0]);
                    if (string == TYPE_STRING && t2 == TYPE_STRING) {
                        this.traverse(builder, "", (SimpleNode)cp.comparators[0], true);
                        builder.append(".contains(");
                        this.traverse(builder, "", (SimpleNode)cp.left, true);
                        builder.append(")");
                        return;
                    }
                    if (string == TYPE_STRING && t2.equals(TYPE_STRING_ARRAY)) {
                        this.traverse(builder, "", (SimpleNode)cp.comparators[0], true);
                        builder.append(".contains(");
                        this.traverse(builder, "", (SimpleNode)cp.left, true);
                        builder.append(")");
                        return;
                    }
                }
                if (cp.ops[0] != 9) {
                    this.traverse(builder, "", (SimpleNode)cp.left, true);
                }
                block27: for (int i : cp.ops) {
                    switch (i) {
                        case 5: {
                            builder.append(">");
                            continue block27;
                        }
                        case 6: {
                            builder.append(">=");
                            continue block27;
                        }
                        case 3: {
                            builder.append("<");
                            continue block27;
                        }
                        case 4: {
                            builder.append("<=");
                            continue block27;
                        }
                        case 1: {
                            builder.append("==");
                            continue block27;
                        }
                        case 2: {
                            builder.append("!=");
                            continue block27;
                        }
                        case 9: {
                            if (cp.comparators.length == 1 && this.guessType(cp.comparators[0]) == TYPE_MAP) {
                                this.traverse(builder, "", (SimpleNode)cp.comparators[0], inline);
                                builder.append(".containsKey(");
                                this.traverse(builder, "", (SimpleNode)cp.left, inline);
                                builder.append(")");
                                continue block27;
                            }
                            this.traverse(builder, "", (SimpleNode)cp.left, inline);
                            builder.append("<in>");
                            for (exprType t : cp.comparators) {
                                this.traverse(builder, "", (SimpleNode)t, inline);
                            }
                            continue block27;
                        }
                        case 7: {
                            builder.append(" instanceof ");
                            continue block27;
                        }
                        default: {
                            builder.append("?<>?");
                        }
                    }
                }
                if (cp.ops[0] != 9) {
                    for (exprType t : cp.comparators) {
                        this.traverse(builder, "", (SimpleNode)t, inline);
                    }
                }
            } else if (sn instanceof Continue) {
                builder.append("continue");
            } else if (sn instanceof Raise) {
                Raise r = (Raise)sn;
                builder.append("throw ");
                this.traverse(builder, "", (SimpleNode)r.type, true);
            } else if (sn instanceof ExtSlice) {
                void var6_47;
                ExtSlice r = (ExtSlice)sn;
                boolean bl = false;
                while (var6_47 < r.dims.length) {
                    if (var6_47 > 0) {
                        builder.append(",");
                    }
                    sliceType st = r.dims[var6_47];
                    this.traverse(builder, "", (SimpleNode)st, true);
                    ++var6_47;
                }
            } else if (sn instanceof Slice) {
                Slice s = (Slice)sn;
                builder.append("[" + String.valueOf(s.lower) + ":" + String.valueOf(s.upper) + ":" + String.valueOf(s.step) + "]");
            } else if (sn instanceof Subscript) {
                this.handleSubscript(builder, (Subscript)sn, indent, inline);
            } else if (sn instanceof Attribute) {
                Attribute at = (Attribute)sn;
                String string = this.guessType(at.value);
                if (string.equals("String")) {
                    if (at.attr.equals("strip")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("trim");
                        return;
                    }
                    if (at.attr.equals("split")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("trim().split(\"\\\\s+\")");
                        return;
                    }
                    if (at.attr.equals("splitlines")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("split(\"\\n\")");
                        return;
                    }
                    if (at.attr.equals("find")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("indexOf");
                        return;
                    }
                    if (at.attr.equals("startswith")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("startsWith");
                        return;
                    }
                    if (at.attr.equals("endswith")) {
                        this.traverse(builder, "", (SimpleNode)at.value, true);
                        builder.append(".");
                        builder.append("endsWith");
                        return;
                    }
                } else if (at.attr.equals("strip") && at.value instanceof Name) {
                    this.traverse(builder, "", (SimpleNode)at.value, true);
                    builder.append(".");
                    builder.append("trim");
                    this.assertType(((Name)at.value).id, TYPE_STRING);
                    return;
                }
                this.traverse(builder, "", (SimpleNode)at.value, true);
                builder.append(".");
                builder.append(at.attr);
            } else if (sn instanceof org.python.parser.ast.List) {
                org.python.parser.ast.List ll = (org.python.parser.ast.List)sn;
                String string = JythonToJavaConverter.getJavaListType(ll);
                builder.append(string);
                builder.append(" { ");
                for (int i = 0; i < ll.elts.length; ++i) {
                    if (i > 0) {
                        builder.append(",");
                    }
                    this.traverse(builder, "", (SimpleNode)ll.elts[i], true);
                }
                builder.append(" } ");
            } else if (sn instanceof Subscript) {
                Subscript ss = (Subscript)sn;
                this.traverse(builder, "", (SimpleNode)ss.value, true);
                builder.append("[");
                this.traverse(builder, "", (SimpleNode)ss.slice, true);
                builder.append("]");
            } else if (sn instanceof Tuple) {
                void var6_51;
                Tuple ss = (Tuple)sn;
                boolean bl = false;
                while (var6_51 < ss.elts.length) {
                    if (var6_51 > 0) {
                        builder.append(',');
                    }
                    this.traverse(builder, "", (SimpleNode)ss.elts[var6_51], true);
                    ++var6_51;
                }
            } else if (sn instanceof AugAssign) {
                AugAssign a1 = (AugAssign)sn;
                switch (a1.op) {
                    case 1: {
                        this.traverse(builder, "", (SimpleNode)a1.target, true);
                        builder.append("+=");
                        this.traverse(builder, "", (SimpleNode)a1.value, true);
                        break;
                    }
                    case 2: {
                        this.traverse(builder, "", (SimpleNode)a1.target, true);
                        builder.append("+=");
                        this.traverse(builder, "", (SimpleNode)a1.value, true);
                        break;
                    }
                    default: {
                        builder.append(sn.toString()).append("\n");
                        break;
                    }
                }
            } else if (sn instanceof TryExcept) {
                void var6_53;
                TryExcept te = (TryExcept)sn;
                System.err.println("" + indent.length() + " length");
                builder.append(indent).append("try {\n");
                this.handleBody(builder, te.body, indent + spaces4);
                builder.append(indent).append("} catch ( Exception e ) {").append("\n");
                boolean bl = false;
                while (var6_53 < te.handlers.length) {
                    if (te.handlers[var6_53] instanceof excepthandlerType) {
                        this.handleBody(builder, te.handlers[var6_53].body, indent + spaces4);
                        if (te.handlers.length > 1) {
                            builder.append("not sure line830");
                        }
                    } else {
                        builder.append("not sure line833");
                    }
                    ++var6_53;
                }
                if (te.orelse != null) {
                    builder.append("not sure line839");
                    this.handleBody(builder, te.orelse, indent + spaces4);
                    builder.append("not sure line832");
                }
                builder.append(indent).append("}");
            } else if (sn instanceof Import) {
                Import imp = (Import)sn;
                builder.append(indent).append("import ");
                for (aliasType a : imp.names) {
                    this.traverse(builder, "", (SimpleNode)a, true);
                    builder.append(",");
                }
            } else if (sn instanceof ImportFrom) {
                ImportFrom imp = (ImportFrom)sn;
                builder.append(indent).append("import ").append(imp.module);
            } else if (sn instanceof aliasType) {
                aliasType at = (aliasType)sn;
                builder.append(indent).append(at.name);
            } else if (sn instanceof Pass) {
                builder.append(indent).append("//pass");
            } else if (sn instanceof Dict) {
                builder.append(indent).append("new HashMap<>()");
            } else if (sn instanceof ListComp) {
                this.handleListComp(builder, (ListComp)sn, indent, inline);
            } else {
                builder.append(sn.toString()).append("\n");
                ++this.lineNumber;
            }
            if (inline) return;
            String ss = builder.toString().trim();
            if (ss.charAt(ss.length() - 1) == '}') {
                builder.append("\n");
            } else {
                builder.append(";\n");
            }
            ++this.lineNumber;
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }

        private String getTypeForName(String name) {
            for (int i = this.contexts.size() - 1; i >= 0; --i) {
                Context c = (Context)this.contexts.get(i);
                String ss = c.names.get(name);
                if (ss == null) continue;
                return ss;
            }
            return null;
        }

        private String guessType(exprType ex) {
            if (ex instanceof Str) {
                return TYPE_STRING;
            }
            if (ex instanceof Num) {
                Num n1 = (Num)ex;
                if (n1.n instanceof PyInteger) {
                    return TYPE_INT;
                }
                return TYPE_FLOAT;
            }
            if (ex instanceof Name) {
                String s = this.getTypeForName(((Name)ex).id);
                if (s == null) {
                    return TYPE_OBJECT;
                }
                return s;
            }
            if (ex instanceof Call) {
                Call call = (Call)ex;
                if (call.func instanceof Attribute) {
                    Attribute attr = (Attribute)call.func;
                    String type = this.guessType(attr.value);
                    if (type == TYPE_STRING) {
                        if (attr.attr.equals("find")) {
                            return TYPE_INT;
                        }
                        if (attr.attr.equals("substring")) {
                            return TYPE_STRING;
                        }
                        if (attr.attr.equals("strip")) {
                            return TYPE_STRING;
                        }
                        if (attr.attr.equals("splitlines")) {
                            return TYPE_STRING_ARRAY;
                        }
                    }
                } else if (call.func instanceof Name) {
                    Name n = (Name)call.func;
                    if (n.id.equals("len")) {
                        return TYPE_INT;
                    }
                }
                return TYPE_OBJECT;
            }
            if (ex instanceof BinOp) {
                BinOp bo = (BinOp)ex;
                String t1 = this.guessType(bo.left);
                String t2 = this.guessType(bo.right);
                if (t1 == TYPE_INT && t2 == TYPE_INT) {
                    return TYPE_INT;
                }
                if (t1 == TYPE_STRING && t2 == TYPE_STRING) {
                    return TYPE_STRING;
                }
                return TYPE_OBJECT;
            }
            if (ex instanceof Subscript) {
                return this.guessType(((Subscript)ex).value);
            }
            return TYPE_OBJECT;
        }

        private String getJavaIterExprType(exprType iter) {
            if (iter instanceof Call) {
                Call cc = (Call)iter;
                if (cc.func instanceof Name) {
                    Name n = (Name)cc.func;
                    if (n.id.equals("range")) {
                        return "int";
                    }
                    if (n.id.equals("xrange")) {
                        return "int";
                    }
                    if (n.id.equals("getDataSet")) {
                        return "QDataSet";
                    }
                    if (n.id.equals("getParam") && cc.args.length > 1) {
                        exprType arg1 = cc.args[1];
                        return this.getJavaExprType(arg1);
                    }
                } else if (cc.func instanceof Attribute) {
                    Attribute att = (Attribute)cc.func;
                    if (att.value instanceof Name) {
                        Name n = (Name)att.value;
                        String ftype = this.getJavaExprType((exprType)n);
                        if (att.attr.equals("readlines")) {
                            return TYPE_STRING;
                        }
                        if (att.attr.equals("splitlines")) {
                            return TYPE_STRING;
                        }
                    }
                }
            }
            return "Object";
        }

        private String getJavaExprType(exprType iter) {
            if (iter instanceof Call) {
                Call cc = (Call)iter;
                if (cc.func instanceof Name) {
                    Name n = (Name)cc.func;
                    if (n.id.equals("int")) {
                        return TYPE_INT;
                    }
                    if (n.id.equals("range")) {
                        return "Stream<int>";
                    }
                    if (n.id.equals("xrange")) {
                        return "Stream<int>";
                    }
                    if (n.id.equals("getDataSet")) {
                        return "QDataSet";
                    }
                    if (n.id.equals("downloadResourceAsTempFile")) {
                        return "File";
                    }
                    if (n.id.equals("getParam")) {
                        if (cc.args.length > 1) {
                            exprType arg1 = cc.args[1];
                            return this.getJavaExprType(arg1);
                        }
                    } else {
                        if (Character.isUpperCase(n.id.charAt(0))) {
                            return n.id;
                        }
                        if (n.id.equals("open")) {
                            return "FileChannel";
                        }
                    }
                } else if (cc.func instanceof Attribute) {
                    Attribute attr = (Attribute)cc.func;
                    String staticClass = "";
                    if (attr.value instanceof Name && Character.isUpperCase(((Name)attr.value).id.charAt(0))) {
                        staticClass = ((Name)attr.value).id;
                    }
                    if (attr instanceof Attribute) {
                        Attribute attr2 = attr;
                        if (attr2.attr.equals("strip")) {
                            return TYPE_STRING;
                        }
                        if (attr2.attr.equals("split")) {
                            return TYPE_STRING_ARRAY;
                        }
                        if (attr2.attr.equals("tell")) {
                            return TYPE_LONG;
                        }
                    }
                    if (staticClass.equals("FileUtil") && attr.attr.equals("readFileToString")) {
                        return TYPE_STRING;
                    }
                }
            } else {
                if (iter instanceof Str) {
                    return TYPE_STRING;
                }
                if (iter instanceof Name) {
                    Name n = (Name)iter;
                    if (n.id.equals("False") || n.id.equals("True")) {
                        return "boolean";
                    }
                    return TYPE_OBJECT;
                }
                if (iter instanceof Num) {
                    Num n = (Num)iter;
                    if (n.n instanceof PyFloat) {
                        return "float";
                    }
                    if (n.n instanceof PyInteger) {
                        return "int";
                    }
                    return "Number";
                }
                if (iter instanceof Str) {
                    return "String";
                }
                if (iter instanceof org.python.parser.ast.List) {
                    org.python.parser.ast.List l = (org.python.parser.ast.List)iter;
                    String t0 = null;
                    for (exprType e1 : l.elts) {
                        String t1 = this.getJavaExprType(e1);
                        if (t0 == null) {
                            t0 = t1;
                            continue;
                        }
                        if (t0.equals(t1)) continue;
                        return "Object[]";
                    }
                    if (t0 == null) {
                        return "Object[]";
                    }
                    return t0 + "[]";
                }
                if (iter instanceof Subscript) {
                    Subscript s = (Subscript)iter;
                    String type = this.guessType(s.value);
                    if (type.equals(TYPE_OBJECT)) {
                        type = this.getJavaExprType(s.value);
                    }
                    if (type.endsWith("[]")) {
                        return type.substring(0, type.length() - 2).intern();
                    }
                    return TYPE_OBJECT;
                }
                if (iter instanceof Dict) {
                    return TYPE_MAP;
                }
            }
            return "Object";
        }

        private void assertType(String name, String type) {
            this.contexts.peek().names.put(name, type);
        }

        private String guessReturnType(stmtType[] body) {
            this.lastReturnType = "Object";
            StringBuilder dummy = new StringBuilder();
            try {
                this.handleBody(dummy, body, "");
            }
            catch (Exception ex) {
                Logger.getLogger(JythonToJavaConverter.class.getName()).log(Level.SEVERE, null, ex);
            }
            boolean hasReturn = false;
            boolean hasSecondBody = false;
            for (stmtType t : body) {
                if (t instanceof If) {
                    hasSecondBody = true;
                    continue;
                }
                if (t instanceof While) {
                    hasSecondBody = true;
                    continue;
                }
                if (t instanceof TryExcept) {
                    hasSecondBody = true;
                    continue;
                }
                if (!(t instanceof Return)) continue;
                hasReturn = true;
            }
            if (!hasReturn && !hasSecondBody) {
                return "void";
            }
            if (body[body.length - 1] instanceof Return && ((Return)body[body.length - 1]).value == null) {
                return "void";
            }
            return this.lastReturnType;
        }

        private void handleFunctionDef(StringBuilder builder, FunctionDef fd, String indent, boolean inline) throws Exception {
            String returnType = this.guessReturnType(fd.body);
            if (fd.body.length > 0 && fd.body[0] instanceof Expr) {
                Expr expr = (Expr)fd.body[0];
                if (expr.value instanceof Str) {
                    builder.append(indent).append("/**\n").append(indent).append(" * ").append(((Str)expr.value).s).append("\n").append(indent).append(" */\n");
                    fd.body = Arrays.copyOfRange(fd.body, 1, fd.body.length);
                }
            }
            this.inferDictionaries(fd.body);
            builder.append("private static ").append(returnType).append(" ").append(fd.name).append("(");
            for (int i = 0; i < fd.args.args.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                String type = this.guessType(fd.args.args[i]);
                builder.append(type).append(" ");
                this.traverse(builder, "", (SimpleNode)fd.args.args[i], true);
            }
            builder.append(") {\n");
            ++this.lineNumber;
            stmtType[] body = fd.body;
            if (returnType.equals("void") && body[body.length - 1] instanceof Return) {
                body = Arrays.copyOfRange(body, 0, body.length - 1);
            }
            this.handleBody(builder, body, indent + spaces4);
            builder.append(indent).append("}\n");
        }

        private void handlePrint(StringBuilder builder, Print pr, String indent, boolean inline) throws Exception {
            builder.append("System.out.println(");
            for (int i = 0; i < pr.values.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                this.traverse(builder, "", (SimpleNode)pr.values[i], true);
            }
            builder.append(")");
        }

        private void handleClassDef(StringBuilder builder, ClassDef classDef, String indent, boolean inline) throws Exception {
            if (classDef.bases.length > 0) {
                builder.append("private class ").append(classDef.name).append(" extends ");
                this.traverse(builder, indent, (SimpleNode)classDef.bases[0], true);
                builder.append(" {");
            } else {
                builder.append("private class ").append(classDef.name).append(" {");
            }
            this.handleBody(builder, classDef.body, indent + spaces4);
            builder.append("}");
        }

        private void handleAssign(StringBuilder builder, Assign as, String indent, boolean inline) throws Exception {
            String typeOf1;
            logger.log(Level.FINE, "handleAssign at {0}", as.beginLine);
            if (as.targets[0] instanceof Subscript && as.targets.length == 1) {
                Subscript subscript = (Subscript)as.targets[0];
                if (subscript.value instanceof Name) {
                    Name name = (Name)subscript.value;
                    if (this.guessType(subscript.value).equals("Map")) {
                        builder.append(name.id).append(".put(");
                        this.traverse(builder, "", (SimpleNode)subscript.slice, true);
                        builder.append(",");
                        this.traverse(builder, "", (SimpleNode)as.value, true);
                        builder.append(")");
                        return;
                    }
                }
            }
            if (as.targets.length == 1 && as.targets[0] instanceof Name && ((typeOf1 = this.guessType((exprType)((Name)as.targets[0]))) == null || typeOf1 == TYPE_OBJECT)) {
                String typeOf = this.getJavaExprType(as.value);
                if (typeOf == TYPE_OBJECT) {
                    typeOf = this.guessType(as.value);
                }
                builder.append(typeOf).append(" ");
                this.assertType(((Name)as.targets[0]).id, typeOf);
            }
            for (int i = 0; i < as.targets.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                this.traverse(builder, "", (SimpleNode)as.targets[i], true);
            }
            builder.append(" = ");
            this.traverse(builder, "", (SimpleNode)as.value, true);
        }

        private void handleListComp(StringBuilder builder, ListComp lc, String indent, boolean inline) throws Exception {
            if (lc.generators.length == 1 && lc.generators[0] instanceof listcompType) {
                listcompType lct = lc.generators[0];
                if (lct.ifs.length == 0) {
                    this.traverse(builder, "", (SimpleNode)lct.iter, true);
                    builder.append(".stream().map( ");
                    this.traverse(builder, "", (SimpleNode)lct.target, true);
                    builder.append(" -> ");
                    this.traverse(builder, "", (SimpleNode)lc.elt, true);
                    builder.append(").collect(Collectors.toList())");
                    return;
                }
            }
            builder.append(lc.toString());
        }

        private void handleName(StringBuilder builder, Name nn, String indent, boolean inline) {
            String name = nn.id;
            if (name.equals("False")) {
                builder.append("false");
            } else if (name.equals("True")) {
                builder.append("true");
            } else if (name.equals("None")) {
                builder.append("null");
            } else {
                builder.append(nn.id);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleCall(StringBuilder builder, Call cc, String indent, boolean inline) throws Exception {
            int i;
            block34: {
                block33: {
                    if (!(cc.func instanceof Name)) break block33;
                    String name = ((Name)cc.func).id;
                    if (Character.isUpperCase(name.charAt(0))) {
                        builder.append("new").append(" ");
                        break block34;
                    } else {
                        if (name.equals("int")) {
                            builder.append("(int)(");
                            this.traverse(builder, "", (SimpleNode)cc.args[0], true);
                            builder.append(")");
                            return;
                        }
                        if (name.equals("open")) {
                            String rw;
                            String string = rw = cc.args.length == 1 ? "r" : ((Str)cc.args[1]).s;
                            if (rw.equals("r")) {
                                builder.append("new RandomAccessFile(");
                                this.traverse(builder, "", (SimpleNode)cc.args[0], true);
                                builder.append(").getChannel()");
                                return;
                            }
                            if (rw.equals("w")) {
                                builder.append("new RandomAccessFile(");
                                this.traverse(builder, "", (SimpleNode)cc.args[0], true);
                                builder.append(").getChannel()");
                                return;
                            }
                            if (!rw.equals("a")) {
                                // empty if block
                            }
                        }
                    }
                    break block34;
                }
                if (cc.func instanceof Attribute) {
                    exprType clas = ((Attribute)cc.func).value;
                    String method = ((Attribute)cc.func).attr;
                    if (clas instanceof Name) {
                        String n = ((Name)clas).id;
                        if (n.equals("struct")) {
                            if (method.equals("pack")) {
                                String type;
                                String format = ((Str)cc.args[0]).s;
                                boolean isBig = format.startsWith(">");
                                char typech = format.charAt(format.length() - 1);
                                switch (typech) {
                                    case 'h': {
                                        type = ".putShort(0,";
                                        break;
                                    }
                                    case 'i': 
                                    case 'l': {
                                        type = ".putInt(0,";
                                        break;
                                    }
                                    case 'q': {
                                        type = ".putLong(0,";
                                        break;
                                    }
                                    default: {
                                        type = ".put???(0,";
                                    }
                                }
                                int byteLen = 2;
                                String bba = String.format("ByteBuffer.allocate(%d)", byteLen);
                                builder.append(bba);
                                if (isBig) {
                                    builder.append(".order(ByteOrder.BIG_ENDIAN)");
                                }
                                builder.append(type);
                                this.traverse(builder, "", (SimpleNode)cc.args[1], true);
                                builder.append(")");
                                return;
                            }
                            if (method.equals("unpack")) {
                                String type;
                                String format = ((Str)cc.args[0]).s;
                                boolean isBig = format.startsWith(">");
                                char typech = format.charAt(format.length() - 1);
                                switch (typech) {
                                    case 'h': {
                                        type = ".getShort(0)";
                                        break;
                                    }
                                    case 'i': 
                                    case 'l': {
                                        type = ".getInt(0)";
                                        break;
                                    }
                                    case 'q': {
                                        type = ".getLong(0)";
                                        break;
                                    }
                                    default: {
                                        type = ".get???(0)";
                                    }
                                }
                                this.traverse(builder, "", (SimpleNode)cc.args[1], true);
                                if (isBig) {
                                    builder.append(".order(ByteOrder.BIG_ENDIAN)");
                                }
                                builder.append(type);
                                return;
                            }
                        } else {
                            String type = this.getTypeForName(((Name)clas).id);
                            if (type != null && type.equals("FileChannel")) {
                                if (method.equals("read")) {
                                    builder.append("readChannel(");
                                    this.traverse(builder, "", (SimpleNode)clas, true);
                                    builder.append(",");
                                    this.traverse(builder, "", (SimpleNode)cc.args[0], true);
                                    builder.append(")");
                                    return;
                                }
                                if (method.equals("seek")) {
                                    this.traverse(builder, "", (SimpleNode)clas, true);
                                    builder.append(".position(");
                                    this.traverse(builder, "", (SimpleNode)cc.args[0], true);
                                    builder.append(")");
                                    return;
                                }
                                if (method.equals("tell")) {
                                    this.traverse(builder, "", (SimpleNode)clas, true);
                                    builder.append(".position(");
                                    builder.append(")");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            this.traverse(builder, "", (SimpleNode)cc.func, true);
            builder.append("(");
            for (i = 0; i < cc.args.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                this.traverse(builder, "", (SimpleNode)cc.args[i], true);
            }
            builder.append(")");
            i = 0;
            while (i < cc.keywords.length) {
                builder.append(" //");
                this.handleKeywordType(builder, cc.keywords[i], true);
                ++i;
            }
            return;
        }

        private void handleKeywordType(StringBuilder builder, keywordType kw, boolean inline) {
            builder.append(kw.arg).append("=");
            try {
                this.traverse(builder, "", (SimpleNode)kw.value, true);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        private void handleBody(StringBuilder builder, stmtType[] body, String thisIndent) throws Exception {
            this.contexts.push(new Context());
            for (int i = 0; i < body.length; ++i) {
                this.traverse(builder, thisIndent, (SimpleNode)body[i], false);
            }
            this.contexts.pop();
        }

        private void handleFor(StringBuilder builder, For ff, String indent, boolean inline) throws Exception {
            String t;
            logger.log(Level.FINE, "handleFor at {0}", ff.beginLine);
            String typeOf = this.getJavaIterExprType(ff.iter);
            if (typeOf == TYPE_OBJECT && (t = this.guessType(ff.iter)) == TYPE_STRING_ARRAY) {
                typeOf = TYPE_STRING;
            }
            if (ff.target instanceof Name) {
                this.assertType(((Name)ff.target).id, typeOf);
            }
            if (ff.iter instanceof Call) {
                Call c = (Call)ff.iter;
                if (c.func instanceof Name) {
                    Name n = (Name)c.func;
                    if (n.id.equals("xrange")) {
                        builder.append("for ( ").append(typeOf).append(" ");
                        this.traverse(builder, "", (SimpleNode)ff.target, true);
                        if (c.args.length == 1) {
                            builder.append("=").append("0; ");
                            this.traverse(builder, "", (SimpleNode)ff.target, true);
                            builder.append("<");
                            this.traverse(builder, "", (SimpleNode)c.args[0], true);
                            builder.append("; ");
                            this.traverse(builder, "", (SimpleNode)ff.target, true);
                            builder.append("++ ) {\n");
                            this.handleBody(builder, ff.body, spaces4 + indent);
                            builder.append(indent).append("}\n");
                            return;
                        }
                        if (c.args.length == 2) {
                            builder.append("=");
                            this.traverse(builder, "", (SimpleNode)c.args[0], true);
                            builder.append("; ");
                            this.traverse(builder, "", (SimpleNode)ff.target, true);
                            builder.append("<");
                            this.traverse(builder, "", (SimpleNode)c.args[1], true);
                            builder.append("; ");
                            this.traverse(builder, "", (SimpleNode)ff.target, true);
                            builder.append("++ ) {\n");
                            this.handleBody(builder, ff.body, spaces4 + indent);
                            builder.append(indent).append("}\n");
                            return;
                        }
                    }
                }
            }
            builder.append("for ( ").append(typeOf).append(" ");
            this.traverse(builder, "", (SimpleNode)ff.target, true);
            builder.append(" : ");
            this.traverse(builder, "", (SimpleNode)ff.iter, true);
            builder.append(" ) {\n");
            ++this.lineNumber;
            this.handleBody(builder, ff.body, spaces4 + indent);
            builder.append(indent).append("}\n");
            ++this.lineNumber;
        }

        private void handleWhile(StringBuilder builder, While ff, String indent, boolean inline) throws Exception {
            builder.append("while ( ");
            this.traverse(builder, "", (SimpleNode)ff.test, true);
            builder.append(" ) {\n");
            ++this.lineNumber;
            this.handleBody(builder, ff.body, spaces4 + indent);
            builder.append(indent).append("}\n");
            ++this.lineNumber;
        }

        private void handleIf(StringBuilder builder, If ff, String indent, boolean inline) throws Exception {
            builder.append("if ( ");
            this.traverse(builder, "", (SimpleNode)ff.test, true);
            builder.append(" ) {\n");
            ++this.lineNumber;
            this.handleBody(builder, ff.body, spaces4 + indent);
            if (ff.orelse == null) {
                builder.append(indent).append("}");
            } else {
                ++this.lineNumber;
                if (ff.orelse.length == 1 && ff.orelse[0] instanceof If) {
                    builder.append(indent).append("} else ");
                    this.handleBody(builder, ff.orelse, indent);
                } else {
                    builder.append(indent).append("} else {\n");
                    this.handleBody(builder, ff.orelse, spaces4 + indent);
                    builder.append(indent).append("}");
                }
            }
        }

        private void handleSubscript(StringBuilder builder, Subscript s, String indent, boolean inline) throws Exception {
            logger.log(Level.FINE, "Subscript at line {0}", s.beginLine);
            if (this.guessType(s.value).equals(TYPE_MAP)) {
                this.traverse(builder, "", (SimpleNode)s.value, true);
                builder.append(".get(");
                this.traverse(builder, "", (SimpleNode)s.slice, true);
                builder.append(")");
            } else {
                sliceType st;
                String n;
                this.traverse(builder, "", (SimpleNode)s.value, true);
                String t = s.value instanceof Subscript ? this.guessType(((Subscript)s.value).value) : this.guessType(s.value);
                if (t.equals("Object") && s.value instanceof Name && (t = this.getTypeForName(n = ((Name)s.value).id)) == null) {
                    t = "Object";
                }
                if ((st = s.slice) instanceof Slice) {
                    Slice slice = (Slice)st;
                    if (t.equals(TYPE_STRING)) {
                        builder.append(".substring(");
                        this.traverse(builder, "", (SimpleNode)slice.lower, true);
                        if (slice.step != null) {
                            builder.append("[ERR slice.step!=null]");
                        }
                        if (slice.upper != null) {
                            builder.append(",");
                            this.traverse(builder, "", (SimpleNode)slice.upper, true);
                        }
                        builder.append(")");
                    } else {
                        this.traverse(builder, "", (SimpleNode)slice, true);
                    }
                } else if (st instanceof Index) {
                    builder.append("[");
                    this.traverse(builder, "", (SimpleNode)((Index)st).value, true);
                    builder.append("]");
                } else {
                    builder.append("[");
                    this.traverse(builder, "", (SimpleNode)st, true);
                    builder.append("]");
                }
            }
        }

        private void inferDictionaries(stmtType[] body) {
            for (stmtType t : body) {
                if (!(t instanceof Assign)) continue;
                Assign a = (Assign)t;
                if (a.targets.length != 1 || !(a.targets[0] instanceof Subscript)) continue;
                Subscript s = (Subscript)a.targets[0];
                if (!(s.slice instanceof Index)) continue;
                Index index = (Index)s.slice;
                if (!(index.value instanceof Str) || !(s.value instanceof Name)) continue;
                this.assertType(((Name)s.value).id, "Map");
            }
        }

        static {
            ops.put(1, "+");
            ops.put(2, "-");
            ops.put(3, "*");
            ops.put(4, "/");
            ops.put(5, "%");
            ops.put(9, "|");
            ops.put(10, "^");
            ops.put(11, "&");
            ops.put(12, "/floordiv/");
        }
    }

    private static class Context {
        Map<String, String> names = new HashMap<String, String>();

        private Context() {
        }
    }
}

