/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.autoplot.datasource.ui.PromptTextArea;
import org.autoplot.datasource.ui.PromptTextField;
import org.autoplot.jythonsupport.JythonUtil;

public class ScriptDocumentationPanel
extends JPanel {
    private PromptTextArea descriptionTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private PromptTextField labelTextField;
    private PromptTextField titleTextField;

    public ScriptDocumentationPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.titleTextField = new PromptTextField();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionTextField = new PromptTextArea();
        this.jLabel1 = new JLabel();
        this.labelTextField = new PromptTextField();
        this.jLabel2 = new JLabel();
        this.titleTextField.setText("promptTextField2");
        this.titleTextField.setFont(this.titleTextField.getFont().deriveFont(this.titleTextField.getFont().getStyle() | 1, this.titleTextField.getFont().getSize() + 2));
        this.titleTextField.setPromptText("script title");
        this.descriptionTextField.setColumns(20);
        this.descriptionTextField.setRows(5);
        this.descriptionTextField.setPromptText("script description");
        this.jScrollPane1.setViewportView((Component)this.descriptionTextField);
        this.jLabel1.setText("Label to use when adding to menu:");
        this.labelTextField.setText("promptTextField3");
        this.labelTextField.setPromptText("script label");
        this.jLabel2.setText("<html>Autoplot scripts have several functions they can call to set the title and description of the script.  These are used for branding and instructions, and set the label used when the script is added to a menu.");
        this.jLabel2.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.titleTextField, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.labelTextField, -2, 286, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.titleTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.labelTextField, -2, -1, -2)).addContainerGap(89, Short.MAX_VALUE)));
    }

    public void initialize(String src) {
        try {
            JythonUtil.ScriptDescriptor sd = JythonUtil.describeScript(src, new HashMap<String, String>());
            this.titleTextField.setText(sd.getTitle());
            this.descriptionTextField.setText(sd.getDescription());
            this.labelTextField.setText(sd.getLabel());
        }
        catch (IOException ex) {
            Logger.getLogger(ScriptDocumentationPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String implement(String text) {
        StringBuilder b = new StringBuilder();
        String[] ss = text.split("\n");
        boolean handledTitle = this.titleTextField.getText().trim().length() == 0;
        boolean handledLabel = this.labelTextField.getText().trim().length() == 0;
        boolean handledDescription = this.descriptionTextField.getText().trim().length() == 0;
        String ignoreUntilTriple = null;
        for (String s : ss) {
            if (ignoreUntilTriple != null) {
                if (!s.contains(ignoreUntilTriple)) continue;
                ignoreUntilTriple = null;
                continue;
            }
            if (s.startsWith("setScriptTitle")) {
                if (this.titleTextField.getText().trim().length() <= 0) continue;
                b.append("setScriptTitle('").append(this.titleTextField.getText()).append("')\n");
                handledTitle = true;
                continue;
            }
            if (s.startsWith("setScriptLabel")) {
                if (this.labelTextField.getText().trim().length() <= 0) continue;
                b.append("setScriptLabel('").append(this.labelTextField.getText()).append("')\n");
                handledLabel = true;
                continue;
            }
            if (s.startsWith("setScriptDescription")) {
                if (this.descriptionTextField.getText().trim().length() > 0) {
                    b.append("setScriptDescription('''").append(this.descriptionTextField.getText()).append("''')\n");
                    handledDescription = true;
                }
                if (s.charAt(21) == '\'' && s.charAt(22) == '\'') {
                    ignoreUntilTriple = "'''";
                } else if (s.charAt(21) == '\"' && s.charAt(22) == '\"') {
                    ignoreUntilTriple = "\"\"\"";
                }
                if (s.indexOf(ignoreUntilTriple, 24) <= -1) continue;
                ignoreUntilTriple = null;
                continue;
            }
            b.append(s).append("\n");
        }
        text = b.toString();
        b = new StringBuilder();
        if (!handledTitle) {
            b.append("setScriptTitle('").append(this.titleTextField.getText()).append("')\n");
        }
        if (!handledLabel) {
            b.append("setScriptLabel('").append(this.labelTextField.getText()).append("')\n");
        }
        if (!handledDescription) {
            b.append("setScriptDescription('''").append(this.descriptionTextField.getText()).append("''')\n");
        }
        b.append(text);
        return b.toString();
    }
}

