/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.Util;

public class GetParamTool
extends JPanel {
    private JPanel allowedValuesPanel;
    private JRadioButton allowedValuesRB;
    private ButtonGroup buttonGroup1;
    private JPanel constraintsPanel;
    private JTextField defaultValueTextField;
    private JTextField descriptionTextField;
    private JCheckBox examplesCheckBox;
    private JTextField examplesTextField;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JCheckBox maxCheckBox;
    private JTextField maxTextField;
    private JCheckBox minCheckBox;
    private JTextField minTextField;
    private JRadioButton moreButton;
    private JPanel moreConstraintsPanel;
    private JRadioButton noneRadioButton;
    private JTextField parameterNameTextField;
    private JCheckBox regexCheckBox;
    private JTextField regexTextField;
    private JCheckBox valuesCheckBox;
    private JTextField valuesTextField;
    private JTextField valuesTextFieldNotMoreTF;

    public GetParamTool() {
        this.initComponents();
        this.constraintsPanel.setLayout(new BorderLayout());
    }

    private String maybeAddQuotes(String s) {
        if (!s.startsWith("'")) {
            if (!s.endsWith("'")) {
                return "'" + s + "'";
            }
            return "'" + s;
        }
        if (s.endsWith("'")) {
            return "'" + s;
        }
        return s;
    }

    private String maybeRemoveQuotes(String s) {
        if (s.startsWith("'") || s.startsWith("\"")) {
            if (s.endsWith("'") || s.endsWith("\"")) {
                return s.substring(1, s.length() - 1);
            }
            return s.substring(1);
        }
        if (s.endsWith("'") || s.endsWith("\"")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder("getParam(");
        sb.append(this.parameterNameTextField.getText());
        sb.append(",");
        sb.append(this.defaultValueTextField.getText());
        if (this.noneRadioButton.isSelected()) {
            String descript = this.descriptionTextField.getText().trim();
            if (descript.length() > 0) {
                sb.append(",");
                sb.append(this.maybeAddQuotes(descript));
            }
        } else {
            String descript = this.descriptionTextField.getText().trim();
            sb.append(",");
            sb.append(this.maybeAddQuotes(descript));
            sb.append(",");
            if (this.moreButton.isSelected()) {
                StringBuilder constraints = new StringBuilder("{");
                if (this.minCheckBox.isSelected()) {
                    constraints.append("\"min\":");
                    constraints.append(this.minTextField.getText());
                    constraints.append(",");
                }
                if (this.maxCheckBox.isSelected()) {
                    constraints.append("\"max\":");
                    constraints.append(this.maxTextField.getText());
                    constraints.append(",");
                }
                if (this.examplesCheckBox.isSelected()) {
                    constraints.append("\"examples\":[");
                    constraints.append(this.examplesTextField.getText());
                    constraints.append("],");
                }
                if (this.valuesCheckBox.isSelected()) {
                    constraints.append("\"values\":[");
                    constraints.append(this.valuesTextField.getText());
                    constraints.append("],");
                }
                if (this.regexCheckBox.isSelected()) {
                    constraints.append("\"regex\":");
                    constraints.append(this.maybeAddQuotes(this.regexTextField.getText()));
                    constraints.append(",");
                }
                sb.append(constraints.substring(0, constraints.length() - 1));
                sb.append("}");
            } else {
                sb.append("[").append(this.valuesTextFieldNotMoreTF.getText()).append("]");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public Object valueOf(Map<String, Object> s, String p, String deft) {
        Object o = s.get(p);
        if (o == null) {
            return deft;
        }
        return o;
    }

    public void setValue(String getParamCall) {
        String s = getParamCall;
        if (s.startsWith("getParam(")) {
            s = s.substring(9);
        }
        if (s.endsWith(")")) {
            s = s.substring(0, s.length() - 1);
        }
        String[] ss = Util.guardedSplit(s, ',', '\'', '\"');
        this.parameterNameTextField.setText(this.maybeRemoveQuotes(ss[0]));
        this.defaultValueTextField.setText(this.maybeRemoveQuotes(ss[1]));
        if (ss.length > 2) {
            this.descriptionTextField.setText(this.maybeRemoveQuotes(ss[2]));
        }
        if (ss.length > 3) {
            String s4 = String.join((CharSequence)",", Arrays.copyOfRange(ss, 3, ss.length)).trim();
            if (s4.startsWith("[")) {
                this.allowedValuesRB.setSelected(true);
                this.valuesTextFieldNotMoreTF.setText(s4.substring(1, s4.length() - 2));
            } else {
                this.moreButton.setSelected(true);
                List<Param> pp = JythonUtil.getGetParams(s);
                Param p = pp.get(0);
                Map<String, Object> constraints = p.constraints;
                this.minTextField.setText((String)constraints.get("min"));
                this.maxTextField.setText((String)constraints.get("max"));
                this.valuesTextField.setText(String.valueOf(constraints.get("values")));
                this.examplesTextField.setText(String.valueOf(constraints.get("examples")));
                this.regexTextField.setText((String)this.valueOf(constraints, "regex", ""));
            }
        }
    }

    public static void main(String[] args) {
        GetParamTool o = new GetParamTool();
        o.setValue("getParam(\"aaa\",10,\"This comma, filled string\", [10,20 ])");
        o.updateConstraints();
        JOptionPane.showMessageDialog(null, o);
        System.err.println(o.getValue());
    }

    private void updateConstraints() {
        this.constraintsPanel.removeAll();
        if (this.allowedValuesRB.isSelected()) {
            this.constraintsPanel.add((Component)this.allowedValuesPanel, "Center");
        } else if (this.moreButton.isSelected()) {
            this.constraintsPanel.add((Component)this.moreConstraintsPanel, "Center");
        }
        this.constraintsPanel.revalidate();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.moreConstraintsPanel = new JPanel();
        this.minCheckBox = new JCheckBox();
        this.maxCheckBox = new JCheckBox();
        this.minTextField = new JTextField();
        this.maxTextField = new JTextField();
        this.examplesCheckBox = new JCheckBox();
        this.examplesTextField = new JTextField();
        this.valuesCheckBox = new JCheckBox();
        this.valuesTextField = new JTextField();
        this.regexCheckBox = new JCheckBox();
        this.regexTextField = new JTextField();
        this.allowedValuesPanel = new JPanel();
        this.valuesTextFieldNotMoreTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.parameterNameTextField = new JTextField();
        this.defaultValueTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.allowedValuesRB = new JRadioButton();
        this.moreButton = new JRadioButton();
        this.constraintsPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.noneRadioButton = new JRadioButton();
        this.minCheckBox.setText("Min:");
        this.minCheckBox.setToolTipText("Minimum allowed value");
        this.maxCheckBox.setText("Max:");
        this.maxCheckBox.setToolTipText("Maximum allowed value");
        this.minTextField.setText("0");
        this.maxTextField.setText("100");
        this.examplesCheckBox.setText("Examples, where any of these are valid example values.");
        this.examplesCheckBox.setToolTipText("Example values, typically shown in droplist along with a field where any value can be entered.");
        this.examplesTextField.setText("jTextField6");
        this.valuesCheckBox.setText("Values, the script can only accept these values.");
        this.valuesCheckBox.setToolTipText("Enumeration of allowed values");
        this.valuesTextField.setText("jTextField7");
        this.regexCheckBox.setText("Regex:");
        this.regexTextField.setText("jTextField8");
        GroupLayout moreConstraintsPanelLayout = new GroupLayout(this.moreConstraintsPanel);
        this.moreConstraintsPanel.setLayout(moreConstraintsPanelLayout);
        moreConstraintsPanelLayout.setHorizontalGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addContainerGap().addGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuesTextField).addComponent(this.examplesTextField))).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addComponent(this.minCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.minTextField, -2, 115, -2).addGap(305, 305, 305)).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addComponent(this.maxCheckBox).addGap(27, 27, 27).addComponent(this.maxTextField).addGap(221, 221, 221)).addComponent(this.examplesCheckBox).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addComponent(this.regexCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regexTextField, -2, 255, -2)).addComponent(this.valuesCheckBox)).addContainerGap(84, Short.MAX_VALUE)));
        moreConstraintsPanelLayout.setVerticalGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moreConstraintsPanelLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minTextField, -2, 19, -2).addComponent(this.minCheckBox)).addGap(2, 2, 2).addGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxCheckBox).addComponent(this.maxTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.examplesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.examplesTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valuesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valuesTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(moreConstraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regexCheckBox).addComponent(this.regexTextField, -2, -1, -2)).addGap(0, 119, Short.MAX_VALUE)));
        this.valuesTextFieldNotMoreTF.setToolTipText("Enter a list of comma-separated values");
        this.valuesTextFieldNotMoreTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetParamTool.this.valuesTextFieldNotMoreTFActionPerformed(evt);
            }
        });
        GroupLayout allowedValuesPanelLayout = new GroupLayout(this.allowedValuesPanel);
        this.allowedValuesPanel.setLayout(allowedValuesPanelLayout);
        allowedValuesPanelLayout.setHorizontalGroup(allowedValuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allowedValuesPanelLayout.createSequentialGroup().addComponent(this.valuesTextFieldNotMoreTF, -2, 436, -2).addGap(0, 0, Short.MAX_VALUE)));
        allowedValuesPanelLayout.setVerticalGroup(allowedValuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(allowedValuesPanelLayout.createSequentialGroup().addComponent(this.valuesTextFieldNotMoreTF, -2, -1, -2).addGap(0, 81, Short.MAX_VALUE)));
        this.jLabel1.setText("Default Value:");
        this.jLabel2.setText("Parameter Name:");
        this.parameterNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetParamTool.this.parameterNameTextFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Description:");
        this.descriptionTextField.setText(" ");
        this.jLabel4.setText("Constraints:");
        this.buttonGroup1.add(this.allowedValuesRB);
        this.allowedValuesRB.setText("Allowed Values");
        this.allowedValuesRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetParamTool.this.allowedValuesRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.moreButton);
        this.moreButton.setText("More...");
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetParamTool.this.moreButtonActionPerformed(evt);
            }
        });
        GroupLayout constraintsPanelLayout = new GroupLayout(this.constraintsPanel);
        this.constraintsPanel.setLayout(constraintsPanelLayout);
        constraintsPanelLayout.setHorizontalGroup(constraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        constraintsPanelLayout.setVerticalGroup(constraintsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 285, Short.MAX_VALUE));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "Integer", "Real", "Boolean", " ", " "}));
        this.buttonGroup1.add(this.noneRadioButton);
        this.noneRadioButton.setSelected(true);
        this.noneRadioButton.setText("None");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(14, 14, 14).addComponent(this.noneRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allowedValuesRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreButton).addGap(0, 76, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parameterNameTextField, -2, 81, -2)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultValueTextField, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTextField).addComponent(this.constraintsPanel, -1, -1, Short.MAX_VALUE))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.parameterNameTextField, -2, -1, -2)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.defaultValueTextField, -2, -1, -2).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.allowedValuesRB).addComponent(this.moreButton).addComponent(this.noneRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.constraintsPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void allowedValuesRBActionPerformed(ActionEvent evt) {
        this.updateConstraints();
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        this.updateConstraints();
    }

    private void parameterNameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void valuesTextFieldNotMoreTFActionPerformed(ActionEvent evt) {
    }
}

