/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.HtmlUtil;

public final class JLinkyLabel
extends JLabel {
    private final Logger logger = LoggerManager.getLogger((String)"jython.editor");
    URI uri;

    public JLinkyLabel(URL context, String label) {
        super(label);
        List uu = HtmlUtil.getLinks((URL)context, (String)label);
        if (!uu.isEmpty()) {
            try {
                this.uri = ((URL)uu.get(0)).toURI();
            }
            catch (URISyntaxException ex) {
                this.logger.log(Level.INFO, "Unable to use URL: {0}", uu.get(0));
                this.uri = null;
            }
        } else if (uu.size() > 1) {
            this.uri = null;
        }
        this.addMouseListener(this.myMouseListener());
    }

    private MouseListener myMouseListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JLinkyLabel.this.uri != null) {
                    try {
                        Desktop.getDesktop().browse(JLinkyLabel.this.uri);
                    }
                    catch (IOException ex) {
                        JLinkyLabel.this.logger.log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (JLinkyLabel.this.uri != null) {
                    JLinkyLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                    JLinkyLabel.this.setToolTipText(JLinkyLabel.this.uri.toString());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JLinkyLabel.this.uri != null) {
                    JLinkyLabel.this.setCursor(Cursor.getPredefinedCursor(0));
                    JLinkyLabel.this.setToolTipText(null);
                }
            }
        };
    }
}

