/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.awt.Graphics2D;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.das2.datum.LoggerManager;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.Utilities;
import org.python.parser.CharStream;
import org.python.parser.PythonGrammar;
import org.python.parser.ReaderCharStream;
import org.python.parser.Token;
import org.python.parser.TokenMgrError;

public class CompletionSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.editor.completion");
    private static Map<Integer, String> grammarConstantLookup;

    private CompletionSupport() {
    }

    private static String join(List<Token> tokens, int offset, int end) {
        StringBuilder result = new StringBuilder(tokens.get((int)offset).image);
        for (int i = 1; i < end - offset; ++i) {
            result.append(tokens.get((int)(offset + i)).image);
        }
        return result.toString();
    }

    private static boolean isContinuation(String possible, String tail) {
        int ipos2;
        int ipos1;
        if (possible.trim().endsWith("\\")) {
            return true;
        }
        for (ipos1 = 0; ipos1 < possible.length() && Character.isWhitespace(possible.charAt(ipos1)); ++ipos1) {
        }
        if (possible.trim().length() == 0) {
            return false;
        }
        for (ipos2 = 0; ipos2 < tail.length() && Character.isWhitespace(tail.charAt(ipos2)); ++ipos2) {
        }
        return ipos1 < ipos2;
    }

    public static CompletionContext checkJavaSubClass(JTextComponent editor) throws BadLocationException {
        int pos = editor.getCaretPosition();
        int i0 = Utilities.getRowStart(editor, pos);
        String line = editor.getText(i0, pos - i0);
        Pattern p = Pattern.compile("\\s*(g)\\.([a-zA-Z]*)");
        Matcher m = p.matcher(line);
        if (m.matches()) {
            CompletionContext result = new CompletionContext("classMethod", m.group(1), m.group(2));
            result.setContextObjectClass(Graphics2D.class);
            return result;
        }
        return null;
    }

    public static CompletionContext getCompletionContext(JTextComponent editor) throws BadLocationException {
        int im1;
        String prevLine;
        int pos = editor.getCaretPosition();
        int i0 = Utilities.getRowStart(editor, pos);
        int i2 = Utilities.getRowEnd(editor, pos);
        String line = editor.getText(i0, i2 - i0 - 1);
        int i1 = i0;
        if (i1 == i2) {
            return new CompletionContext("default", null, "");
        }
        CompletionContext result = CompletionSupport.checkJavaSubClass(editor);
        if (result != null) {
            return result;
        }
        if (i0 > 0 && CompletionSupport.isContinuation(prevLine = editor.getText(im1 = Utilities.getRowStart(editor, i0 - 1), i0 - im1 - 1), line)) {
            logger.finer("carot line is continuation, joining with previous line.");
            do {
                im1 = Utilities.getRowStart(editor, i0 - 1);
                String prevLine1 = prevLine.trim();
                if (prevLine1.endsWith("\\")) {
                    prevLine1 = prevLine1.substring(0, prevLine1.length() - 1);
                }
                line = prevLine1 + " " + line;
                pos -= prevLine.length() - prevLine1.length();
                int lastLineStart = Utilities.getRowStart(editor, im1 - 1);
                prevLine = editor.getText(lastLineStart, im1 - lastLineStart);
                if (!CompletionSupport.isContinuation(prevLine, line)) continue;
                i0 = im1;
            } while (CompletionSupport.isContinuation(prevLine, line));
            i0 = im1;
        }
        i2 = pos -= i0;
        i1 -= i0;
        i0 = 0;
        result = CompletionSupport.getCompletionContext(line, pos, i0, i1, i2);
        logger.log(Level.FINE, "CompletionContext: {0}", result);
        return result;
    }

    private static String preProcess(String line, int pos) {
        boolean inQuote;
        char squote = '\'';
        String[] ss = line.substring(0, pos).split("'", -2);
        boolean bl = inQuote = ss.length % 2 == 0;
        if (inQuote) {
            int i = line.indexOf(squote, pos);
            if (i == -1) {
                return line.substring(0, pos) + squote;
            }
            return line.substring(0, i + 1);
        }
        squote = '\"';
        ss = line.substring(0, pos).split("\"", -2);
        boolean bl2 = inQuote = ss.length % 2 == 0;
        if (inQuote) {
            int i = line.indexOf(squote, pos);
            if (i == -1) {
                return line.substring(0, pos) + squote;
            }
            return line.substring(0, i + 1);
        }
        return line.substring(0, pos);
    }

    private static String exprBeforeDot(List<Token> tokens, int pos) {
        boolean notdone;
        String contextString = tokens.get((int)(pos - 1)).image;
        int i = pos - 1;
        if (i > 1 && (tokens.get((int)(pos - 1)).kind == 19 || tokens.get((int)(pos - 1)).kind == 23)) {
            int rparCount = tokens.get((int)(pos - 1)).kind == 19 ? 1 : 0;
            int rbackCount = tokens.get((int)(pos - 1)).kind == 23 ? 1 : 0;
            for (int lpar = i - 1; lpar > 0 && (rparCount > 0 || rbackCount > 0); --lpar) {
                contextString = tokens.get((int)lpar).image + contextString;
                switch (tokens.get((int)lpar).kind) {
                    case 18: {
                        --rparCount;
                        break;
                    }
                    case 19: {
                        ++rparCount;
                        break;
                    }
                    case 22: {
                        --rbackCount;
                        break;
                    }
                    case 23: {
                        ++rbackCount;
                        break;
                    }
                }
                if (rparCount != 0 || lpar <= 0 || tokens.get((int)(lpar - 1)).kind != 91) continue;
                contextString = tokens.get((int)(lpar - 1)).image + contextString;
                if (lpar > 1 && tokens.get((int)(lpar - 2)).kind == 26) {
                    String before = CompletionSupport.exprBeforeDot(tokens, lpar - 2);
                    return before + "." + contextString;
                }
                return contextString;
            }
        }
        boolean bl = notdone = i > 1 && tokens.get((int)(i - 1)).kind == 26;
        while (notdone) {
            if (tokens.get((int)(i - 2)).kind == 23 && i >= 5 && tokens.get((int)(i - 4)).kind == 22 && tokens.get((int)(i - 5)).kind == 91) {
                contextString = tokens.get((int)(i - 5)).image + tokens.get((int)(i - 4)).image + tokens.get((int)(i - 3)).image + tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 5;
            } else if (tokens.get((int)(i - 2)).kind == 19 && i >= 4 && tokens.get((int)(i - 3)).kind == 18) {
                contextString = tokens.get((int)(i - 4)).image + tokens.get((int)(i - 3)).image + tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 4;
            } else if (tokens.get((int)(i - 2)).kind == 19 && i >= 5 && tokens.get((int)(i - 4)).kind == 18 && tokens.get((int)(i - 5)).kind == 91) {
                contextString = tokens.get((int)(i - 5)).image + tokens.get((int)(i - 4)).image + tokens.get((int)(i - 3)).image + tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 5;
            } else {
                contextString = tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 2;
            }
            notdone = i > 1 && tokens.get((int)(i - 1)).kind == 26;
        }
        return contextString;
    }

    public static CompletionContext getCompletionContext(String line, int pos, int i0, int i1, int i2) {
        Token t;
        ArrayList<Token> tokens = new ArrayList<Token>(20);
        int myTokenIndex = -1;
        int thisTokenIndex = -1;
        int lastTokenEndPos = -1;
        String completable = null;
        line = CompletionSupport.preProcess(line, pos);
        PythonGrammar g = new PythonGrammar((CharStream)new ReaderCharStream((Reader)new StringReader(line)));
        do {
            try {
                t = g.getNextToken();
            }
            catch (TokenMgrError ex) {
                return new CompletionContext("default", null, "");
            }
            ++thisTokenIndex;
            tokens.add(t);
            if (myTokenIndex == -1 && pos <= t.endColumn) {
                myTokenIndex = thisTokenIndex;
                completable = pos >= t.beginColumn && t.image.length() >= pos + 1 - t.beginColumn ? t.image.substring(0, pos + 1 - t.beginColumn) : "";
            }
            lastTokenEndPos = t.endColumn;
        } while (t.kind != 0 && t.kind != 6);
        if (myTokenIndex == -1 && pos >= lastTokenEndPos) {
            myTokenIndex = thisTokenIndex;
            completable = "";
        }
        CompletionContext result = null;
        logger.log(Level.FINE, "completions finds {0} tokens in {1}", new Object[]{tokens.size(), line});
        if (logger.isLoggable(Level.FINER)) {
            int i = 0;
            for (Token t1 : tokens) {
                logger.log(Level.FINER, "{0}:\t{1}\t{2}", new Object[]{i++, t1.toString(), grammarConstantLookup.get(t1.kind)});
            }
        }
        if (tokens.isEmpty()) {
            return new CompletionContext("default", null, "");
        }
        if (((Token)tokens.get((int)0)).kind == 84) {
            int importTokenIndex = -1;
            for (int i = 1; importTokenIndex == -1 && i < tokens.size(); ++i) {
                if (((Token)tokens.get((int)i)).kind != 83) continue;
                importTokenIndex = i;
            }
            if (importTokenIndex != -1 && myTokenIndex > importTokenIndex) {
                result = new CompletionContext("module", CompletionSupport.join(tokens, 1, importTokenIndex), completable);
            } else if (myTokenIndex < importTokenIndex || importTokenIndex == -1) {
                int ti = myTokenIndex;
                if (ti > 0 && ((Token)tokens.get((int)(ti - 1))).kind == 26) {
                    --ti;
                }
                if (((Token)tokens.get((int)myTokenIndex)).kind == 26) {
                    completable = "";
                }
                result = new CompletionContext("package", CompletionSupport.join(tokens, 1, ti), completable);
            }
        } else if (((Token)tokens.get((int)0)).kind == 83) {
            if (completable == null || completable.equals(".")) {
                completable = "";
            }
            if (myTokenIndex > 0 && ((Token)tokens.get((int)(myTokenIndex - 1))).image.equals(".")) {
                --myTokenIndex;
            }
            result = new CompletionContext("package", CompletionSupport.join(tokens, 1, myTokenIndex), completable);
        } else {
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 91) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 19) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 23) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (myTokenIndex > 2 && ((Token)tokens.get((int)myTokenIndex)).kind == 91 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 23) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, completable);
            }
            if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 91) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, completable);
            }
            if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 19) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, ((Token)tokens.get((int)myTokenIndex)).image);
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 108 || ((Token)tokens.get((int)myTokenIndex)).kind == 109) {
                if (myTokenIndex > 3 && ((Token)tokens.get((int)(myTokenIndex - 4))).kind == 91 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 91 && ((Token)tokens.get((int)(myTokenIndex - 3))).kind != 41) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 4))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 91) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 2))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 77) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 2))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 108 && ((Token)tokens.get((int)(myTokenIndex - 2))).image.equals("'resourceURI'")) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 2))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 108 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 28 && ((Token)tokens.get((int)(myTokenIndex - 0))).kind == 108) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 2))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                return null;
            }
            int closeParenCount = 0;
            for (int i = myTokenIndex; i > 0; --i) {
                if (((Token)tokens.get((int)i)).kind == 19) {
                    ++closeParenCount;
                    continue;
                }
                if (((Token)tokens.get((int)i)).kind != 18 || --closeParenCount >= 0 || ((Token)tokens.get((int)(i - 1))).kind != 91) continue;
                String contextString = ((Token)tokens.get((int)(i - 1))).image;
                return new CompletionContext("commandArgument", contextString, ((Token)tokens.get((int)myTokenIndex)).image);
            }
            if (((Token)tokens.get((int)0)).kind == 91) {
                if (tokens.size() == 3) {
                    return new CompletionContext("default", null, "");
                }
                return new CompletionContext("default", null, completable);
            }
        }
        if (result == null) {
            return new CompletionContext("default", null, completable);
        }
        return result;
    }

    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("EOF", 0);
        m.put("SPACE", 1);
        m.put("CONTINUATION", 4);
        m.put("NEWLINE1", 5);
        m.put("NEWLINE", 6);
        m.put("NEWLINE2", 7);
        m.put("CRLF1", 12);
        m.put("DEDENT", 14);
        m.put("INDENT", 15);
        m.put("TRAILING_COMMENT", 16);
        m.put("SINGLE_LINE_COMMENT", 17);
        m.put("LPAREN", 18);
        m.put("RPAREN", 19);
        m.put("LBRACE", 20);
        m.put("RBRACE", 21);
        m.put("LBRACKET", 22);
        m.put("RBRACKET", 23);
        m.put("SEMICOLON", 24);
        m.put("COMMA", 25);
        m.put("DOT", 26);
        m.put("COLON", 27);
        m.put("PLUS", 28);
        m.put("MINUS", 29);
        m.put("MULTIPLY", 30);
        m.put("DIVIDE", 31);
        m.put("FLOORDIVIDE", 32);
        m.put("POWER", 33);
        m.put("LSHIFT", 34);
        m.put("RSHIFT", 35);
        m.put("MODULO", 36);
        m.put("NOT", 37);
        m.put("XOR", 38);
        m.put("OR", 39);
        m.put("AND", 40);
        m.put("EQUAL", 41);
        m.put("GREATER", 42);
        m.put("LESS", 43);
        m.put("EQEQUAL", 44);
        m.put("EQLESS", 45);
        m.put("EQGREATER", 46);
        m.put("LESSGREATER", 47);
        m.put("NOTEQUAL", 48);
        m.put("PLUSEQ", 49);
        m.put("MINUSEQ", 50);
        m.put("MULTIPLYEQ", 51);
        m.put("DIVIDEEQ", 52);
        m.put("FLOORDIVIDEEQ", 53);
        m.put("MODULOEQ", 54);
        m.put("ANDEQ", 55);
        m.put("OREQ", 56);
        m.put("XOREQ", 57);
        m.put("LSHIFTEQ", 58);
        m.put("RSHIFTEQ", 59);
        m.put("POWEREQ", 60);
        m.put("OR_BOOL", 61);
        m.put("AND_BOOL", 62);
        m.put("NOT_BOOL", 63);
        m.put("IS", 64);
        m.put("IN", 65);
        m.put("LAMBDA", 66);
        m.put("IF", 67);
        m.put("ELSE", 68);
        m.put("ELIF", 69);
        m.put("WHILE", 70);
        m.put("FOR", 71);
        m.put("TRY", 72);
        m.put("EXCEPT", 73);
        m.put("DEF", 74);
        m.put("CLASS", 75);
        m.put("FINALLY", 76);
        m.put("PRINT", 77);
        m.put("PASS", 78);
        m.put("BREAK", 79);
        m.put("CONTINUE", 80);
        m.put("RETURN", 81);
        m.put("YIELD", 82);
        m.put("IMPORT", 83);
        m.put("FROM", 84);
        m.put("DEL", 85);
        m.put("RAISE", 86);
        m.put("GLOBAL", 87);
        m.put("EXEC", 88);
        m.put("ASSERT", 89);
        m.put("AS", 90);
        m.put("NAME", 91);
        m.put("LETTER", 92);
        m.put("DECNUMBER", 93);
        m.put("HEXNUMBER", 94);
        m.put("OCTNUMBER", 95);
        m.put("FLOAT", 96);
        m.put("COMPLEX", 97);
        m.put("EXPONENT", 98);
        m.put("DIGIT", 99);
        m.put("SINGLE_STRING", 108);
        m.put("SINGLE_STRING2", 109);
        m.put("TRIPLE_STRING", 110);
        m.put("TRIPLE_STRING2", 111);
        m.put("SINGLE_USTRING", 112);
        m.put("SINGLE_USTRING2", 113);
        m.put("TRIPLE_USTRING", 114);
        m.put("TRIPLE_USTRING2", 115);
        HashMap<Integer, String> fmap = new HashMap<Integer, String>();
        for (Map.Entry e : m.entrySet()) {
            fmap.put((Integer)e.getValue(), (String)e.getKey());
        }
        grammarConstantLookup = fmap;
    }
}

