/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.autoplot.datasource.DataSetURI;
import org.das2.jythoncompletion.support.CompletionItem;
import org.das2.jythoncompletion.support.CompletionTask;

public class DataSetUrlCompletionItem
implements CompletionItem {
    private static final Logger logger = Logger.getLogger("jython.editor");
    DataSetURI.CompletionResult rs;

    DataSetUrlCompletionItem(DataSetURI.CompletionResult rs) {
        this.rs = rs;
    }

    @Override
    public CompletionTask createDocumentationTask() {
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        return null;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        try {
            logger.fine("defaultAction of DataSetUrlCompletionItem");
            int pos = jTextComponent.getCaretPosition();
            Document d = jTextComponent.getDocument();
            if (this.rs.completion.startsWith(this.rs.completable)) {
                String txt = d.getText(pos, d.getLength() - pos);
                int ii = txt.indexOf("'");
                int jj = txt.indexOf("\n");
                if (ii > -1 && ii < jj) {
                    logger.log(Level.FINE, "ii={0}", ii);
                    d.remove(pos, ii);
                }
            } else {
                throw new IllegalArgumentException("implementation problem, completion (" + this.rs.completion + ") must start with completable (" + this.rs.completable + ")");
            }
            d.insertString(pos, this.rs.completion.substring(this.rs.completable.length()), null);
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public CharSequence getInsertPrefix() {
        return this.rs.completion;
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        int n = this.rs.label.length();
        String label = n > 80 ? this.rs.label.substring(n - 80, n) : this.rs.label;
        return graphics.getFontMetrics(font).stringWidth(label);
    }

    @Override
    public int getSortPriority() {
        return 0;
    }

    @Override
    public CharSequence getSortText() {
        return this.rs.completion;
    }

    @Override
    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color0, int i, int i0, boolean b) {
        int n = this.rs.label.length();
        String label = n > 80 ? this.rs.label.substring(n - 80, n) : this.rs.label;
        graphics.drawString(label, 0, graphics.getFontMetrics().getHeight());
    }

    public String getLabel() {
        return this.rs.completion;
    }

    public String toString() {
        return "completion " + this.rs.completion;
    }
}

