/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.monitor.CancelledOperationException;

public class JavadocLookup {
    private static JavadocLookup instance;
    private static final Logger logger;
    private final LinkedHashMap<String, String> lookups = new LinkedHashMap();
    private final LinkedHashMap<String, String> lookupVersions = new LinkedHashMap();

    public static synchronized JavadocLookup getInstance() {
        if (instance == null) {
            instance = new JavadocLookup();
            instance.setLinkForJavaSignature("javax", "https://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("java", "https://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/w3c/dom", "https://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/xml/sax", "https://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/jdesktop", "https://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/apache/commons/math3", "https://commons.apache.org/proper/commons-math/javadocs/api-3.6/");
            instance.setLinkForJavaSignature("org/apache/commons/math", "https://commons.apache.org/proper/commons-math/javadocs/api-2.0/");
            instance.setLinkForJavaSignature("gov/nasa/gsfc/spdf/cdfj", "https://cottagesystems.com/~jbf/autoplot/cdf/doc/");
            instance.setLinkForJavaSignature("org/json", "https://stleary.github.io/JSON-java/");
            instance.setLinkForJavaSignature("org/autoplot", JythonCompletionProvider.getInstance().settings.getDocHome());
            instance.setLinkForJavaSignature("org/das2", JythonCompletionProvider.getInstance().settings.getDocHome());
            instance.setLinkForJavaSignature("com/matio", JythonCompletionProvider.getInstance().settings.getDocHome());
            instance.setLinkForJavaSignature("ProGAL", JythonCompletionProvider.getInstance().settings.getDocHome());
            instance.setLinkForJavaSignature("external", JythonCompletionProvider.getInstance().settings.getDocHome());
        }
        return instance;
    }

    public String getLinkForJavaSignature(String signature) {
        if (signature == null) {
            return null;
        }
        String lookfor = signature.replaceAll("\\.", "/");
        Set<Map.Entry<String, String>> entries = this.lookups.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (!lookfor.startsWith(key)) continue;
            String s = entry.getValue();
            if (s.startsWith("http://docs.oracle.com/javase/8/docs/api/")) {
                return s + signature.replaceAll("[\\(\\)\\,]", "-");
            }
            if (s.startsWith("http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc2018/")) {
                return s + signature.replaceAll("[\\(\\)\\,]", "-");
            }
            if (s.startsWith("https://jfaden.net/~jbf/autoplot/doc") || s.startsWith("https://cottagesystems.com/~jbf/autoplot/doc")) {
                String result;
                if (signature.startsWith("org/das2/qds/ops/Ops.html") && signature.length() > 26) {
                    char let = signature.charAt(26);
                    result = s + signature.substring(0, 20) + "_" + let + signature.substring(20).replaceAll("[\\(\\)\\,]", "-");
                } else {
                    result = s + signature.replaceAll("[\\(\\)\\,]", "-");
                }
                while (result.endsWith("-")) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
            if (s.startsWith("http://www-pw.physics.uiowa.edu/~jbf/autoplot/doc") || s.startsWith("https://cottagesystems.com/jenkins/job/autoplot-javadoc/")) {
                int i = signature.indexOf(40);
                if (i > 0) {
                    signature = signature.substring(0, i);
                }
                if (signature.startsWith("org/das2/qds/ops/Ops.html") && signature.length() > 26) {
                    char let = signature.charAt(26);
                    return s + signature.substring(0, 20) + "_" + let + signature.substring(20);
                }
                return s + signature;
            }
            String v = this.lookupVersions.get(s);
            if (v == null || v.startsWith("1.8")) {
                return s + signature.replaceAll("[\\(\\)\\,]", "-");
            }
            if (s.endsWith("/")) {
                if (s.startsWith("file:")) {
                    if (!signature.endsWith(".html")) {
                        signature = signature + ".html";
                    }
                    return s + signature.replaceAll(",", ", ");
                }
                return s + signature.replaceAll(",", ", ");
            }
            return s + "/" + signature.replaceAll(",", ", ");
        }
        return null;
    }

    public void setLinkForJavaSignature(String signatureStart, String link) {
        if (signatureStart.startsWith("/")) {
            signatureStart = signatureStart.substring(1);
        }
        if (signatureStart.endsWith("/")) {
            signatureStart = signatureStart.substring(0, signatureStart.length() - 1);
        }
        if (link.endsWith(".jar")) {
            logger.fine("link cannot end with .jar, skipping.");
            return;
        }
        this.lookups.put(signatureStart + "/", link);
        String tversion = this.lookupVersions.get(link);
        if (tversion == null) {
            try {
                String htmls = HtmlUtil.readToString((URL)new URL(link));
                String[] ss = htmls.split("\n");
                int iline = 0;
                String version = "";
                Pattern p = Pattern.compile("Generated by javadoc \\((.*)\\)");
                for (String s : ss) {
                    ++iline;
                    Matcher m = p.matcher(s);
                    if (m.find()) {
                        version = m.group(1);
                        break;
                    }
                    if (iline > 50) break;
                }
                this.lookupVersions.put(link, version);
            }
            catch (IOException | CancelledOperationException throwable) {
                // empty catch block
            }
        }
    }

    public List<String> searchForSignature(String clas) {
        if (clas.startsWith("URIT")) {
            return Collections.singletonList("org.hapiserver.URITemplate");
        }
        for (Map.Entry<String, String> entry : this.lookups.entrySet()) {
        }
        return Collections.emptyList();
    }

    static {
        logger = LoggerManager.getLogger((String)"jython.editor.completion");
    }
}

