/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.util.StringSchemeEditor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class TickValuesStringSchemeEditor
extends JPanel
implements StringSchemeEditor {
    public static final String EDITOR_TITLE = "Tick Values Editor";
    private JCheckBox alsoUseMinorCB;
    private JComboBox<String> fixedNumberMinorCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private ButtonGroup majorButtonGroup;
    private JRadioButton majorListOfLocationsRB;
    private JTextField majorListOfLocationsTF;
    private JRadioButton majorRepeatEveryRB;
    private ButtonGroup minorButtonGroup;
    private JRadioButton minorFixedNumberIntervalsRB;
    private JRadioButton minorListOfLocationsRB;
    private JTextField minorListOfLocationsTF;
    private JPanel minorPanel;
    private JRadioButton minorRepeatEveryRB;
    private JComboBox<String> repeatEveryCB;
    private JComboBox<String> repeatEveryCB1;
    private JTextField valueTextField;
    private BindingGroup bindingGroup;

    public TickValuesStringSchemeEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.majorButtonGroup = new ButtonGroup();
        this.minorButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.valueTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.majorListOfLocationsRB = new JRadioButton();
        this.majorRepeatEveryRB = new JRadioButton();
        this.alsoUseMinorCB = new JCheckBox();
        this.repeatEveryCB = new JComboBox();
        this.majorListOfLocationsTF = new JTextField();
        this.minorPanel = new JPanel();
        this.minorListOfLocationsRB = new JRadioButton();
        this.minorListOfLocationsTF = new JTextField();
        this.minorFixedNumberIntervalsRB = new JRadioButton();
        this.fixedNumberMinorCB = new JComboBox();
        this.minorRepeatEveryRB = new JRadioButton();
        this.repeatEveryCB1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1.setText("<html>Enter a specification of how ticks should be generated.  If empty, the default methods are used,  or this can take one of the following forms: \n<ul>\n<li>10,20,30<i> - major ticks at 10,20, and 30 </i>\n<li>+10/4<i> - major ticks every ten units </i>\n<li>*10<i> - major ticks every cycle (10,100,1000,etc) </i>\n<li>+10min/5<i> - ticks every 10 minutes, with 5 divisions </i>\n<li>10,100,1000/50,500,5000<i> -  major and minor ticks </i>\n<li>none<i> - no ticks</i><ul> ");
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setVerticalTextPosition(1);
        this.valueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.valueTextFieldActionPerformed(evt);
            }
        });
        this.jLabel2.setText("For the Major Ticks (with Labels):");
        this.majorButtonGroup.add(this.majorListOfLocationsRB);
        this.majorListOfLocationsRB.setSelected(true);
        this.majorListOfLocationsRB.setText("list of locations:");
        this.majorButtonGroup.add(this.majorRepeatEveryRB);
        this.majorRepeatEveryRB.setText("repeat every:");
        this.alsoUseMinorCB.setText("Also Use the Minor Ticks:");
        this.repeatEveryCB.setEditable(true);
        this.repeatEveryCB.setModel(new DefaultComboBoxModel<String>(new String[]{"+10:  every ten units", "+5 days: specify with unit", "+2hr: specify with unit", "*10: every cycle on log plot", "*100: every two cycles on log plot", " "}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.majorRepeatEveryRB, (Property)ELProperty.create((String)"${selected}"), this.repeatEveryCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.repeatEveryCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TickValuesStringSchemeEditor.this.repeatEveryCBFocusLost(evt);
            }
        });
        this.repeatEveryCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.repeatEveryCBActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.majorListOfLocationsRB, (Property)ELProperty.create((String)"${selected}"), (Object)this.majorListOfLocationsTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.majorListOfLocationsTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TickValuesStringSchemeEditor.this.majorListOfLocationsTFFocusLost(evt);
            }
        });
        this.majorListOfLocationsTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.majorListOfLocationsTFActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.alsoUseMinorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minorPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.minorButtonGroup.add(this.minorListOfLocationsRB);
        this.minorListOfLocationsRB.setText("list of locations:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.alsoUseMinorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minorListOfLocationsRB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minorListOfLocationsRB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minorListOfLocationsTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.minorListOfLocationsTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TickValuesStringSchemeEditor.this.minorListOfLocationsTFFocusLost(evt);
            }
        });
        this.minorListOfLocationsTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.minorListOfLocationsTFActionPerformed(evt);
            }
        });
        this.minorButtonGroup.add(this.minorFixedNumberIntervalsRB);
        this.minorFixedNumberIntervalsRB.setSelected(true);
        this.minorFixedNumberIntervalsRB.setText("fixed number of intervals per major tick interval:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.alsoUseMinorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minorFixedNumberIntervalsRB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.fixedNumberMinorCB.setEditable(true);
        this.fixedNumberMinorCB.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "3", "4", "5", "6"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minorFixedNumberIntervalsRB, (Property)ELProperty.create((String)"${selected}"), this.fixedNumberMinorCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.fixedNumberMinorCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TickValuesStringSchemeEditor.this.fixedNumberMinorCBFocusLost(evt);
            }
        });
        this.fixedNumberMinorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.fixedNumberMinorCBActionPerformed(evt);
            }
        });
        this.minorButtonGroup.add(this.minorRepeatEveryRB);
        this.minorRepeatEveryRB.setText("repeat every:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.alsoUseMinorCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minorRepeatEveryRB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.repeatEveryCB1.setEditable(true);
        this.repeatEveryCB1.setModel(new DefaultComboBoxModel<String>(new String[]{"+1:  every unit", "+1 days: specify with unit", "+2hr: specify with unit", "+1: every cycle on log plot"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minorRepeatEveryRB, (Property)ELProperty.create((String)"${selected}"), this.repeatEveryCB1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.repeatEveryCB1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TickValuesStringSchemeEditor.this.repeatEveryCB1FocusLost(evt);
            }
        });
        this.repeatEveryCB1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickValuesStringSchemeEditor.this.repeatEveryCB1ActionPerformed(evt);
            }
        });
        GroupLayout minorPanelLayout = new GroupLayout(this.minorPanel);
        this.minorPanel.setLayout(minorPanelLayout);
        minorPanelLayout.setHorizontalGroup(minorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(minorPanelLayout.createSequentialGroup().addGroup(minorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(minorPanelLayout.createSequentialGroup().addGroup(minorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(minorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minorFixedNumberIntervalsRB, GroupLayout.Alignment.TRAILING).addComponent(this.minorListOfLocationsRB).addGroup(minorPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.fixedNumberMinorCB, -2, 93, -2))).addComponent(this.minorRepeatEveryRB).addGroup(minorPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.repeatEveryCB1, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, minorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.minorListOfLocationsTF, -2, 339, -2))).addContainerGap()));
        minorPanelLayout.setVerticalGroup(minorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, minorPanelLayout.createSequentialGroup().addComponent(this.minorListOfLocationsRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minorListOfLocationsTF, -2, -1, -2).addGap(11, 11, 11).addComponent(this.minorFixedNumberIntervalsRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fixedNumberMinorCB, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minorRepeatEveryRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repeatEveryCB1, -2, -1, -2).addContainerGap(33, Short.MAX_VALUE)));
        this.jLabel3.setText("Specification:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueTextField, -2, 706, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.majorRepeatEveryRB).addComponent(this.majorListOfLocationsRB).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.majorListOfLocationsTF, -2, 355, -2).addComponent(this.repeatEveryCB, -2, -1, -2)))))).addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.minorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.alsoUseMinorCB))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueTextField, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.alsoUseMinorCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.majorListOfLocationsRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.majorListOfLocationsTF, -2, -1, -2).addGap(5, 5, 5).addComponent(this.majorRepeatEveryRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repeatEveryCB, -2, -1, -2)).addComponent(this.minorPanel, -2, -1, -2))));
        this.bindingGroup.bind();
    }

    private void valueTextFieldActionPerformed(ActionEvent evt) {
        this.updateComponents();
    }

    private void majorListOfLocationsTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void majorListOfLocationsTFFocusLost(FocusEvent evt) {
        this.update();
    }

    private void repeatEveryCBFocusLost(FocusEvent evt) {
        this.update();
    }

    private void repeatEveryCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void minorListOfLocationsTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void minorListOfLocationsTFFocusLost(FocusEvent evt) {
        this.update();
    }

    private void fixedNumberMinorCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fixedNumberMinorCBFocusLost(FocusEvent evt) {
        this.update();
    }

    private void repeatEveryCB1FocusLost(FocusEvent evt) {
        this.update();
    }

    private void repeatEveryCB1ActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void updateComponents() {
        String spec = this.valueTextField.getText();
        String[] ss = spec.split("/", -2);
        if (ss[0].length() > 0 && (ss[0].charAt(0) == '+' || ss[0].charAt(0) == '*')) {
            this.majorRepeatEveryRB.setSelected(true);
            this.repeatEveryCB.setSelectedItem(ss[0]);
        } else {
            this.majorListOfLocationsTF.setText(ss[0]);
        }
        if (ss.length > 1) {
            this.alsoUseMinorCB.setSelected(true);
            if (ss[1].split(",").length > 1) {
                this.minorListOfLocationsTF.setText(ss[1]);
                this.minorListOfLocationsRB.setSelected(true);
            } else if (!ss[1].startsWith("+") && !ss[1].startsWith("*")) {
                this.fixedNumberMinorCB.setSelectedItem(ss[1]);
                this.minorFixedNumberIntervalsRB.setSelected(true);
            } else {
                this.repeatEveryCB1.setSelectedItem(ss[1]);
                this.minorRepeatEveryRB.setSelected(true);
            }
        } else {
            this.alsoUseMinorCB.setSelected(false);
        }
    }

    public void setValue(String v) {
        this.valueTextField.setText(v);
        this.updateComponents();
    }

    public String getValue() {
        this.update();
        return this.valueTextField.getText();
    }

    public void update() {
        int i;
        String text;
        StringBuilder build = new StringBuilder();
        if (this.majorListOfLocationsRB.isSelected()) {
            build.append(this.majorListOfLocationsTF.getText());
        } else {
            text = (String)this.repeatEveryCB.getSelectedItem();
            i = text.indexOf(":");
            if (i > -1) {
                text = text.substring(0, i).trim();
            }
            if (!text.startsWith("+") && !text.startsWith("*")) {
                text = "+" + text;
            }
            build.append(text);
        }
        if (this.alsoUseMinorCB.isSelected()) {
            build.append("/");
            if (this.minorListOfLocationsRB.isSelected()) {
                build.append(this.minorListOfLocationsTF.getText());
            } else if (this.minorFixedNumberIntervalsRB.isSelected()) {
                build.append(this.fixedNumberMinorCB.getSelectedItem().toString());
            } else {
                text = (String)this.repeatEveryCB1.getSelectedItem();
                i = text.indexOf(":");
                if (i > -1) {
                    text = text.substring(0, i).trim();
                }
                if (!text.startsWith("+") && !text.startsWith("*")) {
                    text = "+" + text;
                }
                build.append(text);
            }
        }
        this.valueTextField.setText(build.toString());
    }

    public Component getComponent() {
        return this;
    }

    public void setContext(Object o) {
    }

    public String getLabel() {
        return EDITOR_TITLE;
    }
}

