/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.treetable;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.das2.components.treetable.TreeTableNode;

public class TreeTableModel
extends AbstractTableModel
implements TableModel {
    private TreeTableNode root;
    private JTree tree;

    public TreeTableModel(TreeTableNode root, JTree tree) {
        this.root = root;
        this.tree = tree;
        tree.addTreeExpansionListener(new TreeTableTreeListener());
        tree.getModel().addTreeModelListener(new TreeTableTreeModelListener());
    }

    public Class getColumnClass(int columnIndex) {
        return this.root.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.root.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.root.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getNodeForRow(rowIndex).getValueAt(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getNodeForRow(rowIndex).isCellEditable(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getNodeForRow(rowIndex).setValueAt(aValue, columnIndex);
    }

    public void toggleExpanded(int rowIndex) {
        if (this.tree.isExpanded(rowIndex)) {
            this.tree.collapseRow(rowIndex);
        } else {
            this.tree.expandRow(rowIndex);
        }
    }

    public void expand(int rowIndex) {
        if (this.tree.isCollapsed(rowIndex)) {
            this.tree.expandRow(rowIndex);
        }
    }

    public void collapse(int rowIndex) {
        if (this.tree.isExpanded(rowIndex)) {
            this.tree.collapseRow(rowIndex);
        }
    }

    public TreeTableNode getNodeForRow(int rowIndex) {
        TreePath path = this.tree.getPathForRow(rowIndex);
        return (TreeTableNode)path.getLastPathComponent();
    }

    public TreeTableNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeTableNode node) {
        if (node == null) {
            throw new NullPointerException("null root node not allowed");
        }
        this.tree.setModel(new DefaultTreeModel(node, true));
    }

    private class TreeTableTreeListener
    implements TreeExpansionListener {
        private TreeTableTreeListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            int row = TreeTableModel.this.tree.getRowForPath(path);
            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
            int count = node.getChildCount();
            if (count != 0) {
                TreeTableModel.this.fireTableRowsDeleted(row + 1, row + count);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            int row = TreeTableModel.this.tree.getRowForPath(path);
            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
            int count = node.getChildCount();
            if (count != 0) {
                TreeTableModel.this.fireTableRowsInserted(row + 1, row + count);
            }
        }
    }

    private class TreeTableTreeModelListener
    implements TreeModelListener {
        private TreeTableTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int minRow = Integer.MAX_VALUE;
            int maxRow = Integer.MIN_VALUE;
            for (Object child : e.getChildren()) {
                TreePath childPath = path.pathByAddingChild(child);
                int row = TreeTableModel.this.tree.getRowForPath(childPath);
                if (row > -1 && row > maxRow) {
                    maxRow = row;
                }
                if (row <= -1 || row >= minRow) continue;
                minRow = row;
            }
            if (minRow <= maxRow) {
                TreeTableModel.this.fireTableRowsUpdated(minRow, maxRow);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int row = TreeTableModel.this.tree.getRowForPath(path);
            if (row != -1 && TreeTableModel.this.tree.isExpanded(row)) {
                int[] indices = e.getChildIndices();
                Arrays.sort(indices);
                for (int i = 0; i < indices.length; ++i) {
                    TreeTableModel.this.fireTableRowsInserted(indices[i], indices[i]);
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            int row = TreeTableModel.this.tree.getRowForPath(path);
            if (row != -1 && TreeTableModel.this.tree.isExpanded(row)) {
                int[] indices = e.getChildIndices();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; ++i) {
                    TreeTableModel.this.fireTableRowsDeleted(indices[i], indices[i]);
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeTableModel.this.fireTableStructureChanged();
        }
    }
}

