/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormButton;
import org.das2.dasml.FormCheckBox;
import org.das2.dasml.FormChoice;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormList;
import org.das2.dasml.FormPanel;
import org.das2.dasml.FormRadioButton;
import org.das2.dasml.FormRadioButtonGroup;
import org.das2.dasml.FormTab;
import org.das2.dasml.FormText;
import org.das2.dasml.FormTextField;
import org.das2.dasml.FormWindow;
import org.das2.dasml.Orientation;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.Processor;
import org.das2.dasml.TransferableFormComponent;
import org.das2.graph.DasCanvas;
import org.das2.graph.dnd.TransferableCanvas;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class FormContainer
extends JPanel
implements Editable,
FormComponent {
    float horizontalComponentAlignment = 0.0f;
    final float verticalComponentAlignment = 0.0f;
    boolean onHover = false;
    DnDSupport dndSupport;
    List flavorList;
    int dropPosition;
    boolean editable;
    private int axis = 0;
    private String borderTitle = "";
    private boolean hasBorder = false;

    protected FormContainer() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new NoBorder());
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(boolean b) {
        if (this.hasBorder != b) {
            this.hasBorder = b;
            if (this.hasBorder) {
                EtchedBorder etchedBorder = new EtchedBorder();
                TitledBorder titledBorder = new TitledBorder(etchedBorder, this.borderTitle, 1, 2);
                this.setBorder(titledBorder);
            } else {
                this.setBorder(new NoBorder());
            }
        }
    }

    public String getBorderTitle() {
        return this.borderTitle;
    }

    public void setBorderTitle(String s) {
        if (!s.equals(this.borderTitle)) {
            this.borderTitle = s;
            if (this.hasBorder) {
                EtchedBorder etchedBorder = new EtchedBorder();
                TitledBorder titledBorder = new TitledBorder(etchedBorder, this.borderTitle, 1, 2);
                this.setBorder(titledBorder);
            }
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setAlignmentX(this.horizontalComponentAlignment);
            ((JComponent)comp).setAlignmentY(0.0f);
        }
        super.addImpl(comp, constraints, index);
        if (comp instanceof FormComponent) {
            FormComponent fc = (FormComponent)((Object)comp);
            DnDSupport childDnDSupport = fc.getDnDSupport();
            if (childDnDSupport != null) {
                childDnDSupport.setParent(this.dndSupport);
            }
            fc.setEditingMode(this.getEditingMode());
        }
        this.packFormWindowAnscestor();
    }

    private void packFormWindowAnscestor() {
        if (this.isDisplayable()) {
            if (this instanceof FormWindow) {
                ((FormWindow)this).pack();
            } else {
                FormWindow fw = (FormWindow)SwingUtilities.getAncestorOfClass(FormWindow.class, this);
                if (fw != null) {
                    fw.pack();
                }
            }
        }
    }

    @Override
    public void removeAll() {
        int ncomponents = this.getComponentCount();
        for (int index = ncomponents - 1; index >= 0; --index) {
            this.remove(index);
        }
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        this.packFormWindowAnscestor();
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.packFormWindowAnscestor();
    }

    public void setDirection(Orientation direction) {
        if (direction == Orientation.HORIZONTAL) {
            if (this.axis != 0) {
                this.axis = 0;
                this.setLayout(new BoxLayout(this, this.axis));
                this.getForm().validate();
            }
        } else if (this.axis != 1) {
            this.axis = 1;
            this.setLayout(new BoxLayout(this, this.axis));
            this.revalidate();
        }
    }

    public Orientation getDirection() {
        if (this.axis == 0) {
            return Orientation.HORIZONTAL;
        }
        if (this.axis == 1) {
            return Orientation.VERTICAL;
        }
        throw new AssertionError((Object)"Invalid value for axis");
    }

    @Override
    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    @Override
    public boolean getEditingMode() {
        return this.editable;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.onHover) {
            Graphics2D g2 = (Graphics2D)g.create();
            BasicStroke thick = new BasicStroke(3.0f);
            g2.setStroke(thick);
            g2.setPaint(Color.GRAY);
            g2.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g2.setPaint(Color.ORANGE);
            if (this.getDirection() == Orientation.HORIZONTAL) {
                g2.drawLine(this.dropPosition, 4, this.dropPosition, this.getHeight() - 4);
            } else {
                g2.drawLine(4, this.dropPosition, this.getHeight() - 4, this.dropPosition);
            }
            g2.dispose();
        }
    }

    @Override
    public void setEditingMode(boolean b) {
        if (this.editable == b) {
            return;
        }
        this.editable = b;
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            if (!(this.getComponent(i) instanceof FormComponent)) continue;
            ((FormComponent)((Object)this.getComponent(i))).setEditingMode(b);
        }
    }

    private int[] getInsertionPositions() {
        int componentCount = this.getComponentCount();
        int[] positions = new int[componentCount + 1];
        if (this.getDirection() == Orientation.HORIZONTAL) {
            positions[0] = 2;
            for (int i = 1; i <= componentCount; ++i) {
                Component c = this.getComponent(i - 1);
                positions[i] = c.getX() + c.getWidth() + 1;
            }
        } else {
            positions[0] = 2;
            for (int i = 1; i <= componentCount; ++i) {
                Component c = this.getComponent(i - 1);
                positions[i] = c.getY() + c.getHeight() + 1;
            }
        }
        return positions;
    }

    private int getInsertionPosition(int p) {
        int[] positions = this.getInsertionPositions();
        int insertionPosition = 0;
        int dp = Integer.MAX_VALUE;
        for (int i = 0; i < positions.length; ++i) {
            int delta = Math.abs(p - positions[i]);
            if (delta >= dp) continue;
            dp = delta;
            insertionPosition = positions[i];
        }
        return insertionPosition;
    }

    private int getInsertionIndex(int p) {
        int[] positions = this.getInsertionPositions();
        int insertionIndex = 0;
        int dp = Integer.MAX_VALUE;
        for (int i = 0; i < positions.length; ++i) {
            int delta = Math.abs(p - positions[i]);
            if (delta >= dp) continue;
            dp = delta;
            insertionIndex = i;
        }
        return insertionIndex;
    }

    @Override
    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(x, y)) continue;
            this.dndSupport.startDrag(x, y, action, evt);
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(100, 100);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(100, 100);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pref = this.getPreferredSize();
        Dimension max = super.getMaximumSize();
        max.width = Math.max(max.width, 100);
        max.height = pref.height;
        return max;
    }

    @Override
    public String getDasName() {
        return null;
    }

    @Override
    public void setDasName(String name) throws DasNameException {
        throw new DasNameException();
    }

    @Override
    public void deregisterComponent() {
        for (int index = 0; index < this.getComponentCount(); ++index) {
            Component c = this.getComponent(index);
            if (!(c instanceof FormComponent)) continue;
            ((FormComponent)((Object)c)).deregisterComponent();
        }
    }

    @Override
    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    @Override
    public void registerComponent() throws DasException {
        try {
            for (int index = 0; index < this.getComponentCount(); ++index) {
                Component c = this.getComponent(index);
                if (!(c instanceof FormComponent)) continue;
                ((FormComponent)((Object)c)).registerComponent();
            }
        }
        catch (DasNameException dne) {
            this.deregisterComponent();
            throw dne;
        }
    }

    protected class ContainerDnDSupport
    extends DnDSupport {
        ContainerDnDSupport(DnDSupport parent) {
            super((Component)FormContainer.this, 3, parent);
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            if (FormContainer.this.flavorList != null && FormContainer.this.getEditingMode()) {
                for (int i = 0; i < flavors.length; ++i) {
                    if (!FormContainer.this.flavorList.contains(flavors[i])) continue;
                    FormContainer.this.onHover = true;
                    FormContainer.this.dropPosition = FormContainer.this.getDirection() == Orientation.HORIZONTAL ? FormContainer.this.getInsertionPosition(x) : FormContainer.this.getInsertionPosition(y);
                    FormContainer.this.repaint();
                    return action;
                }
            }
            return -1;
        }

        protected void done() {
            FormContainer.this.onHover = false;
            FormContainer.this.repaint();
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                int insertionIndex = FormContainer.this.getDirection() == Orientation.HORIZONTAL ? FormContainer.this.getInsertionIndex(x) : FormContainer.this.getInsertionIndex(y);
                Component c = null;
                if (t.isDataFlavorSupported(TransferableFormComponent.COMPONENT_FLAVOR)) {
                    c = (Component)t.getTransferData(TransferableFormComponent.COMPONENT_FLAVOR);
                } else if (t.isDataFlavorSupported(TransferableCanvas.CANVAS_FLAVOR)) {
                    c = (Component)t.getTransferData(TransferableCanvas.CANVAS_FLAVOR);
                } else if (t.isDataFlavorSupported(TransferableFormComponent.DASML_FRAGMENT_FLAVOR)) {
                    c = this.getComponentFromDasMLFragment((String)t.getTransferData(TransferableFormComponent.DASML_FRAGMENT_FLAVOR));
                }
                if (!(c == null || c instanceof FormTab || c instanceof FormWindow || c == FormContainer.this || SwingUtilities.isDescendingFrom(FormContainer.this, c))) {
                    if (c.getParent() == FormContainer.this) {
                        int cIndex = -1;
                        int componentCount = FormContainer.this.getComponentCount();
                        for (int i = 0; i < componentCount; ++i) {
                            if (FormContainer.this.getComponent(i) != c) continue;
                            cIndex = i;
                            break;
                        }
                        if (insertionIndex > cIndex) {
                            --insertionIndex;
                        }
                        FormContainer.this.remove(cIndex);
                        FormContainer.this.add(c, insertionIndex);
                        success = true;
                    } else {
                        FormContainer.this.add(c, insertionIndex);
                        success = true;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (success) {
                FormContainer.this.revalidate();
            }
            return success;
        }

        private Component getComponentFromDasMLFragment(String dasML) {
            try {
                Document document = FormBase.parseDasML(new StringReader(dasML), null);
                Element element = document.getDocumentElement();
                String tag = element.getTagName();
                if (tag.equals("panel")) {
                    return new FormPanel(element, FormContainer.this.getForm());
                }
                if (tag.equals("radiobutton")) {
                    return new FormRadioButton(element, FormContainer.this.getForm());
                }
                if (tag.equals("textfield")) {
                    return new FormTextField(element, FormContainer.this.getForm());
                }
                if (tag.equals("text")) {
                    return new FormText(element);
                }
                if (tag.equals("button")) {
                    return new FormButton(element, FormContainer.this.getForm());
                }
                if (tag.equals("checkbox")) {
                    return new FormCheckBox(element, FormContainer.this.getForm());
                }
                if (tag.equals("buttongroup")) {
                    return new FormRadioButtonGroup(element, FormContainer.this.getForm());
                }
                if (tag.equals("canvas")) {
                    DasCanvas canvas = Processor.processCanvasElement(element, FormContainer.this.getForm());
                    FormContainer.this.add(canvas);
                } else if (tag.equals("choice")) {
                    return new FormChoice(element, FormContainer.this.getForm());
                }
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
            catch (DasException de) {
                DasExceptionHandler.handle((Throwable)de);
            }
            catch (ParsedExpressionException pee) {
                DasExceptionHandler.handle((Throwable)pee);
            }
            catch (IOException ioe) {
                DasExceptionHandler.handle((Throwable)ioe);
            }
            catch (ParseException ex) {
                DasExceptionHandler.handle((Throwable)ex);
            }
            return null;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            for (int i = 0; i < FormContainer.this.getComponentCount(); ++i) {
                Component c = FormContainer.this.getComponent(i);
                if (!c.getBounds().contains(x, y)) continue;
                if (c instanceof DasCanvas) {
                    return new TransferableCanvas((DasCanvas)c);
                }
                if (c instanceof FormPanel) {
                    return new TransferableFormComponent((FormPanel)c);
                }
                if (c instanceof FormText) {
                    return new TransferableFormComponent((FormText)c);
                }
                if (c instanceof FormTextField) {
                    return new TransferableFormComponent((FormTextField)c);
                }
                if (c instanceof FormButton) {
                    return new TransferableFormComponent((FormButton)c);
                }
                if (c instanceof FormCheckBox) {
                    return new TransferableFormComponent((FormCheckBox)c);
                }
                if (c instanceof FormRadioButtonGroup) {
                    return new TransferableFormComponent((FormRadioButtonGroup)c);
                }
                if (c instanceof FormRadioButton) {
                    return new TransferableFormComponent((FormRadioButton)c);
                }
                if (c instanceof FormTab) {
                    return new TransferableFormComponent((FormTab)c);
                }
                if (c instanceof FormChoice) {
                    return new TransferableFormComponent((FormChoice)c);
                }
                if (!(c instanceof FormList)) continue;
                return new TransferableFormComponent((FormList)c);
            }
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    class NoBorder
    extends EmptyBorder {
        Color color;

        NoBorder() {
            super(5, 5, 5, 5);
            this.color = Color.GRAY;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (FormContainer.this.editable) {
                g.setColor(this.color);
                g.drawRect(x + 2, y + 2, width - 4, height - 4);
            }
        }
    }
}

