/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Arrays;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.PeakTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class AveragePeakTableRebinner
implements DataSetRebinner {
    private boolean debug = false;

    public String toString() {
        return "averagePeakRebinner";
    }

    @Override
    public QDataSet rebin(QDataSet ds, RebinDescriptor ddX, RebinDescriptor ddY, RebinDescriptor z) throws IllegalArgumentException {
        double xTagWidthDouble;
        RankZeroDataSet xTagWidth;
        int i;
        double[] xTagMax;
        double[] xTagMin;
        double[] xTags;
        QDataSet binPlus;
        JoinDataSet tds3 = new JoinDataSet(3);
        if (ds.rank() != 2) {
            if (ds.rank() == 3) {
                throw new IllegalArgumentException("dataset must be rank 2");
            }
            throw new IllegalArgumentException("dataset must be rank 2");
        }
        tds3.join(ds);
        QDataSet tds = ds;
        QDataSet weights = DataSetUtil.weightsDataSet((QDataSet)ds);
        QDataSet peaks = (QDataSet)ds.property("BIN_MAX");
        if (peaks == null && (binPlus = (QDataSet)ds.property("BIN_PLUS")) != null) {
            peaks = Ops.add((QDataSet)ds, (QDataSet)binPlus);
        }
        int nx = ddX == null ? tds.length() : ddX.numberOfBins();
        int ny = ddY == null ? tds.length(0) : ddY.numberOfBins();
        double[][] averageData = new double[nx][ny];
        double[][] averageWeights = new double[nx][ny];
        double[][] peakData = new double[nx][ny];
        AverageTableRebinner.average((QDataSet)tds3, weights, averageData, averageWeights, ddX, ddY, AverageTableRebinner.Interpolate.NearestNeighbor);
        QDataSet xtds = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet ytds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units xunits = SemanticOps.getUnits((QDataSet)xtds);
        if (ddX != null) {
            xTags = ddX.binCenters();
            xTagMin = ddX.binStops();
            xTagMax = ddX.binStarts();
            for (i = 0; i < tds.length(); ++i) {
                double xt = xtds.value(i);
                int ibin = ddX.whichBin(xt, xunits);
                if (ibin <= -1 || ibin >= nx) continue;
                xTagMin[ibin] = Math.min(xTagMin[ibin], xt);
                xTagMax[ibin] = Math.max(xTagMax[ibin], xt);
            }
        } else {
            xTags = new double[nx];
            for (i = 0; i < nx; ++i) {
                xTags[i] = xtds.value(i);
            }
            xTagMin = xTags;
            xTagMax = xTags;
        }
        if ((xTagWidth = DataSetUtil.guessCadenceNew((QDataSet)xtds, null)) == null) {
            xTagWidthDouble = ddX != null ? ddX.binWidth() : 0.0;
        } else {
            Units u = SemanticOps.getUnits((QDataSet)xTagWidth);
            xTagWidthDouble = u.convertDoubleTo(ddX.getUnits().getOffsetUnits(), xTagWidth.value());
        }
        double[][] averageWeightsCopy = new double[averageWeights.length][];
        for (int i2 = 0; i2 < averageData.length; ++i2) {
            averageWeightsCopy[i2] = Arrays.copyOf(averageWeights[i2], averageWeights[i2].length);
        }
        AverageTableRebinner.fillInterpolateX(averageData, averageWeights, xTags, xTagMin, xTagMax, xTagWidthDouble, AverageTableRebinner.Interpolate.NearestNeighbor);
        if (ddY != null) {
            RankZeroDataSet yTagWidth = DataSetUtil.guessCadenceNew((QDataSet)ytds, null);
            if (yTagWidth == null) {
                AverageTableRebinner.fillInterpolateY(averageData, averageWeights, ddY, null, AverageTableRebinner.Interpolate.NearestNeighbor);
            } else {
                AverageTableRebinner.fillInterpolateY(averageData, averageWeights, ddY, DataSetUtil.asDatum((QDataSet)yTagWidth), AverageTableRebinner.Interpolate.NearestNeighbor);
            }
        }
        if (peaks == null) {
            PeakTableRebinner.peaks(tds, peakData, ddX, ddY);
            AverageTableRebinner.fillInterpolateX(peakData, averageWeightsCopy, xTags, xTagMin, xTagMax, xTagWidthDouble, AverageTableRebinner.Interpolate.NearestNeighbor);
        } else {
            PeakTableRebinner.peaks(peaks, peakData, ddX, ddY);
            AverageTableRebinner.fillInterpolateX(peakData, averageWeightsCopy, xTags, xTagMin, xTagMax, xTagWidthDouble, AverageTableRebinner.Interpolate.NearestNeighbor);
        }
        double[] dd = new double[nx * ny];
        AveragePeakTableRebinner.flatten(averageData, dd, 0, nx, ny);
        DDataSet result = DDataSet.wrap((double[])dd, (int)nx, (int)ny);
        DataSetUtil.copyDimensionProperties((QDataSet)tds, (MutablePropertyDataSet)result);
        double[] ww = new double[nx * ny];
        AveragePeakTableRebinner.flatten(averageWeights, ww, 0, nx, ny);
        DDataSet wds = DDataSet.wrap((double[])ww, (int)nx, (int)ny);
        double[] pp = new double[nx * ny];
        AveragePeakTableRebinner.flatten(peakData, pp, 0, nx, ny);
        DDataSet pds = DDataSet.wrap((double[])pp, (int)nx, (int)ny);
        result.putProperty("DEPEND_1", (Object)ytds);
        result.putProperty("WEIGHTS", (Object)wds);
        result.putProperty("BIN_MAX", (Object)pds);
        return result;
    }

    public static void flatten(double[][] data, double[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            double[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

