/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Arrays;
import org.das2.dataset.AveragePeakTableRebinner;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class PeakTableRebinner
implements DataSetRebinner {
    @Override
    public QDataSet rebin(QDataSet ds, RebinDescriptor ddX, RebinDescriptor ddY, RebinDescriptor ddZ) throws IllegalArgumentException {
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("dataset must be rank 2");
        }
        QDataSet tds = ds;
        int nx = ddX == null ? tds.length() : ddX.numberOfBins();
        int ny = ddY == null ? tds.length(0) : ddY.numberOfBins();
        double[][] rebinData = new double[nx][ny];
        PeakTableRebinner.peaks(tds, rebinData, ddX, ddY);
        double[] dd = new double[nx * ny];
        AveragePeakTableRebinner.flatten(rebinData, dd, 0, nx, ny);
        DDataSet result = DDataSet.wrap((double[])dd, (int)nx, (int)ny);
        DataSetUtil.copyDimensionProperties((QDataSet)tds, (MutablePropertyDataSet)result);
        return result;
    }

    static void peaks(QDataSet tds, double[][] rebinData, RebinDescriptor ddX, RebinDescriptor ddY) {
        int nx = ddX == null ? tds.length() : ddX.numberOfBins();
        int ny = ddY == null ? tds.length(0) : ddY.numberOfBins();
        for (int i = 0; i < rebinData.length; ++i) {
            Arrays.fill(rebinData[i], Double.NaN);
        }
        QDataSet ytds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units yunits = SemanticOps.getUnits((QDataSet)ytds);
        QDataSet xtds = SemanticOps.xtagsDataSet((QDataSet)tds);
        Units xunits = SemanticOps.getUnits((QDataSet)xtds);
        int[] ibiny = new int[tds.length(0)];
        for (int j = 0; j < ibiny.length; ++j) {
            ibiny[j] = ddY != null ? ddY.whichBin(ytds.value(j), yunits) : j;
        }
        for (int i = 0; i < tds.length(); ++i) {
            int ibinx = ddX != null ? ddX.whichBin(xtds.value(i), xunits) : i;
            if (ibinx < 0 || ibinx >= nx) continue;
            for (int j = 0; j < ibiny.length; ++j) {
                if (ibiny[j] < 0 || ibiny[j] >= ny) continue;
                double value = tds.value(i, j);
                rebinData[ibinx][ibiny[j]] = Double.isNaN(rebinData[ibinx][ibiny[j]]) ? value : Math.max(value, rebinData[ibinx][ibiny[j]]);
            }
        }
    }
}

