/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;

public class ScatterRebinner
implements DataSetRebinner {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.data.rebinner");

    @Override
    public QDataSet rebin(QDataSet zds, RebinDescriptor ddX, RebinDescriptor ddY, RebinDescriptor ddZ) {
        QDataSet yMinus;
        QDataSet xMinus;
        WritableDataSet result = Ops.zeros((int)ddX.numberOfBins(), (int)ddY.numberOfBins());
        ddX.setOutOfBoundsAction(-3);
        ddY.setOutOfBoundsAction(-3);
        MutablePropertyDataSet xds = null;
        MutablePropertyDataSet yds = null;
        if (Schemes.isBundleDataSet((QDataSet)zds)) {
            logger.fine("is bundle");
            xds = DataSetOps.slice1((QDataSet)zds, (int)0);
            yds = DataSetOps.slice1((QDataSet)zds, (int)1);
            zds = DataSetOps.slice1((QDataSet)zds, (int)(zds.length(0) - 1));
        } else {
            xds = zds.property("DEPEND_0") != null ? (QDataSet)zds.property("DEPEND_0") : Ops.findgen((int)zds.length());
            if (zds.property("DEPEND_1") != null) {
                yds = (QDataSet)zds.property("DEPEND_1");
            } else if (Schemes.isLegacyXYZScatter((QDataSet)zds)) {
                yds = zds;
                zds = (QDataSet)yds.property("PLANE_0");
            } else {
                yds = Ops.findgen((int)zds.length());
            }
        }
        if (xds == null) {
            throw new IllegalArgumentException("unable to identify x data set");
        }
        if (yds == null) {
            throw new IllegalArgumentException("unable to identify y data set");
        }
        int nx = ddX.numberOfBins() - 1;
        int ny = ddY.numberOfBins() - 1;
        int[][] nPointsInBin = new int[nx + 1][ny + 1];
        double[][] cumMovingAverage = new double[nx + 1][ny + 1];
        int xB = 0;
        int yB = 0;
        Units xdsUnits = SemanticOps.getUnits((QDataSet)xds);
        Units ydsUnits = SemanticOps.getUnits((QDataSet)yds);
        switch (zds.rank()) {
            case 0: {
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < zds.length(); ++i) {
                    switch (xds.rank()) {
                        case 0: {
                            xB = ddX.whichBin(xds.value(), xdsUnits);
                            break;
                        }
                        case 1: {
                            xB = ddX.whichBin(xds.value(i), xdsUnits);
                            break;
                        }
                        case 2: {
                            logger.fine(" Don't know what to do with rank 2 Depend 0 datasets yet.");
                            break;
                        }
                    }
                    switch (yds.rank()) {
                        case 0: {
                            yB = ddY.whichBin(yds.value(), ydsUnits);
                            break;
                        }
                        case 1: {
                            yB = ddY.whichBin(yds.value(i), ydsUnits);
                            break;
                        }
                        case 2: {
                            logger.fine(" Don't know what to do with rank 2 Depend 0 datasets yet.");
                            break;
                        }
                    }
                    if (xB == -1 || yB == -1) continue;
                    cumMovingAverage[xB][yB] = (zds.value(i) + (double)nPointsInBin[xB][yB] * cumMovingAverage[xB][yB]) / (double)(nPointsInBin[xB][yB] + 1);
                    int[] nArray = nPointsInBin[xB];
                    int n = yB;
                    nArray[n] = nArray[n] + 1;
                    result.putValue(xB, yB, cumMovingAverage[xB][yB]);
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < zds.length(); ++i) {
                    for (int j = 0; j < zds.length(i); ++j) {
                        switch (xds.rank()) {
                            case 0: {
                                xB = ddX.whichBin(xds.value(), xdsUnits);
                                break;
                            }
                            case 1: {
                                xB = ddX.whichBin(xds.value(i), xdsUnits);
                                break;
                            }
                            case 2: {
                                logger.fine(" Don't know what to do with rank 2 dataset here.");
                                break;
                            }
                        }
                        switch (yds.rank()) {
                            case 0: {
                                yB = ddY.whichBin(yds.value(), ydsUnits);
                                break;
                            }
                            case 1: {
                                yB = ddY.whichBin(yds.value(j), ydsUnits);
                                break;
                            }
                            case 2: {
                                logger.fine(" Don't know what to do with rank 2 dataset here.");
                                break;
                            }
                        }
                        if (xB == -1 || yB == -1) continue;
                        cumMovingAverage[xB][yB] = (zds.value(i, j) + (double)nPointsInBin[xB][yB] * cumMovingAverage[xB][yB]) / (double)(nPointsInBin[xB][yB] + 1);
                        int[] nArray = nPointsInBin[xB];
                        int n = yB;
                        nArray[n] = nArray[n] + 1;
                        result.putValue(xB, yB, cumMovingAverage[xB][yB]);
                    }
                }
                break;
            }
            case 3: {
                logger.fine("Does not support rank 3 datasets.");
                break;
            }
            default: {
                logger.fine("Rank is not 0, 1, 2 or 3 or not recognized.");
            }
        }
        int xHardBinPlus = 0;
        int xHardBinMinus = 0;
        int yHardBinPlus = 0;
        int yHardBinMinus = 0;
        int xSoftRad = 0;
        int ySoftRad = 0;
        Datum xDat = ddX.binWidthDatum();
        ArrayList<Integer> xCadencesToSort = new ArrayList<Integer>();
        double[] xbinWidths = this.getBinWidths(ddX);
        int[] xcadencesInBins = new int[xbinWidths.length];
        Units xoffsetUnits = xdsUnits.getOffsetUnits();
        QDataSet xPlus = (QDataSet)xds.property("BIN_PLUS");
        if (xPlus != null) {
            xHardBinPlus = (int)(xPlus.value() / xDat.doubleValue(xoffsetUnits));
        }
        if ((xMinus = (QDataSet)xds.property("BIN_MINUS")) != null) {
            xHardBinMinus = (int)(xMinus.value() / xDat.doubleValue(xoffsetUnits));
        }
        QDataSet xCad = (QDataSet)xds.property("CADENCE");
        double xCadenceVal = 0.0;
        if (xCad != null) {
            xCadenceVal = xCad.value();
            if (ddX.isLog) {
                xcadencesInBins = this.getCadenceValues(xbinWidths, xCadenceVal, -1);
            } else {
                xcadencesInBins = null;
                xSoftRad = (int)Math.round(xCadenceVal / xDat.doubleValue(xoffsetUnits));
            }
        } else {
            int xPosInList = (int)Math.round(0.95 * (double)xCadencesToSort.size());
            for (int i = 0; i < xds.length() - 1; ++i) {
                int currentDataWidthx = ddX.whichBin(xds.value(i + 1), xdsUnits) - ddX.whichBin(xds.value(i), xdsUnits);
                if (currentDataWidthx < 1) continue;
                xCadencesToSort.add(currentDataWidthx);
            }
            Collections.sort(xCadencesToSort, Collections.reverseOrder());
            if (xCadencesToSort.size() >= 1) {
                xCadenceVal = ((Integer)xCadencesToSort.get(xPosInList)).intValue();
                logger.log(Level.FINE, " X cadence from sorted list = {0}", xCadenceVal);
            } else {
                logger.fine("No Cadences.");
            }
            if (ddX.isLog) {
                xcadencesInBins = this.getCadenceValues(xbinWidths, xCadenceVal, (Integer)xCadencesToSort.get(0));
            } else {
                xcadencesInBins = null;
                xSoftRad = (int)xCadenceVal;
            }
        }
        Datum yDat = ddY.binWidthDatum();
        ArrayList<Integer> yCadencesToSort = new ArrayList<Integer>();
        ArrayList<Double> yCadencesToSortValues = new ArrayList<Double>();
        double[] ybinWidths = this.getBinWidths(ddY);
        int[] ycadencesInBins = new int[ybinWidths.length];
        Units yoffsetUnits = ydsUnits.getOffsetUnits();
        QDataSet yPlus = (QDataSet)yds.property("BIN_PLUS");
        if (yPlus != null) {
            yHardBinPlus = (int)(yPlus.value() / yDat.doubleValue(yoffsetUnits));
        }
        if ((yMinus = (QDataSet)yds.property("BIN_MINUS")) != null) {
            yHardBinMinus = (int)(yMinus.value() / yDat.doubleValue(yoffsetUnits));
        }
        QDataSet yCad = (QDataSet)yds.property("CADENCE");
        double yCadenceVal = 0.0;
        boolean yCadenceValueBin = false;
        if (yCad != null) {
            yCadenceVal = yCad.value();
            if (ddY.isLog) {
                ycadencesInBins = this.getCadenceValues(ybinWidths, yCadenceVal, -1);
            } else {
                ycadencesInBins = null;
                ySoftRad = (int)Math.round(yCadenceVal / yDat.doubleValue(yoffsetUnits));
            }
        } else {
            for (int i = 0; i < yds.length() - 1; ++i) {
                int currentDataWidthy = ddY.whichBin(yds.value(i + 1), yoffsetUnits) - ddY.whichBin(yds.value(i), yoffsetUnits);
                if (currentDataWidthy < 1) continue;
                yCadencesToSort.add(currentDataWidthy);
                yCadencesToSortValues.add(yds.value(i + 1) - yds.value(i));
            }
            Collections.sort(yCadencesToSort, Collections.reverseOrder());
            Collections.sort(yCadencesToSortValues, Collections.reverseOrder());
            int yCadSortIndex = 0;
            if (yCadencesToSortValues.size() >= 1) {
                yCadSortIndex = (int)Math.round(0.95 * (double)yCadencesToSortValues.size());
                yCadenceVal = (Double)yCadencesToSortValues.get(yCadSortIndex);
                logger.log(Level.FINE, " Y cadence from sorted list = {0}", yCadenceVal);
            } else {
                logger.fine("No Cadences.");
            }
            if (ddY.isLog) {
                ycadencesInBins = this.getCadenceValues(ybinWidths, yCadenceVal, (Integer)yCadencesToSort.get(yCadSortIndex));
            } else {
                ycadencesInBins = null;
                ySoftRad = (Integer)yCadencesToSort.get(yCadSortIndex);
            }
        }
        if (xcadencesInBins != null) {
            logger.fine(" Cadences vary in X");
        } else {
            logger.log(Level.FINE, " x Cadence is = {0}", xSoftRad);
        }
        if (ycadencesInBins != null) {
            logger.fine(" Cadences vary in Y");
        } else {
            logger.log(Level.FINE, " y Cadence is = {0}", ySoftRad);
        }
        result = this.InterpolateHardAndSoftEdge(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, xSoftRad, ySoftRad, nx, ny, result, xcadencesInBins, ycadencesInBins);
        return result;
    }

    private WritableDataSet InterpolateHardAndSoftEdge(int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus, int xSoftRad1, int ySoftRad1, int xbins, int ybins, WritableDataSet data, int[] xVaryingCadenceBin, int[] yVaryingCadenceBin) {
        double[][] ValTimesWeightSum = new double[xbins + 1][ybins + 1];
        double[][] WeightSum = new double[xbins + 1][ybins + 1];
        int[][] count = new int[xbins + 1][ybins + 1];
        double[][] templateBox = this.CreateTemplateBox(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, 1, 1);
        int xSoftRad = xSoftRad1;
        int ySoftRad = ySoftRad1;
        int prevxSoftRad = 1;
        int prevySoftRad = 1;
        double value = 0.0;
        for (int ix = 0; ix <= xbins; ++ix) {
            if (xVaryingCadenceBin != null) {
                xSoftRad = xVaryingCadenceBin[ix];
            }
            for (int iy = 0; iy <= ybins; ++iy) {
                if (yVaryingCadenceBin != null) {
                    ySoftRad = yVaryingCadenceBin[iy];
                }
                if (!((value = data.value(ix, iy)) > 0.0)) continue;
                if (xSoftRad != prevxSoftRad || ySoftRad != prevySoftRad) {
                    templateBox = this.CreateTemplateBox(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, xSoftRad, ySoftRad);
                }
                prevxSoftRad = xSoftRad;
                prevySoftRad = ySoftRad;
                if (xSoftRad == 0 && ySoftRad == 0) continue;
                for (int i = -(xHardBinMinus + xSoftRad); i <= xHardBinPlus + xSoftRad; ++i) {
                    for (int j = -(yHardBinMinus + ySoftRad); j <= yHardBinPlus + ySoftRad; ++j) {
                        if (ix + i < 0 || ix + i > xbins || iy + j < 0 || iy + j > ybins || templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad] == 0.0) continue;
                        double[] dArray = ValTimesWeightSum[ix + i];
                        int n = iy + j;
                        dArray[n] = dArray[n] + value * templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad];
                        double[] dArray2 = WeightSum[ix + i];
                        int n2 = iy + j;
                        dArray2[n2] = dArray2[n2] + templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad];
                        int[] nArray = count[ix + i];
                        int n3 = iy + j;
                        nArray[n3] = nArray[n3] + 1;
                    }
                }
            }
        }
        for (int ix2 = 0; ix2 <= xbins; ++ix2) {
            for (int iy2 = 0; iy2 <= ybins; ++iy2) {
                if (count[ix2][iy2] >= 1) {
                    data.putValue(ix2, iy2, ValTimesWeightSum[ix2][iy2] / WeightSum[ix2][iy2]);
                    continue;
                }
                data.putValue(ix2, iy2, -1.0E31);
            }
        }
        return data;
    }

    public double[][] CreateTemplateBox(int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus, int xSoftRad, int ySoftRad) {
        double[][] templateWeights = new double[xHardBinPlus + xHardBinMinus + 2 * xSoftRad + 1][yHardBinPlus + yHardBinMinus + 2 * ySoftRad + 1];
        for (int i = -(xHardBinMinus + xSoftRad); i <= xHardBinPlus + xSoftRad; ++i) {
            for (int j = -(yHardBinMinus + ySoftRad); j <= yHardBinPlus + ySoftRad; ++j) {
                if (this.InBinPlusMinuxHardEdgeBox(i, j, xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus)) {
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + (yHardBinMinus + ySoftRad)] = 1.0;
                    continue;
                }
                if (this.InEllipseCutoff(i, j, (double)(xHardBinMinus + xHardBinPlus + 2 * xSoftRad) / 2.0, (double)(yHardBinMinus + yHardBinPlus + 2 * ySoftRad) / 2.0)) {
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 1.0 - this.EllipseValue(i, j, (double)(xHardBinMinus + xHardBinPlus + 2 * xSoftRad) / 2.0, (double)(yHardBinMinus + yHardBinPlus + 2 * ySoftRad) / 2.0);
                    if (!(templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] < 0.0)) continue;
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 0.0;
                    continue;
                }
                templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 0.0;
            }
        }
        return templateWeights;
    }

    public boolean InBinPlusMinuxHardEdgeBox(int xPlusMinus, int yPlusMinus, int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus) {
        return xPlusMinus >= -xHardBinMinus && xPlusMinus <= xHardBinPlus && yPlusMinus >= -yHardBinMinus && yPlusMinus <= yHardBinPlus;
    }

    public boolean InEllipseCutoff(int xDist, int yDist, double xR, double yR) {
        return (double)xDist * (double)xDist / (xR * xR) + (double)yDist * (double)yDist / (yR * yR) <= 1.0;
    }

    public double EllipseValue(int xDist, int yDist, double xR, double yR) {
        return (double)xDist * (double)xDist / (xR * xR) + (double)yDist * (double)yDist / (yR * yR);
    }

    public double[] getBinWidths(RebinDescriptor rebinDesc) {
        double[] binStops;
        double[] binStarts = rebinDesc.binStarts();
        if (binStarts.length != (binStops = rebinDesc.binStops()).length) {
            logger.fine("Number of start bins is not equal to number of stop bins.");
            return null;
        }
        double[] binWidths = new double[binStarts.length];
        for (int i = 0; i < binStarts.length; ++i) {
            binWidths[i] = binStops[i] - binStarts[i];
        }
        return binWidths;
    }

    public int[] getCadenceValues(double[] binWidths, double CadenceValue, int maxSep) {
        int[] cadencesIntBins = new int[binWidths.length];
        for (int i = 0; i < binWidths.length; ++i) {
            int IndexBuf = 0;
            for (double cadenceBuffer = 0.0; cadenceBuffer < CadenceValue; cadenceBuffer += binWidths[i + IndexBuf++]) {
                if (IndexBuf + i < binWidths.length) continue;
                if (i == 0) break;
                cadencesIntBins[i] = cadencesIntBins[i - 1];
                break;
            }
            cadencesIntBins[i] = IndexBuf > maxSep && maxSep != -1 ? maxSep : IndexBuf;
        }
        return cadencesIntBins;
    }
}

