/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultVectorDataSet;
import org.das2.dataset.GapListDouble;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class VectorDataSetBuilder {
    private GapListDouble xTags = new GapListDouble();
    private List yValues = new ArrayList();
    private List planeIDs = new ArrayList();
    private Units xUnits;
    private Map yUnitsMap;
    private Map properties;

    public VectorDataSetBuilder(Units xUnits, Units yUnits) {
        this.planeIDs.add("");
        this.xUnits = Units.dimensionless;
        this.yUnitsMap = new HashMap();
        this.yUnitsMap.put("", Units.dimensionless);
        this.properties = new HashMap();
        this.xUnits = xUnits;
        this.setYUnits(yUnits);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperties(Map map) {
        this.properties.putAll(map);
    }

    public void addPlane(String name, Units yUnits) {
        if (!this.planeIDs.contains(name)) {
            this.planeIDs.add(name);
            this.yUnitsMap.put(name, yUnits);
        }
    }

    public void insertY(double x, double y) {
        this.insertY(x, y, "");
    }

    public void insertY(double x, double y, String planeID) {
        if (!this.planeIDs.contains(planeID)) {
            throw new IllegalArgumentException("invalid planeID: " + planeID + ", have " + this.planeIDs);
        }
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new IllegalArgumentException("x is not finite");
        }
        int insertionIndex = this.xTags.indexOf(x);
        if (planeID == null) {
            planeID = "";
        }
        if (insertionIndex < 0) {
            this.xTags.add(x);
            MultiY scan = new MultiY();
            scan.put(planeID, y);
            this.yValues.add(insertionIndex ^= 0xFFFFFFFF, scan);
        } else {
            MultiY scan = (MultiY)this.yValues.get(insertionIndex);
            scan.put(planeID, y);
        }
    }

    public void insertY(double x, double y, String planeId1, double planeValue1) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new IllegalArgumentException("x is not finite");
        }
        int insertionIndex = this.xTags.indexOf(x);
        if (insertionIndex < 0) {
            insertionIndex ^= 0xFFFFFFFF;
            this.xTags.add(x);
            MultiY scan = new MultiY();
            scan.put("", y);
            scan.put(planeId1, planeValue1);
            this.yValues.add(insertionIndex, scan);
        } else {
            MultiY scan = (MultiY)this.yValues.get(insertionIndex);
            scan.put("", y);
            scan.put(planeId1, planeValue1);
        }
    }

    public void insertY(Datum x, Datum y) {
        this.insertY(x, y, "");
    }

    public void insertY(Datum x, Datum y, String planeID) {
        if (!this.planeIDs.contains(planeID)) {
            throw new IllegalArgumentException("invalid planeID: " + planeID + ", have " + this.planeIDs);
        }
        double xd = x.doubleValue(this.xUnits);
        double yd = y.doubleValue((Units)this.yUnitsMap.get(planeID));
        this.insertY(xd, yd, planeID);
    }

    public void append(VectorDataSet vds) {
        String[] planeIds = DataSetUtil.getAllPlaneIds(vds);
        for (int iplane = 0; iplane < planeIds.length; ++iplane) {
            String plane = planeIds[iplane];
            VectorDataSet planeDs = (VectorDataSet)vds.getPlanarView(plane);
            Units yUnits = (Units)this.yUnitsMap.get(plane);
            if (yUnits == null) {
                this.addPlane(plane, planeDs.getYUnits());
                yUnits = (Units)this.yUnitsMap.get(plane);
            }
            for (int i = 0; i < planeDs.getXLength(); ++i) {
                this.insertY(planeDs.getXTagDouble(i, this.xUnits), planeDs.getDouble(i, yUnits), plane);
            }
        }
        this.addProperties(vds.getProperties());
    }

    public void setXUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.xUnits = units;
    }

    public void setYUnits(Units units) {
        this.setYUnits(units, "");
    }

    public void setYUnits(Units units, String planeID) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.yUnitsMap.put(planeID, units);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("x: ").append(VectorDataSetBuilder.toString(this.xTags.toArray())).append("\ny: ");
        for (MultiY y : this.yValues) {
            result.append(y.get("")).append(',');
        }
        return result.toString();
    }

    public VectorDataSet toVectorDataSet() {
        double[][] collapsedYValues = VectorDataSetBuilder.collapseYValues(this.yValues, this.planeIDs, this.yUnitsMap);
        Units[] yUnitsArray = VectorDataSetBuilder.getUnitsArray(this.planeIDs, this.yUnitsMap);
        this.properties.put("plane-list", Collections.unmodifiableList(this.planeIDs));
        return new DefaultVectorDataSet(this.xTags.toArray(), this.xUnits, collapsedYValues, yUnitsArray, this.planeIDs.toArray(new String[this.planeIDs.size()]), this.properties);
    }

    private static double[] insert(double[] array, double value, int index) {
        double[] result = new double[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    private static double[][] insert(double[][] array, double[] values, int index) {
        double[][] result = new double[array.length + 1][];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = values;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    private static String toString(double[] array) {
        return VectorDataSetBuilder.toString(array, 0, array.length);
    }

    private static String toString(double[] array, int startIndex, int endIndex) {
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer("[");
        for (int i = startIndex; i < endIndex - 1; ++i) {
            buffer.append(array[i]).append(", ");
        }
        buffer.append(array[endIndex - 1]).append(']');
        return buffer.toString();
    }

    private static double[][] collapseYValues(List list, List planeIDs, Map unitsMap) {
        double[][] yValues = new double[planeIDs.size()][list.size()];
        int index = 0;
        for (MultiY my : list) {
            for (int plane = 0; plane < planeIDs.size(); ++plane) {
                double y = my.get((String)planeIDs.get(plane));
                if (Double.isNaN(y)) {
                    Units units = (Units)unitsMap.get(planeIDs.get(plane));
                    y = units.getFillDouble();
                }
                yValues[plane][index] = y;
            }
            ++index;
        }
        return yValues;
    }

    private static Units[] getUnitsArray(List planeIDs, Map unitsMap) {
        Units[] units = new Units[planeIDs.size()];
        for (int i = 0; i < units.length; ++i) {
            units[i] = (Units)unitsMap.get(planeIDs.get(i));
        }
        return units;
    }

    private static class MultiY {
        private HashMap yValues = new HashMap();

        private MultiY() {
        }

        private void put(String name, double y) {
            this.yValues.put(name, new Double(y));
        }

        private double get(String name) {
            Double y = (Double)this.yValues.get(name);
            return y == null ? Double.NaN : y;
        }
    }
}

