/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.WaypointsDragRenderer;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.qds.QDataSet;

public class WaypointsMouseModule
extends MouseModule {
    private EventListenerList listenerList = new EventListenerList();

    public WaypointsMouseModule(DasCanvasComponent parent, String label) {
        super(parent);
        WaypointsDragRenderer dr = new WaypointsDragRenderer(parent);
        this.dragRenderer = dr;
        this.setLabel(label);
        dr.setParent(parent);
    }

    @Override
    public String getDirections() {
        WaypointsDragRenderer r = (WaypointsDragRenderer)super.getDragRenderer();
        r.clear(null);
        return "Press P to pin, 1-9 set thickness, w to add a way point.";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        logger.log(Level.FINE, "keyTyped {0} {1}", new Object[]{Character.valueOf(keyEvent.getKeyChar()), keyEvent.isMetaDown()});
        WaypointsDragRenderer r = (WaypointsDragRenderer)super.getDragRenderer();
        if (keyEvent.getKeyChar() >= '1' && keyEvent.getKeyChar() <= '9') {
            r.setWidth((keyEvent.getKeyChar() - 48) * 5);
        } else if (keyEvent.getKeyChar() == '-') {
            r.setWidth(Math.max(1, r.getWidth() - 5));
        } else if (keyEvent.getKeyChar() == '+' || keyEvent.getKeyChar() == '=') {
            r.setWidth(Math.max(1, r.getWidth() + 5));
        } else if (keyEvent.getKeyChar() == 'w') {
            r.addWayPoint();
        }
        this.parent.repaint();
    }

    public void addBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.add(BoxSelectionListener.class, listener);
    }

    public void removeBoxSelectionListener(BoxSelectionListener listener) {
        this.listenerList.remove(BoxSelectionListener.class, listener);
    }

    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BoxSelectionListener.class) continue;
            ((BoxSelectionListener)listeners[i + 1]).boxSelected(event);
        }
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e) {
        Rectangle boundingBox = ((WaypointsDragRenderer)this.getDragRenderer()).getBoundingBox();
        DasPlot p = (DasPlot)this.getParent();
        DatumRange xrange = new DatumRange(p.getXAxis().invTransform(boundingBox.x), p.getXAxis().invTransform(boundingBox.x + boundingBox.width));
        DatumRange yrange = DatumRangeUtil.union((Datum)p.getYAxis().invTransform(boundingBox.y), (Datum)p.getYAxis().invTransform(boundingBox.y + boundingBox.height));
        BoxSelectionEvent evt = new BoxSelectionEvent(this.parent, xrange, yrange);
        this.fireBoxSelectionListenerBoxSelected(evt);
    }

    public QDataSet whereWithin(QDataSet xx, QDataSet yy) {
        if (this.getParent() instanceof DasPlot) {
            DasPlot p = (DasPlot)this.getParent();
            QDataSet result = ((WaypointsDragRenderer)this.getDragRenderer()).whereWithin(p.getXAxis(), p.getYAxis(), xx, yy);
            return result;
        }
        throw new IllegalArgumentException("parent must be a DasPlot to use whereWithin");
    }
}

