/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.graph.DasAxis;

public final class ZoomOutMouseModule
extends BoxSelectorMouseModule {
    DasAxis parent;

    private BoxSelectionListener createBoxSelectionListener() {
        return new BoxSelectionListener(){

            @Override
            public void boxSelected(BoxSelectionEvent event) {
                DatumRange newRange;
                DatumRange outerRange = ZoomOutMouseModule.this.parent.getDatumRange();
                DatumRange range = ZoomOutMouseModule.this.parent.isHorizontal() ? event.getXRange() : event.getYRange();
                range = ZoomOutMouseModule.this.parent.getTickV().enclosingRange(range, true);
                if (ZoomOutMouseModule.this.parent.isLog()) {
                    double nmin = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)outerRange.min());
                    double nmax = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)outerRange.max());
                    nmin = nmin < -3.0 ? -3.0 : nmin;
                    nmax = nmax > 3.0 ? 3.0 : nmax;
                    newRange = DatumRangeUtil.rescaleLog((DatumRange)outerRange, (double)nmin, (double)nmax);
                } else {
                    double nmin = DatumRangeUtil.normalize((DatumRange)range, (Datum)outerRange.min());
                    double nmax = DatumRangeUtil.normalize((DatumRange)range, (Datum)outerRange.max());
                    nmin = nmin < -3.0 ? -3.0 : nmin;
                    nmax = nmax > 3.0 ? 3.0 : nmax;
                    newRange = DatumRangeUtil.rescale((DatumRange)outerRange, (double)nmin, (double)nmax);
                }
                ZoomOutMouseModule.this.parent.setDatumRange(newRange);
            }
        };
    }

    public ZoomOutMouseModule(DasAxis axis) {
        super(axis, axis.isHorizontal() ? axis : null, axis.isHorizontal() ? null : axis, null, new BoxRenderer(axis), "Zoom Out");
        this.parent = axis;
        this.addBoxSelectionListener(this.createBoxSelectionListener());
    }
}

