/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.text.ParseException;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;

public class DasRow
extends DasDevicePosition {
    public static final DasRow NULL = new DasRow(null, null, 0.0, 0.0, 0.0, 0.0, 0, 0);

    public DasRow(DasCanvas parent, double top, double bottom) {
        super(parent, top, bottom, false);
    }

    public DasRow(DasCanvas canvas, DasRow parent, double nMin, double nMax, double emMin, double emMax, int ptMin, int ptMax) {
        super(canvas, false, parent, nMin, nMax, emMin, emMax, ptMin, ptMax);
    }

    public static DasRow create(DasCanvas canvas, DasRow parent, String minStr, String maxStr) {
        double[] max;
        double[] min;
        try {
            min = DasRow.parseLayoutStr(minStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse min: \"" + minStr + "\"");
        }
        try {
            max = DasRow.parseLayoutStr(maxStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse max: \"" + maxStr + "\"");
        }
        return new DasRow(canvas, parent, min[0], max[0], min[1], max[1], (int)min[2], (int)max[2]);
    }

    public DasRow createSubRow(double ptop, double pbottom) {
        double top = this.getMinimum();
        double bottom = this.getMaximum();
        double delta = top - bottom;
        return new DasRow(this.getCanvas(), bottom + ptop * delta, bottom + pbottom * delta);
    }

    public int getHeight() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasRow create(DasCanvas parent) {
        return new DasRow(parent, 0.1, 0.9);
    }

    public static DasRow create(DasCanvas parent, int iplot, int nplot) {
        double min = 0.1 + (double)iplot * 0.8 / (double)nplot;
        double max = 0.099 + (double)(iplot + 1) * 0.8 / (double)nplot;
        return new DasRow(parent, min, max);
    }

    public DasRow createAttachedRow(double ptop, double pbottom) {
        return new DasRow(null, this, ptop, pbottom, 0.0, 0.0, 0, 0);
    }

    public int top() {
        return this.getDMinimum();
    }

    public int bottom() {
        return this.getDMaximum();
    }

    public void setParentRow(DasRow r) {
        this.setParentDevicePosition(r);
    }

    public String getParentRowName() {
        return this.getParentDasName();
    }
}

