/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WeightsDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class HugeScatterRenderer
extends Renderer {
    protected static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.renderer.hugeScatter");
    BufferedImage plotImage;
    Rectangle plotImageBounds;
    DatumRange imageXRange;
    private Color color = Color.BLACK;
    private int ixstepLimitSq = 1000000;
    private Datum xcadence;
    private Shape selectionArea;
    int saturationHitCount = 5;
    protected int envelope = 0;
    public static final String PROP_ENVELOPE = "envelope";
    private boolean print300dpi;

    public HugeScatterRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    @Override
    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)i.getGraphics();
        DasPlot parent = this.getParent();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (parent != null) {
            g.setBackground(parent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        g.setStroke(new BasicStroke(0.5f));
        g.drawLine(2, 3, 13, 7);
        g.setStroke(stroke0);
        i.setRGB(7, 5, this.color.getRGB());
        return new ImageIcon(i);
    }

    private static QDataSet doRange(QDataSet xds) {
        boolean isLog;
        QDataSet xrange = Ops.extent((QDataSet)xds);
        if (xrange.value(1) == xrange.value(0)) {
            QDataSet wds = WeightsDataSet.applyRules((QDataSet)xds, (QDataSet)xrange);
            if (wds.value(0) * wds.value(1) == 0.0) {
                xrange = DDataSet.createRank1Bins((double)0.0, (double)10.0, (Units)SemanticOps.getUnits((QDataSet)xrange));
                return xrange;
            }
            if (!"log".equals(xrange.property("SCALE_TYPE"))) {
                Units xunits = SemanticOps.getUnits((QDataSet)xrange);
                if (UnitsUtil.isTimeLocation((Units)xunits)) {
                    Datum dx = Units.nanoseconds.createDatum(1000).convertTo(xunits.getOffsetUnits());
                    xrange = DDataSet.createRank1Bins((double)(xrange.value(0) - dx.value()), (double)(xrange.value(1) + dx.value()), (Units)xunits);
                } else {
                    xrange = DDataSet.createRank1Bins((double)(xrange.value(0) - 1.0), (double)(xrange.value(1) + 1.0), (Units)xunits);
                }
            } else {
                xrange = DDataSet.createRank1Bins((double)(xrange.value(0) / 10.0), (double)(xrange.value(1) * 10.0), (Units)SemanticOps.getUnits((QDataSet)xrange));
            }
        }
        if (!(isLog = "log".equals(xrange.property("SCALE_TYPE"))) || xrange.value(0) != 0.0) {
            xrange = Ops.rescaleRangeLogLin((QDataSet)xrange, (double)-0.1, (double)1.1);
        }
        return xrange;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        this.xcadence = null;
        super.setDataSet(ds);
    }

    private static QDataSet fastRank2Range(QDataSet ds) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
        for (int i = 0; i < ds.length(); ++i) {
            int n = ds.length(i);
            for (int j = 0; j < n; ++j) {
                double w = wds.value(i, j);
                if (!(w > 0.0)) continue;
                double d = ds.value(i, j);
                min = d < min ? d : min;
                max = d > max ? d : max;
            }
        }
        Units u = SemanticOps.getUnits((QDataSet)ds);
        DDataSet result = DDataSet.createRank1((int)2);
        result.putValue(0, min);
        result.putValue(1, max);
        result.putProperty("UNITS", (Object)u);
        return Ops.rescaleRangeLogLin((QDataSet)result, (double)-0.1, (double)1.1);
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xrange;
        QDataSet yrange;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        if (SemanticOps.isRank2Waveform((QDataSet)ds)) {
            yrange = HugeScatterRenderer.fastRank2Range(ds);
            QDataSet offsrange = HugeScatterRenderer.doRange((QDataSet)ds.property("DEPEND_1"));
            xrange = HugeScatterRenderer.doRange(xds);
            xrange = Ops.add((QDataSet)xrange, (QDataSet)offsrange);
        } else if (ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds)) {
            QDataSet vds = DataSetOps.unbundleDefaultDataSet((QDataSet)ds);
            yrange = HugeScatterRenderer.doRange(vds);
            xrange = HugeScatterRenderer.doRange(xds);
        } else {
            yrange = HugeScatterRenderer.doRange(ds);
            xrange = HugeScatterRenderer.doRange(xds);
        }
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        Units yunits;
        QDataSet vds;
        BufferedImage lplotImage;
        DasPlot parent = this.getParent();
        if (this.ds == null) {
            if (this.lastException != null) {
                if (this.lastException instanceof NoDataInIntervalException) {
                    parent.postMessage((Renderer)this, "no data in interval:!c" + this.lastException.getMessage(), DasPlot.WARNING, null, null);
                } else {
                    parent.postException(this, this.lastException);
                }
                return;
            }
            parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            return;
        }
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            lplotImage = this.plotImage;
        }
        logger.entering("org.das2.graph.HugeScatterRenderer", "render");
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)this.ds);
        if (this.ds.rank() == 2 && SemanticOps.isBundle((QDataSet)this.ds)) {
            vds = DataSetOps.unbundleDefaultDataSet((QDataSet)this.ds);
            yunits = SemanticOps.getUnits((QDataSet)vds);
        } else {
            vds = this.ds;
            yunits = SemanticOps.getUnits((QDataSet)vds);
        }
        if (!xAxis.getUnits().isConvertibleTo(SemanticOps.getUnits((QDataSet)xds))) {
            parent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
        }
        if (!yAxis.getUnits().isConvertibleTo(yunits)) {
            parent.postMessage((Renderer)this, "inconvertible yaxis units", DasPlot.INFO, null, null);
        }
        Graphics2D g2 = g1;
        if (lplotImage == null) {
            if (this.lastException != null) {
                if (this.lastException instanceof NoDataInIntervalException) {
                    parent.postMessage((Renderer)this, "no data in interval:!c" + this.lastException.getMessage(), DasPlot.WARNING, null, null);
                } else {
                    parent.postException(this, this.lastException);
                }
            } else if (this.getDataSet() == null) {
                parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            } else if (this.getDataSet().length() == 0) {
                parent.postMessage((Renderer)this, "empty data set", DasPlot.INFO, null, null);
            }
        } else {
            Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
            int x = (int)((Point2D)p).getX();
            int y = (int)((Point2D)p).getY();
            if (parent.getCanvas().isPrintingThread() && this.print300dpi) {
                AffineTransform atinv;
                AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                BufferedImage image300 = atop.filter(lplotImage, null);
                try {
                    atinv = atop.getTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
                atinv.translate(x * 4, y * 4);
                g2.drawImage(image300, atinv, this.getParent());
            } else {
                g2.drawImage((Image)lplotImage, x, y, this.getParent());
            }
        }
        logger.exiting("org.das2.graph.HugeScatterRenderer", "render");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPointsOfRank1(DasAxis xAxis, DasAxis yAxis, QDataSet ds, Rectangle plotImageBounds2) {
        int ny = plotImageBounds2.height;
        int nx = plotImageBounds2.width;
        logger.entering("org.das2.graph.HugeScatterRenderer", "renderPointsOfRank1");
        BufferedImage image = new BufferedImage(nx, ny, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f));
        g.translate(-plotImageBounds2.x, -plotImageBounds2.y);
        DatumRange visibleRange = this.imageXRange = GraphUtil.invTransformRange(xAxis, plotImageBounds2.x, plotImageBounds2.x + plotImageBounds2.width);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet vds = ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds) ? DataSetOps.unbundleDefaultDataSet((QDataSet)ds) : ds;
        boolean xmono = Boolean.TRUE == SemanticOps.isMonotonic((QDataSet)xds);
        int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min()) : 0;
        int lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1 : xds.length();
        int STATE_LINETO = -991;
        int STATE_MOVETO = -992;
        int state = -992;
        int ix0 = 0;
        int iy0 = 0;
        if (vds.length() > 0) {
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)vds);
            Units dsunits = SemanticOps.getUnits((QDataSet)vds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            if (!dsunits.isConvertibleTo(yAxis.getUnits())) {
                dsunits = yAxis.getUnits();
            }
            if (!xunits.isConvertibleTo(xAxis.getUnits())) {
                xunits = xAxis.getUnits();
            }
            int ylimit = 10000;
            if (!yAxis.isLog()) {
                Units yunits = SemanticOps.getUnits((QDataSet)vds);
                String avgType = (String)vds.property("AVERAGE_TYPE");
                if ("mod24".equals(avgType)) {
                    ylimit = (int)Math.ceil(yAxis.transform(yAxis.getDataMinimum()) - yAxis.transform(yAxis.getDataMinimum().add(24.0, yunits)));
                } else if ("mod360".equals(avgType)) {
                    ylimit = (int)Math.ceil(yAxis.transform(yAxis.getDataMinimum()) - yAxis.transform(yAxis.getDataMinimum().add(360.0, yunits)));
                }
                ylimit /= 2;
            }
            for (int i = firstIndex; i < lastIndex; ++i) {
                boolean isValid;
                boolean bl = isValid = wds.value(i) > 0.0;
                if (!isValid) {
                    state = -992;
                    continue;
                }
                int iy = (int)yAxis.transform(vds.value(i), dsunits);
                int dy = Math.abs(iy - iy0);
                int ix = (int)xAxis.transform(xds.value(i), xunits);
                if ((ix - ix0) * (ix - ix0) > this.ixstepLimitSq) {
                    state = -992;
                }
                switch (state) {
                    case -992: {
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                        break;
                    }
                    case -991: {
                        if (dy < ylimit) {
                            g.draw(new Line2D.Float(ix0, iy0, ix, iy));
                        }
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                    }
                    default: {
                        logger.log(Level.INFO, "state: {0}", state);
                    }
                }
                state = -991;
            }
        }
        logger.exiting("org.das2.graph.HugeScatterRenderer", "renderPointsOfRank1");
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            this.plotImage = image;
            this.selectionArea = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPointsOfRank2Waveform(BufferedImage image, DasAxis xAxis, DasAxis yAxis, QDataSet ds, Rectangle plotImageBounds2) {
        logger.entering("org.das2.graph.HugeScatterRenderer", "renderPointsOfRank2Waveform");
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f / (float)this.saturationHitCount));
        g.translate(-plotImageBounds2.x, -plotImageBounds2.y);
        DatumRange visibleRange = this.imageXRange = GraphUtil.invTransformRange(xAxis, plotImageBounds2.x, plotImageBounds2.x + plotImageBounds2.width);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        boolean xmono = Boolean.TRUE == SemanticOps.isMonotonic((QDataSet)xds);
        int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min()) : 0;
        int lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1 : xds.length();
        int STATE_LINETO = -991;
        int STATE_MOVETO = -992;
        int state = -992;
        int ix0 = 0;
        int iy0 = 0;
        if (xds.length() > 0) {
            ArrayDataSet xoffsets;
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
            Units dsunits = SemanticOps.getUnits((QDataSet)ds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            if (!dsunits.isConvertibleTo(yAxis.getUnits())) {
                dsunits = yAxis.getUnits();
            }
            if (!xunits.isConvertibleTo(xAxis.getUnits())) {
                xunits = xAxis.getUnits();
            }
            if (!UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)(xoffsets = ArrayDataSet.copy((QDataSet)((QDataSet)ds.property("DEPEND_1"))))))) {
                xoffsets = HugeScatterRenderer.resetUnits(xoffsets, SemanticOps.getUnits((QDataSet)xds).getOffsetUnits());
            } else {
                xds = Ops.zeros((int)xoffsets.length());
            }
            int xmin = xAxis.getColumn().getDMinimum() - xAxis.getColumn().getWidth();
            int xmax = xAxis.getColumn().getDMaximum() + xAxis.getColumn().getWidth();
            int xdmin = xAxis.getColumn().getDMinimum();
            int xdmax = xAxis.getColumn().getDMaximum();
            int ydmin = yAxis.getRow().getDMinimum();
            int ydmax = yAxis.getRow().getDMaximum();
            for (int i = firstIndex; i < lastIndex; ++i) {
                int nj = ds.length(i);
                int xoffsetsRank = xoffsets.rank();
                block8: for (int j = 0; j < nj; ++j) {
                    boolean isValid;
                    boolean bl = isValid = wds.value(i, j) > 0.0;
                    if (!isValid) {
                        state = -992;
                        continue;
                    }
                    int iy = (int)yAxis.transform(ds.value(i, j), dsunits, ydmax, ydmin);
                    int ix = xoffsetsRank == 1 ? (int)xAxis.transform(xds.value(i) + xoffsets.value(j), xunits, xdmin, xdmax) : (int)xAxis.transform(xds.value(i) + xoffsets.value(i, j), xunits, xdmin, xdmax);
                    if ((ix - ix0) * (ix - ix0) > this.ixstepLimitSq) {
                        state = -992;
                    }
                    switch (state) {
                        case -992: {
                            if (ix > xmin && ix < xmax) {
                                g.fillRect(ix, iy, 1, 1);
                            }
                            state = -991;
                            ix0 = ix;
                            iy0 = iy;
                            continue block8;
                        }
                        case -991: {
                            if (ix > xmin && ix < xmax) {
                                g.draw(new Line2D.Float(ix0, iy0, ix, iy));
                                g.fillRect(ix, iy, 1, 1);
                            }
                            ix0 = ix;
                            iy0 = iy;
                            continue block8;
                        }
                        default: {
                            logger.log(Level.INFO, "state: {0}", state);
                        }
                    }
                }
            }
        }
        logger.exiting("org.das2.graph.HugeScatterRenderer", "renderPointsOfRank2Waveform");
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            this.plotImage = image;
            this.selectionArea = null;
        }
    }

    private QDataSet convolve33(QDataSet fds, QDataSet kernel) {
        if (kernel.length() != 3 || kernel.length(0) != 3) {
            throw new IllegalArgumentException("kernel must be [3,3]");
        }
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)fds));
        for (int i = 1; i < fds.length() - 1; ++i) {
            for (int j = 1; j < fds.length(i) - 1; ++j) {
                double r = 0.0;
                r += fds.value(i - 1, j - 1);
                r += fds.value(i - 1, j);
                r += fds.value(i - 1, j + 1);
                r += fds.value(i, j - 1);
                r += fds.value(i, j);
                r += fds.value(i, j + 1);
                r += fds.value(i + 1, j - 1);
                r += fds.value(i + 1, j);
                result.putValue(i, j, r += fds.value(i + 1, j + 1));
            }
        }
        return result;
    }

    private void darkenHistogram(WritableDataSet fds) {
        logger.entering("org.das2.graph.HugeScatterRenderer", "darkenHistogram");
        QDataSet convolve = this.convolve33((QDataSet)fds, (QDataSet)DDataSet.wrap((double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, (int[])new int[]{3, 3}));
        for (int i = 0; i < fds.length(); ++i) {
            for (int j = 0; j < fds.length(i); ++j) {
                if (!(convolve.value(i, j) < (double)this.saturationHitCount) || !(fds.value(i, j) > 0.0)) continue;
                fds.putValue(i, j, (double)this.saturationHitCount);
            }
        }
        logger.exiting("org.das2.graph.HugeScatterRenderer", "darkenHistogram");
    }

    private FDataSet histogram(FDataSet tds, RebinDescriptor ddx, RebinDescriptor ddy, QDataSet ds, int firstIndex, int lastIndex) {
        logger.entering("org.das2.graph.HugeScatterRenderer", "histogram");
        ddx.setOutOfBoundsAction(-3);
        ddy.setOutOfBoundsAction(-3);
        if (ds.length() > 0) {
            int i;
            int nj;
            QDataSet vds;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
            Object xoffsets = null;
            boolean isWaveform = SemanticOps.isRank2Waveform((QDataSet)ds);
            if (ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds) && !isWaveform) {
                vds = DataSetOps.unbundleDefaultDataSet((QDataSet)ds);
            } else if (isWaveform) {
                vds = ds;
                xds = SemanticOps.xtagsDataSet((QDataSet)ds);
                isWaveform = true;
            } else {
                vds = ds;
            }
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)vds);
            if (!yunits.isConvertibleTo(ddy.getUnits())) {
                yunits = ddy.getUnits();
            }
            if (!xunits.isConvertibleTo(ddx.getUnits())) {
                xunits = ddx.getUnits();
            }
            int n = lastIndex;
            int n2 = nj = isWaveform ? vds.length(i) : 1;
            if (isWaveform) {
                HugeScatterRenderer.histogramRank2Waveform(ddx, i, n, nj, ddy, vds, yunits, tds);
            } else {
                double vfill;
                Units targetXUnits = ddx.getUnits();
                UnitsConverter xuc = xunits.getConverter(targetXUnits);
                Units targetYUnits = ddy.getUnits();
                UnitsConverter yuc = yunits.getConverter(targetYUnits);
                Number ovmin = (Number)vds.property("VALID_MIN");
                Number ovmax = (Number)vds.property("VALID_MAX");
                Number ofill = (Number)vds.property("FILL_VALUE");
                double vmax = ovmax == null ? Double.MAX_VALUE : ovmax.doubleValue();
                double vmin = ovmin == null ? -1.7976931348623157E308 : ovmin.doubleValue();
                double d = vfill = ofill == null ? Double.MAX_VALUE : ofill.doubleValue();
                if (xuc == UnitsConverter.IDENTITY && yuc == UnitsConverter.IDENTITY) {
                    for (i = firstIndex; i <= n; ++i) {
                        boolean isNotValid;
                        double v = vds.value(i);
                        boolean bl = isNotValid = v == vfill || Double.isNaN(v) || v > vmax || v < vmin;
                        if (isNotValid) continue;
                        int ix = ddx.whichBin(xds.value(i), targetXUnits);
                        int iy = ddy.whichBin(v, targetYUnits);
                        if (ix == -1 || iy == -1) continue;
                        tds.addValue(ix, iy, 1.0);
                    }
                } else {
                    while (i <= n) {
                        boolean isNotValid;
                        double v = vds.value(i);
                        boolean bl = isNotValid = v == vfill || Double.isNaN(v) || v > vmax || v < vmin;
                        if (!isNotValid) {
                            int ix = ddx.whichBin(xuc.convert(xds.value(i)), targetXUnits);
                            int iy = ddy.whichBin(yuc.convert(v), targetYUnits);
                            if (ix != -1 && iy != -1) {
                                tds.addValue(ix, iy, 1.0);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        logger.exiting("org.das2.graph.HugeScatterRenderer", "histogram");
        return tds;
    }

    private static void histogramRank2Waveform(RebinDescriptor ddx, int first0, int last0, int nj, RebinDescriptor ddy, QDataSet vds, Units yunits, FDataSet tds) throws IllegalArgumentException {
        boolean oneRecPerPixelColumn;
        int ix1;
        double dx1;
        int lastRec;
        int ix0;
        double dx0;
        logger.entering("HugeScatterRenderer", "histogramRank2Waveform");
        Object xds = (QDataSet)vds.property("DEPEND_0");
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
        ArrayDataSet xoffsets = ArrayDataSet.copy((QDataSet)((QDataSet)vds.property("DEPEND_1")));
        if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)xoffsets))) {
            dx0 = xoffsets.rank() == 1 ? xoffsets.value(0) : xoffsets.value(0, 0);
            ix0 = ddx.whichBin(dx0, xunits);
            lastRec = xoffsets.length() - 1;
            dx1 = xoffsets.rank() == 1 ? xoffsets.value(lastRec) : xoffsets.value(lastRec, xoffsets.length(lastRec) - 1);
            ix1 = ddx.whichBin(dx1, xunits);
            if (ix0 == -1 && first0 + 1 < last0) {
                ix0 = ddx.whichBin(dx0, xunits);
                ix1 = ddx.whichBin(dx1, xunits);
            }
            boolean bl = oneRecPerPixelColumn = ix0 != -1 && ix0 == ix1;
            xds = oneRecPerPixelColumn ? Ops.slice1((QDataSet)xoffsets, (int)0) : Ops.zeros((int)xoffsets.length());
        } else {
            UnitsConverter uc = UnitsConverter.getConverter((Units)SemanticOps.getUnits((QDataSet)xoffsets), (Units)SemanticOps.getUnits((QDataSet)xds).getOffsetUnits());
            if (!uc.equals(UnitsConverter.IDENTITY)) {
                logger.fine("units should have been converted by now");
                xoffsets = ArrayDataSet.maybeCopy((QDataSet)Ops.convertUnitsTo((QDataSet)xoffsets, (Units)SemanticOps.getUnits((QDataSet)xds).getOffsetUnits()));
            }
            dx0 = xoffsets.rank() == 1 ? xoffsets.value(0) : xoffsets.value(0, 0);
            ix0 = ddx.whichBin(xds.value(first0) + dx0, xunits);
            lastRec = xoffsets.length() - 1;
            dx1 = xoffsets.rank() == 1 ? xoffsets.value(lastRec) : xoffsets.value(lastRec, xoffsets.length(lastRec) - 1);
            ix1 = ddx.whichBin(xds.value(first0) + dx1, xunits);
            if (ix0 == -1 && first0 + 1 < last0) {
                ix0 = ddx.whichBin(xds.value(first0 + 1) + dx0, xunits);
                ix1 = ddx.whichBin(xds.value(first0 + 1) + dx1, xunits);
            }
            boolean bl = oneRecPerPixelColumn = ix0 != -1 && ix0 == ix1;
        }
        if (oneRecPerPixelColumn) {
            logger.fine("wowReduce");
            while (first0 <= last0) {
                int ix = ddx.whichBin(xds.value(first0), xunits);
                if (ix != -1) {
                    for (int j = 0; j < nj; ++j) {
                        int iy;
                        boolean isValid;
                        boolean bl = isValid = wds.value(first0, j) > 0.0;
                        if (!isValid || (iy = ddy.whichBin(vds.value(first0, j), yunits)) == -1) continue;
                        double d = tds.value(ix, iy);
                        tds.putValue(ix, iy, d + 1.0);
                    }
                }
                ++first0;
            }
        } else {
            Units targetXUnits = ddx.getUnits();
            UnitsConverter xuc = xunits.getConverter(targetXUnits);
            Units targetYUnits = ddy.getUnits();
            UnitsConverter yuc = yunits.getConverter(targetYUnits);
            int xoffsetsRank = xoffsets.rank();
            while (first0 <= last0) {
                for (int j = 0; j < nj; ++j) {
                    int iy;
                    int ix;
                    boolean isValid;
                    boolean bl = isValid = wds.value(first0, j) > 0.0;
                    if (!isValid) continue;
                    if (xoffsetsRank == 1) {
                        ix = ddx.whichBin(xuc.convert(xds.value(first0) + xoffsets.value(j)), targetXUnits);
                        iy = ddy.whichBin(yuc.convert(vds.value(first0, j)), targetYUnits);
                    } else {
                        ix = ddx.whichBin(xuc.convert(xds.value(first0) + xoffsets.value(first0, j)), targetXUnits);
                        iy = ddy.whichBin(yuc.convert(vds.value(first0, j)), targetYUnits);
                    }
                    if (ix == -1 || iy == -1) continue;
                    double d = tds.value(ix, iy);
                    tds.putValue(ix, iy, d + 1.0);
                }
                ++first0;
            }
        }
        logger.exiting("HugeScatterRenderer", "histogramRank2Waveform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderHistogram(BufferedImage plotImage1, DasAxis xAxis, DasAxis yAxis, QDataSet ds, Rectangle plotImageBounds2) {
        logger.entering("org.das2.graph.HugeScatterRenderer", "renderHistogram");
        DatumRange xrange = GraphUtil.invTransformRange(xAxis, plotImageBounds2.x, plotImageBounds2.x + plotImageBounds2.width);
        DatumRange yrange = GraphUtil.invTransformRange(yAxis, plotImageBounds2.y + plotImageBounds2.height, plotImageBounds2.y);
        RebinDescriptor ddx = new RebinDescriptor(xrange.min(), xrange.max(), plotImageBounds2.width, xAxis.isLog());
        RebinDescriptor ddy = new RebinDescriptor(yrange.min(), yrange.max(), plotImageBounds2.height, yAxis.isLog());
        FDataSet tds = FDataSet.createRank2((int)ddx.numberOfBins(), (int)ddy.numberOfBins());
        if (SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)ds)) {
            for (int k = 0; k < ds.length(); ++k) {
                int lastIndex;
                QDataSet ds1 = ds.slice(k);
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds1);
                xds.slice(0);
                boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
                int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)ddx.binStart(0)) : 0;
                int n = lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)ddx.binStop(ddx.numberOfBins() - 1)) : ds1.length() - 1;
                if (lastIndex >= firstIndex) {
                    tds = this.histogram(tds, ddx, ddy, ds1, firstIndex, lastIndex);
                    continue;
                }
                logger.fine("dropping record because it is off screen");
            }
        } else {
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
            boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
            int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)ddx.binStart(0)) : 0;
            int lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)ddx.binStop(ddx.numberOfBins() - 1)) : ds.length() - 1;
            tds = this.histogram(tds, ddx, ddy, ds, firstIndex, lastIndex);
        }
        FDataSet newHist = tds;
        if (yAxis.isFlipped() && xAxis.isFlipped()) {
            newHist = DataSetOps.applyIndex((QDataSet)newHist, (int)1, (QDataSet)Ops.linspace((double)(newHist.length(0) - 1), (double)0.0, (int)newHist.length(0)), (boolean)false);
            newHist = DataSetOps.applyIndex((QDataSet)newHist, (int)0, (QDataSet)Ops.linspace((double)(newHist.length() - 1), (double)0.0, (int)newHist.length()), (boolean)false);
        } else if (yAxis.isFlipped()) {
            newHist = DataSetOps.applyIndex((QDataSet)newHist, (int)1, (QDataSet)Ops.linspace((double)(newHist.length(0) - 1), (double)0.0, (int)newHist.length(0)), (boolean)false);
        } else if (xAxis.isFlipped()) {
            newHist = DataSetOps.applyIndex((QDataSet)newHist, (int)0, (QDataSet)Ops.linspace((double)(newHist.length() - 1), (double)0.0, (int)newHist.length()), (boolean)false);
        }
        int h = ddy.numberOfBins();
        int w = ddx.numberOfBins();
        logger.log(Level.FINE, "ghostlyImage: h={0} w={1}", new Object[]{h, w});
        int[] raster = new int[h * w];
        int colorInt = this.color.getRGB() & 0xFFFFFF;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
        int envelopeColor = Integer.MIN_VALUE | colorInt;
        if (this.envelope == 1) {
            envelopeColor = 128 / this.saturationHitCount << 24 | colorInt;
        }
        for (int i = 0; i < w; ++i) {
            int j;
            int ymin = -1;
            int ymax = -1;
            for (j = 0; j < h; ++j) {
                if (!(newHist.value(i, j) > 0.0)) continue;
                if (ymin < 0) {
                    ymin = j;
                }
                ymax = j;
            }
            if (ymin < 0) continue;
            for (j = ymin; j <= ymax; ++j) {
                int index = i + (h - j - 1) * w;
                if (!xmono || this.envelope != 2 && (this.envelope == 0 || newHist.value(i, j) > 0.0)) {
                    int alpha = 255 * (int)newHist.value(i, j) / this.saturationHitCount;
                    if (alpha > 255) {
                        alpha = 255;
                    }
                    raster[index] = alpha << 24 | colorInt;
                    continue;
                }
                raster[index] = envelopeColor;
            }
        }
        WritableRaster r = plotImage1.getRaster();
        r.setDataElements(0, 0, w, h, raster);
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            this.plotImage = plotImage1;
            this.selectionArea = null;
        }
        this.imageXRange = xrange;
        logger.exiting("org.das2.graph.HugeScatterRenderer", "renderHistogram");
    }

    @Override
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        int lastIndex;
        int firstIndex;
        logger.entering("org.das2.graph.HugeScatterRenderer", "updatePlotImage");
        long t0 = System.currentTimeMillis();
        super.incrementUpdateCount();
        super.updatePlotImage(xAxis, yAxis, monitor);
        QDataSet ds1 = this.getDataSet();
        Datum xcad = this.xcadence;
        if (ds1 == null) {
            return;
        }
        QDataSet xds = ds1.rank() == 3 ? SemanticOps.xtagsDataSet((QDataSet)ds1.slice(0)) : SemanticOps.xtagsDataSet((QDataSet)ds1);
        DasPlot parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (!xAxis.getUnits().isConvertibleTo(SemanticOps.getUnits((QDataSet)xds))) {
            parent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
        }
        if (!yAxis.getUnits().isConvertibleTo(SemanticOps.getUnits((QDataSet)ds1))) {
            parent.postMessage((Renderer)this, "inconvertible yaxis units", DasPlot.INFO, null, null);
        }
        this.plotImageBounds = parent.getUpdateImageBounds();
        DatumRange visibleRange = xAxis.getDatumRange();
        boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
        if (ds1.rank() == 3) {
            xmono = false;
        }
        if (xmono) {
            try {
                firstIndex = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
                lastIndex = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max());
            }
            catch (InconvertibleUnitsException ex) {
                parent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
                logger.exiting("org.das2.graph.HugeScatterRenderer", "updatePlotImage");
                return;
            }
            if (xAxis.isLog()) {
                this.ixstepLimitSq = 100000000;
            } else {
                DRank0DataSet d;
                if (xcad != null) {
                    d = DataSetUtil.asDataSet((Datum)xcad);
                } else {
                    QDataSet dep1;
                    d = SemanticOps.isRank2Waveform((QDataSet)ds1) ? ((dep1 = (QDataSet)ds1.property("DEPEND_1")).rank() == 1 ? DataSetUtil.guessCadenceNew((QDataSet)dep1, null) : DataSetUtil.guessCadenceNew((QDataSet)dep1.slice(0), null)) : (ds1.rank() == 3 && SemanticOps.isRank2Waveform((QDataSet)ds1.slice(0)) ? DataSetUtil.guessCadenceNew((QDataSet)((QDataSet)ds1.slice(0).property("DEPEND_1")), null) : DataSetUtil.guessCadenceNew((QDataSet)xds, (QDataSet)ds1));
                    this.xcadence = d == null ? null : DataSetUtil.asDatum((RankZeroDataSet)d);
                }
                logger.log(Level.FINER, "xcadence={0}", this.xcadence);
                if (d != null) {
                    int ixstepLimit;
                    Datum sw = DataSetUtil.asDatum((RankZeroDataSet)d);
                    Datum xmax = xAxis.getDataMaximum();
                    if (UnitsUtil.isRatiometric((Units)sw.getUnits())) {
                        try {
                            ixstepLimit = 1 + (int)(xAxis.transform(xmax) - xAxis.transform(xmax.divide(sw)));
                        }
                        catch (IllegalArgumentException ex) {
                            ixstepLimit = 1;
                        }
                    } else {
                        ixstepLimit = 1 + (int)(xAxis.transform(xmax) - xAxis.transform(xmax.subtract(sw)));
                    }
                    this.ixstepLimitSq = ixstepLimit * ixstepLimit;
                } else {
                    this.ixstepLimitSq = 100000000;
                }
            }
        } else {
            firstIndex = 0;
            lastIndex = ds1.length();
            this.ixstepLimitSq = 100000000;
        }
        int nj = 1;
        if (SemanticOps.isRank2Waveform((QDataSet)ds1)) {
            nj = ds1.length(0);
        } else if (SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)ds1)) {
            nj = ds1.length(0, 0);
            for (int k = 1; k < ds1.length(); ++k) {
                nj += ds1.length(k, 0);
            }
        }
        int ny = this.plotImageBounds.height;
        int nx = this.plotImageBounds.width;
        BufferedImage image = new BufferedImage(nx, ny, 2);
        if (nj * (lastIndex - firstIndex) > 20 * xAxis.getColumn().getWidth()) {
            if (lastIndex == firstIndex + 1) {
                this.renderPointsOfRank2Waveform(image, xAxis, yAxis, ds1, this.plotImageBounds);
            } else {
                this.renderHistogram(image, xAxis, yAxis, ds1, this.plotImageBounds);
            }
        } else if (SemanticOps.isRank2Waveform((QDataSet)ds1)) {
            this.renderPointsOfRank2Waveform(image, xAxis, yAxis, ds1, this.plotImageBounds);
        } else if (ds1.rank() == 3) {
            for (int k = 0; k < ds1.length(); ++k) {
                this.renderPointsOfRank2Waveform(image, xAxis, yAxis, ds1.slice(k), this.plotImageBounds);
            }
        } else if (ds1.rank() == 1 || ds1.rank() == 2 && SemanticOps.isBundle((QDataSet)ds1)) {
            this.renderPointsOfRank1(xAxis, yAxis, ds1, this.plotImageBounds);
        } else {
            parent.postMessage((Renderer)this, "dataset must be rank 1, rank 2 waveform, or rank 2 bundle", DasPlot.INFO, null, null);
        }
        logger.log(Level.FINE, "done updatePlotImage {0} ms", System.currentTimeMillis() - t0);
        logger.exiting("org.das2.graph.HugeScatterRenderer", "updatePlotImage");
    }

    public void setSaturationHitCount(int d) {
        if (d > 10) {
            d = 10;
        }
        this.saturationHitCount = d;
        this.update();
    }

    public int getSaturationHitCount() {
        return this.saturationHitCount;
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateCacheImage();
    }

    public Color getColor() {
        return this.color;
    }

    public int getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(int envelope) {
        int oldEnvelope = this.envelope;
        this.envelope = envelope;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_ENVELOPE, oldEnvelope, envelope);
    }

    @Override
    public boolean acceptContext(int x, int y) {
        BufferedImage im = this.getPlotImage();
        if (im == null) {
            return false;
        }
        Shape s = this.selectionArea();
        return s.contains(x, y);
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }

    private synchronized BufferedImage getPlotImage() {
        return this.plotImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcSelectionArea() {
        BufferedImage lplotImage = this.getPlotImage();
        logger.finer("in calc selection area");
        long t0 = System.currentTimeMillis();
        if (lplotImage == null) {
            return;
        }
        int w = lplotImage.getWidth();
        int h = lplotImage.getHeight();
        DasPlot parent = this.getParent();
        int imagex = (int)parent.getCacheImageBounds().getX();
        int parentx = parent.getX();
        int dx = parent.getColumn().getDMinimum() - imagex;
        int parenty = (int)parent.getCacheImageBounds().getY();
        int overx = imagex - parentx;
        GeneralPath result = new GeneralPath();
        int d = 5;
        int dd = 5;
        if (w * h > 100000) {
            d = 10;
            dd = 10;
        }
        if (w * h > 500000) {
            d = 30;
        }
        for (int i = 0; i < w; i += d) {
            for (int j = 0; j < h; j += d) {
                int n = 0;
                int x = 0;
                int y = 0;
                for (int ii = 0; ii < d; ++ii) {
                    for (int jj = 0; jj < d; ++jj) {
                        if (i + ii >= w || j + jj >= h || (lplotImage.getRGB(i + ii, j + jj) & 0xFF000000) == 0) continue;
                        ++n;
                        x += ii;
                        y += jj;
                    }
                }
                if (n <= 0) continue;
                result.append(new Rectangle(2 * overx + i + x / n + parentx - dd / 2 + dx, j + y / n + parenty - dd / 2, dd, dd), true);
            }
        }
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            this.selectionArea = result;
        }
        logger.log(Level.FINER, "done in calc selection area {0}ms", System.currentTimeMillis() - t0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape selectionArea() {
        Shape localSelectionArea;
        HugeScatterRenderer hugeScatterRenderer = this;
        synchronized (hugeScatterRenderer) {
            localSelectionArea = this.selectionArea;
        }
        if (localSelectionArea == null) {
            this.calcSelectionArea();
            hugeScatterRenderer = this;
            synchronized (hugeScatterRenderer) {
                localSelectionArea = this.selectionArea;
            }
        }
        return localSelectionArea == null ? SelectionUtil.NULL : localSelectionArea;
    }

    private static ArrayDataSet resetUnits(ArrayDataSet xoffsets, Units offsetUnits) {
        UnitsConverter uc = UnitsConverter.getConverter((Units)SemanticOps.getUnits((QDataSet)xoffsets), (Units)offsetUnits);
        if (!uc.equals(UnitsConverter.IDENTITY)) {
            switch (xoffsets.rank()) {
                case 2: {
                    for (int j = 0; j < xoffsets.length(); ++j) {
                        for (int k = 0; k < xoffsets.length(j); ++k) {
                            xoffsets.putValue(j, k, uc.convert(xoffsets.value(j, k)));
                        }
                    }
                    break;
                }
                case 1: {
                    for (int j = 0; j < xoffsets.length(); ++j) {
                        xoffsets.putValue(j, uc.convert(xoffsets.value(j)));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DEPEND_1 must be rank 1 or rank 2");
                }
            }
            xoffsets.putProperty("UNITS", (Object)offsetUnits);
        }
        return xoffsets;
    }
}

