/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.LinkedHashMap;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.GrannyTextRenderer;

public class PolyMeshRenderer
extends Renderer {
    private Color color = Color.LIGHT_GRAY;
    private double lineThick = 1.0;
    private boolean fill = true;
    private String fillTexture = "";
    private PsymConnector lineStyle = PsymConnector.SOLID;

    public static boolean acceptsData(QDataSet ds) {
        if (ds.rank() == 1) {
            QDataSet tris = (QDataSet)ds.property("DEPEND_0");
            if (tris == null) {
                return false;
            }
            return Schemes.isPolyMesh((QDataSet)tris);
        }
        return Schemes.isPolyMesh((QDataSet)ds);
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet tris = ds.rank() == 1 ? (QDataSet)ds.property("DEPEND_0") : ds;
        QDataSet xy = tris.slice(0);
        QDataSet xrange = Ops.extent((QDataSet)Ops.slice1((QDataSet)xy, (int)0));
        QDataSet yrange = Ops.extent((QDataSet)Ops.slice1((QDataSet)xy, (int)1));
        xrange = Ops.rescaleRangeLogLin((QDataSet)xrange, (double)-0.1, (double)1.1);
        yrange = Ops.rescaleRangeLogLin((QDataSet)yrange, (double)-0.1, (double)1.1);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.color = this.getColorControl("color", this.color);
        this.lineThick = this.getDoubleControl("lineThick", this.lineThick);
        this.fill = this.getBooleanControl("fill", this.fill);
        this.fillTexture = this.getControl("fillTexture", this.fillTexture);
        this.lineStyle = PolyMeshRenderer.decodePlotSymbolConnectorControl(this.getControl("lineStyle", PolyMeshRenderer.encodePlotSymbolConnectorControl(this.lineStyle)), this.lineStyle);
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("color", PolyMeshRenderer.encodeColorControl(this.color));
        controls.put("lineThick", String.valueOf(this.lineThick));
        controls.put("fill", PolyMeshRenderer.encodeBooleanControl(this.fill));
        controls.put("fillTexture", this.fillTexture);
        controls.put("lineStyle", PolyMeshRenderer.encodePlotSymbolConnectorControl(this.lineStyle));
        return PolyMeshRenderer.formatControl(controls);
    }

    @Override
    public void render(Graphics2D g, DasAxis xaxis, DasAxis yaxis) {
        QDataSet dependentVariable;
        QDataSet xy;
        QDataSet tri;
        QDataSet ds = this.getDataSet();
        if (ds == null) {
            return;
        }
        if (Schemes.isPolyMesh((QDataSet)ds)) {
            tri = ds.slice(1);
            xy = ds.slice(0);
            dependentVariable = null;
        } else {
            dependentVariable = ds;
            if ((ds = (QDataSet)ds.property("DEPEND_0")) == null || !Schemes.isPolyMesh((QDataSet)ds)) {
                throw new IllegalArgumentException("expected DEPEND_0 to be a polyMesh");
            }
            tri = ds.slice(1);
            xy = ds.slice(0);
        }
        g.setColor(this.color);
        double[] xx = new double[xy.length()];
        double[] yy = new double[xy.length()];
        Units xunits = SemanticOps.getUnits((QDataSet)xy.slice(0).slice(0));
        Units yunits = SemanticOps.getUnits((QDataSet)xy.slice(0).slice(1));
        for (int i = 0; i < xy.length(); ++i) {
            xx[i] = xaxis.transform(xy.value(i, 0), xunits);
            yy[i] = yaxis.transform(xy.value(i, 1), yunits);
        }
        Color[] cc = null;
        String[] ss = null;
        if (dependentVariable != null) {
            int i;
            Units zunits = SemanticOps.getUnits((QDataSet)dependentVariable);
            if (zunits == Units.rgbColor) {
                cc = new Color[tri.length()];
                for (i = 0; i < cc.length; ++i) {
                    cc[i] = new Color((int)dependentVariable.value(i));
                }
            } else {
                ss = new String[tri.length()];
                for (i = 0; i < ss.length; ++i) {
                    ss[i] = DataSetUtil.toString((QDataSet)dependentVariable.slice(i));
                }
            }
        } else {
            cc = new Color[tri.length()];
            for (int i = 0; i < cc.length; ++i) {
                cc[i] = this.color;
            }
        }
        g.setStroke(this.lineStyle.getStroke((float)this.lineThick));
        for (int i = 0; i < tri.length(); ++i) {
            QDataSet tri1 = tri.slice(i);
            if (cc != null) {
                g.setColor(cc[i]);
                GeneralPath gp = new GeneralPath();
                int k = (int)tri1.value(tri1.length() - 1);
                gp.moveTo(xx[k], yy[k]);
                for (int j = 0; j < tri1.length(); ++j) {
                    k = (int)tri1.value(j);
                    gp.lineTo(xx[k], yy[k]);
                }
                if (this.fill) {
                    if (this.fillTexture.length() > 0) {
                        GraphUtil.fillWithTexture(g, gp, cc[i], this.fillTexture);
                    } else {
                        g.fill(gp);
                    }
                }
                if (this.lineStyle == PsymConnector.NONE) continue;
                g.draw(gp);
                continue;
            }
            if (ss == null) continue;
            double x = 0.0;
            double y = 0.0;
            for (int j = 0; j < tri1.length(); ++j) {
                int k = (int)tri1.value(j);
                x += xx[k];
                y += yy[k];
            }
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString((Graphics)g, ss[i]);
            gtr.draw((Graphics)g, (float)((int)((x /= (double)tri1.length()) - gtr.getWidth() / 2.0)), (float)((int)((y /= (double)tri1.length()) + gtr.getAscent() / 2.0)));
        }
    }
}

