/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.DataLoader;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.Painter;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.XAxisDataLoader;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public abstract class Renderer
implements DataSetConsumer,
Editable,
Displayable {
    protected static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.renderer");
    String dataSetId;
    protected QDataSet ds;
    private DasAxis.Memento xmemento;
    private DasAxis.Memento ymemento;
    private DasPlot parent;
    DataLoader loader;
    protected Exception lastException;
    protected Exception renderException;
    protected int firstValidIndex = -1;
    protected int lastValidIndex = -1;
    private static final String PROPERTY_ACTIVE = "active";
    private static final String PROPERTY_DATASET = "dataSet";
    protected Set<String> needWorkMarkers = Collections.synchronizedSet(new HashSet());
    protected final String MARKER_DATASET = "dataset";
    protected final String MARKER_X_AXIS_RANGE = "xaxisRange";
    protected final String MARKER_Y_AXIS_RANGE = "yaxisRange";
    private boolean dumpDataSet;
    protected Painter bottomDecorator = null;
    public static final String PROP_BOTTOMDECORATOR = "bottomDecorator";
    protected Painter topDecorator = null;
    public static final String PROP_TOPDECORATOR = "topDecorator";
    public static final String CONTROL_KEY_COLOR = "color";
    public static final String CONTROL_KEY_FILL_COLOR = "fillColor";
    public static final String CONTROL_KEY_FILL_DIRECTION = "fillDirection";
    public static final String CONTROL_KEY_COLOR_TABLE = "colorTable";
    public static final String CONTROL_KEY_LINE_THICK = "lineThick";
    public static final String CONTROL_KEY_LINE_STYLE = "lineStyle";
    public static final String CONTROL_KEY_SYMBOL = "symbol";
    public static final String CONTROL_KEY_SYMBOL_SIZE = "symbolSize";
    public static final String CONTROL_KEY_SPECIAL_COLORS = "specialColors";
    public static final String CONTROL_KEY_FILL_TEXTURE = "fillTexture";
    public static final String CONTROL_KEY_FONT_SIZE = "fontSize";
    public static final String CONTROL_KEY_REFERENCE = "reference";
    public static final String CONTROL_KEY_DRAW_ERROR = "drawError";
    public static final String CONTROL_KEY_MODULO_Y = "moduloY";
    public static final String CONTROL_KEY_MODULO_X = "moduloX";
    public static final String PROP_CONTROL = "control";
    protected String control = "";
    private Map<String, String> controls = Collections.emptyMap();
    public static final String PROP_ACTIVE = "active";
    private boolean active = true;
    public static final String PROP_LEGENDLABEL = "legendLabel";
    protected String legendLabel = "";
    protected boolean drawLegendLabel = false;
    public static final String PROP_DRAWLEGENDLABEL = "drawLegendLabel";
    protected String id = "rend";
    public static final String PROP_ID = "id";
    public static final String PROP_COLORBAR = "colorBar";
    protected DasColorBar colorBar;
    private final AtomicInteger renderCount = new AtomicInteger(0);
    private final AtomicInteger updateCount = new AtomicInteger(0);
    private String recordFile = "";
    private PrintStream recordStream = null;
    public static final String PROP_RECORDFILE = "recordFile";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected Renderer(DataSetDescriptor dsd) {
        this.loader = new XAxisDataLoader(this, dsd);
    }

    protected Renderer(QDataSet ds) {
        this.ds = ds;
        this.loader = null;
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    public DasPlot getParent() {
        return this.parent;
    }

    public void setParent(DasPlot parent) {
        this.parent = parent;
    }

    public DasAxis.Memento getXmemento() {
        return this.xmemento;
    }

    public DasAxis.Memento getYmemento() {
        return this.ymemento;
    }

    public void postMessage(String message, int messageType, Datum x, Datum y) {
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        lparent.postMessage(this, message, messageType, x, y);
    }

    public void postMessage(String message, Level messageLevel, Datum x, Datum y) {
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        lparent.postMessage(this, message, messageLevel, x, y);
    }

    public void postException(Exception exception) {
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        lparent.postException(this, exception);
    }

    public static boolean isTableDataSet(QDataSet ds) {
        return SemanticOps.isTableDataSet((QDataSet)ds);
    }

    private void updateFirstLastValid() {
        if (this.ds == null || this.ds.rank() == 0) {
            this.firstValidIndex = 0;
            this.lastValidIndex = 0;
        } else if (SemanticOps.isTableDataSet((QDataSet)this.ds)) {
            this.firstValidIndex = 0;
            this.lastValidIndex = this.ds.length();
        } else if (SemanticOps.isSimpleBundleDataSet((QDataSet)this.ds)) {
            this.firstValidIndex = 0;
            this.lastValidIndex = this.ds.length();
        } else {
            this.firstValidIndex = -1;
            this.lastValidIndex = -1;
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)this.ds);
            if (wds.rank() == 1) {
                int i;
                for (i = 0; this.firstValidIndex == -1 && i < this.ds.length(); ++i) {
                    if (!(wds.value(i) > 0.0)) continue;
                    this.firstValidIndex = i;
                }
                for (i = this.ds.length() - 1; this.lastValidIndex == -1 && i >= 0; --i) {
                    if (!(wds.value(i) > 0.0)) continue;
                    this.lastValidIndex = i + 1;
                }
            } else {
                this.firstValidIndex = 0;
                this.lastValidIndex = wds.length();
            }
        }
    }

    protected void invalidateParentCacheImage() {
        DasPlot lparent = this.parent;
        if (lparent != null) {
            lparent.invalidateCacheImage();
        }
    }

    public QDataSet getDataSet() {
        return this.ds;
    }

    protected QDataSet getInternalDataSet() {
        return this.getDataSet();
    }

    @Override
    public QDataSet getConsumedDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean dumpDataSet) {
        this.dumpDataSet = dumpDataSet;
        if (dumpDataSet) {
            try {
                if (this.ds == null) {
                    this.setDumpDataSet(false);
                    throw new DasException("data set is null");
                }
                JFileChooser chooser = new JFileChooser();
                int xx = chooser.showSaveDialog(this.getParent());
                if (xx == 0) {
                    File file = chooser.getSelectedFile();
                    if (Renderer.isTableDataSet(this.ds)) {
                        TableUtil.dumpToAsciiStream((TableDataSet)DataSetAdapter.createLegacyDataSet(this.ds), new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)DataSetAdapter.createLegacyDataSet(this.ds), new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set: " + this.ds);
                    }
                }
                this.setDumpDataSet(false);
            }
            catch (HeadlessException | FileNotFoundException | DasException e) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)e);
            }
            this.dumpDataSet = dumpDataSet;
        }
    }

    public Painter getBottomDecorator() {
        return this.bottomDecorator;
    }

    public void setBottomDecorator(Painter bottomDecorator) {
        Painter oldBottomDecorator = this.topDecorator;
        this.bottomDecorator = bottomDecorator;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_BOTTOMDECORATOR, oldBottomDecorator, bottomDecorator);
    }

    public Painter getTopDecorator() {
        return this.topDecorator;
    }

    public void setTopDecorator(Painter topDecorator) {
        Painter oldTopDecorator = this.topDecorator;
        this.topDecorator = topDecorator;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_TOPDECORATOR, oldTopDecorator, topDecorator);
    }

    public void setLastException(Exception e) {
        logger.log(Level.FINE, "Renderer.setLastException {0}: {1}", new Object[]{this.id, String.valueOf(e)});
        this.renderException = this.lastException = e;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public boolean acceptsDataSet(QDataSet ds) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSet(QDataSet ds) {
        logger.log(Level.FINE, "Renderer.setDataSet {0}: {1}", new Object[]{this.id, String.valueOf(ds)});
        QDataSet oldDs = this.ds;
        boolean update = this.lastException != null || oldDs != ds;
        this.lastException = null;
        this.renderException = null;
        if (update) {
            Renderer renderer = this;
            synchronized (renderer) {
                this.updateFirstLastValid();
                this.ds = ds;
            }
            this.needWorkMarkers.add("dataset");
            this.update();
            this.invalidateParentCacheImage();
            this.propertyChangeSupport.firePropertyChange(PROPERTY_DATASET, oldDs, ds);
        }
    }

    public void setException(Exception e) {
        logger.log(Level.FINE, "Renderer.setException {0}: {1}", new Object[]{this.id, String.valueOf(e)});
        Exception oldException = this.lastException;
        this.renderException = this.lastException = e;
        if (this.parent != null && oldException != e) {
            this.update();
            this.invalidateParentCacheImage();
        }
    }

    public void setDataSetID(String id) throws DasException {
        if (id == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (id.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        try {
            DataSetDescriptor dsd = DataSetDescriptor.create(id);
            this.setDataSetDescriptor(dsd);
        }
        catch (DasException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getDataSetID() {
        if (this.getDataSetDescriptor() == null) {
            return "";
        }
        return this.getDataSetDescriptor().getDataSetID();
    }

    public void setControl(String s) {
        String oldValue = this.control;
        this.control = s;
        if (oldValue == s || oldValue != null && oldValue.equals(s)) {
            return;
        }
        this.controls = Renderer.parseControl(s);
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROL, oldValue, this.control);
    }

    public String getControl() {
        return this.control;
    }

    public static String formatControl(Map<String, String> c) {
        StringBuilder result = new StringBuilder(50);
        String ampstr = "&";
        for (Map.Entry<String, String> ee : c.entrySet()) {
            if (ee.getKey().contains("&")) {
                throw new IllegalArgumentException("keys must be java identifiers");
            }
            if (!ee.getValue().contains("&")) continue;
            ampstr = "&amp;";
        }
        boolean amp = false;
        for (Map.Entry<String, String> ee : c.entrySet()) {
            if (amp) {
                result.append(ampstr);
            } else {
                amp = true;
            }
            result.append(ee.getKey()).append("=").append(ee.getValue());
        }
        return result.toString();
    }

    public static Map<String, String> parseControl(String c) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (c == null) {
            return result;
        }
        String ampstr = "&";
        if (c.contains("&amp;")) {
            ampstr = "&amp;";
        }
        if (c.trim().length() == 0) {
            return result;
        }
        String[] ss = c.split(ampstr);
        if (ss.length == 1) {
            ss = c.split(";");
        }
        for (String s : ss) {
            if (s.trim().length() == 0) continue;
            String[] ss2 = s.split("=", 2);
            if (ss2.length == 1) {
                result.put(ss2[0].trim(), "T");
                continue;
            }
            String k = ss2[0].trim();
            String v = ss2[1].trim();
            result.put(k, v);
        }
        return result;
    }

    public String getControl(String key, String deft) {
        if (this.control.trim().length() == 0) {
            return deft;
        }
        String v = this.controls.get(key);
        if (v != null) {
            return v;
        }
        return deft;
    }

    public boolean hasControl(String key) {
        if (this.control.trim().length() == 0) {
            return false;
        }
        return this.controls.containsKey(key);
    }

    public boolean getBooleanControl(String key, boolean deft) {
        String v = this.controls.get(key);
        if (v != null) {
            return v.equalsIgnoreCase("T");
        }
        return deft;
    }

    public static String encodeBooleanControl(boolean v) {
        return v ? "T" : "F";
    }

    public double getDoubleControl(String key, double deft) {
        String v = this.controls.get(key);
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "Unable to parse as double: {0}", key);
                return deft;
            }
        }
        return deft;
    }

    public int getIntegerControl(String key, int deft) {
        String v = this.controls.get(key);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "Unable to parse as int: {0}", key);
                return deft;
            }
        }
        return deft;
    }

    public double[] getDoubleArrayControl(String key, double[] deft) {
        String v = this.controls.get(key);
        if (v != null) {
            try {
                String[] ss = v.split(",");
                double[] result = new double[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    result[i] = Double.parseDouble(ss[i]);
                }
                return result;
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "Unable to parse as double array: {0}", key);
                return deft;
            }
        }
        return deft;
    }

    public Datum getDatumControl(String key, Datum deft) {
        String v = this.controls.get(key);
        if (v != null) {
            try {
                return deft.getUnits().parse(key);
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "Unable to parse as datum: {0}", key);
                return deft;
            }
        }
        return deft;
    }

    public Color getColorControl(String key, Color deft) {
        String v = this.controls.get(key);
        if (v != null) {
            try {
                return ColorUtil.decodeColor((String)v);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "Unable to parse as color: {0}", v);
                return deft;
            }
        }
        return deft;
    }

    public static String encodeColorControl(Color color) {
        return ColorUtil.encodeColor((Color)color);
    }

    public static String encodePlotSymbolControl(PlotSymbol psym) {
        return psym.toString().toLowerCase();
    }

    public static PlotSymbol decodePlotSymbolControl(String s, PlotSymbol deflt) {
        switch (s = s.toUpperCase()) {
            case "NONE": {
                return DefaultPlotSymbol.NONE;
            }
            case "CIRCLES": {
                return DefaultPlotSymbol.CIRCLES;
            }
            case "TRIANGLES": {
                return DefaultPlotSymbol.TRIANGLES;
            }
            case "CROSS": {
                return DefaultPlotSymbol.CROSS;
            }
            case "EX": {
                return DefaultPlotSymbol.EX;
            }
            case "STAR": {
                return DefaultPlotSymbol.STAR;
            }
            case "DIAMOND": {
                return DefaultPlotSymbol.DIAMOND;
            }
            case "BOX": {
                return DefaultPlotSymbol.BOX;
            }
            case "TRIANGLESEAST": {
                return DefaultPlotSymbol.TRIANGLES_EAST;
            }
            case "TRIANGLESNORTH": {
                return DefaultPlotSymbol.TRIANGLES_NORTH;
            }
            case "TRIANGLESWEST": {
                return DefaultPlotSymbol.TRIANGLES_WEST;
            }
            case "TRIANGLESSOUTH": {
                return DefaultPlotSymbol.TRIANGLES_SOUTH;
            }
        }
        logger.log(Level.FINE, "unable to parse symbol: {0}", deflt);
        return deflt;
    }

    public static String encodePlotSymbolConnectorControl(PsymConnector psymConnector) {
        return psymConnector.toString();
    }

    public static PsymConnector decodePlotSymbolConnectorControl(String s, PsymConnector deflt) {
        switch (s = s.toUpperCase()) {
            case "NONE": {
                return PsymConnector.NONE;
            }
            case "DASHES": {
                return PsymConnector.DASHES;
            }
            case "DASHFINE": {
                return PsymConnector.DASHFINE;
            }
            case "DOTDASHES": {
                return PsymConnector.DOTDASHES;
            }
            case "DOTFINE": {
                return PsymConnector.DOTFINE;
            }
            case "DOTS": {
                return PsymConnector.DOTS;
            }
            case "SOLID": {
                return PsymConnector.SOLID;
            }
        }
        logger.log(Level.FINE, "unable to parse symbol: {0}", deflt);
        return deflt;
    }

    public static FillStyle decodeFillStyle(String s, FillStyle deflt) {
        switch (s = s.toUpperCase()) {
            case "NONE": {
                return FillStyle.STYLE_NONE;
            }
            case "OUTLINE": {
                return FillStyle.STYLE_OUTLINE;
            }
            case "SOLID": {
                return FillStyle.STYLE_SOLID;
            }
        }
        logger.log(Level.FINE, "unable to parse symbol: {0}", deflt);
        return deflt;
    }

    public static String encodeFillStyle(FillStyle fillStyle) {
        return fillStyle.toString();
    }

    public static String encodeDatum(Datum d) {
        return d.toString();
    }

    public static Datum decodeDatum(String s, Datum deft) {
        try {
            return DatumUtil.parse((String)s);
        }
        catch (ParseException ex) {
            Logger.getLogger(Renderer.class.getName()).log(Level.SEVERE, null, ex);
            return deft;
        }
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    public abstract void render(Graphics2D var1, DasAxis var2, DasAxis var3);

    public boolean acceptContext(int x, int y) {
        return false;
    }

    protected void renderException(Graphics g, DasAxis xAxis, DasAxis yAxis, Exception e) {
        DasPlot lparent;
        String message;
        String s;
        if (e instanceof NoDataInIntervalException) {
            s = "no data in interval";
            message = e.getMessage();
        } else {
            s = e.getMessage();
            message = "";
            if (s == null || s.length() < 10) {
                s = e.toString();
            }
        }
        if (!message.equals("")) {
            s = s + ":!c" + message;
        }
        if ((lparent = this.parent) != null) {
            lparent.postMessage(this, s, DasPlot.SEVERE, null, null);
        }
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
    }

    protected void refreshImage() {
        if (this.getParent() != null) {
            // empty if block
        }
    }

    public void update() {
        logger.log(Level.FINE, "Renderer.update {0}", this.id);
        DasPlot lparent = this.parent;
        if (lparent == null) {
            logger.fine("update but parent was null");
            return;
        }
        lparent.repaint();
        this.xmemento = null;
        this.ymemento = null;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        DasRendererUpdateEvent drue = new DasRendererUpdateEvent(lparent, this);
        eventQueue.postEvent(drue);
    }

    public void updateCacheImage() {
        DasPlot lparent = this.parent;
        if (lparent == null) {
            logger.fine("update but parent was null");
            return;
        }
        lparent.invalidateCacheImageNoUpdate();
        this.update();
    }

    protected void updateImmediately() {
        logger.entering("org.das.graph.Renderer", "updateImmediately");
        DasPlot lparent = this.parent;
        if (lparent == null || !lparent.isDisplayable()) {
            logger.exiting("org.das.graph.Renderer", "updateImmediately");
            return;
        }
        if (this.loader != null) {
            this.loader.update();
        }
        logger.exiting("org.das.graph.Renderer", "updateImmediately");
    }

    private void refreshImmediately() {
        logger.log(Level.FINE, "update plot image for {0}", this.id);
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        try {
            ProgressMonitor progressPanel = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(this.parent, "Rebinning data set", "updatePlotImage");
            DasAxis lxaxis = lparent.getXAxis();
            DasAxis lyaxis = lparent.getYAxis();
            this.updatePlotImage(lxaxis, lyaxis, progressPanel);
            this.xmemento = lxaxis.getMemento();
            this.ymemento = lyaxis.getMemento();
            this.renderException = null;
        }
        catch (DasException de) {
            logger.log(Level.WARNING, de.getMessage(), de);
            this.renderException = de;
        }
        catch (RuntimeException re) {
            logger.log(Level.WARNING, re.getMessage(), re);
            this.renderException = re;
            lparent.invalidateCacheImage();
            throw re;
        }
        logger.fine("invalidate parent cacheImage and repaint");
        lparent.invalidateCacheImage();
    }

    protected void refresh() {
        if (!this.isActive()) {
            return;
        }
        DasPlot lparent = this.parent;
        logger.fine("entering Renderer.refresh");
        if (lparent == null) {
            logger.fine("null parent in refresh");
            return;
        }
        if (!lparent.isDisplayable()) {
            logger.fine("parent not displayable");
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Renderer.this.refreshImmediately();
            }
        };
        boolean async = true;
        if (EventQueue.isDispatchThread()) {
            if (async) {
                new Thread(run, "updatePlotImage").start();
            } else {
                run.run();
            }
        } else {
            run.run();
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        if (this.loader == null) {
            logger.warning("installing loader--danger!");
            this.loader = new XAxisDataLoader(this, dsd);
        }
        if (this.loader instanceof XAxisDataLoader) {
            ((XAxisDataLoader)this.loader).setDataSetDescriptor(dsd);
            DasPlot lparent = this.parent;
            if (lparent != null) {
                lparent.markDirty("dataSetDescriptor");
                lparent.update();
            }
        } else {
            throw new RuntimeException("loader is not based on DataSetDescriptor");
        }
        this.ds = null;
    }

    public DataLoader getDataLoader() {
        return this.loader;
    }

    public void setDataSetLoader(DataLoader loader) {
        this.loader = loader;
        if (loader != null) {
            loader.update();
        }
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.loader == null) {
            return null;
        }
        if (this.loader instanceof XAxisDataLoader) {
            return ((XAxisDataLoader)this.loader).getDataSetDescriptor();
        }
        return null;
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldValue = this.active;
        this.active = active;
        if (oldValue != active) {
            this.update();
        }
        this.propertyChangeSupport.firePropertyChange("active", oldValue, active);
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public void setLegendLabel(String legendLabel) {
        String oldLegendLabel = this.legendLabel;
        this.legendLabel = legendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_LEGENDLABEL, oldLegendLabel, legendLabel);
        this.updateCacheImage();
    }

    public boolean isDrawLegendLabel() {
        return this.drawLegendLabel;
    }

    public void setDrawLegendLabel(boolean drawLegendLabel) {
        boolean oldDrawLegendLabel = this.drawLegendLabel;
        this.drawLegendLabel = drawLegendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWLEGENDLABEL, oldDrawLegendLabel, drawLegendLabel);
        this.updateCacheImage();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange(PROP_ID, oldId, id);
    }

    @Override
    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon icon = (ImageIcon)this.getListIcon();
        g.drawImage(icon.getImage(), x, y, null);
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(new BufferedImage(16, 16, 2));
    }

    @Override
    public String getListLabel() {
        StringBuilder l = new StringBuilder(this.getLegendLabel());
        if (this.getDataSetDescriptor() != null && l.length() > 0) {
            l.append(" (").append(this.getDataSetDescriptor()).append(")");
        }
        if (this.id != null && this.id.length() > 0) {
            return this.id;
        }
        return l.toString();
    }

    public void setColorBar(DasColorBar cb) {
        this.colorBar = cb;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public static Font setUpFont(Font f, String fontSize) {
        if (fontSize != null && fontSize.length() > 0 && !fontSize.equals("1em")) {
            try {
                double[] size = DasDevicePosition.parseLayoutStr(fontSize);
                double s = (double)f.getSize2D() * size[0] / 100.0 + (double)f.getSize2D() * size[1] + size[2];
                f = f.deriveFont((float)s);
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            return f;
        }
        return f;
    }

    public static double parseLayoutString(String sizeStr, int nsize, double emSize, double fail) throws ParseException {
        return DasDevicePosition.parseLayoutStr(sizeStr, emSize, nsize, fail);
    }

    protected void setUpFont(Graphics g1, String fontSize) {
        Font f0 = this.getParent().getFont();
        if (f0 == null) {
            return;
        }
        Font f = Renderer.setUpFont(f0, fontSize);
        if (!f.equals(f0)) {
            g1.setFont(f);
        }
    }

    protected void incrementRenderCount() {
        this.renderCount.incrementAndGet();
    }

    public int getRenderCount() {
        return this.renderCount.get();
    }

    protected void incrementUpdateCount() {
        this.updateCount.incrementAndGet();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    public void resetCounters() {
        this.renderCount.set(0);
        this.updateCount.set(0);
    }

    public String getStatsFile() {
        return this.recordFile;
    }

    public void setStatsFile(String recordFile) {
        String oldRecordFile = this.recordFile;
        boolean reset = false;
        if (oldRecordFile != null && !oldRecordFile.equals(recordFile)) {
            if (this.recordStream != null) {
                this.recordStream.close();
            }
            reset = true;
        }
        this.recordFile = recordFile;
        try {
            if (reset) {
                this.resetCounters();
                if (recordFile.length() > 0) {
                    this.recordStream = new PrintStream(recordFile);
                    this.recordStream.println("updates, renders, numberOfPoints, seconds, type");
                }
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_RECORDFILE, oldRecordFile, recordFile);
    }

    protected void addToStats(int numberOfPoints, long millis, char t) {
        if (this.recordStream != null) {
            this.recordStream.format("%d, %d, %d, %.3f, %c\n", this.getUpdateCount(), this.getRenderCount(), numberOfPoints, (double)millis / 1000.0, Character.valueOf(t));
            this.recordStream.flush();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

