/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft;

import org.das2.dataset.ClippedVectorDataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.QuickVectorDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.math.fft.ComplexArray;
import org.das2.math.fft.GeneralFFT;

public class FFTUtil {
    public static VectorDataSet fftPower(GeneralFFT fft, VectorDataSet vds) {
        return FFTUtil.fftPower(fft, vds, FFTUtil.getWindowUnity(vds.getXLength()));
    }

    public static VectorDataSet getWindowUnity(final int size) {
        QuickVectorDataSet unity = new QuickVectorDataSet(){

            @Override
            public double getDouble(int i, Units units) {
                return 1.0;
            }

            @Override
            public int getXLength() {
                return size;
            }

            @Override
            public double getXTagDouble(int i, Units units) {
                return i;
            }

            @Override
            public Units getXUnits() {
                return Units.dimensionless;
            }

            @Override
            public Units getYUnits() {
                return Units.dimensionless;
            }
        };
        return unity;
    }

    public static VectorDataSet getWindow10PercentEdgeCosine(int size) {
        int i;
        final int n = size;
        int maxlim = 410;
        int lim = Math.min(n / 10, maxlim);
        final double[] ww = new double[n];
        double step = Math.PI / (double)lim;
        for (i = 0; i < lim; ++i) {
            ww[i] = (1.0 - Math.cos(step * (double)i)) / 2.0;
            ww[n - i - 1] = ww[i];
        }
        for (i = lim; i < size - lim; ++i) {
            ww[i] = 1.0;
        }
        QuickVectorDataSet result = new QuickVectorDataSet(){

            @Override
            public double getDouble(int i, Units units) {
                return ww[i];
            }

            @Override
            public int getXLength() {
                return n;
            }

            @Override
            public double getXTagDouble(int i, Units units) {
                return i;
            }

            @Override
            public Units getXUnits() {
                return Units.dimensionless;
            }

            @Override
            public Units getYUnits() {
                return Units.dimensionless;
            }
        };
        return result;
    }

    public static VectorDataSet fftPower(GeneralFFT fft, VectorDataSet vds, VectorDataSet weights) {
        vds = new ClippedVectorDataSet(vds, 0, fft.n);
        double[] yreal = new double[fft.n];
        Units yUnits = vds.getYUnits();
        double[] yimag = new double[fft.n];
        for (int i = 0; i < fft.n; ++i) {
            yreal[i] = vds.getDouble(i, yUnits) * weights.getDouble(i, Units.dimensionless);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        DatumVector xtags = FFTUtil.getFrequencyDomainTags(DataSetUtil.getXTags(vds));
        Units xUnits = xtags.getUnits();
        double binsize = 2.0 * xtags.get(xtags.getLength() / 2).doubleValue(Units.hertz) / (double)fft.n;
        VectorDataSetBuilder builder = new VectorDataSetBuilder(xtags.getUnits(), Units.dimensionless);
        for (int i = 0; i < xtags.getLength() / 2; ++i) {
            builder.insertY(xtags.get(i).doubleValue(xUnits), (double)(i == 0 ? 1 : 4) * ComplexArray.magnitude2(ca, i) / binsize);
        }
        return builder.toVectorDataSet();
    }

    public static ComplexArray.Double fft(GeneralFFT fft, VectorDataSet vds, Units units) {
        double[] yreal = new double[vds.getXLength()];
        Units yUnits = units;
        double[] yimag = new double[vds.getXLength()];
        for (int i = 0; i < vds.getXLength(); ++i) {
            yreal[i] = vds.getDouble(i, yUnits);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        return ca;
    }

    public static double[] getFrequencyDomainTags(double fs, int size) {
        int i;
        double[] result = new double[size];
        int n = size;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = fs / (double)n * (double)i;
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = fs / (double)n * (double)(n21 - n + i);
        }
        return result;
    }

    static DatumVector getFrequencyDomainTags(DatumVector timeDomainTags) {
        int i;
        Units timeUnit = timeDomainTags.getUnits();
        double[] x = timeDomainTags.toDoubleArray(timeUnit);
        double[] result = new double[x.length];
        result[0] = 0.0;
        double T = x[1] - x[0];
        int n = x.length;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        Units frequencyUnit = UnitsUtil.getInverseUnit((Units)timeUnit.getOffsetUnits());
        return DatumVector.newDatumVector((double[])result, (Units)frequencyUnit);
    }
}

