/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.datasource.jython.JythonDataSourceTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.jythonsupport.ui.ScriptPanelSupport;
import org.das2.components.TearoffTabbedPane;
import org.das2.jythoncompletion.nbadapt.Utilities;
import org.das2.util.FileUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.core.PyException;

public class JythonEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.jyds");
    ScriptPanelSupport support;
    String suri;
    File file;
    URI resourceUri;
    boolean hasVariables = false;
    ParametersFormPanel parametersFormPanel;
    private JLabel caretPositionLabel;
    protected JLabel fileNameLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel paramsPanel;
    private JScrollPane paramsScrollPane;
    private JPanel scriptPanel;
    private JScrollPane scriptScrollPane;
    private TearoffTabbedPane tearoffTabbedPane1;
    private EditorTextPane textArea;
    private JComboBox variableComboBox;

    public JythonEditorPanel() {
        this.initComponents();
        this.tearoffTabbedPane1.hideMouseAdapter();
        this.support = new ScriptPanelSupport(this.textArea);
        this.support.addCaretLabel(this.caretPositionLabel);
        this.support.addFileLabel(this.fileNameLabel);
        this.support.setReadOnly();
        this.scriptScrollPane.getVerticalScrollBar().setUnitIncrement(this.scriptScrollPane.getFont().getSize());
        this.paramsScrollPane.getVerticalScrollBar().setUnitIncrement(this.scriptScrollPane.getFont().getSize());
        this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String id;
                    int idx;
                    int offs = JythonEditorPanel.this.textArea.viewToModel(e.getPoint());
                    int[] ii = Utilities.getIdentifierBlock((JTextComponent)JythonEditorPanel.this.textArea, (int)offs);
                    if (ii != null && (idx = JythonEditorPanel.this.lookupResultVariableIndex(id = JythonEditorPanel.this.textArea.getDocument().getText(ii[0], ii[1] - ii[0]))) != -1) {
                        JythonEditorPanel.this.variableComboBox.setSelectedIndex(idx);
                    }
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    private void initComponents() {
        this.variableComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tearoffTabbedPane1 = new TearoffTabbedPane();
        this.scriptPanel = new JPanel();
        this.caretPositionLabel = new JLabel();
        this.fileNameLabel = new JLabel();
        this.scriptScrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.textArea = new EditorTextPane();
        this.paramsScrollPane = new JScrollPane();
        this.paramsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.setName("jythonDataSourceEditorPanel");
        this.variableComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(running script)"}));
        this.jLabel1.setText("Select variable:");
        this.jLabel1.setToolTipText("The dataset pointed to by the URI");
        this.caretPositionLabel.setText("1,1");
        this.fileNameLabel.setMinimumSize(new Dimension(200, 16));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.textArea, "Center");
        this.scriptScrollPane.setViewportView(this.jPanel1);
        GroupLayout scriptPanelLayout = new GroupLayout((Container)this.scriptPanel);
        this.scriptPanel.setLayout((LayoutManager)scriptPanelLayout);
        scriptPanelLayout.setHorizontalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.fileNameLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 56, -2)).add((Component)this.scriptScrollPane));
        scriptPanelLayout.setVerticalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.scriptScrollPane, -1, 208, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)scriptPanelLayout.createParallelGroup(2).add((Component)this.fileNameLabel, -2, 20, -2).add((Component)this.caretPositionLabel))));
        this.tearoffTabbedPane1.addTab("script", (Component)this.scriptPanel);
        this.paramsPanel.setLayout(new BoxLayout(this.paramsPanel, 1));
        this.paramsScrollPane.setViewportView(this.paramsPanel);
        this.tearoffTabbedPane1.addTab("params", (Component)this.paramsScrollPane);
        this.jLabel2.setText("Select from the variables calculated by the script, 'data' or 'result' is used by default:");
        this.jLabel2.setMinimumSize(new Dimension(200, 17));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.variableComboBox, 0, -1, Short.MAX_VALUE)).add((Component)this.tearoffTabbedPane1, -2, 0, Short.MAX_VALUE).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tearoffTabbedPane1, -1, -1, Short.MAX_VALUE).add(8, 8, 8).add((Component)this.jLabel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.variableComboBox, -2, -1, -2).add((Component)this.jLabel1))));
    }

    public JPanel getPanel() {
        return this;
    }

    private JComponent getSpacer() {
        JLabel spacer = new JLabel("  ");
        spacer.setSize(new Dimension(20, 16));
        spacer.setMinimumSize(new Dimension(20, 16));
        spacer.setPreferredSize(new Dimension(20, 16));
        return spacer;
    }

    private JComponent getSpacer(int size) {
        JLabel spacer = new JLabel(" ");
        spacer.setSize(new Dimension(size, 16));
        spacer.setMinimumSize(new Dimension(size, 16));
        spacer.setPreferredSize(new Dimension(size, 16));
        return spacer;
    }

    private boolean doVariables(Map<String, Object> env, File f, Map<String, String> params) throws PyException {
        boolean hasVars = false;
        try {
            String src = FileUtil.readFileToString((File)f);
            ParametersFormPanel p = new ParametersFormPanel();
            ParametersFormPanel.FormData fd = p.doVariables(env, src, params, this.paramsPanel);
            hasVars = fd.count > 0;
            this.parametersFormPanel = p;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return hasVars;
    }

    private Map<String, String> getParamsFromGui() throws IllegalArgumentException {
        URISplit split = URISplit.parse((String)this.suri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String param = (String)this.variableComboBox.getSelectedItem();
        int i = param.indexOf("<span");
        if (i == -1) {
            params.put("arg_0", param.trim());
        } else {
            int j = param.startsWith("<html>") ? 6 : 0;
            params.put("arg_0", param.substring(j, i).trim());
        }
        if (this.parametersFormPanel == null) {
            return Collections.emptyMap();
        }
        ParametersFormPanel.FormData formData = this.parametersFormPanel.getFormData();
        ParametersFormPanel.resetVariables((ParametersFormPanel.FormData)formData, (Map)params);
        String resourceURI = (String)params.get("resourceURI");
        if (resourceURI != null) {
            if (resourceURI.startsWith("'")) {
                resourceURI = resourceURI.substring(1);
            }
            if (resourceURI.endsWith("'")) {
                resourceURI = resourceURI.substring(0, resourceURI.length() - 1);
            }
            params.put("resourceURI", resourceURI);
        }
        return params;
    }

    private String[] getScriptURI(URISplit split) {
        String resourceUri1;
        String furi;
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        if (params.containsKey("script")) {
            furi = (String)params.get("script");
            resourceUri1 = split.resourceUri == null ? null : split.resourceUri.toString();
        } else {
            furi = split.resourceUri.toString();
            resourceUri1 = null;
        }
        return new String[]{furi, resourceUri1};
    }

    public void setURI(String url) {
        try {
            File f;
            this.suri = url;
            URISplit split = URISplit.parse((String)this.suri);
            String[] furir = this.getScriptURI(split);
            this.file = f = DataSetURI.getFile((String)furir[0], (ProgressMonitor)new NullProgressMonitor());
            Map<String, String> results = JythonDataSourceFactory.getResultParameters(f.toString(), (ProgressMonitor)new NullProgressMonitor());
            String[] dropList = new String[results.size() + 1];
            int i = 0;
            int idx = -1;
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            String param = (String)params.remove("arg_0");
            dropList[0] = "";
            for (Map.Entry<String, String> ent : results.entrySet()) {
                dropList[i + 1] = "<html>" + ent.getKey() + "<span color=#808080>: <i>" + ent.getValue() + "</i></span>";
                if (param != null && param.equals(ent.getKey())) {
                    idx = i + 1;
                }
                ++i;
            }
            this.variableComboBox.setModel(new DefaultComboBoxModel<String>(dropList));
            if (idx >= 0) {
                this.variableComboBox.setSelectedIndex(idx);
            } else {
                this.variableComboBox.setSelectedIndex(0);
            }
            Map<String, Object> env = Collections.singletonMap("PWD", split.path);
            HashMap<String, String> ffparams = new HashMap<String, String>(params);
            if (furir[1] != null) {
                ffparams.put("resourceURI", furir[1]);
            }
            this.support.loadFile(f);
            if (FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)this.support.getFile()) || !this.support.getFile().canWrite()) {
                this.support.setReadOnly();
            }
            try {
                this.hasVariables = this.doVariables(env, f, ffparams);
            }
            catch (PyException e) {
                this.hasVariables = false;
                try {
                    this.support.annotateError(e, 0);
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                this.paramsPanel.add(new JLabel("<html>Script contains errors.</html>"));
            }
            if (this.hasVariables) {
                this.tearoffTabbedPane1.setSelectedIndex(1);
            }
            try {
                ArrayList errs = new ArrayList();
                if (JythonUtil.pythonLint((URI)f.toURI(), errs)) {
                    EditorAnnotationsSupport esa = this.textArea.getEditorAnnotationsSupport();
                    for (String s : errs) {
                        String[] ss = s.split(":", 2);
                        try {
                            String doc = ss[1];
                            doc = doc.replaceAll("<", "&lt;");
                            doc = doc.replaceAll(">", "&gt;");
                            esa.annotateLine(Integer.parseInt(ss[0]), "warning", "Variable name is already used before execution: " + doc + "<br>Consider using a different name");
                        }
                        catch (BadLocationException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
            }
            catch (NoClassDefFoundError ex) {
                logger.warning(ex.toString());
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private int lookupResultVariableIndex(String var) {
        for (int jj = 0; jj < this.variableComboBox.getItemCount(); ++jj) {
            int j;
            String it = (String)this.variableComboBox.getItemAt(jj);
            int i = it.indexOf("<span");
            if (i == -1) {
                if (!var.equals(it)) continue;
                return jj;
            }
            int n = j = it.startsWith("<html>") ? 6 : 0;
            if (!var.equals(it.substring(j, i).trim())) continue;
            return jj;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURI() {
        if (this.support.isDirty() && this.support.getFile() != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.support.getFile());
                String text = this.textArea.getText();
                ((OutputStream)out).write(text.getBytes());
                this.support.setDirty(false);
            }
            catch (IOException text) {
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException text) {}
                }
            }
        }
        URISplit split = URISplit.parse((String)this.suri);
        Map<String, String> params = this.getParamsFromGui();
        if (split.resourceUri != null && params.get("resourceURI") != null) {
            try {
                String script = params.get("script");
                if (script == null) {
                    script = split.resourceUri.toString();
                }
                params.put("script", script);
                split.resourceUri = new URI(params.remove("resourceURI"));
                split.file = split.resourceUri.toString();
                split.vapScheme = "vap+jyds";
            }
            catch (URISyntaxException script) {}
        } else {
            logger.fine("bugfix code used to go through here and do something that appeared to be incorrect.");
        }
        if (this.support.isDirty()) {
            try (FileWriter writer = new FileWriter(this.support.getFile());){
                writer.write(this.textArea.getText());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            JythonDataSourceTimeSeriesBrowse tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(this.suri, this.support.getFile());
            if (tsb1 == null) {
                params.remove("timerange");
                if ("".equals(params.get("arg_0"))) {
                    params.remove("arg_0");
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        split.params = params.isEmpty() ? null : URISplit.formatParams(params);
        String uri = URISplit.format((URISplit)split);
        return uri;
    }

    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.length() == 0 || split.file.equals("file:///")) {
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            return !params.containsKey("script");
        }
        return false;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)uri);
        String[] furir = this.getScriptURI(split);
        DataSetURI.getFile((String)furir[0], (ProgressMonitor)mon);
        return true;
    }

    public void markProblems(List<String> problems) {
    }
}

