/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.jython.JythonDataSource;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.datasource.jython.JythonExtensionDataSourceFactory;
import org.das2.datum.LoggerManager;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class JythonExtensionDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.jyds");

    public JythonExtensionDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        String jydsUri = JythonExtensionDataSourceFactory.getJydsUri(this.uri);
        logger.log(Level.FINE, "Using script to implement extension: {0}", jydsUri);
        JythonDataSourceFactory jdsf = (JythonDataSourceFactory)DataSourceRegistry.getInstance().getSource(".jyds");
        JythonDataSource jyds = (JythonDataSource)jdsf.getDataSource(DataSetURI.getURI((String)jydsUri));
        return jyds.getDataSet(mon);
    }
}

