/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceRecognizer;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonExtensionDataSource;
import org.das2.datum.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class JythonExtensionDataSourceFactory
extends AbstractDataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.jyds");

    public static String getScriptForResource(URI uri) {
        String script;
        URISplit split = URISplit.parse((URI)uri);
        String scheme = split.vapScheme;
        if (scheme == null) {
            scheme = "vap+" + split.ext.substring(1);
        }
        switch (scheme) {
            case "vap+sps": {
                script = "https://github.com/autoplot/scripts/blob/master/formats/sps/readTypeSps.jyds";
                break;
            }
            case "vap+spd": {
                script = "https://github.com/autoplot/scripts/blob/master/formats/sps/readTypeSpd.jyds";
                break;
            }
            case "vap+npy": {
                script = "https://github.com/autoplot/scripts/blob/master/formats/npy/read_npy.jyds";
                break;
            }
            case "vap+wdc": {
                script = "https://raw.githubusercontent.com/autoplot/jyds/master/wdc_kp_ap.jyds";
                break;
            }
            case "vap+tfcat": {
                script = "https://github.com/autoplot/scripts/blob/master/formats/tfcat/tfcat.jyds";
                break;
            }
            default: {
                try {
                    File f = DataSetURI.getFile((String)uri.getRawSchemeSpecificPart(), (ProgressMonitor)new AlertNullProgressMonitor());
                    String extr = DataSourceRecognizer.guessDataSourceType((File)f);
                    if (extr != null && extr.equals("vap+tfcat")) {
                        script = "https://github.com/autoplot/scripts/blob/master/formats/tfcat/tfcat.jyds";
                        break;
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                throw new IllegalArgumentException("resource extension is not supported: " + split.ext);
            }
        }
        String ext = scheme.substring(4);
        String alt = System.getProperty("jydsExtension_" + ext, "");
        if (alt.length() > 0) {
            logger.log(Level.FINE, "system property jydsExtension_{0}={1}", new Object[]{ext, alt});
            script = alt;
        } else {
            logger.log(Level.FINER, "System.getProperty(\"jydsExtension_{0}\",\"\") returns \"\"", new Object[]{ext});
        }
        logger.log(Level.FINE, "Using script {0}", script);
        return script;
    }

    public static String getInternalScriptForResource(URI uri) {
        String script;
        URISplit split = URISplit.parse((URI)uri);
        String scheme = split.vapScheme;
        if (scheme == null) {
            scheme = "vap+" + split.ext.substring(1);
        }
        switch (scheme) {
            case "vap+sps": {
                script = "/readTypeSps.jyds";
                break;
            }
            case "vap+spd": {
                script = "/readTypeSpd.jyds";
                break;
            }
            case "vap+wdc": {
                script = "/wdc_kp_ap.jyds";
                break;
            }
            default: {
                throw new IllegalArgumentException("resource extension is not supported: " + split.ext);
            }
        }
        try {
            File scriptFile = DataSetURI.downloadResourceAsTempFile((URL)JythonExtensionDataSourceFactory.class.getResource(script), (ProgressMonitor)new NullProgressMonitor());
            return scriptFile.toURI().toString();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public static String getJydsUri(URI uri) {
        String script;
        block2: {
            script = JythonExtensionDataSourceFactory.getScriptForResource(uri);
            try {
                File scriptFile = DataSetURI.getFile((URL)new URL(script), (ProgressMonitor)new NullProgressMonitor());
                logger.log(Level.FINE, "can be downloaded: {0}", scriptFile);
            }
            catch (IOException ex) {
                logger.log(Level.INFO, "unable to read remote script {0}, using internal copy", script);
                script = JythonExtensionDataSourceFactory.getInternalScriptForResource(uri);
                if (script != null) break block2;
                throw new IllegalArgumentException("Unable to locate script");
            }
        }
        URISplit split = URISplit.parse((URI)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        params.put("script", script);
        split.params = URISplit.formatParams((Map)params);
        return URISplit.format((URISplit)split);
    }

    public DataSource getDataSource(URI uri) throws Exception {
        return new JythonExtensionDataSource(uri);
    }
}

