/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.inline;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.inline.InlineDataSource;
import org.autoplot.inline.InlineTimeSeriesBrowse;
import org.autoplot.inline.MakeAggMap;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.LoggerManager;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.DefaultCompletionItem;
import org.das2.jythoncompletion.JythonCompletionTask;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class InlineDataSourceFactory
extends AbstractDataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.inline");

    public InlineDataSourceFactory() {
        DataSourceUtil.addMakeAggregationForScheme((String)"vap+inline", (DataSourceUtil.URIMap)new MakeAggMap());
    }

    public DataSource getDataSource(URI uri) throws Exception {
        return new InlineDataSource(uri);
    }

    public List<org.autoplot.datasource.CompletionContext> getCompletions(org.autoplot.datasource.CompletionContext cc, ProgressMonitor mon) throws Exception {
        ArrayList<org.autoplot.datasource.CompletionContext> result;
        block11: {
            ArrayList<DefaultCompletionItem> r;
            block10: {
                result = new ArrayList<org.autoplot.datasource.CompletionContext>();
                if (cc.context != org.autoplot.datasource.CompletionContext.CONTEXT_PARAMETER_NAME) break block10;
                InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
                URL imports = JythonOps.class.getResource("/imports2025.py");
                if (imports != null) {
                    interp.execfile(imports.openStream(), "imports2025.py");
                } else {
                    logger.warning("unable to find imports2025.py");
                }
                String frag = cc.completable;
                CompletionContext cc1 = CompletionSupport.getCompletionContext((String)("x=" + frag), (int)(cc.completablepos + 2), (int)0, (int)0, (int)0);
                List r2 = JythonCompletionTask.getLocalsCompletions((PythonInterpreter)interp, (CompletionContext)cc1);
                Collections.sort(r2, new Comparator<DefaultCompletionItem>(){

                    @Override
                    public int compare(DefaultCompletionItem o1, DefaultCompletionItem o2) {
                        return o1.getComplete().compareTo(o2.getComplete());
                    }
                });
                for (DefaultCompletionItem item : r2) {
                    result.add(new org.autoplot.datasource.CompletionContext(org.autoplot.datasource.CompletionContext.CONTEXT_PARAMETER_NAME, item.getComplete(), (DataSourceFactory)this, "arg_0"));
                }
                break block11;
            }
            if (cc.context != org.autoplot.datasource.CompletionContext.CONTEXT_PARAMETER_VALUE) break block11;
            InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
            URL imports = JythonOps.class.getResource("/imports2023.py");
            interp.execfile(imports.openStream(), "imports2023.py");
            String frag = cc.completable;
            CompletionContext cc1 = CompletionSupport.getCompletionContext((String)("x=" + frag), (int)(cc.completablepos + 2), (int)0, (int)0, (int)0);
            if (cc1.contextType.equals("stringLiteralArgument")) {
                if (cc1.contextString.equals("getDataSet")) {
                    String s = cc1.completable;
                    char q = s.charAt(0);
                    if ((s = s.substring(1)).charAt(s.length() - 1) == q) {
                        s = s.substring(0, s.length() - 1);
                    }
                    int len = s.length();
                    List rx = DataSetURI.getCompletions((String)s, (int)len, (ProgressMonitor)mon);
                    r = new ArrayList<DefaultCompletionItem>(rx.size());
                    for (int i = 0; i < rx.size(); ++i) {
                        String t = cc1.contextString + "(" + q + ((DataSetURI.CompletionResult)rx.get((int)i)).completion + q;
                        r.add(new DefaultCompletionItem(t, len, t, "xxx", null));
                    }
                } else {
                    r = JythonCompletionTask.getLocalsCompletions((PythonInterpreter)interp, (CompletionContext)cc1);
                }
            } else {
                r = JythonCompletionTask.getLocalsCompletions((PythonInterpreter)interp, (CompletionContext)cc1);
            }
            Collections.sort(r, new Comparator<DefaultCompletionItem>(){

                @Override
                public int compare(DefaultCompletionItem o1, DefaultCompletionItem o2) {
                    return o1.getComplete().compareTo(o2.getComplete());
                }
            });
            for (DefaultCompletionItem item : r) {
                result.add(new org.autoplot.datasource.CompletionContext(org.autoplot.datasource.CompletionContext.CONTEXT_PARAMETER_VALUE, item.getComplete(), (DataSourceFactory)this, item.getComplete()));
            }
        }
        return result;
    }

    protected static String getScript(String suri, List<String> script) {
        String scriptInline = suri.substring("vap+inline:".length());
        String[] ss = Util.guardedSplit((String)scriptInline, (char)'&', (char)'\'', (char)'\"');
        String timerange = null;
        for (String s : ss) {
            if (!s.startsWith("timerange=")) continue;
            timerange = JythonUtil.maybeUnquoteString((String)JythonUtil.maybeQuoteString((String)s.substring(10)));
        }
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            if (timerange != null && s.contains("getDataSet(")) {
                int k = s.lastIndexOf(")");
                s = s.substring(0, k) + ",'" + timerange + "')";
            }
            ss[i] = s;
        }
        script.addAll(Arrays.asList(ss));
        if (timerange == null) {
            return null;
        }
        return timerange;
    }

    private static boolean checkRejectGetDataSet(String suri, List<String> problems, ProgressMonitor mon) {
        ArrayList<String> script = new ArrayList<String>();
        String timerange = InlineDataSourceFactory.getScript(suri, script);
        StringBuilder scriptBuilder = new StringBuilder();
        for (String s : script) {
            scriptBuilder.append(s).append("\n");
        }
        Map pp = JythonUtil.getGetDataSet(null, (String)scriptBuilder.toString(), null);
        for (Map.Entry e : pp.entrySet()) {
            String surl1 = (String)e.getValue();
            int itr = surl1.indexOf(" ");
            if (itr > -1) {
                surl1 = surl1.substring(0, itr);
            }
            URISplit delegateSplit = URISplit.parse((String)surl1);
            URI uri = DataSetURI.toUri((String)URISplit.format((URISplit)delegateSplit));
            try {
                TimeSeriesBrowse tsb;
                DataSourceFactory dsf = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
                if (timerange != null && (tsb = (TimeSeriesBrowse)dsf.getCapability(TimeSeriesBrowse.class)) != null) {
                    try {
                        tsb.setURI(surl1);
                        tsb.setTimeRange(DatumRangeUtil.parseTimeRange((String)timerange));
                        surl1 = tsb.getURI();
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (!dsf.reject(surl1, problems, mon.getSubtaskMonitor(""))) continue;
                return true;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        if (surl.length() == 11) {
            return true;
        }
        mon.started();
        try {
            if (InlineDataSourceFactory.checkRejectGetDataSet(surl, problems, mon.getSubtaskMonitor("getDataSet calls"))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = super.reject(surl, problems, mon.getSubtaskMonitor("super.reject"));
            return bl;
        }
        finally {
            mon.finished();
        }
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new InlineTimeSeriesBrowse();
        }
        return (T)super.getCapability(clazz);
    }

    public boolean supportsDiscovery() {
        return true;
    }

    public boolean isFileResource() {
        return false;
    }

    public String getDescription() {
        return "Data encoded within the URI";
    }
}

