/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.imagedatasource;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.ops.Ops;

public class ImageDataSet
extends AbstractDataSet {
    BufferedImage image;
    ColorOp op;
    int w;
    int h;
    private int rank;

    private double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public ImageDataSet(BufferedImage image) {
        this(image, null, null);
    }

    public ImageDataSet(BufferedImage image, Color mask, ColorOp op) {
        this.image = image;
        this.h = image.getHeight();
        this.w = image.getWidth();
        this.rank = 2;
        if (mask == null) {
            if (op == null) {
                this.rank = 3;
                this.putProperty("DEPEND_2", Ops.labelsDataset((String[])new String[]{"red", "green", "blue"}));
            } else {
                this.op = op;
            }
        } else {
            this.op = new ChannelColorOp(mask.getRGB() & 0xFFFFFF, (int)this.log2(Integer.lowestOneBit(mask.getRGB())));
        }
        this.putProperty("QUBE", Boolean.TRUE);
        this.putProperty("RENDER_TYPE", "image");
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.w;
    }

    public int length(int i) {
        return this.h;
    }

    public int length(int i, int j) {
        return 3;
    }

    public double value(int i0, int i1) {
        return this.op.value(this.image.getRGB(i0, this.h - i1 - 1));
    }

    public double value(int i0, int i1, int i2) {
        int rgb = this.image.getRGB(i0, this.h - i1 - 1);
        switch (i2) {
            case 0: {
                return (rgb & 0xFF0000) >> 16;
            }
            case 1: {
                return (rgb & 0xFF00) >> 8;
            }
            case 2: {
                return rgb & 0xFF;
            }
        }
        throw new IndexOutOfBoundsException("i2=3");
    }

    private static class ChannelColorOp
    implements ColorOp {
        int mask;
        int rot;

        ChannelColorOp(int mask, int rot) {
            this.mask = mask;
            this.rot = rot;
        }

        @Override
        public double value(int rgb) {
            return (rgb & this.mask) >> this.rot;
        }
    }

    public static interface ColorOp {
        public double value(int var1);
    }
}

