/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Frame;
import java.awt.Window;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.das2.util.Base64;
import org.das2.util.CredentialsDialog;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;

public class CredentialsManager {
    private static final Logger logger = LoggerManager.getLogger("das2.credentialsmanager");
    static final HashMap<String, CredentialsManager> g_dManagers = new HashMap();
    String m_sName;
    HashMap<String, Location> m_dLocs;
    CredentialsDialog m_dlg;

    public static CredentialsManager getMannager() {
        return g_dManagers.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialsManager getMannager(String sWhich) {
        if (!g_dManagers.containsKey(sWhich)) {
            HashMap<String, CredentialsManager> hashMap = g_dManagers;
            synchronized (hashMap) {
                g_dManagers.put(sWhich, new CredentialsManager(sWhich));
            }
        }
        return g_dManagers.get(sWhich);
    }

    protected CredentialsManager(String sName) {
        this.m_sName = sName;
        this.m_dLocs = new HashMap();
        this.m_dlg = null;
    }

    public void setDescription(String sLocationId, String sDescription) {
        this.setDescription(sLocationId, sDescription, null);
    }

    public synchronized void setDescription(String sLocationId, String sDescription, ImageIcon icon) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            this.m_dLocs.put(sLocationId, new Location(sLocationId, sDescription, icon));
        } else {
            Location loc = this.m_dLocs.get(sLocationId);
            loc.sDesc = sDescription;
            loc.iconLogo = icon;
        }
    }

    public boolean hasCredentials(String sLocationId) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            return false;
        }
        Location loc = this.m_dLocs.get(sLocationId);
        return loc.hasCredentials();
    }

    public void setHttpBasicHashRaw(String sLocationId, String userInfo) {
        if (!this.hasCredentials(sLocationId)) {
            this.m_dLocs.put(sLocationId, new Location(sLocationId, null, null));
        }
        Location loc = this.m_dLocs.get(sLocationId);
        String[] ss = userInfo.split(":", -2);
        loc.sUser = ss[0];
        loc.sPasswd = ss[1];
    }

    public boolean hasDescription(String sLocationId) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            return false;
        }
        Location loc = this.m_dLocs.get(sLocationId);
        return loc.sDesc != null && !loc.sDesc.isEmpty();
    }

    public boolean hasIcon(String sLocationId) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            return false;
        }
        Location loc = this.m_dLocs.get(sLocationId);
        return loc.iconLogo != null;
    }

    public String getHttpBasicHash(String sLocationId) {
        String sTmp = this.getHttpBasicHashRaw(sLocationId);
        if (sTmp == null) {
            return null;
        }
        String sHash = Base64.getEncoder().encodeToString(sTmp.getBytes());
        return sHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHttpBasicHashRaw(String sLocationId) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            CredentialsManager credentialsManager = this;
            synchronized (credentialsManager) {
                if (!this.m_dLocs.containsKey(sLocationId)) {
                    this.m_dLocs.put(sLocationId, new Location(sLocationId, null, null));
                }
            }
        }
        Location loc = this.m_dLocs.get(sLocationId);
        if (!this.hasCredentials(sLocationId) && ("true".equals(System.getProperty("java.awt.headless")) ? !this.getCredentialsCmdLine(loc) : !this.getCredentialsGUI(loc))) {
            return null;
        }
        String sTmp = loc.sUser + ":" + loc.sPasswd;
        return sTmp;
    }

    public synchronized void invalidate(String sLocationId) {
        if (!this.m_dLocs.containsKey(sLocationId)) {
            return;
        }
        Location loc = this.m_dLocs.get(sLocationId);
        loc.sUser = null;
        loc.sPasswd = null;
    }

    public static String getProperty(String name, String deft) {
        try {
            return System.getProperty(name, deft);
        }
        catch (SecurityException ex) {
            return deft;
        }
    }

    public static File getDas2UserDirectory() {
        File local = CredentialsManager.getProperty("user.name", "Web").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        local = new File(local, ".das2");
        return local;
    }

    private String checkKeyChainForCredentials(Location loc) {
        File das2Dir = CredentialsManager.getDas2UserDirectory();
        if (!das2Dir.exists() && !das2Dir.mkdirs()) {
            logger.log(Level.WARNING, "unable to mkdir {0}", das2Dir);
            return null;
        }
        File credentialsDir = new File(das2Dir, "keychain");
        if (!credentialsDir.exists() && !credentialsDir.mkdirs()) {
            logger.log(Level.WARNING, "unable to mkdir {0}", credentialsDir);
            return null;
        }
        String hash = String.format("%09d.txt", loc.sLocId.hashCode() & Integer.MAX_VALUE);
        File locFile = new File(credentialsDir, hash);
        if (locFile.exists()) {
            if (!locFile.canRead()) {
                logger.log(Level.WARNING, "unable to read file {0}", locFile);
                return null;
            }
            try {
                String result = FileUtil.readFileToString(locFile).trim();
                String[] ss = result.split("\n");
                result = ss[1];
                return result;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
        }
        return null;
    }

    private void recordCredentialsToKeyChain(Location loc) {
        String hash;
        File locFile;
        File credentialsDir;
        File das2Dir = CredentialsManager.getDas2UserDirectory();
        if (!das2Dir.exists() && !das2Dir.mkdirs()) {
            logger.log(Level.WARNING, "unable to mkdir {0}", das2Dir);
        }
        if (!(credentialsDir = new File(das2Dir, "keychain")).exists() && !credentialsDir.mkdirs()) {
            logger.log(Level.WARNING, "unable to mkdir {0}", credentialsDir);
        }
        if ((locFile = new File(credentialsDir, hash = String.format("%09d.txt", loc.sLocId.hashCode() & Integer.MAX_VALUE))).exists() && !locFile.canWrite()) {
            logger.log(Level.WARNING, "unable to write file {0}", locFile);
        } else {
            try {
                String old;
                String credentialsString = loc.sLocId + "\n" + loc.sUser + ":" + loc.sPasswd + "\n";
                if (locFile.exists() && (old = FileUtil.readFileToString(locFile)).equals(credentialsString)) {
                    logger.fine("password didn't change");
                    return;
                }
                FileUtil.writeStringToFile(locFile, credentialsString);
                if (!locFile.setReadable(false)) {
                    logger.warning("setReadable failure");
                }
                if (!locFile.setReadable(false, false)) {
                    logger.warning("setReadable failure");
                }
                if (!locFile.setReadable(true, true)) {
                    logger.warning("setReadable failure");
                }
                if (!locFile.setWritable(false)) {
                    logger.warning("setWritable failure");
                }
                if (!locFile.setWritable(false, false)) {
                    logger.warning("setWritable failure");
                }
                if (!locFile.setWritable(true, true)) {
                    logger.warning("setWritable failure");
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    protected synchronized boolean getCredentialsGUI(final Location loc) {
        if (loc.hasCredentials()) {
            return true;
        }
        String credentialsFromKeyChain = this.checkKeyChainForCredentials(loc);
        if (credentialsFromKeyChain != null) {
            int i = credentialsFromKeyChain.indexOf(":");
            loc.sUser = credentialsFromKeyChain.substring(0, i);
            loc.sPasswd = credentialsFromKeyChain.substring(i + 1);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String sTmp;
                    if (CredentialsManager.this.m_dlg == null) {
                        Window[] lTopWnds;
                        Frame wParent = null;
                        for (Window wnd : lTopWnds = Window.getOwnerlessWindows()) {
                            if (!wnd.isVisible() || !(wnd instanceof Frame)) continue;
                            wParent = (Frame)wnd;
                            break;
                        }
                        CredentialsManager.this.m_dlg = new CredentialsDialog(wParent);
                    }
                    if ((sTmp = loc.sDesc) == null || sTmp.isEmpty()) {
                        sTmp = loc.sLocId;
                    }
                    CredentialsManager.this.m_dlg.runDialog(sTmp, loc.iconLogo, loc.sUser, loc.sPasswd);
                }
            });
        }
        catch (InterruptedException ex) {
            LoggerManager.getLogger("das2.util").severe(ex.toString());
            return false;
        }
        catch (InvocationTargetException ex) {
            LoggerManager.getLogger("das2.util").severe(ex.toString());
            return false;
        }
        if (this.m_dlg.getReturn() == 2) {
            return false;
        }
        loc.sUser = this.m_dlg.getUser();
        loc.sPasswd = this.m_dlg.getPasswd();
        this.recordCredentialsToKeyChain(loc);
        return true;
    }

    protected synchronized boolean getCredentialsCmdLine(Location loc) {
        Console c = System.console();
        if (c == null) {
            throw new IllegalArgumentException("Console is not available to query username and password for " + loc.sDesc);
        }
        c.printf("%s\n", loc.sDesc);
        loc.sUser = c.readLine("Username: ", new Object[0]);
        loc.sPasswd = new String(c.readPassword("Password: ", new Object[0]));
        return true;
    }

    static {
        g_dManagers.put(null, new CredentialsManager(null));
    }

    protected static class Location {
        String sLocId;
        String sDesc;
        ImageIcon iconLogo;
        String sUser;
        String sPasswd;

        protected Location(String sLocationId, String sDescription, ImageIcon icon) {
            this.sLocId = sLocationId;
            this.sDesc = sDescription;
            this.iconLogo = icon;
            this.sUser = null;
            this.sPasswd = null;
        }

        protected boolean hasCredentials() {
            return this.sUser != null || this.sPasswd != null;
        }
    }
}

