/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public class ExpensiveOpCache {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.opcache");
    Op op;
    int limitMs;
    Map<String, Object> results = new HashMap<String, Object>();
    Map<String, Long> times = new HashMap<String, Long>();

    public ExpensiveOpCache(Op op, int limitMs) {
        this.limitMs = limitMs;
        this.op = op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doOp(String key) throws Exception {
        long dt;
        Object result;
        Long t;
        ExpensiveOpCache expensiveOpCache = this;
        synchronized (expensiveOpCache) {
            t = this.times.get(key);
            result = this.results.get(key);
        }
        long t0 = System.currentTimeMillis();
        long l = dt = t != null ? t0 - t : 99999L;
        if (t == null) {
            logger.log(Level.FINE, "no cache entry for: {0}", new Object[]{key});
            result = this.op.doOp(key);
            ExpensiveOpCache expensiveOpCache2 = this;
            synchronized (expensiveOpCache2) {
                this.times.put(key, t0);
                this.results.put(key, result);
            }
        } else if (dt > (long)this.limitMs) {
            logger.log(Level.FINE, "stale ({0}s) cache entry {1}: {2}", new Object[]{dt / 1000L, key, result.toString()});
            result = this.op.doOp(key);
            ExpensiveOpCache expensiveOpCache3 = this;
            synchronized (expensiveOpCache3) {
                this.times.put(key, t0);
                this.results.put(key, result);
            }
        } else {
            logger.log(Level.FINE, "using cached value for {0}: {1}", new Object[]{key, result.toString()});
        }
        return result;
    }

    public synchronized void reset() {
        this.times.clear();
        this.results.clear();
    }

    public static interface Op {
        public Object doOp(String var1) throws Exception;
    }
}

