/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;

    protected CmapFormat4(RandomAccessFile raf) throws IOException {
        super(raf);
        this.format = 4;
        this.segCountX2 = raf.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = raf.readUnsignedShort();
        this.entrySelector = raf.readUnsignedShort();
        this.rangeShift = raf.readUnsignedShort();
        int i = 0;
        while (i < this.segCount) {
            this.endCode[i] = raf.readUnsignedShort();
            ++i;
        }
        raf.readUnsignedShort();
        int i2 = 0;
        while (i2 < this.segCount) {
            this.startCode[i2] = raf.readUnsignedShort();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segCount) {
            this.idDelta[i3] = raf.readUnsignedShort();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.segCount) {
            this.idRangeOffset[i4] = raf.readUnsignedShort();
            ++i4;
        }
        int count = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        int i5 = 0;
        while (i5 < count) {
            this.glyphIdArray[i5] = raf.readUnsignedShort();
            ++i5;
        }
    }

    public int mapCharCode(int charCode) {
        try {
            int i = 0;
            while (i < this.segCount) {
                if (this.endCode[i] >= charCode) {
                    if (this.startCode[i] <= charCode) {
                        if (this.idRangeOffset[i] > 0) {
                            return this.glyphIdArray[this.idRangeOffset[i] / 2 + (charCode - this.startCode[i]) - (this.segCount - i)];
                        }
                        return (this.idDelta[i] + charCode) % 65536;
                    }
                    break;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("error: Array out of bounds - " + e.getMessage());
        }
        return 0;
    }

    public String toString() {
        return super.toString() + ", segCountX2: " + this.segCountX2 + ", searchRange: " + this.searchRange + ", entrySelector: " + this.entrySelector + ", rangeShift: " + this.rangeShift + ", endCode: " + this.endCode + ", startCode: " + this.endCode + ", idDelta: " + this.idDelta + ", idRangeOffset: " + this.idRangeOffset;
    }
}

